/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiDataListUI;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.common.client.CCRelationNavUI;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class CCRelationBillEditImpl
implements IBTPBillEdit {
    private CoreBillEditUI billEditUI = null;
    private static String RESNAME = "com.kingdee.eas.base.btp.btpResource";

    public CCRelationBillEditImpl(CoreBillEditUI billEditUI) {
        this.billEditUI = billEditUI;
    }

    public void init() throws Exception {
    }

    public IObjectPK save(Context ctx) throws Exception {
        if (this.billEditUI.getBillInterface() instanceof ICoreBillBase) {
            IBTPManager iBTPManager = null;
            iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)ctx) : BTPManagerFactory.getRemoteInstance();
            return iBTPManager.saveRelations(this.billEditUI.getEditData(), this.billEditUI.getMakeRelations());
        }
        return this.billEditUI.runSave();
    }

    public IObjectPK submit(Context ctx) throws Exception {
        if (this.billEditUI.getBillInterface() instanceof ICoreBillBase) {
            IBTPManager iBTPManager = null;
            iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)ctx) : BTPManagerFactory.getRemoteInstance();
            IObjectPK pk = iBTPManager.submitRelations(this.billEditUI.getEditData(), this.billEditUI.getMakeRelations());
            if (this.billEditUI.getOprtState().equals("ADDNEW") || this.billEditUI.getOprtState().equals("COPYADDNEW") || this.billEditUI.getOprtState().equals("EXITING")) {
                this.billEditUI.setMakeRelations(null);
            } else {
                this.billEditUI.setMakeRelations(this.getBillRelation(pk.toString()));
            }
            return pk;
        }
        return this.billEditUI.runSubmit();
    }

    private BOTRelationCollection getBillRelation(String id) throws Exception {
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        return iBTPManager.getRelationCollection(id);
    }

    public void createFrom(Context ctx) throws Exception {
        this.createFrom(ctx, null);
    }

    public void createFrom(Context ctx, HashMap hm) throws Exception {
        IBTPManager iBTPManager;
        int flag = 2;
        flag = this.billEditUI.getBtpCreateFromType();
        if (flag != 0 && flag != 1 && flag != 2) {
            throw new IllegalArgumentException("Param  flag only accept 0 or 1 or 2 !");
        }
        BOSObjectType destBosType = this.billEditUI.getBillInterface().getType();
        UIContext uiContext = new UIContext((Object)this.billEditUI);
        uiContext.put("billEdit", this.billEditUI);
        if (hm != null) {
            uiContext.put("BTPEDITPARAMETER", hm);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = null;
        if (flag == 0) {
            uiContext.put("srcBillBOSTypeString", destBosType);
            window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillFromUI", (Map)uiContext, null);
        } else if (flag == 1) {
            uiContext.put("destBillBOSTypeString", destBosType);
            window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiData", (Map)uiContext, null);
        } else if (flag == 2) {
            List srcBosTypeList = this.getAllSrcBosType(destBosType);
            srcBosTypeList = this.billEditUI.getSrcBosTypeForBotp(srcBosTypeList);
            window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiDataListUI", (Map)uiContext, null);
            ((BTPMakeBillFromMultiDataListUI)window.getUIObject()).setSrcBosTypeList(srcBosTypeList);
        }
        window.show();
        IObjectCollection destBillCols = null;
        BOTRelationCollection botRelationCols = null;
        if (flag == 2) {
            List srcBillColsList = ((BTPMakeBillFromMultiDataListUI)window.getUIObject()).getSrcBillColsList();
            iBTPManager = null;
            iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)ctx) : BTPManagerFactory.getRemoteInstance();
            BTPTransformResult btpResult = iBTPManager.transformFromMultiBillType(srcBillColsList, destBosType.toString());
            destBillCols = btpResult.getBills();
            botRelationCols = btpResult.getBOTRelationCollection();
        } else {
            this.billEditUI.getUIContext().put("srcBillID", window.getUIObject().getUIContext().get("srcBillID"));
            if (window.getUIObject().getUIContext().get("ifOk") != null && window.getUIObject().getUIContext().get("ifOk").toString().equals("YES")) {
                destBillCols = (IObjectCollection)window.getUIObject().getUIContext().get("destBills");
                botRelationCols = (BOTRelationCollection)window.getUIObject().getUIContext().get("relations");
            }
        }
        if (destBillCols != null && destBillCols.size() > 0) {
            if (destBillCols.size() > 1) {
                RealModeIDList idList = RealModeIDList.getEmptyIDList();
                iBTPManager = null;
                iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)ctx) : BTPManagerFactory.getRemoteInstance();
                int count = destBillCols.size();
                for (int i = 0; i < count; ++i) {
                    CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                    DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
                    agent.markBotpTransfer((IObjectValue)destBillInfo, destBillInfo.getId().toString());
                    iBTPManager.saveRelations(destBillInfo, botRelationCols);
                    idList.add(destBillInfo.getId().toString());
                }
                idList.setCurrentIndex(0);
                this.billEditUI.getUIContext().put("ID", idList.getCurrentID());
                this.billEditUI.getUIContext().put("IDList", idList);
                this.billEditUI.setOprtState("EDIT");
                this.billEditUI.onLoad();
            } else {
                IObjectValue destBillInfo = destBillCols.getObject(0);
                DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
                agent.markBotpTransfer(destBillInfo, destBillInfo.get("id").toString());
                this.billEditUI.setMakeRelations(botRelationCols);
                this.billEditUI.getUIContext().put("InitDataObject", destBillInfo);
                this.billEditUI.setOprtState("ADDNEW");
                this.billEditUI.onLoad();
            }
        } else if (destBillCols != null && destBillCols.size() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
    }

    private void transformFromMultiBillType(List srcBillColsList, String destBosType) throws Exception {
        if (srcBillColsList == null || srcBillColsList.size() == 0) {
            return;
        }
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BTPTransformResult btpResult = iBTPManager.transformFromMultiBillType(srcBillColsList, destBosType);
        if (btpResult.getBills() != null && btpResult.getBills().size() > 1) {
            IObjectCollection destBillCols = btpResult.getBills();
            BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
                agent.markBotpTransfer((IObjectValue)destBillInfo, destBillInfo.getId().toString());
                iBTPManager.saveRelations(destBillInfo, botRelationCols);
            }
            return;
        }
        CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)btpResult.getBills().getObject(0);
        DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
        agent.markBotpTransfer((IObjectValue)destBillInfo, destBillInfo.getId().toString());
        this.billEditUI.getUIContext().put("InitDataObject", destBillInfo);
        this.billEditUI.setMakeRelations(btpResult.getBOTRelationCollection());
        this.billEditUI.setOprtState("ADDNEW");
        this.billEditUI.onLoad();
    }

    private List getAllSrcBosType(BOSObjectType type) throws BOTPException, BOSException {
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        String srcBillBOSType = iBOTMapping.getSourceBillTypeList(type.toString());
        if (srcBillBOSType.equals("")) {
            MsgBox.showWarning((String)EASResource.getString((String)RESNAME, (String)"noDestBill"));
            SysUtil.abort();
        }
        String[] srcBillType = StringUtil.split((String)srcBillBOSType, (String)",");
        ArrayList<String> bosTypeList = new ArrayList<String>();
        int count = srcBillType.length;
        for (int i = 0; i < count; ++i) {
            bosTypeList.add(srcBillType[i]);
        }
        return bosTypeList;
    }

    public void traceUp(CoreBillBaseInfo bill) throws Exception {
        if (bill.getId() == null) {
            return;
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", this.billEditUI);
        uiContext.put("BTPNAVCTX", this.billEditUI.getUIContext());
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        uiContext.put("billInfoNumber", bill.getNumber());
        uiContext.put("findType", new Integer(0));
        IUIFactory uiFactory = this.createUIFactory(this.billEditUI);
        IUIWindow window = uiFactory.create(CCRelationNavUI.class.getName(), uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    public void traceDown(CoreBillBaseInfo bill) throws Exception {
        if (bill.getId() == null) {
            return;
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", this.billEditUI);
        uiContext.put("BTPNAVCTX", new BOSUIContext());
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(1));
        IUIFactory uiFactory = this.createUIFactory(this.billEditUI);
        IUIWindow window = uiFactory.create(CCRelationNavUI.class.getName(), uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    private IUIFactory createUIFactory(CoreBillEditUI billEditUI) throws Exception {
        IUIWindow window = billEditUI.getUIWindow();
        if (window != null && window instanceof UIModelDialog) {
            return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        }
        return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
    }

    public void createFromMultiData() throws Exception {
        UIContext uiContext = new UIContext((Object)this.billEditUI);
        uiContext.put("destBillBOSTypeString", this.billEditUI.getBillInterface().getType());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.cal.client.BTPMakeBillFromUI", (Map)uiContext, null);
        window.getUIObject().getUIContext().put("billEdit", this.billEditUI);
        window.show();
        this.billEditUI.getUIContext().put("srcBillID", window.getUIObject().getUIContext().get("srcBillID"));
        if (window.getUIObject().getUIContext().get("ifOk") != null && window.getUIObject().getUIContext().get("ifOk").toString().equals("YES")) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)window.getUIObject().getUIContext().get("destBill");
            BOTRelationCollection relations = (BOTRelationCollection)window.getUIObject().getUIContext().get("relations");
            this.billEditUI.setMakeRelations(relations);
            this.billEditUI.setDataObject((IObjectValue)destBillInfo);
            this.billEditUI.onLoad();
        }
    }

    public void CreateTo(CoreBillBaseInfo bill) throws Exception {
    }

    public void CreateTo(CoreBillBaseInfo arg0, String arg1) throws Exception {
    }

    public void getRelationDiagram(CoreBillBaseInfo bill) throws Exception {
    }
}

