/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.AbstractSCMBillFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.QueryFilterManager;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMBillFilterUI
extends AbstractSCMBillFilterUI
implements ISCMFilter {
    private static final Logger logger = CoreUIObject.getLogger(SCMBillFilterUI.class);
    private QueryFilterManager manager = null;
    private HashMap orgF7Map = new HashMap();
    protected boolean isInBOTP = false;
    public CustomerParams params = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private KDBizPromptBox[] prmtBillNumF7s = null;
    private static final String resClassName = "com.kingdee.eas.scm.common.SCMResource";
    protected F7ContextManager f7Manager = null;
    private OrgUnitCollection colMainOrgs = null;
    protected boolean isReport = false;
    private Map botpMap = null;
    private boolean isSupportMultiOrgs = false;
    private Object contextObject;
    private DataChangeListener mainOrgListener;
    private OrgUnitCollection authorizedMainOrgs = null;

    public void setReport(boolean isReport) {
        this.isReport = isReport;
    }

    public SCMBillFilterUI() throws Exception {
        this.manager = new QueryFilterManager();
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgUnitInfo[] getMainOrgs() {
        return this.mainOrgs;
    }

    public void onLoad() throws Exception {
        SCMClientUtils.strDateFormat = CtrlFormatUtilities.getDateFormatString();
        SCMClientUtils.strTimeFormat = CtrlFormatUtilities.getDateTimeFormatString();
        super.onLoad();
        if (!this.isInBOTP && this.getMainBizOrgF7() != null) {
            this.setMainBizF7(this.getMainBizOrgF7());
        }
        this.clear();
        if (this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setRequired(true);
            this.getMainBizOrgF7().addDataChangeListener(this.mainOrgListener);
            this.getMainBizOrgF7().setDisplayFormat("$name$");
        }
    }

    protected void setMainBizF7(KDBizPromptBox bizOrgUnitBox) {
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        NewSaleF7 model = null;
        String permissionItem = this.getViewPermission();
        NewOrgUnitFilterInfoProducer iProducer = null;
        if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
            model = new NewSaleF7();
        }
        if ((iProducer = !this.isSupportVirturalOrgs() ? new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType(), permissionItem) : (model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model, permissionItem) : new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType(), permissionItem))) != null && iProducer.getModel() != null) {
            iProducer.getModel().setNeedAddSealUp(false);
        }
        if (this.isNeedAddVirtual()) {
            iProducer.getModel().setNeedAddVirtual(false);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        if (this.isSupportMultiOrgs || this.isReport) {
            bizOrgUnitBox.setEnabledMultiSelection(true);
        }
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }

    public QueryFilterManager getFilterManager() {
        return this.manager;
    }

    public FilterInfo getFilterInfo() {
        return this.manager.getFilterInfo();
    }

    public void clear() {
        this.manager.clearAll();
        this.setDefaultValue();
        if (!this.isInBOTP) {
            OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
            if (this.isReport) {
                if (aOrgUnitInfo != null && this.getMainBizOrgF7() != null) {
                    this.getMainBizOrgF7().setValue((Object)new OrgUnitInfo[]{aOrgUnitInfo.castToFullOrgUnitInfo()});
                }
            } else {
                Object storageOrgUnit = SysContext.getSysContext().getProperty((Object)"storageOrgUnit");
                if (this.getMainBizOrgF7() != null && storageOrgUnit == null) {
                    this.getMainBizOrgF7().setData((Object)aOrgUnitInfo);
                }
            }
        } else {
            this.setOrgInBOTP(this.botpMap);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.manager.clearAll();
        this.manager.setCustomerParams(this.params, this.isInBOTP || this.isReport || this.isSupportMultiOrgs);
        if (this.isInBOTP) {
            this.setOrgInBOTP(this.botpMap);
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manager.setPrmtNeedOrgF7s(f7s);
    }

    public void initMainBizOrg() {
        if (this.getMainBizOrgF7() != null) {
            this.mainOrgListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SCMBillFilterUI.this.mainOrgChanged();
                }
            };
        }
    }

    protected final void mainOrgChanged() {
        if (this.getMainBizOrgF7() == null) {
            return;
        }
        OrgUnitCollection collection = this.getMainBizOrgs();
        if (!SCMGroupClientUtils.isDiffrent4OrgCollection(this.colMainOrgs, collection)) {
            return;
        }
        this.colMainOrgs = collection;
        String ids = null;
        Object mainOrg = this.manager.getMainOrgs();
        if (mainOrg == null) {
            mainOrg = this.getMainBizOrgF7().getData();
        }
        if (mainOrg instanceof OrgUnitInfo && mainOrg != null) {
            ids = ((OrgUnitInfo)mainOrg).getId().toString();
            this.afterMainOrgChanged(ids);
        } else if (mainOrg instanceof Object[] && collection != null) {
            Object[] objects = (Object[])mainOrg;
            if (objects.length > 0) {
                collection.clear();
                OrgUnitInfo[] unitInfos = new OrgUnitInfo[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    unitInfos[i] = (OrgUnitInfo)objects[i];
                    collection.add(unitInfos[i]);
                }
                ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])unitInfos, ",");
                this.afterMainOrgChanged(ids);
            }
        } else {
            this.afterMainOrgChanged(null);
        }
        if (ids == null) {
            if (this.mainOrgs == null) {
                this.gainAuthMainBizOrgs();
            }
            ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])this.mainOrgs, ",");
        }
        if (!"materialRequest_view".equals(this.getViewPermission()) && collection != null) {
            this.f7Manager.changeF7Context(ids, collection);
        }
    }

    public void afterMainOrgChanged(String ids) {
    }

    @Override
    public void setBOTPFilter(Map botpMap) {
        this.isInBOTP = true;
        this.clear();
        this.isInBOTP = true;
        this.botpMap = botpMap;
        this.setOrgInBOTP(botpMap);
    }

    protected void setOrgInBOTP(Map botpMap) {
        OrgType destType = null;
        OrgUnitInfo destOrg = null;
        if (botpMap != null) {
            destType = (OrgType)botpMap.get("MAINBIZORG.TYPE");
            destOrg = (OrgUnitInfo)botpMap.get("MAINBIZORG");
            if (destType == null) {
                return;
            }
            if (destType.equals((Object)this.getMainBizOrgType())) {
                if (this.getMainBizOrgF7() != null) {
                    this.getMainBizOrgF7().setData((Object)destOrg);
                    this.getMainBizOrgF7().setEnabled(false);
                    this.mainOrgChanged();
                }
            } else {
                Object obj = this.orgF7Map.get(destType);
                if (obj != null) {
                    if (obj instanceof List) {
                        List list = (List)obj;
                        for (int i = 0; i < list.size(); ++i) {
                            ((KDBizPromptBox)list.get(i)).setData((Object)destOrg);
                            ((KDBizPromptBox)list.get(i)).setEnabled(false);
                        }
                    } else {
                        ((KDBizPromptBox)obj).setData((Object)destOrg);
                        ((KDBizPromptBox)obj).setEnabled(false);
                    }
                }
                if (this.getMainBizOrgF7() != null) {
                    OrgUnitCollection collection;
                    if (destType.equals((Object)OrgType.Purchase) && this.getMainBizOrgType().equals((Object)OrgType.Sale) || destType.equals((Object)OrgType.Sale) && this.getMainBizOrgType().equals((Object)OrgType.Purchase)) {
                        if (botpMap.containsKey("has_owner_filter") && botpMap.get("has_owner_filter") instanceof Boolean) {
                            if (((Boolean)botpMap.get("has_owner_filter")).booleanValue()) {
                                this.getMainBizOrgF7().setCommitFormat("$number$;$code$");
                                this.getMainBizOrgF7().setEnabledMultiSelection(true);
                            } else {
                                this.setBizOrgF7ByType(this.getMainBizOrgF7(), this.getMainBizOrgType(), OrgType.Company, false);
                                collection = null;
                                try {
                                    collection = SCMGroupClientUtils.getOrgsByRelation(destType, OrgType.Company, destOrg.getId());
                                    this.getMainBizOrgF7().setMainBizOrgs(collection, OrgType.Company);
                                }
                                catch (Exception e) {
                                    logger.error((Object)e);
                                }
                            }
                        } else {
                            this.setBizOrgF7ByType(this.getMainBizOrgF7(), this.getMainBizOrgType(), OrgType.Company, false);
                            collection = null;
                            try {
                                collection = SCMGroupClientUtils.getOrgsByRelation(destType, OrgType.Company, destOrg.getId());
                                this.getMainBizOrgF7().setMainBizOrgs(collection, OrgType.Company);
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    } else if (botpMap.containsKey("has_owner_filter") && botpMap.get("has_owner_filter") instanceof Boolean) {
                        if (((Boolean)botpMap.get("has_owner_filter")).booleanValue()) {
                            this.getMainBizOrgF7().setCommitFormat("$number$;$code$");
                            this.getMainBizOrgF7().setEnabledMultiSelection(true);
                        } else {
                            this.setBizOrgF7ByType(this.getMainBizOrgF7(), this.getMainBizOrgType(), destType, false);
                            collection = new OrgUnitCollection();
                            collection.add(destOrg);
                            this.getMainBizOrgF7().setMainBizOrgs(collection, destType);
                        }
                    } else {
                        this.setBizOrgF7ByType(this.getMainBizOrgF7(), this.getMainBizOrgType(), destType, false);
                        collection = new OrgUnitCollection();
                        collection.add(destOrg);
                        this.getMainBizOrgF7().setMainBizOrgs(collection, destType);
                    }
                }
            }
        } else {
            this.isInBOTP = false;
        }
    }

    public void setBizOrgF7ByType(KDBizPromptBox bizOrgUnitBox, OrgType orgType, OrgType mainOrgType, boolean isFiltered) {
        ArrayList<Object> list = null;
        SCMGroupClientUtils.setBizOrgF7ByType(bizOrgUnitBox, orgType, mainOrgType, false);
        bizOrgUnitBox.setEnabledMultiSelection(true);
        if (isFiltered) {
            if (this.orgF7Map.containsKey(orgType)) {
                Object value = this.orgF7Map.get(orgType);
                if (value instanceof List) {
                    list = (ArrayList<Object>)value;
                } else {
                    list = new ArrayList<Object>();
                    list.add(this.orgF7Map.get(orgType));
                }
                list.add(bizOrgUnitBox);
                this.orgF7Map.put(orgType, list);
            } else {
                this.orgF7Map.put(orgType, bizOrgUnitBox);
            }
        }
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    protected String getViewPermission() {
        return null;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = this.manager.getCustomerParams();
        if (this.getMaterialGroupStandard() != null) {
            customerParams.addCustomerParam("materialGroupStandard", String.valueOf(this.getMaterialGroupStandard().getSelectedIndex()));
        }
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (this.getMaterialGroupStandard() != null) {
            if (cp != null && cp.getCustomerParam("materialGroupStandard") != null) {
                this.getMaterialGroupStandard().setSelectedIndex(Integer.valueOf(cp.getCustomerParam("materialGroupStandard")).intValue());
            }
            if (this.getMaterialGroupStandard().getSelectedIndex() < 0) {
                this.getMaterialGroupStandard().setSelectedIndex(0);
            }
        }
        this.params = cp;
    }

    public boolean verify() {
        boolean flag = this.manager.verify();
        return flag;
    }

    protected void setDefaultValue() {
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                if (this.authorizedMainOrgs == null) {
                    if (this.isReport) {
                        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
                        if (collection != null && collection.size() > 0) {
                            this.mainOrgs = new OrgUnitInfo[collection.size()];
                            for (int i = 0; i < collection.size(); ++i) {
                                this.mainOrgs[i] = collection.get(i);
                            }
                        }
                    } else {
                        this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
                    }
                } else {
                    int size = this.authorizedMainOrgs.size();
                    this.mainOrgs = new OrgUnitInfo[size];
                    if (size > 0) {
                        Object[] objects = this.authorizedMainOrgs.toArray();
                        System.arraycopy(objects, 0, this.mainOrgs, 0, size);
                    }
                }
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected String getPropertyOfMainBizOrg() {
        return null;
    }

    protected void setBillNumberF7s(KDBizPromptBox[] f7s) {
        this.prmtBillNumF7s = f7s;
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (SCMBillFilterUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = SCMBillFilterUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg(SCMBillFilterUI.this.getMainBizOrgType()));
                        SCMBillFilterUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected EntityViewInfo setEntityViewInfo(FilterInfo userFilterInfo, String property, String values) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        if (values != null) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo(property, (Object)values, CompareType.INCLUDE));
        }
        if (userFilterInfo != null && userFilterInfo.getFilterItems().size() > 0) {
            try {
                if (filterInfo == null) {
                    view.setFilter(userFilterInfo);
                    return view;
                }
                filterInfo.mergeFilter(userFilterInfo, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            view.setFilter(filterInfo);
            return view;
        }
        return null;
    }

    protected void setBizMaterialF7(KDBizPromptBox bizMaterialBox, boolean isMulSelect, String queryInfo) {
        this.f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, null, isMulSelect);
    }

    protected void setBizMaterialF7(KDBizPromptBox kDBizPromptBoxMaterial, boolean isMulSelect, String queryInfo, OrgType mainOrgType, boolean isRelegable, OrgUnitInfo mainOrg) {
        this.f7Manager.registerBizMaterialF7(kDBizPromptBoxMaterial, null, null, mainOrg, mainOrgType, isMulSelect, isRelegable);
    }

    protected void setBizChannelF7(KDBizPromptBox bizChannelBox, boolean isMulSelect, String queryInfo) {
        this.f7Manager.registerBizChannelF7(bizChannelBox, null, queryInfo, null);
    }

    protected void setBizSupplierF7(KDBizPromptBox bizSupplierBox, String queryInfo) {
        this.setBizSupplierF7(bizSupplierBox, queryInfo, true);
    }

    protected void setBizSupplierF7(KDBizPromptBox bizSupplierBox, String queryInfo, boolean isReportFilter) {
        this.f7Manager.registerBizSupplierF7(bizSupplierBox, null, queryInfo, null, isReportFilter);
    }

    protected void setBizCustomerF7(KDBizPromptBox bizCustomerBox, String queryInfo) {
        this.f7Manager.registerBizCustomerF7(bizCustomerBox, null, queryInfo, null);
    }

    protected void setBizCustomerF7(KDBizPromptBox bizCustomerBox, String queryInfo, boolean isMulti) {
        this.f7Manager.registerBizCustomerF7(bizCustomerBox, null, isMulti, queryInfo, null, this.getMainBizOrgType());
    }

    public RptParams getCustomCondition() {
        return this.manager.getRptParams();
    }

    public void setCustomCondition(RptParams params) {
        this.manager.setRptParams(params);
    }

    public void onInit(RptParams initParams) throws Exception {
        this.manager.setRptParams(initParams);
    }

    @Override
    public void setIsSupportMultiOrgs(boolean value) {
        this.isSupportMultiOrgs = value;
    }

    @Override
    public void setContextObject(Object object) {
        this.contextObject = object;
    }

    public Object getContextObject() {
        return this.contextObject;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    @Override
    public void setAuthorizedMainOrgs(OrgUnitCollection authorizedMainOrgs) {
        this.authorizedMainOrgs = authorizedMainOrgs;
    }

    @Override
    public IUIActionPostman prepareInit() {
        RequestContext request;
        IUIActionPostman handle = super.prepareInit();
        if (handle == null && (handle = UIActionPostman.getInstance((IUIObject)this)) != null) {
            request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            handle.setRequestContext((Serializable)request);
        }
        if (!this.isPrepareInit()) {
            return handle;
        }
        request = new RequestContext();
        request.setMainOrgType(this.getMainBizOrgType());
        request.put("_SCMMAINORGTYPE", (Object)this.getMainBizOrgType());
        request.put("_SCMF7DISPLAYMODE", (Object)"F7DISPLAYMODE");
        request.put("_SCMPERMISSIONITEM", (Object)this.getViewPermission());
        request.setClassName("com.kingdee.eas.scm.common.app.SCMBillFilterUIHandler");
        request.setMethodName("handleInit");
        handle.setRequestContext((Serializable)request);
        return handle;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void setShowAllSealOrg(KDBizPromptBox[] boxs, OrgType[] orgType) {
        if (boxs.length != orgType.length) {
            return;
        }
        String query = null;
        int c = boxs.length;
        for (int i = 0; i < c; ++i) {
            if (orgType[i].equals((Object)OrgType.Storage)) {
                query = "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery";
            } else if (orgType[i].equals((Object)OrgType.Purchase)) {
                query = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery";
            } else if (orgType[i].equals((Object)OrgType.Sale)) {
                query = "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery";
            } else if (orgType[i].equals((Object)OrgType.Company)) {
                query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
            } else if (orgType[i].equals((Object)OrgType.Admin)) {
                query = "com.kingdee.eas.sem.mp.app.AdminOrgUnitF7";
            }
            boxs[i].setQueryInfo(query);
        }
    }

    public boolean isReport() {
        return this.isReport;
    }

    protected KDComboBox getMaterialGroupStandard() {
        return null;
    }

    protected boolean isNeedAddVirtual() {
        return false;
    }

    protected void orgsChanged(SCMRptMultiOrgsF7 f7, F7ContextManager f7Manager) {
        String ids = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        if (f7 == null) {
            return;
        }
        Object orgs = f7.getFullData();
        if (orgs == null) {
            return;
        }
        Object[] objects = (Object[])orgs;
        if (objects[0] == null) {
            return;
        }
        if (objects.length > 0) {
            collection.clear();
            OrgUnitInfo[] unitInfos = new OrgUnitInfo[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                unitInfos[i] = (OrgUnitInfo)objects[i];
                collection.add(unitInfos[i]);
            }
            ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])unitInfos, ",");
        }
        if (collection.size() > 0) {
            f7Manager.changeF7Context(ids, collection);
        }
    }
}

