/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.BooleanDataType;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.ISetOrgType;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeGroupEnum;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.ISCMBillParamValue;
import com.kingdee.eas.scm.common.PurControlBudgetEnum;
import com.kingdee.eas.scm.common.PurControlBudgetFieldsEnum;
import com.kingdee.eas.scm.common.SCMBillParamCollection;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMBillParamInfo;
import com.kingdee.eas.scm.common.SCMBillParamValueCollection;
import com.kingdee.eas.scm.common.SCMBillParamValueFactory;
import com.kingdee.eas.scm.common.SCMBillParamValueInfo;
import com.kingdee.eas.scm.common.client.AbstractSCMBillParamUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SCMBillParamUI
extends AbstractSCMBillParamUI
implements IOtherParam,
ICustomParamUI,
ISetOrgType {
    private static final Logger logger = CoreUIObject.getLogger(SCMBillParamUI.class);
    private static final String RESOURCENAME = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private static final String ROOTTAG = "root";
    private static final String SUBTAG = "sub";
    private KDTreeNode rootTreeNode = null;
    private static final String COL_BILLTYPE = "billType";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_PARAMVALUE = "paramValue";
    private static final String COL_PARAMTYPE = "paramType";
    private static final String COL_CANBEMODIFIED = "canBeModified";
    private static final String COL_DEFAULTVALUE = "defaultValue";
    private static final String COL_DESCRIPTION = "description";
    private static final String COL_LASTUPDATEUSER = "lastUpdateUser";
    private static final String COL_LASTUPDATETIME = "lastUpdateTime";
    private static final String COL_ID = "id";
    private static final String RESCLASSNAME = "com.kingdee.eas.scm.common.SCM_COMMONResource";
    private Map paramValueMap = null;
    String msg = null;
    private static final int L2 = 0;
    private static final int L3 = 1;
    private OrgType selOrgType = null;
    private OrgUnitInfo selOrgUnitInfo = null;
    private static final int SAVEPARAM = 0;
    private static final int USERPARAM = 1;
    private static final int PARAMSETTING = 2;
    private static Locale locale = SysContext.getSysContext().getLocale();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setPrecision() {
        int precision = 0;
        if (this.txtPrecision.getText() != null && this.txtPrecision.getText().trim().length() > 0) {
            precision = new Integer(this.txtPrecision.getText());
            this.numParamValue.setPrecision(precision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tree_changed(TreeSelectionEvent e) {
        this.tableParam.getEditManager().stopEditing();
        if (this.paramValueMap != null) {
            try {
                int ret;
                if (this.msg == null) {
                    this.msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"PARAMHASMODIFIED");
                }
                if ((ret = MsgBox.showConfirm3((Component)((Object)this), (String)this.msg)) == 2) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent();
                    if (this.treeBill.getTreeSelectionListeners() != null && this.treeBill.getTreeSelectionListeners().length > 0) {
                        this.treeBill.removeTreeSelectionListener(this.treeBill.getTreeSelectionListeners()[0]);
                    }
                    this.treeBill.setSelectionNode(node);
                    this.treeBill.addTreeSelectionListener((TreeSelectionListener)new treeChangedListener());
                } else if (ret == 0) {
                    try {
                        this.otherParamSave();
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        this.handUIException(e1);
                    }
                }
            }
            finally {
                this.paramValueMap = null;
            }
        }
        if (this.selOrgType == null || this.selOrgUnitInfo == null) {
            return;
        }
        SCMBillParamValueCollection spc = this.getParamValueCollection(this.getParamFilterData(1));
        HashMap paramMap = (HashMap)this.getParamFilterData(1);
        String billType = null;
        if (paramMap != null) {
            billType = (String)paramMap.get(COL_BILLTYPE);
        }
        if (billType == null) {
            SCMBillParamValueCollection spvs;
            spc = spvs = this.filterSCMBillParamValue(spc);
        }
        this.fillTableParamTable(spc);
        SCMBillParamCollection spvc = this.getParamCollection(this.getParamFilterData(2));
        if (billType == null) {
            SCMBillParamCollection spvcs;
            spvc = spvcs = this.filterSCMBillParam(spvc);
        }
        this.fillTableSettingTable(spvc);
    }

    private void tableParam_changed(KDTEditEvent e) {
        if (e.getValue() == null) {
            return;
        }
        if (e.getOldValue() != null && e.getValue() != null && e.getOldValue().toString().equals(e.getValue().toString())) {
            return;
        }
        if (!e.getValue().equals(e.getOldValue()) || !e.getValue().toString().equals(e.getOldValue().toString())) {
            if (this.paramValueMap == null) {
                this.paramValueMap = new HashMap();
            }
            IRow iRow = this.tableParam.getRow(e.getRowIndex());
            ParamDataType paramDataType = (ParamDataType)iRow.getCell(COL_PARAMTYPE).getValue();
            String number = iRow.getCell(COL_NUMBER).getValue().toString();
            this.paramValueMap.put(iRow.getCell(COL_ID).getValue().toString(), this.getParamValue(paramDataType.getValue(), false, iRow, number));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setControlDisplay(false);
        this.initControl();
        this.initKDTreeMain((JTree)this.treeBill);
    }

    private void lockColumns(KDTable kdTable) {
        for (int i = 0; i < kdTable.getColumnCount(); ++i) {
            kdTable.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    private void setColumnsWidth(KDTable kdTable) {
        kdTable.getColumn(COL_BILLTYPE).setWidth(120);
        kdTable.getColumn(COL_NUMBER).setWidth(100);
        kdTable.getColumn(COL_NAME).setWidth(150);
        kdTable.getColumn(COL_PARAMVALUE).setWidth(100);
        kdTable.getColumn(COL_CANBEMODIFIED).setWidth(100);
        kdTable.getColumn(COL_DEFAULTVALUE).setWidth(100);
        kdTable.getColumn(COL_DESCRIPTION).setWidth(250);
        kdTable.getColumn(COL_LASTUPDATEUSER).setWidth(100);
        kdTable.getColumn(COL_LASTUPDATETIME).setWidth(100);
    }

    private void initControl() {
        this.tableParam.checkParsed();
        this.tableSetting.checkParsed();
        this.tableParam.getColumn(COL_DEFAULTVALUE).getStyleAttributes().setHided(true);
        this.tableParam.getColumn(COL_NUMBER).getStyleAttributes().setHided(true);
        this.lockColumns(this.tableParam);
        this.lockColumns(this.tableSetting);
        this.setColumnsWidth(this.tableParam);
        this.setColumnsWidth(this.tableSetting);
        this.txtPrecision.setDataType(0);
        this.txtPrecision.setMinimumValue((Comparable)new Integer(0));
        this.txtPrecision.setMaximumValue((Comparable)new Integer(6));
        this.cmbParamType.removeItem((Object)ParamDataType.BaseInformation);
        this.treeBill.getSelectionModel().setSelectionMode(1);
        this.treeBill.addTreeSelectionListener((TreeSelectionListener)new treeChangedListener());
        this.tableParam.addKDTEditListener((KDTEditListener)new tableParamValueChangedListener());
        this.cmbParamType.addActionListener((ActionListener)new paramTypeChangedListener());
        this.txtPrecision.addDataChangeListener((DataChangeListener)new precisionChangedListener());
    }

    @Override
    public void actionParamSetting_actionPerformed(ActionEvent e) throws Exception {
        this.setControlDisplay(true);
    }

    @Override
    protected void btnExit_actionPerformed(ActionEvent e) throws Exception {
        this.setControlDisplay(false);
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.clearControl();
    }

    private void clearControl() {
        this.txtNumber.setText(null);
        this.txtName.setSelectedItemData(null);
        this.txtDesc.setSelectedItemData(null);
        this.cmbParamType.setSelectedIndex(0);
        this.txtParamValue.setText(null);
        this.txtDefaultValue.setText(null);
        this.txtPrecision.setValue(null);
        this.chkIsDisplay.setSelected(false);
        this.chkCanBeModified.setSelected(false);
        this.txtPrecision.setEnabled(false);
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkValidBeforeSave();
        Map paramHash = this.getParamData();
        ISCMBillParam isp = SCMBillParamFactory.getRemoteInstance();
        boolean isSave = true;
        Integer billGroup = (Integer)paramHash.get("billGroup");
        String billType = (String)paramHash.get(COL_BILLTYPE);
        String number = paramHash.get(COL_NUMBER).toString();
        String orgType = paramHash.get("orgType").toString();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(COL_NUMBER, (Object)number, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)billGroup, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo(COL_BILLTYPE, (Object)billType, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("orgType", (Object)orgType, CompareType.EQUALS));
        if (isp.exists(fi)) {
            int ret = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESCLASSNAME, (String)"NumberHasExistConfirmSave"));
            if (0 != ret) {
                isSave = false;
            }
        }
        if (isSave) {
            isp.saveParam(paramHash);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESCLASSNAME, (String)"SaveSuccess"));
        }
    }

    private void checkValidBeforeSave() {
        ParamDataType pdt;
        String msg = null;
        TreePath treePath = this.treeBill.getSelectionPath();
        if (msg != null && treePath == null) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"ChooseOneBillTypeNodeOrAllBillType");
        }
        if (msg != null && this.selOrgType == null) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"ChooseOneOrgType");
        }
        if (msg != null && this.selOrgUnitInfo == null) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"ChooseOneOrgUnit");
        }
        if (msg != null && (this.txtNumber.getText() == null || this.txtNumber.getText().length() <= 0)) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"InputParamNumber");
        }
        if (msg != null && this.txtName.getSelectedItem() == null) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"InputParamName");
        }
        if (msg != null && (this.txtParamValue.getText() == null || this.txtParamValue.getText().length() <= 0)) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"InputParamValue");
        }
        if (msg != null && (this.txtPrecision.getText() == null || this.txtPrecision.getText().length() <= 0) && (pdt = (ParamDataType)this.cmbParamType.getSelectedItem()).getValue() == 2) {
            msg = EASResource.getString((String)RESCLASSNAME, (String)"InputPrecision");
        }
        if (msg != null) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    private String getParamValue(int paramType, boolean isParamSetting, IRow iRow, String number) {
        String paramValue = null;
        if (0 == paramType) {
            if (isParamSetting) {
                paramValue = this.txtParamValue.getText().trim();
            } else if (iRow.getCell(COL_PARAMVALUE).getValue() != null) {
                paramValue = iRow.getCell(COL_PARAMVALUE).getValue().toString().trim();
            }
        } else if (1 == paramType) {
            if (isParamSetting) {
                paramValue = this.numParamValue.getNumberValue().toString();
            } else if (iRow.getCell(COL_PARAMVALUE).getValue() != null) {
                paramValue = iRow.getCell(COL_PARAMVALUE).getValue().toString();
            }
        } else if (2 == paramType) {
            if (isParamSetting) {
                paramValue = this.numParamValue.getNumberValue().toString();
            } else if (iRow.getCell(COL_PARAMVALUE).getValue() != null) {
                paramValue = iRow.getCell(COL_PARAMVALUE).getValue().toString();
            }
        } else if (4 == paramType) {
            if (isParamSetting) {
                paramValue = this.dateParamValue.getValue().toString();
            } else if (iRow.getCell(COL_PARAMVALUE).getValue() != null) {
                paramValue = iRow.getCell(COL_PARAMVALUE).getValue().toString();
            }
        } else if (3 == paramType) {
            BooleanDataType bdt;
            paramValue = isParamSetting ? ((bdt = (BooleanDataType)this.comboxParamValue.getSelectedItem()).getValue().equalsIgnoreCase("true") ? "1" : "0") : ((Boolean)iRow.getCell(COL_PARAMVALUE).getValue() != false ? "1" : "0");
        } else if (5 == paramType && !isParamSetting) {
            if ("IsControlBudget".equals(number)) {
                KDComboBox comboBox = (KDComboBox)iRow.getCell(COL_PARAMVALUE).getEditor().getComponent();
                paramValue = String.valueOf(((PurControlBudgetEnum)((Object)comboBox.getSelectedItem())).getValue());
            } else if ("PUR_BudgetFields".equals(number)) {
                KDComboBox comboBox = (KDComboBox)iRow.getCell(COL_PARAMVALUE).getEditor().getComponent();
                paramValue = String.valueOf(((PurControlBudgetFieldsEnum)((Object)comboBox.getSelectedItem())).getValue());
            }
        }
        return paramValue;
    }

    private Map getParamData() {
        Map paramHash = this.getParamFilterData(0);
        paramHash.put(COL_NUMBER, this.txtNumber.getText().trim());
        paramHash.put("name_l2", this.txtName.getItemAt(0).toString());
        paramHash.put("name_l3", this.txtName.getItemAt(1).toString());
        if (this.txtDesc.getItemAt(0) != null && this.txtDesc.getItemAt(0).toString().length() > 0) {
            paramHash.put("desc_l2", this.txtDesc.getItemAt(0).toString());
            paramHash.put("desc_l3", this.txtDesc.getItemAt(1).toString());
        } else {
            paramHash.put("desc_l2", null);
            paramHash.put("desc_l3", null);
        }
        ParamDataType pdt = (ParamDataType)this.cmbParamType.getSelectedItem();
        paramHash.put(COL_PARAMTYPE, new Integer(pdt.getValue()));
        paramHash.put(COL_PARAMVALUE, this.getParamValue(pdt.getValue(), true, null, this.txtNumber.getText().trim()));
        if (this.txtDefaultValue.getText() == null || this.txtDefaultValue.getText().length() <= 0) {
            paramHash.put(COL_DEFAULTVALUE, null);
        } else {
            paramHash.put(COL_DEFAULTVALUE, this.txtDefaultValue.getText().trim());
        }
        if (this.txtPrecision.getNumberValue() == null || this.txtPrecision.getText().length() <= 0) {
            paramHash.put("precision", null);
        } else {
            paramHash.put("precision", new Integer(this.txtPrecision.getNumberValue().intValue()));
        }
        paramHash.put("displayHided", new Integer(this.chkIsDisplay.isSelected() ? 1 : 0));
        paramHash.put(COL_CANBEMODIFIED, new Integer(this.chkCanBeModified.isSelected() ? 1 : 0));
        return paramHash;
    }

    private void setBillTypeParam(Map paramMap) {
        TreePath treePath = this.treeBill.getSelectionPath();
        if (treePath != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            BillTypeInfo billTypeInfo = (BillTypeInfo)node.getUserObject();
            if (billTypeInfo.getNumber().equals(ROOTTAG)) {
                paramMap.put("billGroup", null);
            } else if (billTypeInfo.getNumber().equals(SUBTAG)) {
                paramMap.put("billGroup", new Integer(billTypeInfo.getBillTypeGroup().getValue()));
                paramMap.put(COL_BILLTYPE, null);
            } else {
                paramMap.put("billGroup", new Integer(billTypeInfo.getBillTypeGroup().getValue()));
                paramMap.put(COL_BILLTYPE, billTypeInfo.getId().toString());
            }
        }
    }

    private void setControlDisplay(boolean isParamSet) {
        if (isParamSet) {
            this.kDTabbedPane1.add((Component)this.tableParam, (Object)this.resHelper.getString("tableParam.constraints"));
            this.kDTabbedPane1.add((Component)this.tableSetting, (Object)this.resHelper.getString("tableSetting.constraints"));
            this.kDTabbedPane1.add((Component)this.kDPanel3, (Object)this.resHelper.getString("kDPanel3.constraints"));
        } else {
            this.kDTabbedPane1.remove((Component)this.kDPanel3);
            this.kDTabbedPane1.remove((Component)this.tableSetting);
        }
    }

    private void initKDTreeMain(JTree kdTree) throws Exception {
        kdTree.setModel(new DefaultTreeModel((TreeNode)this.createRootNode()));
        kdTree.setShowsRootHandles(true);
        this.treeBill.setSelectionNode((DefaultKingdeeTreeNode)this.rootTreeNode);
    }

    private DefaultKingdeeTreeNode createRootNode() throws Exception {
        BillTypeInfo rootBillTypeInfo = new BillTypeInfo();
        rootBillTypeInfo.setNumber(ROOTTAG);
        rootBillTypeInfo.setName(EASResource.getString((String)RESOURCENAME, (String)"BillTypeTitle"));
        this.rootTreeNode = new KDTreeNode((Object)rootBillTypeInfo);
        ArrayList<BillTypeGroupEnum> billTypeList = new ArrayList<BillTypeGroupEnum>();
        billTypeList.add(BillTypeGroupEnum.PURCHASE);
        billTypeList.add(BillTypeGroupEnum.SALE);
        billTypeList.add(BillTypeGroupEnum.SUBCONTRACT);
        billTypeList.add(BillTypeGroupEnum.INVENTORY);
        billTypeList.add(BillTypeGroupEnum.CALCULATE);
        billTypeList.add(BillTypeGroupEnum.TRANSPORT);
        for (BillTypeGroupEnum billTypeValue : billTypeList) {
            BillTypeInfo subBillTypeInfo = new BillTypeInfo();
            subBillTypeInfo.setNumber(SUBTAG);
            subBillTypeInfo.setName(billTypeValue.getAlias());
            subBillTypeInfo.setBillTypeGroup(billTypeValue);
            KDTreeNode subTreeNode = new KDTreeNode((Object)subBillTypeInfo);
            this.addChildrenToNode(billTypeValue, subTreeNode);
            this.rootTreeNode.add((MutableTreeNode)subTreeNode);
        }
        return this.rootTreeNode;
    }

    private Vector vctBillTypeFilter() {
        Vector<String> vct = new Vector<String>();
        vct.add("510b6503-0105-1000-e000-010fc0a812fd463ED552");
        vct.add("510b6503-0105-1000-e000-0117c0a812fd463ED552");
        return vct;
    }

    private void addChildrenToNode(BillTypeGroupEnum billTypeGroupEnum, KDTreeNode treeNode) throws Exception {
        IBillType iBillType = BillTypeFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)new Integer(billTypeGroupEnum.getValue()), CompareType.EQUALS));
        entityView.getSelector().add(new SelectorItemInfo(COL_ID));
        entityView.getSelector().add(new SelectorItemInfo(COL_NAME));
        entityView.getSelector().add(new SelectorItemInfo(COL_NUMBER));
        entityView.setFilter(filterInfo);
        BillTypeCollection collection = iBillType.getBillTypeCollection(entityView);
        if (collection != null && collection.size() > 0) {
            Vector vct = this.vctBillTypeFilter();
            for (int i = 0; i < collection.size(); ++i) {
                BillTypeInfo aBillTypeInfo = collection.get(i);
                if (vct.contains(aBillTypeInfo.getId().toString())) continue;
                aBillTypeInfo.setBillTypeGroup(billTypeGroupEnum);
                KDTreeNode childrenNode = new KDTreeNode((Object)aBillTypeInfo);
                treeNode.add((MutableTreeNode)childrenNode);
            }
        }
    }

    protected IRow insertLine(int index, KDTable kdTable) {
        return kdTable.addRow(index);
    }

    private void fillTableParamTable(SCMBillParamValueCollection spvc) {
        this.clearTableParam(this.tableParam);
        if (spvc != null && spvc.size() > 0) {
            IRow iRow = null;
            SCMBillParamValueInfo sp = null;
            for (int i = 0; i < spvc.size(); ++i) {
                iRow = this.insertLine(i, this.tableParam);
                sp = spvc.get(i);
                iRow.getCell(COL_PARAMVALUE).getStyleAttributes().setLocked(!sp.getParam().isCanBeModified());
                int paramType = sp.getParam().getInt(COL_PARAMTYPE);
                String number = sp.getParam().getNumber();
                String strDateFormat = SCMClientUtils.strDateFormat;
                if (3 == paramType) {
                    iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
                    iRow.getCell(COL_PARAMVALUE).setValue((Object)new Boolean(new Integer(sp.getParamValue()) == 1));
                } else if (4 == paramType) {
                    iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
                    iRow.getCell(COL_PARAMVALUE).getStyleAttributes().setNumberFormat(strDateFormat);
                    iRow.getCell(COL_PARAMVALUE).setValue((Object)sp.getParamValue());
                } else if (2 == paramType) {
                    iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.getNewFormatTxtField(sp.getParam().getPrecision())));
                    iRow.getCell(COL_PARAMVALUE).setValue((Object)sp.getParamValue());
                } else if (0 == paramType) {
                    iRow.getCell(COL_PARAMVALUE).setValue((Object)sp.getParamValue());
                } else if (1 == paramType) {
                    iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.getNewFormatTxtField(0)));
                    iRow.getCell(COL_PARAMVALUE).setValue((Object)sp.getParamValue());
                } else if (5 == paramType) {
                    if ("IsControlBudget".equals(number)) {
                        Object[] obj = PurControlBudgetEnum.getEnumList().toArray();
                        Object[] newObj = new Object[]{obj[0], obj[1]};
                        iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(newObj)));
                        iRow.getCell(COL_PARAMVALUE).setValue((Object)PurControlBudgetEnum.getEnum(Integer.parseInt(sp.getParamValue())).getAlias(locale));
                    } else if ("PUR_BudgetFields".equals(number)) {
                        iRow.getCell(COL_PARAMVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(PurControlBudgetFieldsEnum.getEnumList().toArray())));
                        iRow.getCell(COL_PARAMVALUE).setValue((Object)PurControlBudgetFieldsEnum.getEnum(Integer.parseInt(sp.getParamValue())).getAlias(locale));
                    }
                }
                iRow.getCell(COL_PARAMTYPE).setValue((Object)sp.getParam().getParamType());
                iRow.getCell(COL_BILLTYPE).setValue((Object)sp.getParam().getBillType().getName());
                iRow.getCell(COL_NUMBER).setValue((Object)sp.getParam().getNumber());
                iRow.getCell(COL_NAME).setValue((Object)sp.getParam().getName());
                iRow.getCell(COL_CANBEMODIFIED).setValue((Object)new Boolean(sp.getParam().isCanBeModified()));
                iRow.getCell(COL_DEFAULTVALUE).setValue((Object)sp.getParam().getDefaultValue());
                iRow.getCell(COL_DESCRIPTION).setValue((Object)sp.getParam().getDescription());
                iRow.getCell(COL_LASTUPDATEUSER).setValue((Object)sp.getParam().getLastUpdateUser());
                iRow.getCell(COL_LASTUPDATETIME).setValue((Object)sp.getParam().getLastUpdateTime());
                iRow.getCell(COL_ID).setValue((Object)sp.getId());
            }
        }
    }

    private void fillTableSettingTable(SCMBillParamCollection spc) {
        this.clearTableParam(this.tableSetting);
        if (spc != null && spc.size() > 0) {
            IRow iRow = null;
            SCMBillParamInfo sp = null;
            for (int i = 0; i < spc.size(); ++i) {
                iRow = this.insertLine(i, this.tableSetting);
                sp = spc.get(i);
                iRow.getCell(COL_PARAMTYPE).setValue((Object)sp.getParamType());
                iRow.getCell(COL_BILLTYPE).setValue((Object)sp.getBillType().getName());
                iRow.getCell(COL_NUMBER).setValue((Object)sp.getNumber());
                iRow.getCell(COL_NAME).setValue((Object)sp.getName());
                iRow.getCell(COL_CANBEMODIFIED).setValue((Object)new Boolean(sp.isCanBeModified()));
                iRow.getCell(COL_DEFAULTVALUE).setValue((Object)sp.getDefaultValue());
                iRow.getCell(COL_DESCRIPTION).setValue((Object)sp.getDescription());
                iRow.getCell(COL_LASTUPDATEUSER).setValue((Object)sp.getLastUpdateUser());
                iRow.getCell(COL_LASTUPDATETIME).setValue((Object)sp.getLastUpdateTime());
                iRow.getCell(COL_ID).setValue((Object)sp.getId());
            }
        }
    }

    private KDFormattedTextField getNewFormatTxtField(int precision) {
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setPrecision(precision);
        txtField.setMaximumValue((Comparable)InvClientUtils.MAXVAL);
        txtField.setMinimumValue((Comparable)InvClientUtils.MINVAL);
        txtField.setNegatived(false);
        txtField.setHorizontalAlignment(4);
        return txtField;
    }

    private void clearTableParam(KDTable kdTable) {
        for (int i = kdTable.getRowCount() - 1; i >= 0; --i) {
            kdTable.getSelectManager().select(i, 0, i, 0, 2);
            kdTable.removeRow(i);
        }
    }

    private Map getParamFilterData(int filterType) {
        TreePath treePath = this.treeBill.getSelectionPath();
        if (treePath != null) {
            HashMap<String, Object> paramHash = new HashMap<String, Object>();
            paramHash.put("orgType", new Integer(this.selOrgType.getValue()));
            if (filterType != 0) {
                if (this.selOrgUnitInfo == null || this.selOrgUnitInfo.getId() == null) {
                    return null;
                }
                paramHash.put("orgUnitID", this.selOrgUnitInfo.getId().toString());
            }
            if (filterType == 1) {
                paramHash.put("displayHided", new Boolean(false));
            } else if (filterType == 2) {
                paramHash.put("displayHided", new Boolean(false));
            }
            this.setBillTypeParam(paramHash);
            return paramHash;
        }
        return null;
    }

    private SCMBillParamValueCollection getParamValueCollection(Map paramHash) {
        try {
            if (paramHash != null) {
                ISCMBillParamValue iSCMBillParam = SCMBillParamValueFactory.getRemoteInstance();
                SCMBillParamValueCollection sCMBillParamValueCollection = iSCMBillParam.getParamValueCollection(paramHash);
                return sCMBillParamValueCollection;
            }
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    private SCMBillParamCollection getParamCollection(Map paramHash) {
        try {
            if (paramHash != null) {
                ISCMBillParam iSCMBillParam = SCMBillParamFactory.getRemoteInstance();
                SCMBillParamCollection sCMBillParamCollection = iSCMBillParam.getParamCollection(paramHash);
                return sCMBillParamCollection;
            }
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void otherParamSave() throws BOSException, EASBizException {
        this.tableParam.getEditManager().stopEditing();
        try {
            if (this.paramValueMap != null) {
                Object[] pc = this.paramValueMap.values().toArray();
                for (int i = 0; i < pc.length; ++i) {
                    if (pc[i] != null) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESCLASSNAME, (String)"ParamValueCantNull"));
                    SysUtil.abort();
                }
                ISCMBillParamValue ispv = SCMBillParamValueFactory.getRemoteInstance();
                ispv.updateParamValue(this.paramValueMap);
                this.tableParam.removeRows();
                SCMBillParamValueCollection spc = this.getParamValueCollection(this.getParamFilterData(1));
                this.fillTableParamTable(spc);
            }
        }
        finally {
            this.paramValueMap = null;
        }
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
    }

    public Vector getOrgTypeVect() throws BOSException, EASBizException {
        Vector<OrgType> vect = new Vector<OrgType>();
        vect.add(OrgType.Storage);
        vect.add(OrgType.Company);
        vect.add(OrgType.Sale);
        vect.add(OrgType.Purchase);
        vect.add(OrgType.Admin);
        vect.add(OrgType.Transport);
        return vect;
    }

    public void setOrgInfo(OrgType arg0, OrgUnitInfo arg1, OrgTreeInfo arg2) {
        if (arg0 == null) {
            return;
        }
        this.selOrgType = arg0;
        this.selOrgUnitInfo = arg1;
        HashMap paramMap = (HashMap)this.getParamFilterData(1);
        SCMBillParamValueCollection spc = this.getParamValueCollection(this.getParamFilterData(1));
        String billType = null;
        if (paramMap != null) {
            billType = (String)paramMap.get(COL_BILLTYPE);
        }
        if (billType == null) {
            SCMBillParamValueCollection spvs;
            spc = spvs = this.filterSCMBillParamValue(spc);
        }
        this.fillTableParamTable(spc);
        SCMBillParamCollection spvc = this.getParamCollection(this.getParamFilterData(2));
        if (billType == null) {
            SCMBillParamCollection spvcs;
            spvc = spvcs = this.filterSCMBillParam(spvc);
        }
        this.fillTableSettingTable(spvc);
    }

    private SCMBillParamValueCollection filterSCMBillParamValue(SCMBillParamValueCollection spc) {
        SCMBillParamValueCollection spcs = new SCMBillParamValueCollection();
        if (spc != null) {
            Iterator it = spc.iterator();
            while (it.hasNext()) {
                String strBillTypeId;
                SCMBillParamValueInfo spcInfo = (SCMBillParamValueInfo)it.next();
                if (spcInfo.getParam() == null || spcInfo.getParam().getBillType() == null || (strBillTypeId = spcInfo.getParam().getBillType().getId().toString()).equals("JeCqeo42zUqaIctYbVWT+UY+1VI=") || strBillTypeId.equals("w0K1/r+3S7m9EroqYHhIvUY+1VI=") || strBillTypeId.equals("e3soUQaBR8un8D2R7UpNwkY+1VI=") || strBillTypeId.equals("3fY8szOQTQmfaNi+Tm5SJUY+1VI=") || strBillTypeId.equals("Tgx4hbjrTRCki6pl2V5aLkY+1VI=") || strBillTypeId.equals("ejIZHXXTQliYCQJg9t4Re0Y+1VI=") || strBillTypeId.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=") || strBillTypeId.equals("PJSZtgEhEADgAAJ8fwAAAUY+1VI=") || strBillTypeId.equals("B2aZSVXaSx6qxdfekgCmrEY+1VI=") || strBillTypeId.equals("YnsvoPSeRzCK0b/jEufQpkY+1VI=") || strBillTypeId.equals("nb+ReM6GTqiwiF1vm0/PCkY+1VI=") || strBillTypeId.equals("WB3X6gEqEADgAAB5fwAAAUY+1VI=") || strBillTypeId.equals("EVuaJtWZ4kKbRG9czgLdmkY+1VI=") || strBillTypeId.equals("nZKqC2a2IFXgQAB/AQBHNUY+1VI=") || strBillTypeId.equals("n0SwvzJuRMzgQAB/AQB9lEY+1VI=") || strBillTypeId.equals("n0nEWp9zUUDgQAB/AQALcUY+1VI=") || strBillTypeId.equals("pGdb1wEaEADgAABFwKg9C0Y+1VI=") || strBillTypeId.equals("pGlaTAEaEADgAABEwKg9C0Y+1VI=") || strBillTypeId.equals("pGcPqwEaEADgAAAywKg9C0Y+1VI=") || strBillTypeId.equals("pGlaewEaEADgAAA+wKg9C0Y+1VI=") || strBillTypeId.equals("VnuqmgEhEADgAAAMwKgPZ7dsPo0=") || strBillTypeId.equals("PQmB0qv6S02gx+xypWAQo8LWunc=") || strBillTypeId.equals("528d806a-0106-1000-e111-0194c0a812e6463ED552")) continue;
                spcs.add(spcInfo);
            }
        }
        return spcs;
    }

    private SCMBillParamCollection filterSCMBillParam(SCMBillParamCollection spvc) {
        SCMBillParamCollection spvcs = new SCMBillParamCollection();
        if (spvc != null) {
            Iterator it = spvc.iterator();
            while (it.hasNext()) {
                String strBillTypeId;
                SCMBillParamInfo spInfo = (SCMBillParamInfo)it.next();
                if (spInfo.getBillType() == null || (strBillTypeId = spInfo.getBillType().getId().toString()).equals("JeCqeo42zUqaIctYbVWT+UY+1VI=") || strBillTypeId.equals("w0K1/r+3S7m9EroqYHhIvUY+1VI=") || strBillTypeId.equals("e3soUQaBR8un8D2R7UpNwkY+1VI=") || strBillTypeId.equals("3fY8szOQTQmfaNi+Tm5SJUY+1VI=") || strBillTypeId.equals("Tgx4hbjrTRCki6pl2V5aLkY+1VI=") || strBillTypeId.equals("ejIZHXXTQliYCQJg9t4Re0Y+1VI=") || strBillTypeId.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=") || strBillTypeId.equals("PJSZtgEhEADgAAJ8fwAAAUY+1VI=") || strBillTypeId.equals("B2aZSVXaSx6qxdfekgCmrEY+1VI=") || strBillTypeId.equals("YnsvoPSeRzCK0b/jEufQpkY+1VI=") || strBillTypeId.equals("nb+ReM6GTqiwiF1vm0/PCkY+1VI=") || strBillTypeId.equals("HxPKDRdzRpaqr31LD+3SBEY+1VI=") || strBillTypeId.equals("pGdb1wEaEADgAABFwKg9C0Y+1VI=") || strBillTypeId.equals("pGlaTAEaEADgAABEwKg9C0Y+1VI=") || strBillTypeId.equals("pGcPqwEaEADgAAAywKg9C0Y+1VI=") || strBillTypeId.equals("pGlaewEaEADgAAA+wKg9C0Y+1VI=") || strBillTypeId.equals("VnuqmgEhEADgAAAMwKgPZ7dsPo0=") || strBillTypeId.equals("PQmB0qv6S02gx+xypWAQo8LWunc=") || strBillTypeId.equals("528d806a-0106-1000-e111-0194c0a812e6463ED552")) continue;
                spvcs.add(spInfo);
            }
        }
        return spvcs;
    }

    class tableParamValueChangedListener
    implements KDTEditListener {
        tableParamValueChangedListener() {
        }

        public void editStopped(KDTEditEvent e) {
            SCMBillParamUI.this.tableParam_changed(e);
        }

        public void editStarting(KDTEditEvent e) {
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editCanceled(KDTEditEvent e) {
        }
    }

    class paramTypeChangedListener
    implements ActionListener {
        paramTypeChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParamDataType pdt = (ParamDataType)SCMBillParamUI.this.cmbParamType.getSelectedItem();
            if (pdt == null) {
                return;
            }
            if (pdt.getValue() == 0) {
                SCMBillParamUI.this.kDLabelContainer5.setBoundEditor((JComponent)SCMBillParamUI.this.txtParamValue);
                SCMBillParamUI.this.txtParamValue.setVisible(true);
                SCMBillParamUI.this.numParamValue.setVisible(false);
                SCMBillParamUI.this.dateParamValue.setVisible(false);
                SCMBillParamUI.this.comboxParamValue.setVisible(false);
                SCMBillParamUI.this.txtPrecision.setEnabled(false);
                SCMBillParamUI.this.txtPrecision.setValue(null);
                SCMBillParamUI.this.txtDefaultValue.setText(null);
            } else if (pdt.getValue() == 1) {
                SCMBillParamUI.this.kDLabelContainer5.setBoundEditor((JComponent)SCMBillParamUI.this.numParamValue);
                SCMBillParamUI.this.txtParamValue.setVisible(false);
                SCMBillParamUI.this.numParamValue.setVisible(true);
                SCMBillParamUI.this.numParamValue.setDataType(0);
                SCMBillParamUI.this.dateParamValue.setVisible(false);
                SCMBillParamUI.this.comboxParamValue.setVisible(false);
                SCMBillParamUI.this.txtPrecision.setEnabled(false);
                SCMBillParamUI.this.txtPrecision.setValue(null);
                SCMBillParamUI.this.txtDefaultValue.setText(null);
            } else if (pdt.getValue() == 2) {
                SCMBillParamUI.this.kDLabelContainer5.setBoundEditor((JComponent)SCMBillParamUI.this.numParamValue);
                SCMBillParamUI.this.txtParamValue.setVisible(false);
                SCMBillParamUI.this.numParamValue.setVisible(true);
                SCMBillParamUI.this.numParamValue.setDataType(1);
                SCMBillParamUI.this.dateParamValue.setVisible(false);
                SCMBillParamUI.this.comboxParamValue.setVisible(false);
                SCMBillParamUI.this.txtPrecision.setEnabled(true);
                SCMBillParamUI.this.txtPrecision.setValue((Object)new Integer(2));
                SCMBillParamUI.this.txtDefaultValue.setText(null);
            } else if (pdt.getValue() == 4) {
                SCMBillParamUI.this.kDLabelContainer5.setBoundEditor((JComponent)SCMBillParamUI.this.dateParamValue);
                SCMBillParamUI.this.txtParamValue.setVisible(false);
                SCMBillParamUI.this.numParamValue.setVisible(false);
                SCMBillParamUI.this.comboxParamValue.setVisible(false);
                SCMBillParamUI.this.dateParamValue.setVisible(true);
                SCMBillParamUI.this.txtPrecision.setEnabled(false);
                SCMBillParamUI.this.txtPrecision.setValue(null);
                SCMBillParamUI.this.txtDefaultValue.setText(null);
            } else if (pdt.getValue() == 3) {
                SCMBillParamUI.this.kDLabelContainer5.setBoundEditor((JComponent)SCMBillParamUI.this.comboxParamValue);
                SCMBillParamUI.this.comboxParamValue.setVisible(true);
                SCMBillParamUI.this.txtParamValue.setVisible(false);
                SCMBillParamUI.this.numParamValue.setVisible(false);
                SCMBillParamUI.this.dateParamValue.setVisible(false);
                SCMBillParamUI.this.txtPrecision.setEnabled(false);
                SCMBillParamUI.this.txtPrecision.setValue(null);
                SCMBillParamUI.this.txtDefaultValue.setText("1");
            }
        }
    }

    class precisionChangedListener
    implements DataChangeListener {
        precisionChangedListener() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            SCMBillParamUI.this.setPrecision();
        }
    }

    class treeChangedListener
    implements TreeSelectionListener {
        treeChangedListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SCMBillParamUI.this.tree_changed(e);
        }
    }
}

