/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.ISCMBizChainParams;
import com.kingdee.eas.scm.common.OperateTypeEnum;
import com.kingdee.eas.scm.common.ProcessTypeEnum;
import com.kingdee.eas.scm.common.SCMBizChainParamsCollection;
import com.kingdee.eas.scm.common.SCMBizChainParamsFactory;
import com.kingdee.eas.scm.common.SCMBizChainParamsInfo;
import com.kingdee.eas.scm.common.client.AbstractSCMBizChainParamsRptUI;
import com.kingdee.eas.scm.common.client.SCMBizChainParamsFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SCMBizChainParamsRptUI
extends AbstractSCMBizChainParamsRptUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SCMBizChainParamsRptUI.class);
    private static final String SCMBIZCHAINPARAMS_RESOURCE = "com.kingdee.eas.scm.common.SCMBizChainParamsResource";

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(10);
        super.onLoad();
        this.tHelper.setCanMoveColumn(true);
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getActionMap().remove("Paste");
        this.actionPopupPaste.setVisible(false);
    }

    protected void query() {
        try {
            this.kDTable1.removeRows();
            this.initTableData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.handUIException(e);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.showMessageInfo(EASResource.getString((String)SCMBIZCHAINPARAMS_RESOURCE, (String)"004_REFRESH_OK"));
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    protected void actionCacelCacel_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable1.getSelectManager().size(); ++i) {
            KDTSelectBlock sb = this.kDTable1.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                this.kDTable1.getRow(j).getCell("isUsed").setValue((Object)true);
            }
        }
        this.actionSubmit_actionPerformed(e);
        this.showMessageInfo(EASResource.getString((String)SCMBIZCHAINPARAMS_RESOURCE, (String)"001_CACELCACEL_OK"));
    }

    @Override
    protected void actionCacel_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable1.getSelectManager().size(); ++i) {
            KDTSelectBlock sb = this.kDTable1.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                this.kDTable1.getRow(j).getCell("isUsed").setValue((Object)false);
            }
        }
        this.actionSubmit_actionPerformed(e);
        this.showMessageInfo(EASResource.getString((String)SCMBIZCHAINPARAMS_RESOURCE, (String)"002_CACEL_OK"));
    }

    private void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ISCMBizChainParams iSCMBizChainParams = (ISCMBizChainParams)this.getBizInterface();
        iSCMBizChainParams.submitData((IObjectCollection)this.loadDataForSubmit());
    }

    private SCMBizChainParamsCollection loadDataForSubmit() {
        SCMBizChainParamsCollection collection = new SCMBizChainParamsCollection();
        for (int i = 0; i < this.kDTable1.getSelectManager().size(); ++i) {
            KDTSelectBlock sb = this.kDTable1.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                SCMBizChainParamsInfo info = new SCMBizChainParamsInfo();
                String fid = this.kDTable1.getRow(j).getCell("id").getValue().toString();
                info.setId(BOSUuid.read((String)fid));
                info.setBillBosType(this.kDTable1.getRow(j).getCell("billBosType").getValue().toString());
                info.setBillName(this.kDTable1.getRow(j).getCell("billName").getValue().toString());
                String actionNumber = this.kDTable1.getRow(j).getCell("actionNumber").getValue().toString();
                info.setActionNumber(actionNumber);
                info.setActionName(OperateTypeEnum.getEnum(actionNumber));
                String processNumber = this.kDTable1.getRow(j).getCell("processNumber").getValue().toString();
                info.setProcessNumber(processNumber);
                info.setProcessName(ProcessTypeEnum.getEnum(processNumber.substring(processNumber.lastIndexOf(".") + 1)));
                info.setIsUsed((Boolean)this.kDTable1.getRow(j).getCell("isUsed").getValue());
                collection.add(info);
            }
        }
        return collection;
    }

    private void initTableData() throws Exception {
        ISCMBizChainParams iSCMBizChainParams = SCMBizChainParamsFactory.getRemoteInstance();
        SCMBizChainParamsCollection conn = iSCMBizChainParams.queryData(this.params);
        for (int i = 0; i < conn.size(); ++i) {
            IRow row = this.kDTable1.addRow();
            row.getCell("id").setValue((Object)conn.get(i).getId());
            row.getCell("billBosType").setValue((Object)conn.get(i).getBillBosType());
            row.getCell("billName").setValue((Object)conn.get(i).getBillName());
            row.getCell("actionNumber").setValue((Object)conn.get(i).getActionNumber());
            row.getCell("actionName").setValue((Object)conn.get(i).getActionName());
            row.getCell("processNumber").setValue((Object)conn.get(i).getProcessNumber());
            row.getCell("processName").setValue((Object)conn.get(i).getProcessName());
            row.getCell("isUsed").setValue((Object)conn.get(i).isIsUsed());
        }
    }

    private void showMessageInfo(String message) {
        this.setMessageText(message);
        this.showMessage();
    }

    private ICoreBase getBizInterface() throws Exception {
        return SCMBizChainParamsFactory.getRemoteInstance();
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        SCMBizChainParamsFilterUI filterUI = new SCMBizChainParamsFilterUI();
        return filterUI;
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return null;
    }

    protected RptParams getParamsForInit() {
        return null;
    }
}

