/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.MultiOUs4OrgFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBrowseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.util.app.ContextUtil;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class SCMGroupClientUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.client.SCMGroupClientUtils");

    public static OrgUnitCollection getOrgsByRelation(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        Object result = null;
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: 
            case 4: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 24: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static boolean isAuthoriedForOrg(IObjectPK user, OrgType orgType, IObjectPK orgPK, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = SCMGroupClientUtils.getAuthOrgByPermItem(user, orgType, permItem);
        if (result != null) {
            for (int i = 0; i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(orgPK.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void setBizOrgF7ByType(KDBizPromptBox bizOrgUnitBox, OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (bizOrgUnitBox == null) {
            return;
        }
        String query = null;
        if (orgType.equals((Object)OrgType.Storage)) {
            query = "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            query = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Sale)) {
            query = "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Company)) {
            query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Admin)) {
            query = "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery";
        } else if (OrgType.Quality.equals((Object)orgType)) {
            query = "com.kingdee.eas.basedata.org.app.QualityItemQuery";
        } else {
            return;
        }
        bizOrgUnitBox.setQueryInfo(query);
        if (!orgType.equals((Object)OrgType.Admin)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Integer.valueOf("1"), CompareType.EQUALS));
            view.setFilter(filter);
            bizOrgUnitBox.setEntityViewInfo(view);
        }
        if (!OrgType.Admin.equals((Object)mainOrgType)) {
            bizOrgUnitBox.setFilterInfoProducer(SCMGroupClientUtils.getOrgUnitProducer(orgType, mainOrgType, isSingleMainOrg));
        }
    }

    private static IFilterInfoProducer getOrgUnitProducer(OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (isSingleMainOrg) {
            IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)SCMGroupClientUtils.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
            OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
            producer.getModel().setDoNotUseUserOrgRangeAsFilter();
            return producer;
        }
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getMultiOUs4OrgFilterInfoProducer(null, (OrgType)mainOrgType, (DelegationPartsEnum)SCMGroupClientUtils.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
        MultiOUs4OrgFilterInfoProducer producer = (MultiOUs4OrgFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        return producer;
    }

    private static DelegationPartsEnum getDelegationDirection(OrgType orgType, OrgType mainOrgType) {
        int iMainType = mainOrgType.getValue();
        int iDeleType = orgType.getValue();
        switch (iMainType) {
            case 1: {
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 2: {
                if (iDeleType == 4) {
                    return DelegationPartsEnum.THE_FROM_UNIT;
                }
                return DelegationPartsEnum.THE_TO_UNIT;
            }
            case 3: {
                if (iDeleType == 1 || iDeleType == 32) {
                    return DelegationPartsEnum.THE_TO_UNIT;
                }
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 4: {
                return DelegationPartsEnum.THE_TO_UNIT;
            }
            case 24: {
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
        }
        return DelegationPartsEnum.THE_TO_UNIT;
    }

    public static GeneralKDPromptSelectorAdaptor setBizSupplierF7(KDBizPromptBox bizSupplierBox, Component owner, OrgType mainOrgType, String queryInfo) {
        return SCMGroupClientUtils.setBizSupplierF7(bizSupplierBox, owner, mainOrgType, queryInfo, false);
    }

    public static GeneralKDPromptSelectorAdaptor setBizSupplierF7(KDBizPromptBox bizSupplierBox, Component owner, OrgType mainOrgType, String queryInfo, boolean isReportFilter) {
        if (bizSupplierBox == null) {
            return null;
        }
        if (queryInfo != null) {
            bizSupplierBox.setQueryInfo(queryInfo);
        }
        GeneralKDPromptSelectorAdaptor selectorListenerSupplier = queryInfo != null ? new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizSupplierBox, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)owner, CSSPGroupInfo.getBosType(), QueryInfoConstants.getSupplierQueryInfo(mainOrgType, isReportFilter), "browseGroup.id", QueryInfoConstants.getSupplierQueryOrgId(mainOrgType)) : new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizSupplierBox, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)owner, CSSPGroupInfo.getBosType(), QueryInfoConstants.getSupplierQueryInfo(mainOrgType, isReportFilter), "browseGroup.id", QueryInfoConstants.getSupplierQueryOrgId(mainOrgType), QueryInfoConstants.getStdSupplierQueryInfo(mainOrgType, isReportFilter));
        bizSupplierBox.setSelector((KDPromptSelector)selectorListenerSupplier);
        bizSupplierBox.addSelectorListener((SelectorListener)selectorListenerSupplier);
        return selectorListenerSupplier;
    }

    public static GeneralKDPromptSelectorAdaptor setBizCustomerF7(KDBizPromptBox bizCustomerBox, Component owner, OrgType mainOrgType, String queryInfo) {
        return SCMGroupClientUtils.setBizCustomerF7(bizCustomerBox, owner, mainOrgType, false, queryInfo);
    }

    public static GeneralKDPromptSelectorAdaptor setBizCustomerF7(KDBizPromptBox bizCustomerBox, Component owner, OrgType mainOrgType, boolean isMultiSelect, String queryInfo) {
        return SCMGroupClientUtils.setBizCustomerF7(bizCustomerBox, owner, mainOrgType, isMultiSelect, queryInfo, false);
    }

    public static GeneralKDPromptSelectorAdaptor setBizCustomerF7(KDBizPromptBox bizCustomerBox, Component owner, OrgType mainOrgType, boolean isMultiSelect, String queryInfo, boolean isReportFilter) {
        if (bizCustomerBox == null) {
            return null;
        }
        if (queryInfo != null) {
            bizCustomerBox.setQueryInfo(queryInfo);
        }
        GeneralKDPromptSelectorAdaptor selectorListenerCustomer = null;
        selectorListenerCustomer = queryInfo != null ? new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizCustomerBox, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)owner, CSSPGroupInfo.getBosType(), QueryInfoConstants.getStdCustomerQueryInfo(mainOrgType, isReportFilter), "browseGroup.id", QueryInfoConstants.getCustomerQueryOrgId(mainOrgType)) : new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizCustomerBox, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)owner, CSSPGroupInfo.getBosType(), QueryInfoConstants.getCustomerQueryInfo(mainOrgType, isReportFilter), "browseGroup.id", QueryInfoConstants.getCustomerQueryOrgId(mainOrgType), QueryInfoConstants.getStdCustomerQueryInfo(mainOrgType, isReportFilter));
        bizCustomerBox.setSelector((KDPromptSelector)selectorListenerCustomer);
        bizCustomerBox.addSelectorListener((SelectorListener)selectorListenerCustomer);
        if (isMultiSelect) {
            selectorListenerCustomer.setIsMultiSelect(true);
        }
        return selectorListenerCustomer;
    }

    public static F7MaterialMultiUISelectorAdaptor setBizMaterialF7(KDBizPromptBox bizMaterialBox, Component owner, OrgType mainOrgType, boolean isMulSelect, String queryInfo) {
        if (bizMaterialBox == null) {
            return null;
        }
        if (queryInfo != null) {
            bizMaterialBox.setQueryInfo(queryInfo);
        }
        bizMaterialBox.setEditable(true);
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        if (queryInfo != null) {
            if (queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery") || queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery")) {
                String query = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanNoGroupQuery";
                if (queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery")) {
                    query = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery";
                }
                selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI", (Object)owner, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", QueryInfoConstants.getMaterialQueryOrgId(mainOrgType), query);
            } else {
                selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI", (Object)owner, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", QueryInfoConstants.getMaterialQueryOrgId(mainOrgType));
            }
        } else {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI", (Object)owner, MaterialGroupInfo.getBosType(), QueryInfoConstants.getMaterialQueryInfo(mainOrgType), "materialGroup.id", QueryInfoConstants.getMaterialQueryOrgId(mainOrgType), QueryInfoConstants.getMaterialNoGroupQueryInfo(mainOrgType));
        }
        bizMaterialBox.setSelector((KDPromptSelector)selectorLisenterMaterial);
        bizMaterialBox.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        if (isMulSelect) {
            selectorLisenterMaterial.setIsMultiSelect(true);
        }
        return selectorLisenterMaterial;
    }

    public static GeneralKDPromptSelectorAdaptor setBizChannelF7(KDBizPromptBox bizChannelBox, Component owner, OrgType mainOrgType, boolean isMulSelect, String queryInfo) {
        if (bizChannelBox == null) {
            return null;
        }
        if (queryInfo != null) {
            bizChannelBox.setQueryInfo(queryInfo);
        }
        bizChannelBox.setEditable(true);
        GeneralKDPromptSelectorAdaptor selectorLisenterChannel = null;
        if (queryInfo != null) {
            selectorLisenterChannel = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizChannelBox, "com.kingdee.eas.basedata.scm.sd.channel.client.F7ChannelTreeListUI", (Object)owner, ChannelBrowseGroupInfo.getBosType(), QueryInfoConstants.getChannelQueryInfo(mainOrgType), "materialGroup.id", QueryInfoConstants.getChannelQueryOrgId(mainOrgType));
        }
        bizChannelBox.setSelector(selectorLisenterChannel);
        bizChannelBox.addSelectorListener(selectorLisenterChannel);
        if (isMulSelect && selectorLisenterChannel != null) {
            selectorLisenterChannel.setIsMultiSelect(true);
        }
        return selectorLisenterChannel;
    }

    public static FullOrgUnitInfo getOrgUnitInfo(String id) {
        FullOrgUnitInfo orgInfo = null;
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            orgInfo = iOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
            return orgInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return orgInfo;
        }
    }

    public static DataBaseInfo[] getDataBaseInfos(String ids) {
        try {
            LinkedHashSet idSet = SCMGroupClientUtils.getKeyIdList(ids);
            String id = (String)idSet.iterator().next();
            BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
            if (bosType == null) {
                return null;
            }
            IDataBase iDataBase = (IDataBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, IDataBase.class);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            DataBaseCollection collection = iDataBase.getDataBaseCollection(view);
            DataBaseInfo[] results = new DataBaseInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static OrgUnitInfo[] getOrgUnitInfos(String ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtils.getKeyIdList(ids), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static OrgUnitInfo[] getOrgUnitInfosByNumber(String number) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)SCMGroupClientUtils.getKeyIdList(number), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static LinkedHashSet getKeyIdList(String ids) {
        return SCMGroupClientUtils.getKeyIdList(ids, ";");
    }

    public static LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public static String getKeyIdList(ObjectBaseInfo[] vos, String delim) {
        if (vos == null || vos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vos.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(vos[i].getId().toString());
        }
        return sb.toString();
    }

    public static String getKeyIdList(String[] ids) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(ids[i]).append("'");
        }
        return sb.toString();
    }

    public static OrgUnitInfo getOrgUnitInfoByType(String id, OrgType orgType) {
        OrgUnitInfo orgInfo = null;
        ObjectStringPK pk = new ObjectStringPK(id);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                    return iAdmin.getAdminOrgUnitInfo((IObjectPK)pk);
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    return iCompany.getCompanyOrgUnitInfo((IObjectPK)pk);
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getRemoteInstance();
                    return iSale.getSaleOrgUnitInfo((IObjectPK)pk);
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getRemoteInstance();
                    return iPurchase.getPurchaseOrgUnitInfo((IObjectPK)pk);
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                    return iStorage.getStorageOrgUnitInfo((IObjectPK)pk);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return orgInfo;
    }

    public static OrgUnitInfo[] getOrgUnitInfosByType(FullOrgUnitCollection orgs, OrgType orgType) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getRemoteInstance();
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getRemoteInstance();
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static String getMainOrgNullMsg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return SCMClientUtils.getResource("PURORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return SCMClientUtils.getResource("STORAGENOTNULL");
        }
        if (orgType.equals((Object)OrgType.Sale)) {
            return SCMClientUtils.getResource("SALEORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return SCMClientUtils.getResource("COMPANYORGNOTNULL");
        }
        return SCMClientUtils.getResource("MAINBIZORGISNULL");
    }

    protected static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        if (queryInfo == null) {
            return entityNames;
        }
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo)) continue;
            SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            entityNames.add(entityName);
        }
        return entityNames;
    }

    protected static String getMainEntityName(String queryName) {
        QueryInfo queryInfo = Util.getQueryInfo((String)queryName);
        ArrayList entityNames = SCMGroupClientUtils.getEntitiyNames(queryInfo);
        if (entityNames.size() > 0) {
            return (String)entityNames.get(0);
        }
        return null;
    }

    public static EntityObjectInfo getEntity(String entityName) {
        return Util.getEntity((String)entityName);
    }

    public static boolean isDiffrent4OrgCollection(OrgUnitCollection collection1, OrgUnitCollection collection2) {
        boolean isChanged = false;
        if (collection1 == null && collection2 != null) {
            isChanged = collection2.size() > 0;
        } else if (collection1 != null && collection2 == null) {
            isChanged = collection1.size() > 0;
        } else if (collection1 != null && collection2 != null) {
            if (collection1.size() != collection2.size()) {
                isChanged = true;
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < collection1.size(); ++i) {
                    list.add(collection1.get(i).getId().toString());
                }
                for (i = 0; i < collection2.size(); ++i) {
                    if (list.contains(collection2.get(i).getId().toString())) continue;
                    isChanged = true;
                    break;
                }
            }
        }
        return isChanged;
    }

    public static boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : !arg0.equals(arg1);
        }
        return isChanged;
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) throws Exception {
        Method method = null;
        Class clz = clazz;
        if (clazz == null || methodName == null || methodName.length() == 0) {
            return null;
        }
        while (clz != null && method == null) {
            try {
                method = clz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                clz = clz.getSuperclass();
            }
        }
        return method;
    }

    public static int getF7DisplayMode(String cuId) throws BOSException, EASBizException {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            return Integer.valueOf(ipc.getParamValue((IObjectPK)pk, "F7DISPLAYMODE"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void isCurrentMainOrgChanged(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext) {
        FilterInfo bizFilterInfo;
        boolean isHasPorperty = false;
        EntityViewInfo view = null;
        view = promptBox.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if ((bizFilterInfo = SCMGroupClientUtils.getBizFilterInfo(promptBox, propertyOfBizOrg, mainOrgContext)) == null) {
            return;
        }
        if (view != null && view.getFilter() != null && view.getFilter().getFilterItems().size() > 0) {
            FilterItemInfo itemInfo = null;
            for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                itemInfo = view.getFilter().getFilterItems().get(i);
                if (propertyOfBizOrg == null || itemInfo.getPropertyName().indexOf(propertyOfBizOrg) < 0) continue;
                view.getFilter().getFilterItems().set(i, bizFilterInfo.getFilterItems().get(0));
                isHasPorperty = true;
            }
        }
        try {
            if (view.getFilter() != null && view.getFilter().getFilterItems().size() > 0) {
                if (bizFilterInfo != null && !isHasPorperty) {
                    view.getFilter().mergeFilter(bizFilterInfo, "and");
                }
            } else if (bizFilterInfo != null && !isHasPorperty) {
                view.setFilter(bizFilterInfo);
            }
            if (promptBox instanceof KDBizPromptBox) {
                promptBox.setEntityViewInfo(view);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static FilterInfo getBizFilterInfo(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext) {
        FilterInfo bizFilterInfo = null;
        if (promptBox.getCurrentMainBizOrgUnit() != null) {
            OrgUnitInfo orgUnitInfo = promptBox.getCurrentMainBizOrgUnit();
            CtrlUnitInfo cu = orgUnitInfo.getCU();
            if (cu == null && mainOrgContext != null) {
                cu = (CtrlUnitInfo)mainOrgContext.get((Object)OrgType.ControlUnit);
            }
            if (cu == null) {
                try {
                    IFullOrgUnit iFullOrg = FullOrgUnitFactory.getRemoteInstance();
                    orgUnitInfo = iFullOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (cu == null) {
                cu = ContextUtil.getCurrentCtrlUnit((Context)mainOrgContext);
            }
            String cuId = cu.getId().toString();
            if (propertyOfBizOrg != null && !propertyOfBizOrg.trim().equals("")) {
                bizFilterInfo = new FilterInfo();
                if (!orgUnitInfo.getId().toString().equals(cuId)) {
                    StringBuffer orgIdBuffer = new StringBuffer();
                    orgIdBuffer.append(orgUnitInfo.getId().toString());
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
                } else {
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        } else if (promptBox.getMainBizOrgs() != null) {
            OrgUnitCollection collection = promptBox.getMainBizOrgs();
            if (collection.size() > 0) {
                StringBuffer orgIdBuffer = new StringBuffer();
                for (int i = 0; i < collection.size(); ++i) {
                    if (i > 0) {
                        orgIdBuffer.append(",");
                    }
                    orgIdBuffer.append(collection.get(i).getId().toString());
                }
                if (propertyOfBizOrg != null && !propertyOfBizOrg.trim().equals("")) {
                    bizFilterInfo = new FilterInfo();
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
                }
            } else {
                bizFilterInfo = new FilterInfo();
                bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, null, CompareType.EQUALS));
            }
        } else {
            bizFilterInfo = new FilterInfo();
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        return bizFilterInfo;
    }

    public static void setApproved4F7(KDBizPromptBox bizPromptBox) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(view);
    }

    public static void setApproved4SupplierF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        EntityViewInfo viewInfo = SCMGroupClientUtils.getApproved4SupplierF7Filter(orgType);
        EntityViewInfo defaultViewInfo = bizPromptBox.getEntityViewInfo();
        try {
            if (defaultViewInfo != null && defaultViewInfo.getFilter() != null) {
                viewInfo.getFilter().mergeFilter(defaultViewInfo.getFilter(), "and");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    public static EntityViewInfo getApproved4SupplierF7Filter(OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Purchase)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierPurchasing.usingStatus", (Object)new Integer(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierPurchasing.IsFreezeMakeOrder", (Object)false, CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierCompany.isFreezePayment", (Object)false, CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        return view;
    }

    public static void setApproved4CustomerF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        bizPromptBox.setEntityViewInfo(SCMGroupClientUtils.getApproved4CustomerF7Filter(orgType));
    }

    public static EntityViewInfo getApproved4CustomerF7Filter(OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Sale)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.isFreezeOrder", (Object)false, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.isFreezeDelivery", (Object)false, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.usingStatus", (Object)Integer.valueOf("0"), CompareType.EQUALS));
        }
        if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0), CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        return view;
    }

    public static void setApproved4MaterialF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Sale)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Sales.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Purchasing.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Storage)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(view);
    }

    public static void addFilter4EV(EntityViewInfo viewInfo, FilterItemInfo itemInfo) {
        FilterInfo filter = viewInfo.getFilter();
        boolean found = false;
        String key = itemInfo.getPropertyName();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!item.getPropertyName().equalsIgnoreCase(key)) continue;
            item.setCompareType(itemInfo.getCompareType());
            item.setCompareValue(itemInfo.getCompareValue());
            found = true;
        }
        if (!found) {
            FilterInfo info = new FilterInfo();
            info.getFilterItems().add(itemInfo);
            try {
                filter.mergeFilter(info, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }
}

