/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.client.AbstractStorageOrgQueryListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StorageOrgQueryListUI
extends AbstractStorageOrgQueryListUI {
    private static final Logger logger = CoreUIObject.getLogger(StorageOrgQueryListUI.class);
    protected IMetaDataPK mainQueryPK;
    protected HashMap hmQuery = new HashMap();
    private final String[] QTYPRECISIONTAB = new String[]{"curStoreQty", "curStoreAssistQty", "baseQty"};

    public StorageOrgQueryListUI() throws Exception {
        this.onLoad();
    }

    @Override
    public void action_back_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.detailTable.checkParsed();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InvQuery");
    }

    private void initEntriesTableNumberField() throws EASBizException, BOSException {
        SCMClientUtils.changeTableColPrecisionByMaterial(null, null, this.detailTable, this.QTYPRECISIONTAB);
    }

    protected void executQuery() throws BOSException, Exception {
        IRowSet rowSet = this.getQueryExecutor(this.mainQueryPK, this.getEntityViewInfo()).executeQuery();
        this.setRowSetBeforeFillTable(rowSet);
        this.detailTable.removeRows();
        Collection col = rowSet.toCollection();
        if (col.size() != 0) {
            Collection[] colls = new Collection[col.size()];
            System.arraycopy(col.toArray(), 0, colls, 0, col.size());
            KDTableHelper.addRows((KDTable)this.detailTable, (Collection[])colls);
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo() throws Exception {
        EntityViewInfo eni = new EntityViewInfo();
        HashMap hm = this.getHmQueryCon();
        StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
        if (aStorageOrgUnitInfo == null || aStorageOrgUnitInfo.getId() == null) {
            return eni;
        }
        aStorageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(aStorageOrgUnitInfo.getId().toString()));
        this.bizstorageOrg.setValue((Object)aStorageOrgUnitInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)aStorageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        eni.getSelector().add(new SelectorItemInfo("id"));
        eni.getSelector().add(new SelectorItemInfo("material.number"));
        eni.getSelector().add(new SelectorItemInfo("material.name"));
        eni.getSelector().add(new SelectorItemInfo("assistProperty.name"));
        eni.getSelector().add(new SelectorItemInfo("lot"));
        eni.getSelector().add(new SelectorItemInfo("warehouse.name"));
        eni.getSelector().add(new SelectorItemInfo("location.name"));
        eni.getSelector().add(new SelectorItemInfo("storetype.name"));
        eni.getSelector().add(new SelectorItemInfo("unit.name"));
        eni.getSelector().add(new SelectorItemInfo("curStoreQty"));
        eni.getSelector().add(new SelectorItemInfo("assistUnit.name"));
        eni.getSelector().add(new SelectorItemInfo("curStoreAssistQty"));
        eni.getSelector().add(new SelectorItemInfo("FBaseUnit.name"));
        eni.getSelector().add(new SelectorItemInfo("baseQty"));
        eni.getSelector().add(new SelectorItemInfo("multiUnit.qtyPrecision"));
        eni.getSelector().add(new SelectorItemInfo("multiAssistUnit.qtyPrecision"));
        eni.getSelector().add(new SelectorItemInfo("multiBaseUnit.qtyPrecision"));
        eni.getSorter().add(new SorterItemInfo("material.number"));
        eni.getSorter().add(new SorterItemInfo("warehouse.number"));
        eni.setFilter(filter);
        return eni;
    }

    public HashMap getHmQueryCon() {
        return this.hmQuery;
    }

    public void setHmQueryCon(HashMap hmQueryCon) {
        this.hmQuery = hmQueryCon;
    }

    protected void setRowSetBeforeFillTable(IRowSet rowSet) {
        BigDecimal curStoreQty = new BigDecimal("0.0");
        BigDecimal curStoreAssitQty = new BigDecimal("0.0");
        BigDecimal baseQty = new BigDecimal("0.0");
        try {
            while (rowSet.next()) {
                curStoreQty = rowSet.getBigDecimal("curStoreQty");
                curStoreAssitQty = rowSet.getBigDecimal("curStoreAssistQty");
                baseQty = rowSet.getBigDecimal("baseQty");
                if (curStoreQty != null) {
                    rowSet.updateObject("curStoreQty", (Object)curStoreQty.setScale(rowSet.getInt("multiUnit.qtyPrecision"), 4), rowSet.getInt("multiUnit.qtyPrecision"));
                }
                if (curStoreAssitQty != null) {
                    rowSet.updateObject("curStoreAssistQty", (Object)curStoreAssitQty.setScale(rowSet.getInt("multiAssistUnit.qtyPrecision"), 4), rowSet.getInt("multiAssistUnit.qtyPrecision"));
                }
                if (baseQty == null) continue;
                rowSet.updateObject("baseQty", (Object)baseQty.setScale(rowSet.getInt("multiBaseUnit.qtyPrecision"), 4), rowSet.getInt("multiBaseUnit.qtyPrecision"));
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }
}

