/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import java.util.HashMap;
import java.util.Map;

public final class FixedDataCache {
    private static FixedDataCache dataCache;
    private Map dataMap;
    private CompanyOrgUnitInfo cou = SysContext.getSysContext().getCurrentFIUnit();
    private String periodMsg = null;

    private FixedDataCache() {
        this.dataMap = new HashMap();
    }

    public static FixedDataCache getInstance() {
        if (dataCache == null) {
            dataCache = new FixedDataCache();
        }
        return dataCache;
    }

    public void putInCache(BOSObjectType bosType, AbstractObjectCollection collection) {
        this.dataMap.put(bosType, collection);
    }

    public void putInCache(AbstractObjectCollection collection) {
        if (collection != null && collection.size() > 0) {
            IObjectValue value = collection.getObject(0);
            BOSObjectType bosType = value.getBOSType();
            this.dataMap.put(bosType, collection);
        }
    }

    public boolean containsType(BOSObjectType bosType) {
        return this.dataMap.containsKey(bosType);
    }

    public IObjectValue getDataFromCache(IObjectPK pk) {
        BOSUuid id = BOSUuid.read((String)pk.toString());
        BOSObjectType bosType = id.getType();
        AbstractObjectCollection collection = (AbstractObjectCollection)this.dataMap.get(bosType);
        if (collection != null) {
            return collection.getObject((Object)id);
        }
        return null;
    }

    public void initDataLoading(SCMEntryDataVO inDataVO) {
        BOSObjectType bosType;
        if (inDataVO == null) {
            inDataVO = new SCMEntryDataVO();
        }
        inDataVO.setIsLoadingRowType(!this.containsType(bosType = BOSObjectType.create((String)"7C7DC4A3")));
        bosType = BOSObjectType.create((String)"6BCA0AB5");
        inDataVO.setIsLoadingPaymentType(!this.containsType(bosType));
        bosType = BOSObjectType.create((String)"E96B2B8E");
        inDataVO.setIsLoadingSettlementType(!this.containsType(bosType));
    }

    public void putInCache(SCMEntryDataVO inDataVO, SCMEntryDataVO outDataVO) {
        if (inDataVO == null || outDataVO == null) {
            return;
        }
        if (inDataVO.isLoadingRowType()) {
            this.dataMap.put(BOSObjectType.create((String)"7C7DC4A3"), outDataVO.getRowTypes());
        }
        if (inDataVO.isLoadingPaymentType()) {
            this.dataMap.put(BOSObjectType.create((String)"6BCA0AB5"), outDataVO.getPaymentTypes());
        }
        if (inDataVO.isLoadingPaymentType()) {
            this.dataMap.put(BOSObjectType.create((String)"E96B2B8E"), outDataVO.getSettlementTypes());
        }
    }

    private void loadPeriod() throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo;
        if (this.cou != null && (curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.cou)) != null) {
            this.periodMsg = curPeriodInfo.getPeriodYear() + SCMClientUtils.getResource("YEAR") + curPeriodInfo.getPeriodNumber() + SCMClientUtils.getResource("PERIOD");
        }
    }

    public String getPeriodMsg() throws EASBizException, BOSException {
        OrgUnitCollection companys;
        OrgUnitInfo currentOrg = SysContext.getSysContext().getCurrentOrgUnit();
        StorageOrgUnitInfo storageOrg = SysContext.getSysContext().getCurrentStorageUnit();
        CompanyOrgUnitInfo curCOU = SysContext.getSysContext().getCurrentFIUnit();
        String curOrgId = currentOrg.getId().toString();
        CompanyOrgUnitInfo companyOrg = null;
        if (curCOU != null && curOrgId.equals(curCOU.getId().toString())) {
            companyOrg = curCOU;
        } else if (storageOrg != null && curOrgId.equals(storageOrg.getId().toString()) && (companys = OrgUnitRelationFactory.getRemoteInstance().getToUnit(curOrgId, 4, 1)) != null) {
            companyOrg = (CompanyOrgUnitInfo)companys.get(0);
        }
        if (companyOrg == null) {
            companyOrg = curCOU;
        }
        if (this.isCOUChange(companyOrg)) {
            this.resetPeriodMsg();
            this.setCou(companyOrg);
        }
        if (this.periodMsg == null) {
            this.loadPeriod();
        }
        return this.periodMsg;
    }

    private boolean isCOUChange(CompanyOrgUnitInfo curCOU) {
        if (curCOU == null) {
            return true;
        }
        return !curCOU.equals((Object)this.cou);
    }

    public void setCou(CompanyOrgUnitInfo cou) {
        this.cou = cou;
    }

    public void resetPeriodMsg() {
        this.periodMsg = null;
    }
}

