/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.KDTableUtils;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FixedDataCache;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.client.helper.IUiHandling;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;

public abstract class UiHandlingHelper
implements IUiHandling {
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    protected static final BigDecimal ONE = new BigDecimal("1.00");
    private CurrencyInfo baseCurrInfo;
    protected String TB_ROWTYPE = null;
    protected String TB_MATERIAL = null;
    protected String TB_MATERIALNAME = null;
    protected String TB_MATERIALSIZE = null;
    protected String TB_UNIT = null;
    protected String TB_ASSISTUNIT = null;
    protected String TB_ASSISTPROPERTY = null;
    protected String TB_ISPRESENT = null;
    protected String TB_BASEUNIT = null;
    protected String TB_COMPANYORGUNIT = null;
    protected String TB_BASEQTY = null;
    protected String TB_QTY = null;
    protected String TB_ASSISTQTY = null;
    protected String TB_PRICE = null;
    protected String TB_DISCOUNT = null;
    protected String TB_DISCOUNTTYPE = null;
    protected String TB_ACTUALTAXPRICE = null;
    protected String TB_ACTUALPRICE = null;
    protected String TB_DISCOUNTAMOUNT = null;
    protected String TB_AMOUNT = null;
    protected String TB_LOCALAMOUNT = null;
    protected String TB_LOCALTAX = null;
    protected String TB_LOCALTAXAMOUNT = null;
    protected String TB_TAXRATE = null;
    protected String TB_TAXPRICE = null;
    protected String TB_TAX = null;
    protected String TB_TAXAMOUNT = null;
    protected String TB_SENDOVERRATE = null;
    protected String TB_SENDOWINGRATE = null;
    protected KDFormattedTextField txtTotalAmount;
    public static final String txtTotalAmount_Const = "txtTotalAmount";
    protected KDFormattedTextField txtTotalTax;
    public static final String txtTotalTax_Const = "txtTotalTax";
    protected KDFormattedTextField txtTotalTaxAmount;
    public static final String txtTotalTaxAmount_Const = "txtTotalTaxAmount";
    protected KDCheckBox cbIsInTax = null;
    public static final String cbIsInTax_Const = "cbIsInTax";
    protected KDCheckBox chkIsPriceInTax = null;
    public static final String chkIsPriceInTax_Const = "chkIsPriceInTax";
    protected KDBizPromptBox prmtCurrency;
    public static final String prmtCurrency_Const = "prmtCurrency";
    protected KDBizPromptBox prmtOrderCustomer;
    public static final String prmtOrderCustomer_Const = "prmtOrderCustomer";
    protected KDFormattedTextField txtExchangeRate;
    public static final String txtExchangeRate_Const = "txtExchangeRate";
    protected KDBizPromptBox prmtDeliveryType;
    public static final String prmtDeliveryType_Const = "prmtDeliveryType";
    protected KDFormattedTextField txtTransLeadTime;
    public static final String txtTransLeadTime_Const = "txtTransLeadTime";
    public KDDatePicker pkBizDate;
    public static final String pkBizDate_Cost = "pkBizDate";
    public KDBizPromptBox prmtPurchaseOrgUnit;
    public static final String prmtPurchaseOrgUnit_Cost = "prmtPurchaseOrgUnit";
    public static final String prmtCompanyOrgUnit_Cost = "prmtCompanyOrgUnit";
    public KDBizPromptBox prmtCompanyOrgUnit;
    public KDBizPromptBox prmtSupplier;
    public static final String prmtSupplier_Cost = "prmtSupplier";
    public static final String TB_MATERIALMODEL = "materialModel";
    public static final String TB_SUPPLIERMATERIALNUM = "supplierMaterialNumber";
    public static final String TB_SUPPLIERMATERIALNAME = "supplierMaterialName";
    public static final String TB_SUPPLIERMATERIALMODEL = "supplierMaterialModel";
    public static final String TB_RECEIVEOVERRATE = "receiveOverRate";
    public static final String TB_RECEIVEOWINGRATE = "receiveOwingRate";
    public static final String TB_DELIVERYADVANCEDAY = "deliverAdvanceDay";
    public static final String TB_DELIVERYDEFERRALDAY = "deliverDeferralDay";
    public static final String TB_DISCOUNTRATE = "discountRate";
    public static final String TB_ISSUPINFO = "isSupInfo";
    protected String TB_STORAGEORGUNIT;
    protected String TB_WAREHOUSE;
    protected String TB_QUANTITYUNCTRL;
    protected String TB_TIMEUNCTRL;
    protected String TB_SENDADVANCEDAY;
    protected String TB_SENDDEFERRALDAY;
    protected String TB_ISBYSALEORDER;
    protected String TB_DISCOUNTCOND;
    protected String TB_ORDEREDQTY;
    protected String TB_UNORDEREDQTY;
    protected String TB_PREPAYMENTRATE;
    protected String TB_PREPAYMENT;
    protected String TB_PRERECEIVED;
    protected String TB_UNPRERECEIVEDAMOUNT;
    protected String TB_SENDDATE;
    protected String TB_DELIVERYDATE;
    protected String TB_UNITACTUALCOST;
    protected String TB_ACTUALCOST;
    protected String TB_UNITSTANDARDCOST;
    protected String TB_STANDARDCOST;
    protected String TB_PURCHASECOST = null;
    protected String TB_UNITPURCHASECOST = null;
    protected String TB_PURCHASEFEE = null;
    protected String TB_MATERIALCOST = null;
    protected String TB_UNITMATERIALCOST = null;
    protected String TB_PRICESOURCETYPE = null;
    protected String TB_PRICESOURCEID = null;
    protected String TB_PRICESOURCENUMBER = null;
    protected String TB_PRICESOURCEENTRYID = null;
    protected String TB_SOURCEPRICE = null;
    protected String[] MATERIALUNITTAB;
    protected String[] PRICEPRECISIONTAB;
    protected String[] QTYPRECISIONFROMUNITTAB;
    protected String[] QTYPRECISIONFROMBASEUNITTAB;
    protected String[] QTYPRECISIONFROMASSISTUNITTAB;
    protected String[] DEFAULTRECISIONTAB;
    protected KDFormattedTextField[] CURRENCYPRECISIONCOMPENT;
    protected String[] CURRENCYPRECISIONTAB;
    protected KDFormattedTextField[] BASECURRENCYPRECISIONCOMPENT;
    protected String[] BASECURRENCYPRECISIONTAB;
    protected KDFormattedTextField[] DEFAULTRECISIONCOMPENT;
    protected Map requieredAssistPropRow;
    protected String[] EDITCTRLTAB;
    private OrgType mainOrgType;
    protected SCMBillEditUI editUi;
    protected KDTable kdtEntries;
    protected SCMBillBaseInfo editData;
    private Map parametersMap = null;
    private String billTypeId;
    protected String TB_PROJECTNUM;
    protected String TB_TRACKNUM;
    protected String TB_ISMRPCAL;
    protected boolean iscalTaxRateByQtyChangeed = true;
    protected String TB_RELATIONBILLADDFLAG = "relationBillAddFlag";
    private Map configMap = null;
    private Object oldValue = null;

    public UiHandlingHelper(OrgType mainOrgType, SCMBillEditUI editUi) {
        this.mainOrgType = mainOrgType;
        this.editUi = editUi;
    }

    protected OrgType getMainBizOrgType() {
        return this.mainOrgType;
    }

    protected OrgUnitInfo getMainOrgInfo() {
        return this.editUi.getMainOrgInfo();
    }

    protected CurrencyInfo getCurrencyInfo() {
        return this.baseCurrInfo;
    }

    protected boolean isBotpBill() {
        if (this.editData == null) {
            return false;
        }
        BillTypeInfo billType = this.editData.getSourceBillType();
        return billType != null;
    }

    protected String getOprtState() {
        return this.editUi.getOprtState();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    public void calEntryPriceByTaxPrice(int rowIndex, int colIndex) {
        int scale;
        BigDecimal taxPrice = new BigDecimal("0.00");
        BigDecimal taxRate = new BigDecimal("0.00");
        if (this.TB_TAXPRICE == null) {
            return;
        }
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue() != null) {
            taxPrice = new BigDecimal(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue().toString());
        }
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue() != null) {
            taxRate = new BigDecimal(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue().toString());
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        if (taxPrice == null) {
            taxPrice = ZERO;
        }
        BigDecimal price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            price = CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
    }

    @Override
    public void calEntryTaxPricebyPrice(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null) {
            return;
        }
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
    }

    protected boolean isBotpBill(String billTypeID) {
        if (this.isBotpBill()) {
            return this.editData.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }

    @Override
    public void calEntryDiscountAmount(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_DISCOUNT == null) {
            return;
        }
        BigDecimal discount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue());
        BigDecimal qty = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
        BigDecimal taxRate = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue());
        DiscountModeEnum discounMode = DiscountModeEnum.PERCENT;
        if (this.TB_DISCOUNTTYPE != null) {
            discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        }
        BigDecimal taxPrice = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue());
        taxPrice = this.validateNullValue(taxPrice);
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (qty == null || discounMode == null || discounMode.getValue() == -1) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)ZERO);
            return;
        }
        if (discounMode != null && discounMode.getValue() == 1 && taxPrice != null && discount != null && taxPrice.compareTo(discount) < 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)new BigDecimal("0.00"));
            discount = new BigDecimal("0.00");
        }
        BigDecimal discountAmount = CalculateUtils.calDiscountAmount(discounMode, discount, qty, taxPrice, taxRate, scale, this.cbIsInTax.isSelected());
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)discountAmount);
    }

    protected BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    @Override
    public void calEntryTotalTaxAmount(int rowIndex, int colIndex) {
        if (this.cbIsInTax != null && this.cbIsInTax.isSelected()) {
            ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
            int scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
            BigDecimal taxPrice = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue());
            DiscountModeEnum discounMode = null;
            discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            BigDecimal zero = new BigDecimal("0.0");
            BigDecimal discount = SCMClientUtils.handleSpcialString(KDTableUtils.getFieldValue(this.getDetailTable(), rowIndex, this.TB_DISCOUNT));
            BigDecimal qty = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
            qty = qty == null ? zero : qty;
            BigDecimal actualPrice = null;
            taxPrice = this.validateNullValue(taxPrice);
            discount = discount == null ? zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            BigDecimal discountAmount = new BigDecimal("0.00");
            if (taxPrice != null && discount != null && qty != null) {
                if (discounMode == null || discounMode.getValue() == 0) {
                    discountAmount = taxPrice.multiply(qty).multiply(discount).divide(oneHundred, 10, 4);
                    actualPrice = taxPrice.multiply(qty).subtract(discountAmount).divide(one, scale, 4);
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)actualPrice);
                } else {
                    if (discount.compareTo(taxPrice) > 0) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)ZERO);
                        discount = ZERO;
                    }
                    actualPrice = taxPrice.subtract(discount);
                    BigDecimal taxAmount = actualPrice.multiply(qty);
                    taxAmount = taxAmount.setScale(scale, 4);
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)taxAmount);
                }
            }
        } else {
            if (this.TB_AMOUNT == null) {
                return;
            }
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
            BigDecimal totalTaxAmount = SysConstant.BIGZERO;
            if (tax != null) {
                totalTaxAmount = amount.add(tax);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)totalTaxAmount);
        }
    }

    @Override
    public void calEntryTax(int rowIndex, int colIndex) {
        int scale;
        BigDecimal taxAmount = new BigDecimal("0.00");
        BigDecimal taxRate = new BigDecimal("0.00");
        if (this.TB_TAX == null) {
            return;
        }
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_TAX).getEditor() == null ? this.getDetailTable().getColumn(this.TB_TAX).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_TAX).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal one = new BigDecimal("1.0");
            if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue() != null) {
                taxAmount = new BigDecimal(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue().toString());
            }
            if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue() != null) {
                taxRate = new BigDecimal(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue().toString());
            }
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
        } else {
            BigDecimal tax;
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue() != null) {
                taxRate = new BigDecimal(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue().toString());
            }
            if ((tax = CalculateUtils.calTax(amount, taxRate, scale)) != null) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)SysConstant.BIGZERO);
            }
        }
    }

    @Override
    public void calEntryActualTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_DISCOUNT == null || this.TB_ACTUALTAXPRICE == null) {
            return;
        }
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        BigDecimal zero = new BigDecimal("0.0");
        if (discount == null || discount != null && discount.compareTo(zero) == 0) {
            BigDecimal price = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue());
            KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALTAXPRICE, (Object)price);
            return;
        }
        int scale = 2;
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE) != null) {
            ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_ACTUALTAXPRICE).getEditor() == null ? this.getDetailTable().getColumn(this.TB_ACTUALTAXPRICE).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_ACTUALTAXPRICE).getEditor();
            scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        }
        BigDecimal taxAmount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue());
        BigDecimal qty = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
        BigDecimal actualTaxPrice = SysConstant.BIGZERO;
        if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
            actualTaxPrice = taxAmount.divide(qty, scale, 4);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
    }

    @Override
    public void calEntryAmount(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_AMOUNT == null) {
            return;
        }
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal taxAmount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue());
            BigDecimal tax = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue());
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)actualTaxPrice);
            }
        } else {
            BigDecimal price = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue());
            DiscountModeEnum discounMode = DiscountModeEnum.PERCENT;
            if (this.TB_DISCOUNTTYPE != null) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            }
            BigDecimal discount = null;
            if (this.TB_DISCOUNT != null) {
                discount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue());
            }
            BigDecimal qty = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
            BigDecimal actualPrice = null;
            BigDecimal zero = new BigDecimal("0.0");
            discount = discount == null ? zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (price != null && discount != null) {
                if (discounMode == null || discounMode.getValue() == 0) {
                    actualPrice = price.multiply(one.subtract(discount.divide(oneHundred, 10, 4)));
                } else {
                    if (discount.compareTo(price) > 0) {
                        discount = SysConstant.BIGZERO;
                    }
                    actualPrice = price.subtract(discount);
                }
            }
            BigDecimal amount = CalculateUtils.calAmount(qty, actualPrice, scale);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
        }
    }

    @Override
    public void calEntryActualPrice(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null || this.TB_ACTUALPRICE == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal amount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue());
        BigDecimal qty = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
        KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)SysConstant.BIGZERO);
        BigDecimal price = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue());
        BigDecimal discountRate = SCMClientUtils.handleSpcialString(KDTableUtils.getFieldValue(this.getDetailTable(), rowIndex, this.TB_DISCOUNT));
        BigDecimal bigDecimal = discountRate = discountRate == null ? zero : discountRate;
        if (discountRate.compareTo(zero) == 0) {
            if (price != null) {
                KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)price);
            }
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualTaxPrice = amount.divide(qty, scale, 4);
            KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)actualTaxPrice);
        }
    }

    public int getDiscountRate() {
        String discountRate;
        int discount = 2;
        if (this.parametersMap != null && (discountRate = (String)this.parametersMap.get("DISCOUNTRATEPRECISION")) != null && discountRate.length() > 0) {
            discount = Integer.parseInt(discountRate);
        }
        return discount;
    }

    public boolean isPurParamPUR(String key, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public boolean isFirstSuppInfoTaxRate() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURORDER003", false);
    }

    public boolean isMaterialTaxPrice() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURORDER002", true);
    }

    public boolean isGetMaterialPrice() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURORDER005", true);
    }

    public boolean isCheckSupplierEdit() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP004", true);
    }

    public boolean isCheckSupplierPriceEdit() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP009", true);
    }

    protected final String getCacheParameter(String parameter) {
        if (null != this.parametersMap) {
            return (String)this.parametersMap.get(parameter);
        }
        return null;
    }

    @Override
    public void setDiscountPrecision(int rowIndex) {
        if (this.TB_DISCOUNT == null) {
            return;
        }
        int curPrecision = 2;
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currencyInfo != null && currencyInfo.getId() != null && currencyInfo.getName() == null) {
            curPrecision = currencyInfo.getPrecision();
        }
        IRow row = this.getDetailTable().getRow(rowIndex);
        ICell discountCell = row.getCell(this.TB_DISCOUNT);
        DiscountModeEnum discounMode = null;
        if (this.TB_DISCOUNTTYPE != null) {
            discounMode = (DiscountModeEnum)row.getCell(this.TB_DISCOUNTTYPE).getValue();
        }
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            int precision = this.getDiscountRate();
            BigDecimal discount = null;
            if (null != discountCell) {
                discount = SCMClientUtils.handleSpcialString(discountCell.getValue());
            }
            if (discount == null || discount.compareTo(new BigDecimal("100.00")) > 0) {
                discountCell.setValue((Object)new BigDecimal("100.00"));
            }
            if (discount == null || discount.compareTo(new BigDecimal("0.00")) < 0 && !this.isDiscountCanNegative()) {
                discountCell.setValue((Object)SysConstant.BIGZERO);
            }
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(precision);
            colTxtField.setMaximumValue((Comparable)new BigDecimal("100.00"));
            colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
            if (this.isDiscountCanNegative()) {
                colTxtField.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            } else {
                colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
            }
            colTxtField.setRemoveingZeroInDispaly(false);
            colTxtField.setSupportedEmpty(true);
            discountCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
            discountCell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString(precision));
            discountCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        } else {
            if (this.TB_MATERIAL == null || this.TB_PRICE == null) {
                return;
            }
            String priceColName = null;
            priceColName = this.cbIsInTax != null && this.cbIsInTax.isSelected() ? this.TB_TAXPRICE : this.TB_PRICE;
            MaterialInfo materialInfo = (MaterialInfo)row.getCell(this.TB_MATERIAL).getValue();
            int precision = materialInfo == null ? 2 : materialInfo.getPricePrecision();
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(precision);
            colTxtField.setRemoveingZeroInDispaly(false);
            if (this.isDiscountCanNegative()) {
                colTxtField.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            } else {
                colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
            }
            BigDecimal price = (BigDecimal)row.getCell(priceColName).getValue();
            colTxtField.setSupportedEmpty(true);
            BigDecimal qty = (BigDecimal)row.getCell(this.TB_QTY).getValue();
            if (qty != null && price != null && price.compareTo(SysConstant.BIGZERO) > 0 && qty.compareTo(SysConstant.BIGZERO) > 0) {
                colTxtField.setMaximumValue((Comparable)price);
            }
            discountCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
            discountCell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString(precision));
            discountCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private boolean isFromSaleOrderEditUI() {
        return this.editUi != null && this.editUi.getMetaDataPK().getFullName().startsWith("com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI");
    }

    @Override
    public void calEntryBaseQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        if (this.TB_ROWTYPE == null) {
            this.calEntryBaseQtyWhenRowTypeNotExist(rowIndex);
        } else {
            this.calEntryBaseQtyWhenRowTypeExist(rowIndex);
        }
    }

    private void calEntryBaseQtyWhenRowTypeExist(int rowIndex) throws EASBizException, BOSException {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ROWTYPE).getValue();
        if (rowTypeInfo == null) {
            return;
        }
        BigDecimal baseUnitQty = null;
        baseUnitQty = rowTypeInfo.isIsHasMaterialNumber() ? this.getQtyAfterConversion(rowIndex, this.TB_MATERIAL, this.TB_BASEUNIT, this.TB_UNIT, this.TB_QTY) : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getValue();
        this.setEntryBaseQtyValue(baseUnitQty, rowIndex);
    }

    private void calEntryBaseQtyWhenRowTypeNotExist(int rowIndex) throws EASBizException, BOSException {
        BigDecimal baseUnitQty = this.getQtyAfterConversion(rowIndex, this.TB_MATERIAL, this.TB_BASEUNIT, this.TB_UNIT, this.TB_QTY);
        this.setEntryBaseQtyValue(baseUnitQty, rowIndex);
    }

    public BigDecimal getQtyAfterConversion(int rowIndex, String material, String unit1, String unit2, String qty) throws EASBizException, BOSException {
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(unit1).getValue();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(unit2).getValue();
        BigDecimal orderQty = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, qty);
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(material).getValue();
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        if (this.getScmEntryDataVO() == null || this.getScmEntryDataVO().getMmuConvsRate() == null || this.getScmEntryDataVO().getMmuConvsRate().get(materialInfo.getId().toString() + unitInfo.getId().toString()) == null || this.getScmEntryDataVO().getMmuConvsRate().get(materialInfo.getId().toString() + baseUnitInfo.getId().toString()) == null) {
            return SCMClientUtils.getBaseUnitQty(this.getDetailTable(), rowIndex, material, unit1, unit2, qty);
        }
        return this.getBaseUnitQty(materialInfo, baseUnitInfo, unitInfo, orderQty);
    }

    private BigDecimal getBaseUnitQty(MaterialInfo materialInfo, MeasureUnitInfo baseUnitInfo, MeasureUnitInfo unitInfo, BigDecimal orderQty) {
        SCMEntryDataVO vo = this.getScmEntryDataVO();
        Map convertMap = vo.getMmuConvsRate();
        BigDecimal targetQty = orderQty;
        BigDecimal baseExchangeRate1 = (BigDecimal)convertMap.get(materialInfo.getId().toString() + unitInfo.getId().toString());
        BigDecimal baseExchangeRate2 = (BigDecimal)convertMap.get(materialInfo.getId().toString() + baseUnitInfo.getId().toString());
        if (baseExchangeRate1 == null) {
            baseExchangeRate1 = new BigDecimal("1.00");
        }
        if (baseExchangeRate2 == null) {
            baseExchangeRate2 = new BigDecimal("1.00");
        }
        BigDecimal baseQty = SCMUtils.effectualNumeric(orderQty).multiply(baseExchangeRate1);
        int scale = 10;
        if (baseQty != null && orderQty != null) {
            scale = baseQty.scale() + orderQty.scale();
        }
        targetQty = SCMUtils.effectualNumeric(baseQty).divide(SCMUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        return targetQty;
    }

    private void setEntryBaseQtyValue(BigDecimal baseUnitQty, int rowIndex) {
        if (baseUnitQty != null) {
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getEditor().getComponent()).getPrecision();
            baseUnitQty = baseUnitQty.setScale(scale, 4);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).setValue((Object)baseUnitQty);
    }

    @Override
    public void calEntryAssistQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        BigDecimal assistUnitQty = this.getQtyAfterConversion(rowIndex, this.TB_MATERIAL, this.TB_ASSISTUNIT, this.TB_UNIT, this.TB_QTY);
        if (assistUnitQty != null) {
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor().getComponent()).getPrecision();
            assistUnitQty = assistUnitQty.setScale(scale, 4);
        } else {
            assistUnitQty = new BigDecimal("0.00");
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).setValue((Object)assistUnitQty);
    }

    @Override
    public void setConfigMap(Map colMap) {
        this.configMap = colMap;
        this.setConfigMapValue();
    }

    protected void setConfigMapValue() {
        if (this.configMap != null) {
            this.TB_ROWTYPE = (String)this.configMap.get("ROWTYPE");
            this.TB_MATERIAL = (String)this.configMap.get("MATERIAL");
            this.TB_MATERIALNAME = (String)this.configMap.get("TB_MATERIALNAME");
            this.TB_MATERIALSIZE = (String)this.configMap.get("TB_MATERIALSIZE");
            this.TB_BASEUNIT = (String)this.configMap.get("TB_BASEUNIT");
            this.TB_UNIT = (String)this.configMap.get("TB_UNIT");
            this.TB_QTY = (String)this.configMap.get("QTY");
            this.TB_BASEQTY = (String)this.configMap.get("TB_BASEQTY");
            this.TB_ASSISTUNIT = (String)this.configMap.get("TB_ASSISTUNIT");
            this.TB_ASSISTQTY = (String)this.configMap.get("TB_ASSISTQTY");
            this.TB_ASSISTPROPERTY = (String)this.configMap.get("TB_ASSISTPROPERTY");
            this.TB_DISCOUNTTYPE = (String)this.configMap.get("TB_DISCOUNTTYPE");
            this.TB_DISCOUNT = (String)this.configMap.get("TB_DISCOUNT");
            this.TB_TAXAMOUNT = (String)this.configMap.get("TB_TAXAMOUNT");
            this.TB_TAXPRICE = (String)this.configMap.get("TAXPRICE");
            this.TB_PRICE = (String)this.configMap.get("TB_PRICE");
            this.TB_ACTUALTAXPRICE = (String)this.configMap.get("TB_ACTUALTAXPRICE");
            this.TB_TAXRATE = (String)this.configMap.get("TB_TAXRATE");
            this.TB_DISCOUNTAMOUNT = (String)this.configMap.get("TB_DISCOUNTAMOUNT");
            this.TB_AMOUNT = (String)this.configMap.get("TB_AMOUNT");
            this.TB_TAX = (String)this.configMap.get("TB_TAX");
            this.TB_LOCALAMOUNT = (String)this.configMap.get("TB_LOCALAMOUNT");
            this.TB_LOCALTAXAMOUNT = (String)this.configMap.get("TB_LOCALTAXAMOUNT");
            this.TB_LOCALTAX = (String)this.configMap.get("TB_LOCALTAX");
            this.TB_ACTUALTAXPRICE = (String)this.configMap.get("TB_ACTUALTAXPRICE");
            this.TB_ACTUALPRICE = (String)this.configMap.get("TB_ACTUALPRICE");
            this.TB_SENDOVERRATE = (String)this.configMap.get("TB_SENDOVERRATE");
            this.TB_SENDOWINGRATE = (String)this.configMap.get("TB_SENDOWINGRATE");
            this.TB_UNITPURCHASECOST = (String)this.configMap.get("unitPurchaseCost");
            this.TB_PURCHASECOST = (String)this.configMap.get("purchaseCost");
            this.TB_PURCHASEFEE = (String)this.configMap.get("purchaseFee");
            this.TB_MATERIALCOST = (String)this.configMap.get("materialCost");
            this.TB_UNITMATERIALCOST = (String)this.configMap.get("unitMaterialCost");
            this.TB_ACTUALCOST = (String)this.configMap.get("ACTUALCOST");
            this.TB_UNITACTUALCOST = (String)this.configMap.get("UNITACTUALCOST");
            this.TB_STORAGEORGUNIT = (String)this.configMap.get("STORAGEORGUNIT");
            this.TB_WAREHOUSE = (String)this.configMap.get("WAREHOUSE");
            this.TB_QUANTITYUNCTRL = (String)this.configMap.get("QUANTITYUNCTRL");
            this.TB_TIMEUNCTRL = (String)this.configMap.get("TIMEUNCTRL");
            this.TB_SENDADVANCEDAY = (String)this.configMap.get("SENDADVANCEDAY");
            this.TB_SENDDEFERRALDAY = (String)this.configMap.get("SENDDEFERRALDAY");
            this.TB_ISBYSALEORDER = (String)this.configMap.get("ISBYSALEORDER");
            this.TB_DISCOUNTCOND = (String)this.configMap.get("DISCOUNTCOND");
            this.TB_ORDEREDQTY = (String)this.configMap.get("ORDEREDQTY");
            this.TB_UNORDEREDQTY = (String)this.configMap.get("UNORDEREDQTY");
            this.TB_PREPAYMENTRATE = (String)this.configMap.get("PREPAYMENTRATE");
            this.TB_PREPAYMENT = (String)this.configMap.get("PREPAYMENT");
            this.TB_PRERECEIVED = (String)this.configMap.get("PRERECEIVED");
            this.TB_UNPRERECEIVEDAMOUNT = (String)this.configMap.get("UNPRERECEIVEDAMOUNT");
            this.TB_SENDDATE = (String)this.configMap.get("SENDDATE");
            this.TB_UNITACTUALCOST = (String)this.configMap.get("UNITACTUALCOST");
            this.TB_ACTUALCOST = (String)this.configMap.get("ACTUALCOST");
            this.TB_UNITSTANDARDCOST = (String)this.configMap.get("UNITSTANDARDCOST");
            this.TB_STANDARDCOST = (String)this.configMap.get("STANDARDCOST");
            this.TB_DELIVERYDATE = (String)this.configMap.get("DELIVERYDATE");
            this.TB_ISPRESENT = (String)this.configMap.get("ISPRESENT");
            this.TB_PRICESOURCETYPE = (String)this.configMap.get("TB_PRICESOURCETYPE");
            this.TB_PRICESOURCEID = (String)this.configMap.get("TB_PRICESOURCEID");
            this.TB_PRICESOURCENUMBER = (String)this.configMap.get("TB_PRICESOURCENUMBER");
            this.TB_PRICESOURCEENTRYID = (String)this.configMap.get("TB_PRICESOURCEENTRYID");
            this.TB_SOURCEPRICE = (String)this.configMap.get("TB_SOURCEPRICE");
            this.TB_PROJECTNUM = (String)this.configMap.get("PROJECTNUM");
            this.TB_TRACKNUM = (String)this.configMap.get("TRACKNUM");
            this.TB_ISMRPCAL = (String)this.configMap.get("ISMRPCAL");
            this.EDITCTRLTAB = (String[])this.configMap.get("EDITCTRLTAB");
            this.MATERIALUNITTAB = (String[])this.configMap.get("MATERIALUNITTAB");
            this.PRICEPRECISIONTAB = (String[])this.configMap.get("PRICEPRECISIONTAB");
            this.QTYPRECISIONFROMUNITTAB = (String[])this.configMap.get("QTYPRECISIONFROMUNITTAB");
            this.QTYPRECISIONFROMBASEUNITTAB = (String[])this.configMap.get("QTYPRECISIONFROMBASEUNITTAB");
            this.QTYPRECISIONFROMASSISTUNITTAB = (String[])this.configMap.get("QTYPRECISIONFROMASSISTUNITTAB");
            this.DEFAULTRECISIONTAB = (String[])this.configMap.get("DEFAULTRECISIONTAB");
            this.CURRENCYPRECISIONCOMPENT = (KDFormattedTextField[])this.configMap.get("CURRENCYPRECISIONCOMPENT");
            this.CURRENCYPRECISIONTAB = (String[])this.configMap.get("CURRENCYPRECISIONTAB");
            this.BASECURRENCYPRECISIONCOMPENT = (KDFormattedTextField[])this.configMap.get("BASECURRENCYPRECISIONCOMPENT");
            this.BASECURRENCYPRECISIONTAB = (String[])this.configMap.get("BASECURRENCYPRECISIONTAB");
            this.DEFAULTRECISIONCOMPENT = (KDFormattedTextField[])this.configMap.get("DEFAULTRECISIONCOMPENT");
            this.prmtCurrency = (KDBizPromptBox)this.configMap.get(prmtCurrency_Const);
            this.prmtOrderCustomer = (KDBizPromptBox)this.configMap.get(prmtOrderCustomer_Const);
            this.cbIsInTax = (KDCheckBox)this.configMap.get(cbIsInTax_Const);
            this.txtTotalAmount = (KDFormattedTextField)this.configMap.get(txtTotalAmount_Const);
            this.txtTotalTax = (KDFormattedTextField)this.configMap.get(txtTotalTax_Const);
            this.txtTotalTaxAmount = (KDFormattedTextField)this.configMap.get(txtTotalTaxAmount_Const);
            this.txtExchangeRate = (KDFormattedTextField)this.configMap.get(txtExchangeRate_Const);
            this.chkIsPriceInTax = (KDCheckBox)this.configMap.get(chkIsPriceInTax_Const);
            this.prmtDeliveryType = (KDBizPromptBox)this.configMap.get(prmtDeliveryType_Const);
            this.txtTransLeadTime = (KDFormattedTextField)this.configMap.get(txtTransLeadTime_Const);
            this.pkBizDate = (KDDatePicker)this.configMap.get(pkBizDate_Cost);
            this.prmtSupplier = (KDBizPromptBox)this.configMap.get(prmtSupplier_Cost);
            this.prmtPurchaseOrgUnit = (KDBizPromptBox)this.configMap.get(prmtPurchaseOrgUnit_Cost);
            this.prmtCompanyOrgUnit = (KDBizPromptBox)this.configMap.get(prmtCompanyOrgUnit_Cost);
        }
    }

    @Override
    public void setEditData(SCMBillBaseInfo editData) {
        this.editData = editData;
    }

    @Override
    public void setKdtEntries(KDTable kdtEntries) {
        this.kdtEntries = kdtEntries;
    }

    @Override
    public void calByEntryTaxPriceChange(int rowIndex, int colIndex) {
        this.calEntryPriceByTaxPrice(rowIndex, colIndex);
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    @Override
    public void calTotalTaxAmount() {
        if (this.txtTotalTaxAmount == null || this.txtTotalAmount == null || this.txtTotalTax == null) {
            return;
        }
        BigDecimal amount = this.txtTotalAmount.getBigDecimalValue();
        BigDecimal tax = this.txtTotalTax.getBigDecimalValue();
        this.txtTotalTaxAmount.setValue((Object)CalculateUtils.calTotalTaxAmount(amount, tax, this.txtTotalTaxAmount.getPrecision()));
    }

    @Override
    public void calTotalAmount() {
        if (this.TB_AMOUNT == null || this.txtTotalAmount == null) {
            return;
        }
        this.txtTotalAmount.setValue((Object)this.calculateSum(this.getDetailTable(), this.TB_AMOUNT).setScale(this.txtTotalAmount.getPrecision(), 4));
    }

    @Override
    public void calTotalTax() {
        if (this.TB_TAX == null || this.txtTotalTax == null) {
            return;
        }
        this.txtTotalTax.setValue((Object)this.calculateSum(this.getDetailTable(), this.TB_TAX).setScale(this.txtTotalTax.getPrecision(), 4));
    }

    @Override
    public void setDiscountAmountMaxValue(int rowIndex) {
        if (this.getDetailTable() == null || this.TB_AMOUNT == null || this.TB_DISCOUNTAMOUNT == null || this.TB_QTY == null || this.TB_TAXPRICE == null) {
            return;
        }
        IRow row = this.getDetailTable().getRow(rowIndex);
        ICell cell = row.getCell(this.TB_DISCOUNTAMOUNT);
        if (row != null) {
            BigDecimal qty = SCMClientUtils.handleSpcialString(row.getCell(this.TB_QTY).getValue());
            BigDecimal taxPrice = SCMClientUtils.handleSpcialString(row.getCell(this.TB_TAXPRICE).getValue());
            ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
            int scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(scale);
            colTxtField.setRemoveingZeroInDispaly(false);
            if (this.isDiscountCanNegative()) {
                colTxtField.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            } else {
                colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
            }
            if (qty != null && taxPrice != null && taxPrice.compareTo(SysConstant.BIGZERO) > 0 && qty.compareTo(SysConstant.BIGZERO) > 0) {
                colTxtField.setMaximumValue((Comparable)taxPrice.multiply(qty).setScale(scale, 4));
            } else {
                colTxtField.setMaximumValue((Comparable)SysConstant.BIGZERO);
            }
            BigDecimal discountAmount = SCMClientUtils.handleSpcialString(row.getCell(this.TB_DISCOUNTAMOUNT).getValue());
            if (discountAmount != null && discountAmount.compareTo((BigDecimal)colTxtField.getMaximumValue()) > 0) {
                cell.setValue((Object)SysConstant.BIGZERO);
            }
            colTxtField.setSupportedEmpty(true);
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
            if (this.isDiscountCanNegative()) {
                cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString(scale));
            } else {
                cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatStringWithoutMinus(scale));
            }
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void calByEntryPriceChange(int rowIndex, int colIndex) {
        this.calEntryTaxPricebyPrice(rowIndex, colIndex);
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    @Override
    public void calByEntryQtyChange(int rowIndex, int colIndex) throws EASBizException, BOSException {
        if (this.cbIsInTax.isSelected()) {
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryAmount(rowIndex, colIndex);
        } else {
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
        }
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryBaseQty(rowIndex, colIndex);
        boolean isAssistQtyCalAllowed = this.isAssistQtyCalAllowed();
        if (isAssistQtyCalAllowed) {
            this.calTotalAmount();
        }
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    @Override
    public boolean isAssistQtyCalAllowed() {
        String flag;
        if (!this.getMainBizOrgType().equals((Object)OrgType.Purchase)) {
            return true;
        }
        boolean isAssistQtyCalAllowed = true;
        if (this.parametersMap != null && (flag = (String)this.parametersMap.get("PURORDER007")) != null && flag.length() > 0) {
            isAssistQtyCalAllowed = Boolean.valueOf(flag);
        }
        return isAssistQtyCalAllowed;
    }

    protected BigDecimal calculateSum(KDTable table, String colunmName) {
        BigDecimal ret = new BigDecimal(0.0);
        String str = null;
        Object o = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            o = table.getRow(i).getCell(colunmName).getValue();
            if (o == null || (str = o.toString()) == null || !StringUtil.isNumber(str)) continue;
            BigDecimal value = new BigDecimal(str);
            ret = ret.add(value);
        }
        return ret;
    }

    protected BigDecimal getResultForUnitChanged(String materialID, MeasureUnitInfo fromUnitInfo, MeasureUnitInfo toUnitInfo, BigDecimal qty, Map mmuConvsRate) throws BOSException, EASBizException {
        if (mmuConvsRate == null) {
            return qty;
        }
        BigDecimal targetQty = qty;
        BigDecimal baseExchangeRate1 = (BigDecimal)mmuConvsRate.get(materialID + toUnitInfo.getId().toString());
        BigDecimal baseExchangeRate2 = (BigDecimal)mmuConvsRate.get(materialID + fromUnitInfo.getId().toString());
        if (baseExchangeRate1 == null) {
            baseExchangeRate1 = ONE;
        }
        if (baseExchangeRate2 == null) {
            baseExchangeRate2 = ONE;
        }
        BigDecimal baseQty = SCMUtils.effectualNumeric(qty).multiply(baseExchangeRate1);
        int scale = 10;
        if (baseQty != null && qty != null) {
            scale = baseQty.scale() + qty.scale();
        }
        targetQty = SCMUtils.effectualNumeric(baseQty).divide(SCMUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        return targetQty;
    }

    public void dealWithBaseQtyAndBaseUnitWhenNotProduce(int selectedRowIdx) {
        if (this.TB_ROWTYPE == null) {
            return;
        }
        RowTypeInfo rowTypeInfo = (RowTypeInfo)this.kdtEntries.getRow(selectedRowIdx).getCell(this.TB_ROWTYPE).getValue();
        if (rowTypeInfo == null || rowTypeInfo.isIsHasMaterialNumber()) {
            return;
        }
        Object qty = this.kdtEntries.getRow(selectedRowIdx).getCell(this.TB_QTY).getValue();
        Object unit = this.kdtEntries.getRow(selectedRowIdx).getCell(this.TB_UNIT).getValue();
        this.kdtEntries.getRow(selectedRowIdx).getCell(this.TB_BASEQTY).setValue(qty);
        this.kdtEntries.getRow(selectedRowIdx).getCell(this.TB_BASEUNIT).setValue(unit);
    }

    @Override
    public void tableChange_Cal(KDTEditEvent e, ExchangeRateInfo exchangeRateinfo) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        ICell cell = this.getDetailTable().getRow(rowIndex).getCell(colIndex);
        if (this.TB_QTY != null && this.TB_QTY.equalsIgnoreCase(fieldName)) {
            this.calByEntryQtyChange(rowIndex, colIndex);
            if (this.iscalTaxRateByQtyChangeed()) {
                this.calByEntryTaxRateChange(rowIndex, colIndex);
            }
            this.dealWithBaseQtyAndBaseUnitWhenNotProduce(rowIndex);
        } else if (this.TB_PRICE != null && this.TB_PRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_PRICE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calByEntryPriceChange(rowIndex, colIndex);
            this.setDiscountPrecision(rowIndex);
        } else if (this.TB_TAXPRICE != null && this.TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXPRICE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calByEntryTaxPriceChange(rowIndex, colIndex);
            this.setDiscountPrecision(rowIndex);
        } else if (this.TB_TAXRATE != null && this.TB_TAXRATE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXRATE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            if (cell.getValue() != null) {
                BigDecimal ONEHAN = new BigDecimal("100.00");
                if (cell.getValue() instanceof BigDecimal && ONEHAN.compareTo((BigDecimal)cell.getValue()) != 1) {
                    cell.setValue(e.getOldValue());
                    return;
                }
            }
            this.calByEntryTaxRateChange(rowIndex, colIndex);
        } else if (this.TB_AMOUNT != null && this.TB_AMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_AMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryAmountChange(rowIndex);
        } else if (this.TB_TAXAMOUNT != null && this.TB_TAXAMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXAMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryTaxAmountChange(rowIndex);
        } else if (this.TB_TAX != null && this.TB_TAX.equalsIgnoreCase(fieldName)) {
            this.calEntryTaxChange(rowIndex);
        } else if (this.TB_DISCOUNTTYPE != null && this.TB_DISCOUNTTYPE.equalsIgnoreCase(fieldName)) {
            this.calEntryDiscountTypeChange(rowIndex, fieldName);
        } else if (this.TB_DISCOUNT != null && this.TB_DISCOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_DISCOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.oldValue = e.getOldValue();
            this.calEntryDiscountTypeChange(rowIndex, fieldName);
        } else if (this.TB_DISCOUNTAMOUNT != null && this.TB_DISCOUNTAMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_DISCOUNTAMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            if (this.checkDiscount(rowIndex, 0)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryDiscountAmountChange(rowIndex);
        } else if (this.TB_ACTUALPRICE != null && this.TB_ACTUALPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
                if (!this.checkByLimitPriceParam(rowIndex, this.TB_ACTUALPRICE)) {
                    cell.setValue(e.getOldValue());
                    return;
                }
            } else {
                this.preCheckActualPrice(e);
            }
            this.calEntryActualPriceChange(rowIndex);
        } else if (this.TB_ACTUALTAXPRICE != null && this.TB_ACTUALTAXPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
                if (!this.checkByLimitPriceParam(rowIndex, this.TB_ACTUALTAXPRICE)) {
                    cell.setValue(e.getOldValue());
                    return;
                }
            } else {
                this.preCheckActualTaxPrice(e);
            }
            this.calEntryActualTaxPriceChange(rowIndex);
        }
        if (this.cbIsInTax.isSelected()) {
            this.calEntryLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, exchangeRateinfo);
            this.calEntryLocalAmount(rowIndex, exchangeRateinfo);
        } else {
            this.calEntryLocalAmount(rowIndex, exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, exchangeRateinfo);
            this.calEntryLocalTaxAmount(rowIndex, exchangeRateinfo);
        }
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
    }

    protected void preCheckActualTaxPrice(KDTEditEvent e) {
        IRow row = this.getDetailTable().getRow(e.getRowIndex());
        BigDecimal price = (BigDecimal)row.getCell(this.TB_TAXPRICE).getValue();
        BigDecimal actualTaxPrice = (BigDecimal)row.getCell(this.TB_ACTUALTAXPRICE).getValue();
        if (price == null || actualTaxPrice != null && actualTaxPrice.compareTo(price) > 0) {
            row.getCell(this.TB_ACTUALTAXPRICE).setValue(e.getOldValue());
        }
    }

    protected boolean checkByLimitPriceParam(int rowIndex, String colName) throws Exception {
        return true;
    }

    @Override
    public void calEntryAmountByCurrency(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        int scale;
        if (this.TB_AMOUNT == null || this.txtExchangeRate == null || this.TB_LOCALAMOUNT == null) {
            return;
        }
        BigDecimal localamount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        int n = scale = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        if (this.getDetailTable() != null) {
            if (localamount != null && exchangerate != null) {
                if (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)localamount.multiply(exchangerate).setScale(scale, 4));
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)localamount.divide(exchangerate, scale, 4));
                    }
                } else {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)localamount.multiply(exchangerate).setScale(scale, 4));
                }
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)localamount);
            }
        }
    }

    @Override
    public void calEntryDiscountRateByCurrency(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        int scale;
        if (TB_DISCOUNTRATE == null || this.txtExchangeRate == null) {
            return;
        }
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(TB_DISCOUNTRATE).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        int n = scale = this.getDetailTable().getColumn(TB_DISCOUNTRATE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, TB_DISCOUNTRATE).getEditor().getComponent()).getPrecision();
        if (this.getDetailTable() != null) {
            if (amount != null && exchangerate != null) {
                if (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        this.getDetailTable().getRow(rowIndex).getCell(TB_DISCOUNTRATE).setValue((Object)amount.multiply(exchangerate).setScale(scale, 4));
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(TB_DISCOUNTRATE).setValue((Object)amount.divide(exchangerate, scale, 4));
                    }
                } else {
                    this.getDetailTable().getRow(rowIndex).getCell(TB_DISCOUNTRATE).setValue((Object)amount.multiply(exchangerate).setScale(scale, 4));
                }
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(TB_DISCOUNTRATE).setValue((Object)amount);
            }
        }
    }

    @Override
    public void calEntryTaxAmountByCurrency(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        int scale;
        if (this.TB_TAXAMOUNT == null || this.txtExchangeRate == null || this.TB_LOCALTAXAMOUNT == null) {
            return;
        }
        BigDecimal localtaxamount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_TAXAMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (this.getDetailTable() != null) {
            if (localtaxamount != null && exchangerate != null) {
                if (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localtaxamount.multiply(exchangerate).setScale(scale, 4));
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localtaxamount.divide(exchangerate, scale, 4));
                    }
                } else {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localtaxamount.multiply(exchangerate).setScale(scale, 4));
                }
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localtaxamount);
            }
        }
    }

    @Override
    public void calEntryLocalAmount(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        int scale;
        if (this.TB_AMOUNT == null || this.TB_LOCALAMOUNT == null || this.txtExchangeRate == null) {
            return;
        }
        BigDecimal localAmount = BigDecimal.ZERO;
        int n = scale = this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor().getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            BigDecimal localTax = BigDecimal.ZERO;
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue() != null) {
                localTaxAmount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
            }
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue() != null) {
                localTax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
            }
            localAmount = localTaxAmount.subtract(localTax);
        } else {
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
            if (this.getDetailTable() != null) {
                localAmount = amount != null && exchangerate != null ? (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null ? (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? amount.multiply(exchangerate).setScale(scale, 4) : amount.divide(exchangerate, scale, 4)) : amount.multiply(exchangerate).setScale(scale, 4)) : amount;
            }
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).setValue((Object)localAmount);
    }

    protected void calEntryLocalTax(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_TAX == null || this.TB_LOCALTAX == null || this.txtExchangeRate == null) {
            return;
        }
        BigDecimal tax = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAX).getValue();
        int scale = this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        if (this.getDetailTable() != null) {
            if (tax != null && exchangerate != null) {
                if (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.multiply(exchangerate).setScale(scale, 4));
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.divide(exchangerate, scale, 4));
                    }
                } else {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.multiply(exchangerate).setScale(scale, 4));
                }
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax);
            }
        }
    }

    protected void calEntryLocalTaxAmount(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_TAXAMOUNT == null || this.TB_LOCALTAXAMOUNT == null || this.txtExchangeRate == null) {
            return;
        }
        int scale = this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_LOCALAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal localTaxAmount = BigDecimal.ZERO;
        if (this.cbIsInTax.isSelected()) {
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getValue();
            BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
            if (this.getDetailTable() != null) {
                localTaxAmount = taxAmount != null && exchangerate != null ? (exchangeRateinfo != null && exchangeRateinfo.getExchangeAux() != null ? (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? taxAmount.multiply(exchangerate).setScale(scale, 4) : taxAmount.divide(exchangerate, scale, 4)) : taxAmount.multiply(exchangerate).setScale(scale, 4)) : taxAmount;
            }
        } else {
            BigDecimal localAmount = BigDecimal.ZERO;
            BigDecimal localTax = BigDecimal.ZERO;
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).getValue() != null) {
                localAmount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).getValue();
            }
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue() != null) {
                localTax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
            }
            localTaxAmount = localAmount.add(localTax);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)localTaxAmount);
    }

    private void calEntryActualTaxPriceChange(int rowIndex) {
        this.calEntryDiscountByActualTaxPrice(rowIndex, 0);
        this.calEntryPriceByTaxPrice(rowIndex, 0);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryTax(rowIndex, 0);
        this.calEntryAmount(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    protected void preCheckActualPrice(KDTEditEvent e) {
        IRow row = this.getDetailTable().getRow(e.getRowIndex());
        BigDecimal price = (BigDecimal)row.getCell(this.TB_PRICE).getValue();
        BigDecimal actualTaxPrice = (BigDecimal)row.getCell(this.TB_ACTUALPRICE).getValue();
        if (price == null || actualTaxPrice != null && actualTaxPrice.compareTo(price) > 0) {
            row.getCell(this.TB_ACTUALPRICE).setValue(e.getOldValue());
        }
    }

    private void calEntryActualPriceChange(int rowIndex) {
        this.calEntryDiscountByActualPrice(rowIndex, 0);
        this.calEntryTaxPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calEntryAmount(rowIndex, 0);
        this.calEntryTax(rowIndex, 0);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    private void calEntryDiscountAmountChange(int rowIndex) {
        this.calEntryDiscountByDiscountAmount(rowIndex, 0);
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        discount = SCMUtils.effectualNumeric(discount);
        StringBuffer discountStr = new StringBuffer("100.00");
        discountStr.setLength(this.getDiscountRate() + 3);
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            if (discount.compareTo(new BigDecimal("100.00")) > 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)new BigDecimal(discountStr.toString()));
            }
        } else if (discounMode.getValue() == 1) {
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_TAXPRICE);
                if ((taxPrice = SCMUtils.effectualNumeric(taxPrice)).compareTo(discount) < 0) {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                }
            } else {
                BigDecimal price = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_PRICE);
                if ((price = SCMUtils.effectualNumeric(price)).compareTo(discount) < 0) {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                }
            }
        }
        this.setDiscountAmountMaxValue(rowIndex);
        this.setDiscountPrecision(rowIndex);
        if (this.cbIsInTax.isSelected()) {
            BigDecimal qty = this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            BigDecimal discountAmount = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
            BigDecimal amount = SysConstant.BIGZERO;
            if (taxPrice != null) {
                ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_TAXAMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor();
                int scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
                amount = qty.multiply(taxPrice).setScale(scale, 4).subtract(discountAmount);
                if (amount.compareTo(SysConstant.BIGZERO) < 0) {
                    amount = SysConstant.BIGZERO;
                }
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)amount);
            }
            this.calEntryTax(rowIndex, 0);
            this.calEntryAmount(rowIndex, 0);
        } else {
            ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
            int scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
            BigDecimal qty = this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            BigDecimal discountAmount = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            BigDecimal oneHundred = new BigDecimal("100.0");
            taxRate = taxRate.divide(oneHundred, taxRate.scale(), 4);
            discountAmount = discountAmount.divide(new BigDecimal("1.00").add(taxRate), 10, 4);
            BigDecimal amount = qty.multiply(price).subtract(discountAmount);
            amount = amount.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
            this.calEntryTax(rowIndex, 0);
            this.calEntryTotalTaxAmount(rowIndex, 0);
        }
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
    }

    private void calEntryDiscountTypeChange(int rowIndex, String fieldName) {
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        discount = SCMUtils.effectualNumeric(discount);
        int scale = this.getDiscountRate();
        discount = discount.setScale(scale, 4);
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            if (discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)SCMConstant.BIGDECIMAL_ONEHUNDRED.setScale(scale, 4));
            }
            if (discount.compareTo(new BigDecimal("0.00")) < 0 && !this.isDiscountCanNegative()) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
            }
        } else if (discounMode.getValue() == 1) {
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_TAXPRICE);
                if ((taxPrice = SCMUtils.effectualNumeric(taxPrice)).compareTo(discount) < 0) {
                    if (this.TB_DISCOUNTTYPE.equals(fieldName)) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
                    }
                }
            } else {
                BigDecimal price = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_PRICE);
                if ((price = SCMUtils.effectualNumeric(price)).compareTo(discount) < 0) {
                    if (this.TB_DISCOUNTTYPE.equals(fieldName)) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
                    }
                }
            }
        }
        this.setDiscountAmountMaxValue(rowIndex);
        this.setDiscountPrecision(rowIndex);
        if (this.cbIsInTax.isSelected()) {
            this.calEntryTotalTaxAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryAmount(rowIndex, 0);
        } else {
            this.calEntryAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryTotalTaxAmount(rowIndex, 0);
        }
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
    }

    @Override
    public boolean isDiscountCanNegative() {
        return false;
    }

    private void calEntryTaxChange(int rowIndex) {
        int scale;
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (!this.cbIsInTax.isSelected()) {
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
            if (amount != null && tax != null) {
                amount = amount.add(tax);
                amount = amount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)amount);
        } else {
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
            if (amount != null && tax != null) {
                amount = amount.subtract(tax);
                amount = amount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
        }
    }

    private void calEntryTaxAmountChange(int rowIndex) {
        this.calEntryTax(rowIndex, 0);
        this.calEntryAmount(rowIndex, 0);
        this.calEntryTaxPrice(rowIndex, 0);
        this.calEntryPriceByTaxPrice(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calTotalTax();
        this.calTotalAmount();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    private void calEntryAmountChange(int rowIndex) {
        this.calEntryPriceByAmount(rowIndex, 0);
        this.calEntryTaxPrice(rowIndex, 0);
        this.calEntryTax(rowIndex, 0);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    public void calByEntryTaxRateChange(int rowIndex, int colIndex) {
        if (this.cbIsInTax.isSelected()) {
            this.calEntryPriceByTaxPrice(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryAmount(rowIndex, colIndex);
        } else {
            this.calEntryTaxPrice(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
        }
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    @Override
    public void calEntryTaxPrice(int rowIndex, int colIndex) {
        if (this.cbIsInTax.isSelected()) {
            DiscountModeEnum discounMode = DiscountModeEnum.PERCENT;
            if (this.TB_DISCOUNTTYPE != null) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            }
            BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
            BigDecimal taxPrice = null;
            BigDecimal zero = BigDecimal.ZERO;
            if (qty != null && qty.compareTo(zero) != 0) {
                if (discounMode == null || discounMode.getValue() == 0) {
                    BigDecimal one = new BigDecimal("1.0");
                    BigDecimal oneHundred = new BigDecimal("100.0");
                    if (discount == null) {
                        discount = new BigDecimal("0.00");
                    }
                    discount = one.subtract(discount.divide(oneHundred, 10, 4));
                    if (taxAmount != null && qty != null) {
                        taxPrice = taxAmount.divide(qty, 10, 4);
                        taxPrice = discount.compareTo(zero) == 0 ? taxPrice : taxPrice.divide(discount, scale, 4);
                    }
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
                } else {
                    if (taxAmount != null) {
                        taxPrice = taxAmount.divide(qty, scale, 4);
                    }
                    if (discount != null && taxPrice != null) {
                        taxPrice = taxPrice.add(discount);
                    }
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
                }
            }
        } else {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
            BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
        }
    }

    @Override
    public void calEntryPriceByAmount(int rowIndex, int colIndex) {
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        DiscountModeEnum discounMode = null;
        if (this.TB_DISCOUNTTYPE != null) {
            discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        }
        BigDecimal price = ZERO;
        if (discounMode == null || discounMode != null && discounMode.getValue() == 0) {
            if (discount != null && discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) == 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)SysConstant.BIGZERO);
            }
            price = CalculateUtils.calPrice(amount, qty, discount, scale);
        } else {
            price = CalculateUtils.calPriceByDiscountAmount(amount, qty, discount, scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
    }

    public boolean checkDiscount(int rowIndex, int colIndex) {
        int scale;
        boolean checkDiscount = false;
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
        if (discounMode == null || discounMode.getValue() == 0) {
            BigDecimal discount = CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
            if (discount != null && discount.compareTo(new BigDecimal("100.00")) > 0) {
                checkDiscount = true;
            }
        } else {
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            BigDecimal discount = CalculateUtils.calDiscountByPerunit(discountAmount, qty, taxRate, scale, this.cbIsInTax.isSelected());
            String priceColName = "";
            priceColName = this.cbIsInTax != null && this.cbIsInTax.isSelected() ? this.TB_TAXPRICE : this.TB_PRICE;
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(priceColName).getValue();
            if (discount != null && price != null && discount.compareTo(price) > 0) {
                checkDiscount = true;
            }
        }
        return checkDiscount;
    }

    @Override
    public void calEntryDiscountByDiscountAmount(int rowIndex, int colIndex) {
        int scale;
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
        if (discounMode == null || discounMode.getValue() == 0) {
            BigDecimal discount = CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
        } else {
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            BigDecimal discount = CalculateUtils.calDiscountByPerunit(discountAmount, qty, taxRate, scale, this.cbIsInTax.isSelected());
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
        }
    }

    @Override
    public void calEntryDiscountByActualPrice(int rowIndex, int colIndex) {
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
        int scale = this.getDiscountRate();
        if (discounMode == null && discounMode.getValue() == -1) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(null);
            return;
        }
        if (discounMode == null || discounMode.getValue() == 0) {
            BigDecimal zero = new BigDecimal("0.0");
            if (actualPrice != null && price != null && price.compareTo(zero) > 0) {
                actualPrice = price.subtract(actualPrice);
                BigDecimal discount = actualPrice.divide(price, 10, 4);
                discount = discount.multiply(new BigDecimal("100.0"));
                discount = discount.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
            }
        } else if (actualPrice != null && price != null) {
            BigDecimal discount = price.subtract(actualPrice);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
        }
    }

    @Override
    public void calEntryDiscountByActualTaxPrice(int rowIndex, int colIndex) {
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal actualTaxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getValue();
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.getDiscountRate();
        if (actualTaxPrice == null) {
            actualTaxPrice = zero = zero.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)zero);
        }
        if (discounMode != null && discounMode.getValue() == -1) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(null);
            return;
        }
        if (discounMode == null || discounMode.getValue() == 0) {
            if (actualTaxPrice != null && price != null && price.compareTo(zero) > 0) {
                actualTaxPrice = price.subtract(actualTaxPrice);
                BigDecimal discount = actualTaxPrice.divide(price, 10, 4);
                discount = discount.multiply(new BigDecimal("100.0"));
                discount = discount.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
            }
        } else if (actualTaxPrice != null && price != null) {
            BigDecimal discount = price.subtract(actualTaxPrice);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
        }
    }

    @Override
    public void calEntryDiscountAmountByActualTaxPrice(int rowIndex, int colIndex) {
        Object o = KDTableUtils.getFieldValue(this.getDetailTable(), rowIndex, this.TB_TAXPRICE);
        BigDecimal taxPrice = SysConstant.BIGZERO;
        if (o != null && o instanceof BigDecimal) {
            taxPrice = (BigDecimal)o;
        }
        o = KDTableUtils.getFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALTAXPRICE);
        BigDecimal actualTaxPrice = SysConstant.BIGZERO;
        if (o != null && o instanceof BigDecimal) {
            actualTaxPrice = (BigDecimal)o;
        }
        if (actualTaxPrice.compareTo(SysConstant.BIGZERO) <= 0 || actualTaxPrice.compareTo(taxPrice) >= 0) {
            actualTaxPrice = taxPrice;
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
        }
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        if (discounMode.getValue() == -1) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue(null);
            return;
        }
        BigDecimal discount = SysConstant.BIGZERO;
        discount = discounMode == null || discounMode.getValue() == 0 ? CalculateUtils.calDiscountRateByActualTaxPrice(actualTaxPrice, taxPrice, 2) : CalculateUtils.calUnitDiscountByActualTaxPrice(actualTaxPrice, taxPrice, 2);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
    }

    @Override
    public void setTaxMaxValue(int rowIndex) {
        ICellEditor taxEditor = this.getDetailTable().getColumn(this.TB_TAX).getEditor();
        if (taxEditor != null && taxEditor.getComponent() != null) {
            return;
        }
        if (this.TB_AMOUNT == null) {
            return;
        }
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_AMOUNT).getEditor();
        int scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(scale);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)ZERO);
        if (this.cbIsInTax.isSelected()) {
            if (taxAmount != null) {
                colTxtField.setMaximumValue((Comparable)taxAmount.subtract(ONE.movePointLeft(scale)));
            }
        } else if (amount != null) {
            colTxtField.setMaximumValue((Comparable)amount.subtract(ONE.movePointLeft(scale)));
        }
        colTxtField.setSupportedEmpty(true);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        String colPrecision = PrecisionUtil.getFormatStringWithoutMinus(scale);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setEditor((ICellEditor)col_CellEditor);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getStyleAttributes().setNumberFormat(colPrecision);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setEditor((ICellEditor)col_CellEditor);
    }

    @Override
    public void setActualTaxPriceMaxValue(int rowIndex) {
        String colPrecision;
        KDFormattedTextField colTxtField;
        KDTDefaultCellEditor col_CellEditor;
        BigDecimal zero;
        int scale;
        if (this.TB_ACTUALTAXPRICE == null || this.isDiscountCanNegative()) {
            return;
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getEditor().getComponent()).getPrecision();
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue() != null) {
            zero = new BigDecimal("0.00");
            BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            if (taxPrice.compareTo(zero) > 0) {
                col_CellEditor = null;
                if (col_CellEditor == null) {
                    colTxtField = new KDFormattedTextField();
                    col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
                } else {
                    colTxtField = (KDFormattedTextField)col_CellEditor.getComponent();
                }
                if (colTxtField == null) {
                    colTxtField = new KDFormattedTextField();
                    col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
                }
                colTxtField.setDataType(1);
                colTxtField.setPrecision(scale);
                colTxtField.setRemoveingZeroInDispaly(false);
                colTxtField.setMinimumValue((Comparable)zero);
                colTxtField.setMaximumValue((Comparable)taxPrice);
                colTxtField.setSupportedEmpty(true);
                colPrecision = PrecisionUtil.getFormatString(scale);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setEditor((ICellEditor)col_CellEditor);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getStyleAttributes().setNumberFormat(colPrecision);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setEditor((ICellEditor)col_CellEditor);
            }
        }
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue() != null) {
            zero = new BigDecimal("0.00");
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            if (price.compareTo(zero) > 0) {
                col_CellEditor = null;
                if (col_CellEditor == null) {
                    colTxtField = new KDFormattedTextField();
                    col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
                } else {
                    colTxtField = (KDFormattedTextField)col_CellEditor.getComponent();
                }
                if (colTxtField == null) {
                    colTxtField = new KDFormattedTextField();
                    col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
                }
                colTxtField.setDataType(1);
                colTxtField.setPrecision(scale);
                colTxtField.setRemoveingZeroInDispaly(false);
                colTxtField.setMinimumValue((Comparable)zero);
                colTxtField.setMaximumValue((Comparable)price);
                colTxtField.setSupportedEmpty(true);
                colPrecision = PrecisionUtil.getFormatString(scale);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setEditor((ICellEditor)col_CellEditor);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getStyleAttributes().setNumberFormat(colPrecision);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setEditor((ICellEditor)col_CellEditor);
            }
        }
    }

    @Override
    public void entryUnitChange(int rowIndex, MeasureUnitInfo curUnitOldValue, boolean isPrice, boolean isQtyTrans) {
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getCell(rowIndex, this.TB_MATERIAL).getValue();
        if (measureUnitInfo != null && materialInfo != null) {
            try {
                IRow changeRow = this.getDetailTable().getRow(rowIndex);
                BigDecimal price = null;
                if (changeRow.getCell(this.TB_PRICE).getValue() != null) {
                    price = (BigDecimal)changeRow.getCell(this.TB_PRICE).getValue();
                }
                BigDecimal qty = (BigDecimal)changeRow.getCell(this.TB_QTY).getValue();
                SCMClientUtils.changeTableColPrecisionByMaterial(materialInfo, measureUnitInfo, this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, new int[]{rowIndex});
                if (curUnitOldValue != null && !curUnitOldValue.equals((Object)measureUnitInfo)) {
                    int qtyScale;
                    BigDecimal newDiscount;
                    ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_DISCOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_DISCOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_DISCOUNT).getEditor();
                    int discountScale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
                    DiscountModeEnum discounMode = null;
                    discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                    BigDecimal discount = new BigDecimal("0.00");
                    if (changeRow.getCell(this.TB_DISCOUNT).getValue() != null) {
                        discount = (BigDecimal)changeRow.getCell(this.TB_DISCOUNT).getValue();
                    }
                    if (!isPrice && discounMode != null && discounMode.getValue() == 1 && (newDiscount = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, discount = discount.setScale(discountScale, 4))) != null) {
                        newDiscount = newDiscount.setScale(discountScale, 4);
                        changeRow.getCell(this.TB_DISCOUNT).setValue((Object)newDiscount);
                    }
                    int scale = this.getDetailTable().getColumn(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_PRICE).getEditor().getComponent()).getPrecision();
                    int n = qtyScale = this.getDetailTable().getColumn(this.TB_QTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getEditor().getComponent()).getPrecision();
                    if (!isQtyTrans && price != null && !isPrice) {
                        if (this.cbIsInTax.isSelected()) {
                            BigDecimal taxPrice = (BigDecimal)changeRow.getCell(this.TB_TAXPRICE).getValue();
                            BigDecimal baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, taxPrice);
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_TAXPRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryTaxPriceChange(rowIndex, 0);
                        } else {
                            BigDecimal baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, price);
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_PRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryPriceChange(rowIndex, 0);
                        }
                        isPrice = false;
                    }
                    if (isQtyTrans && qty != null) {
                        BigDecimal newQtyFrom = SCMClientUtils.getBaseUnitQtyFromData(measureUnitInfo, curUnitOldValue, materialInfo, qty = qty.setScale(10, 4));
                        if (newQtyFrom != null) {
                            newQtyFrom = newQtyFrom.setScale(qtyScale, 4);
                            changeRow.getCell(this.TB_QTY).setValue((Object)newQtyFrom);
                        }
                        this.calByEntryQtyChange(rowIndex, 0);
                    }
                }
            }
            catch (Exception ex) {
                this.editUi.handUIException(ex);
            }
        }
    }

    @Override
    public void entryUnitChange(int rowIndex, MeasureUnitInfo curUnitOldValue, boolean isPrice) {
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getCell(rowIndex, this.TB_MATERIAL).getValue();
        if (measureUnitInfo != null && materialInfo != null) {
            try {
                IRow changeRow = this.getDetailTable().getRow(rowIndex);
                BigDecimal price = null;
                if (changeRow.getCell(this.TB_PRICE).getValue() != null) {
                    price = (BigDecimal)changeRow.getCell(this.TB_PRICE).getValue();
                }
                BigDecimal qty = (BigDecimal)changeRow.getCell(this.TB_QTY).getValue();
                SCMClientUtils.changeTableColPrecisionByMaterial(materialInfo, measureUnitInfo, this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, new int[]{rowIndex});
                if (curUnitOldValue != null && !curUnitOldValue.equals((Object)measureUnitInfo)) {
                    int qtyScale;
                    BigDecimal newDiscount;
                    ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_DISCOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_DISCOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_DISCOUNT).getEditor();
                    int discountScale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
                    DiscountModeEnum discounMode = null;
                    discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                    BigDecimal discount = new BigDecimal("0.00");
                    if (changeRow.getCell(this.TB_DISCOUNT).getValue() != null) {
                        discount = (BigDecimal)changeRow.getCell(this.TB_DISCOUNT).getValue();
                    }
                    if (!isPrice && discounMode != null && discounMode.getValue() == 1 && (newDiscount = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, discount = discount.setScale(discountScale, 4))) != null) {
                        newDiscount = newDiscount.setScale(discountScale, 4);
                        changeRow.getCell(this.TB_DISCOUNT).setValue((Object)newDiscount);
                    }
                    int scale = this.getDetailTable().getColumn(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_PRICE).getEditor().getComponent()).getPrecision();
                    int n = qtyScale = this.getDetailTable().getColumn(this.TB_QTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getEditor().getComponent()).getPrecision();
                    if (price != null && !isPrice) {
                        if (this.cbIsInTax.isSelected()) {
                            BigDecimal taxPrice = (BigDecimal)changeRow.getCell(this.TB_TAXPRICE).getValue();
                            BigDecimal baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, taxPrice);
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_TAXPRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryTaxPriceChange(rowIndex, 0);
                        } else {
                            BigDecimal baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, price);
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_PRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryPriceChange(rowIndex, 0);
                        }
                        isPrice = false;
                    }
                    if (qty != null) {
                        BigDecimal newQtyFrom = SCMClientUtils.getBaseUnitQtyFromData(measureUnitInfo, curUnitOldValue, materialInfo, qty = qty.setScale(10, 4));
                        if (newQtyFrom != null) {
                            newQtyFrom = newQtyFrom.setScale(qtyScale, 4);
                            changeRow.getCell(this.TB_QTY).setValue((Object)newQtyFrom);
                        }
                        this.calByEntryQtyChange(rowIndex, 0);
                    }
                }
            }
            catch (Exception ex) {
                this.editUi.handUIException(ex);
            }
        }
    }

    @Override
    public void setEntryDiscountEditor(int rowIndex, MaterialInfo materialInfo) {
        int discountRate = this.getDiscountRate();
        if (materialInfo != null || this.isDestinationTypeNotStorage(rowIndex)) {
            KDTDefaultCellEditor col_CellEditor = FormattedEditorFactory.getDiscountCellEditor(discountRate);
            ((KDFormattedTextField)col_CellEditor.getComponent()).setMaximumValue((Comparable)new BigDecimal("100.0000000000"));
            String colPrecision = PrecisionUtil.getFormatString(discountRate);
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT) != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setEditor((ICellEditor)col_CellEditor);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setNumberFormat(colPrecision);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setEditor((ICellEditor)col_CellEditor);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(TB_DISCOUNTRATE).setEditor((ICellEditor)col_CellEditor);
                this.kdtEntries.getRow(rowIndex).getCell(TB_DISCOUNTRATE).getStyleAttributes().setNumberFormat(colPrecision);
                this.kdtEntries.getRow(rowIndex).getCell(TB_DISCOUNTRATE).setEditor((ICellEditor)col_CellEditor);
            }
        }
    }

    @Override
    public void setEntryDiscount(KDTable table) {
        int discountRate = this.getDiscountRate();
        KDTDefaultCellEditor col_CellEditor = FormattedEditorFactory.getBigDecimalCellEditor(discountRate, false);
        String colPrecision = PrecisionUtil.getFormatString(discountRate);
        table.getColumn(TB_DISCOUNTRATE).setEditor((ICellEditor)col_CellEditor);
        table.getColumn(TB_DISCOUNTRATE).setEditor((ICellEditor)col_CellEditor);
        table.getColumn(TB_DISCOUNTRATE).getStyleAttributes().setNumberFormat(colPrecision);
    }

    private boolean isDestinationTypeNotStorage(int row) {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)this.kdtEntries.getRow(row).getCell(this.TB_ROWTYPE).getValue();
        return rowTypeInfo.getDestinationType() != DestinationTypeEnum.STORAGE;
    }

    @Override
    public void entryQtyUnCtrl(int rowIndex, Object o) throws Exception {
        if (o != null && o instanceof Boolean) {
            boolean isUnCtrlQty = (Boolean)o;
            if (rowIndex >= 0) {
                this.kdtEntries.getCell(rowIndex, TB_RECEIVEOVERRATE).getStyleAttributes().setLocked(isUnCtrlQty);
                this.kdtEntries.getCell(rowIndex, TB_RECEIVEOWINGRATE).getStyleAttributes().setLocked(isUnCtrlQty);
                if (isUnCtrlQty) {
                    this.kdtEntries.getCell(rowIndex, TB_RECEIVEOVERRATE).setValue((Object)ZERO);
                    this.kdtEntries.getCell(rowIndex, TB_RECEIVEOWINGRATE).setValue((Object)ZERO);
                }
            }
        }
        this.setSENDRATEMaxValue(rowIndex);
    }

    @Override
    public void entryTimeUnCtrl(int rowIndex, Object o) throws Exception {
        if (o != null && o instanceof Boolean) {
            boolean isUnCtrlTime = (Boolean)o;
            if (rowIndex >= 0) {
                this.kdtEntries.getCell(rowIndex, TB_DELIVERYADVANCEDAY).getStyleAttributes().setLocked(isUnCtrlTime);
                this.kdtEntries.getCell(rowIndex, TB_DELIVERYDEFERRALDAY).getStyleAttributes().setLocked(isUnCtrlTime);
                if (isUnCtrlTime) {
                    this.kdtEntries.getCell(rowIndex, TB_DELIVERYADVANCEDAY).setValue(null);
                    this.kdtEntries.getCell(rowIndex, TB_DELIVERYDEFERRALDAY).setValue(null);
                }
            }
        }
    }

    @Override
    public void calEntryTaxAmount(int rowIndex, int colIndex) {
        int scale;
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_TAXAMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor();
        int n = scale = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal qty = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal taxPrice = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue() == null ? new BigDecimal("0.00") : (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            BigDecimal discountRate = new BigDecimal(0);
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT) != null) {
                discountRate = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
            } else if (this.kdtEntries.getRow(rowIndex).getCell(TB_DISCOUNTRATE) != null) {
                discountRate = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TB_DISCOUNTRATE).getValue();
            }
            if (discountRate != null && discountRate.compareTo(new BigDecimal("0.00")) > 0) {
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal oneHundred = new BigDecimal("100.0");
                discountRate = one.subtract(discountRate.divide(oneHundred, 10, 4));
            } else {
                discountRate = null;
            }
            if (qty != null && taxPrice != null) {
                BigDecimal totalTaxAmount = qty.multiply(taxPrice);
                if (discountRate != null) {
                    totalTaxAmount = totalTaxAmount.multiply(discountRate);
                }
                totalTaxAmount = totalTaxAmount.setScale(scale, 4);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)totalTaxAmount);
            }
        } else {
            BigDecimal amount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAX).getValue();
            BigDecimal totalTaxAmount = CalculateUtils.calTotalTaxAmount(amount, tax, scale);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)totalTaxAmount);
        }
    }

    public void calEntryTaxAmountByDiscountAmount(int rowIndex, int colIndex) {
        ICellEditor editor;
        int scale = 2;
        ICellEditor iCellEditor = editor = this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor() == null ? this.getDetailTable().getColumn(this.TB_TAXAMOUNT).getEditor() : this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getEditor();
        if (editor != null) {
            scale = ((KDFormattedTextField)editor.getComponent()).getPrecision();
        }
        if (this.cbIsInTax.isSelected()) {
            BigDecimal qty = ZERO;
            if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue() != null) {
                qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            }
            BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            BigDecimal discountAmount = ZERO;
            if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue() != null) {
                discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
            }
            BigDecimal amount = SysConstant.BIGZERO;
            if (taxPrice != null) {
                amount = qty.multiply(taxPrice).subtract(discountAmount);
                amount = amount.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)amount);
            }
        } else {
            BigDecimal amount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAX).getValue();
            BigDecimal totalTaxAmount = CalculateUtils.calTotalTaxAmount(amount, tax, scale);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)totalTaxAmount);
        }
    }

    @Override
    public void afterMainOrgChanged(String arg0, String arg1, SCMBizDataVO vo) {
        this.parametersMap = vo.getParametersMap();
        this.baseCurrInfo = vo.getBaseCurrInfo();
    }

    @Override
    public void changedByMaterials(int rowIdx, MaterialInfo[] materialInfos, Map dataMap, int changeLevel, EventObject e, boolean allowAddEntry) throws Exception {
    }

    @Override
    public void changedByMaterials(int rowIdx, MaterialInfo[] materialInfos, Map[] params, Map dataMap, int changeLevel, EventObject e, boolean allowAddEntry) throws Exception {
    }

    @Override
    public void setSENDRATEMaxValue(int rowIndex) {
    }

    @Override
    public void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo, boolean allowAddEntry) throws EASBizException, BOSException {
    }

    @Override
    public SCMEntryDataVO initInLoadFields(SCMEntryDataVO inDataVO) {
        SCMEntryDataVO resultVO = null;
        SCMEntryDataVO vo = null;
        vo = inDataVO != null ? inDataVO : (OrgType.Sale.equals((Object)this.mainOrgType) ? new SaleOrderDataVO() : (OrgType.Purchase.equals((Object)this.mainOrgType) ? new PurEntryDataVO() : new SCMEntryDataVO()));
        vo.setMainOrgType(this.getMainBizOrgType());
        vo.setMainOrg(this.getMainOrgInfo());
        if (this.isBotpBill()) {
            vo.setIsLoadingMou(true);
        }
        vo.setIsLoadingMmuPrecision(true);
        vo.setIsLoadingCurrency(this.prmtCurrency != null);
        try {
            boolean hasMaterial = this.initSCMEntryDataVO(vo);
            resultVO = this.loadComplexData(vo, hasMaterial);
            if (this.TB_ROWTYPE == null) {
                SCMClientUtils.changeTableRowColPrecisionByMaterial(vo.getMaterialInfos(), resultVO, this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, this.QTYPRECISIONFROMBASEUNITTAB, this.QTYPRECISIONFROMASSISTUNITTAB);
            } else {
                this.changePrecisionWhenRowTypeExists(vo, resultVO);
            }
            if (hasMaterial) {
                this.initPricePrecision(resultVO);
                if (this.TB_QTY != null && this.isBotpBill()) {
                    this.calEntryBaseQty(vo, resultVO);
                }
            }
        }
        catch (Exception e) {
            this.editUi.handUIException(e);
            return vo;
        }
        if (vo.isLoadingCurrency()) {
            this.initPrecision(resultVO);
        }
        return resultVO;
    }

    private void changePrecisionWhenRowTypeExists(SCMEntryDataVO vo, SCMEntryDataVO resultVO) {
        MaterialInfo[] materialInfos = vo.getMaterialInfos();
        if (materialInfos != null && materialInfos.length != 0) {
            this.changePrecisionWhenHasMaterial(resultVO, materialInfos, this.getDetailTable());
        } else {
            this.changePrecisionWhenHasNotMaterial();
        }
    }

    private void changePrecisionWhenHasNotMaterial() {
        MeasureUnitInfo unitInfo = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            unitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_UNIT).getValue();
            this.changePrecisionByUnit(unitInfo, i);
        }
    }

    private void changePrecisionByUnit(MeasureUnitInfo unitInfo, int i) {
        if (unitInfo != null) {
            SCMClientUtils.changeTableColPrecision(unitInfo.getQtyPrecision(), this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, i);
            SCMClientUtils.changeTableColPrecision(unitInfo.getQtyPrecision(), this.getDetailTable(), this.QTYPRECISIONFROMBASEUNITTAB, i);
            SCMClientUtils.changeTableColPrecision(unitInfo.getQtyPrecision(), this.getDetailTable(), this.QTYPRECISIONFROMASSISTUNITTAB, i);
        } else {
            SCMClientUtils.changeTableColPrecision(8, this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, i);
            SCMClientUtils.changeTableColPrecision(8, this.getDetailTable(), this.QTYPRECISIONFROMBASEUNITTAB, i);
            SCMClientUtils.changeTableColPrecision(8, this.getDetailTable(), this.QTYPRECISIONFROMASSISTUNITTAB, i);
        }
    }

    private void changePrecisionWhenHasMaterial(SCMEntryDataVO resultVO, MaterialInfo[] materialInfos, KDTable table) {
        Map mulUnitMap = null;
        MaterialInfo materialInfo = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        MeasureUnitInfo assistUnit = null;
        RowTypeInfo rowTypeInfo = null;
        if (resultVO != null) {
            mulUnitMap = resultVO.getMmuPrecisions();
        }
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            rowTypeInfo = (RowTypeInfo)this.kdtEntries.getRow(i).getCell(this.TB_ROWTYPE).getValue();
            if (rowTypeInfo == null) continue;
            materialInfo = (MaterialInfo)this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue();
            if (rowTypeInfo.isIsHasMaterialNumber() && materialInfo != null) {
                unit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_UNIT).getValue();
                baseUnit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_BASEUNIT).getValue();
                assistUnit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_ASSISTUNIT).getValue();
                SCMClientUtils.changeTableColPrecision(mulUnitMap, materialInfo, unit, this.getDetailTable(), this.QTYPRECISIONFROMUNITTAB, i);
                SCMClientUtils.changeTableColPrecision(mulUnitMap, materialInfo, baseUnit, this.getDetailTable(), this.QTYPRECISIONFROMBASEUNITTAB, i);
                if (this.QTYPRECISIONFROMASSISTUNITTAB == null) continue;
                SCMClientUtils.changeTableColPrecision(mulUnitMap, materialInfo, assistUnit, this.getDetailTable(), this.QTYPRECISIONFROMASSISTUNITTAB, i);
                continue;
            }
            unit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_UNIT).getValue();
            this.changePrecisionByUnit(unit, i);
        }
    }

    protected SCMEntryDataVO loadComplexData(SCMEntryDataVO inDataVO, boolean hasMaterial) throws EASBizException, BOSException {
        return SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(inDataVO);
    }

    protected boolean initSCMEntryDataVO(SCMEntryDataVO vo) {
        int length;
        if (vo.isLoadingCurrency()) {
            vo.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getValue());
        }
        if ((length = this.getDetailTable().getRowCount()) <= 0) {
            return false;
        }
        MaterialInfo[] materialInfos = new MaterialInfo[length];
        MeasureUnitInfo[] measureUnitInfos = null;
        MeasureUnitInfo[] measureBaseUnitInfos = null;
        MeasureUnitInfo[] measureAssistUnitInfos = null;
        StorageOrgUnitInfo[] storageOrgUnitInfos = null;
        boolean hasMaterial = false;
        if (vo.isLoadingMou() || vo.isLoadingMmuPrecision()) {
            measureUnitInfos = new MeasureUnitInfo[length];
            measureBaseUnitInfos = new MeasureUnitInfo[length];
            measureAssistUnitInfos = new MeasureUnitInfo[length];
        }
        if (vo.isLoadingMaterialInventory() && vo.getStorageOrgUnitInfos() == null) {
            storageOrgUnitInfos = new StorageOrgUnitInfo[length];
        } else if (vo.isLoadingMaterialInventory()) {
            storageOrgUnitInfos = vo.getStorageOrgUnitInfos();
        }
        if (vo.isLoadingCurrency()) {
            vo.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getValue());
        }
        for (int i = 0; i < length; ++i) {
            materialInfos[i] = (MaterialInfo)this.getDetailTable().getRow(i).getCell(this.TB_MATERIAL).getValue();
            if (materialInfos[i] == null) continue;
            hasMaterial = true;
            if (vo.isLoadingMou() || vo.isLoadingMmuPrecision()) {
                measureUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(this.TB_UNIT).getValue();
                measureBaseUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(this.TB_BASEUNIT).getValue();
                if (this.getDetailTable().getRow(i).getCell(this.TB_ASSISTUNIT) != null) {
                    measureAssistUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(this.TB_ASSISTUNIT).getValue();
                }
            }
            if (!vo.isLoadingMaterialInventory() || vo.getStorageOrgUnitInfos() != null) continue;
            storageOrgUnitInfos[i] = (StorageOrgUnitInfo)this.getDetailTable().getRow(i).getCell(this.TB_STORAGEORGUNIT).getValue();
        }
        vo.setMaterialInfos(materialInfos);
        vo.setMeasureUnitInfos(measureUnitInfos);
        vo.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        vo.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        vo.setStorageOrgUnitInfos(storageOrgUnitInfos);
        return hasMaterial;
    }

    private void calEntryBaseQty(SCMEntryDataVO inDataVO, SCMEntryDataVO resultVO) {
        for (int idxOfRow = 0; idxOfRow < this.getDetailTable().getRowCount(); ++idxOfRow) {
            BigDecimal baseQty = null;
            BigDecimal orderQty = (BigDecimal)this.getDetailTable().getRow(idxOfRow).getCell(this.TB_QTY).getValue();
            MaterialInfo materialInfo = inDataVO.getMaterialInfos()[idxOfRow];
            MeasureUnitInfo unitInfo = inDataVO.getMeasureUnitInfos()[idxOfRow];
            Map convetRateMap = resultVO.getMmuConvsRate();
            if (convetRateMap == null || unitInfo == null || orderQty == null || orderQty.compareTo(ZERO) == 0) continue;
            BigDecimal unitRate = (BigDecimal)convetRateMap.get(materialInfo.getId().toString() + unitInfo.getId().toString());
            baseQty = unitRate == null ? orderQty : orderQty.multiply(unitRate);
            int scale = this.getDetailTable().getRow(idxOfRow).getCell(this.TB_BASEQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(idxOfRow).getCell(this.TB_BASEQTY).getEditor().getComponent()).getPrecision();
            baseQty = baseQty.setScale(scale, 4);
            this.getDetailTable().getRow(idxOfRow).getCell(this.TB_BASEQTY).setValue((Object)baseQty);
        }
    }

    private void initPricePrecision(SCMEntryDataVO resultVO) {
        if (resultVO.getMaterialInfos() == null) {
            return;
        }
        int num = resultVO.getMaterialInfos().length;
        for (int i = 0; i < num; ++i) {
            MaterialInfo material = resultVO.getMaterialInfos()[i];
            if (material == null) continue;
            SCMClientUtils.changeTableColPrecision(material.getPricePrecision(), this.kdtEntries, this.PRICEPRECISIONTAB, i);
        }
    }

    private void initPrecision(SCMEntryDataVO resultVO) {
        CurrencyInfo currencyInfo;
        if (this.DEFAULTRECISIONCOMPENT != null) {
            SCMClientUtils.changeTableColPrecision(2, this.DEFAULTRECISIONCOMPENT);
        }
        if (this.DEFAULTRECISIONTAB != null) {
            SCMClientUtils.changeTableColPrecisionByCol(2, this.getDetailTable(), this.DEFAULTRECISIONTAB);
        }
        if (resultVO != null && resultVO.getBaseCurrencyInfo() != null) {
            if (this.BASECURRENCYPRECISIONCOMPENT != null) {
                SCMClientUtils.changeTableColPrecisionByCurrency(resultVO.getBaseCurrencyInfo(), this.BASECURRENCYPRECISIONCOMPENT);
            }
            if (this.BASECURRENCYPRECISIONTAB != null) {
                SCMClientUtils.changeTableColPrecisionByCurrency(resultVO.getBaseCurrencyInfo(), this.getDetailTable(), this.BASECURRENCYPRECISIONTAB);
            }
        }
        if (this.txtExchangeRate != null) {
            int precision = 2;
            if (resultVO != null && resultVO.getExchangeRateinfo() != null) {
                precision = resultVO.getExchangeRateinfo().getPrecision();
            }
            SCMClientUtils.changeTableColPrecision(precision, new KDFormattedTextField[]{this.txtExchangeRate});
        }
        if ((currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue()) != null) {
            if (this.CURRENCYPRECISIONCOMPENT != null) {
                SCMClientUtils.changeTableColPrecisionByCurrency(currencyInfo, this.CURRENCYPRECISIONCOMPENT);
            }
            if (this.CURRENCYPRECISIONTAB != null) {
                SCMClientUtils.changeTableColPrecisionByCurrency(currencyInfo, this.getDetailTable(), this.CURRENCYPRECISIONTAB);
            }
        }
    }

    @Override
    public IObjectValue getDataFromCache(IObjectPK pk) {
        return FixedDataCache.getInstance().getDataFromCache(pk);
    }

    @Override
    public SCMBizDataVO loadSCMBizData(SCMBizDataVO vo) throws EASBizException, BOSException {
        SCMEntryDataVO inDataVO = new SCMEntryDataVO();
        if (vo.isFirstLoading()) {
            FixedDataCache.getInstance().initDataLoading(inDataVO);
        }
        vo.setScmEntryDataVO(inDataVO);
        SCMBizDataVO bizDataVO = SCMGroupFacadeFactory.getRemoteInstance().loadSCMBizDataVO(vo);
        return bizDataVO;
    }

    @Override
    public Map getConfigMap() {
        return this.configMap;
    }

    public SCMEntryDataVO getScmEntryDataVO() {
        return (SCMEntryDataVO)this.configMap.get("SCMENTRYVO");
    }

    @Override
    public boolean isExistsListener(KDBizPromptBox prmtBox, Class listenerType, EventListener listener) {
        HashSet<EventListener> set = new HashSet<EventListener>();
        EventListener[] listeners = prmtBox.getListeners(listenerType);
        set.addAll(Arrays.asList(listeners));
        return set.contains(listener);
    }

    @Override
    public void addDataChangeListener(KDBizPromptBox prmtBox, DataChangeListener listener) {
        if (listener == null) {
            return;
        }
        boolean flag = false;
        EventListener[] dataChangeListeners = prmtBox.getListeners(DataChangeListener.class);
        EventListener oldListener = null;
        for (int i = 0; i < dataChangeListeners.length; ++i) {
            oldListener = dataChangeListeners[i];
            if (!listener.equals(oldListener)) continue;
            flag = true;
            break;
        }
        if (flag) {
            return;
        }
        prmtBox.addDataChangeListener(listener);
    }

    public void removeDataChangeListener(KDFormattedTextField component, DataChangeListener listener) {
        if (listener == null) {
            return;
        }
        EventListener[] dataChangeListeners = component.getListeners(DataChangeListener.class);
        EventListener oldListener = null;
        for (int i = 0; i < dataChangeListeners.length; ++i) {
            oldListener = dataChangeListeners[i];
            if (!listener.equals(oldListener)) continue;
            component.removeDataChangeListener(listener);
        }
    }

    public Map getRequieredAssistPropRow() {
        return this.requieredAssistPropRow;
    }

    public void setRequieredAssistPropRow(Map requieredAssistPropRow) {
        this.requieredAssistPropRow = requieredAssistPropRow != null ? requieredAssistPropRow : new HashMap();
    }

    @Override
    public SCMEntryDataVO initSCMEntryDataVO4RPC() {
        SCMEntryDataVO vo = null;
        vo = OrgType.Sale.equals((Object)this.getMainBizOrgType()) ? new SaleOrderDataVO() : (OrgType.Purchase.equals((Object)this.getMainBizOrgType()) ? new PurEntryDataVO() : new SCMEntryDataVO());
        vo.setMainOrgType(this.getMainBizOrgType());
        vo.setIsLoadingCurrency(this.prmtCurrency != null);
        return vo;
    }

    @Override
    public void handlePrice(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, SaleOrderDataVO resultVO, EventObject e) throws EASBizException, BOSException {
    }

    public String getBillTypeId() {
        return this.billTypeId;
    }

    public void setBillTypeId(String billTypeId) {
        this.billTypeId = billTypeId;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public boolean iscalTaxRateByQtyChangeed() {
        return this.iscalTaxRateByQtyChangeed;
    }
}

