/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import java.awt.Component;
import java.util.Map;
import javax.swing.JToggleButton;

public class CheckRadioFilterElement
extends FilterElement {
    private Component component = null;
    private FilterItemInfo selectedFilterItem = null;
    private FilterItemInfo unselectedFilterItem = null;
    private Boolean defValue = null;

    public CheckRadioFilterElement(Component component, FilterItemInfo selFilterItem, FilterItemInfo unselFilterItem) {
        this.component = component;
        this.selectedFilterItem = selFilterItem;
        this.unselectedFilterItem = unselFilterItem;
    }

    public CheckRadioFilterElement(String id, Component component) {
        super(id);
        if (!(component instanceof JToggleButton)) {
            throw new UnsupportedOperationException("The element must be extends JToggleButton, such as KDCheckBox or KDRadioButton.");
        }
        this.component = component;
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        Boolean isSelected = this.isSelected();
        if (isSelected == null) {
            return null;
        }
        if (this.getId() == null) {
            if (isSelected.booleanValue() && this.selectedFilterItem != null) {
                filterInfo.getFilterItems().add(this.selectedFilterItem);
            } else if (!isSelected.booleanValue() && this.unselectedFilterItem != null) {
                filterInfo.getFilterItems().add(this.unselectedFilterItem);
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(this.getId(), (Object)isSelected, CompareType.EQUALS));
        }
        return filterInfo;
    }

    public Boolean isSelected() {
        if (this.component instanceof KDCheckBox) {
            return ((KDCheckBox)this.component).isSelected();
        }
        if (this.component instanceof KDRadioButton) {
            return ((KDRadioButton)this.component).isSelected();
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.defValue != null) {
            this.setData(this.component, this.defValue);
        }
    }

    @Override
    public void setParam(Map map) {
        super.setParam(map, this.component);
    }

    @Override
    protected void setData(Map paramMap, Map propMap) {
        if (paramMap.containsKey(this.getName(this.component))) {
            super.setData(this.component, paramMap.get(this.getName(this.component)));
        }
    }

    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public FilterItemInfo getSelectedFilterItem() {
        return this.selectedFilterItem;
    }

    public void setSelectedFilterItem(FilterItemInfo selectedFilterItem) {
        this.selectedFilterItem = selectedFilterItem;
    }

    public FilterItemInfo getUnselectedFilterItem() {
        return this.unselectedFilterItem;
    }

    public void setUnselectedFilterItem(FilterItemInfo unselectedFilterItem) {
        this.unselectedFilterItem = unselectedFilterItem;
    }

    @Override
    public void addCustomerParam(CustomerParams cp) {
        super.addCustomerParam(cp, this.component);
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam(this.getName(this.component)) != null) {
            this.setNumber(this.component, cp.getCustomerParam(this.getName(this.component)));
        }
    }

    @Override
    protected void setElementData(CustomerParams cp, String key) {
    }

    @Override
    protected boolean verify(VerifyItem verifyItem) {
        return true;
    }

    @Override
    public void setDefaultValue(Object value) {
        if (value instanceof Boolean) {
            this.defValue = (Boolean)value;
        }
    }

    @Override
    public void addRptParams(RptParams cp) {
        super.addRptParams(cp, this.getId(), this.component);
    }

    @Override
    public void setElementValue(RptParams cp) {
        if (cp != null && cp.getObject(this.getId()) != null) {
            this.setData(this.component, cp.getObject(this.getId()));
        }
    }
}

