/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CompositeFilterElement
extends FilterElement {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.filter.CompositeFilterElement");
    public static final int AND = 0;
    public static final int OR = 1;
    private Map elementMap = new HashMap();
    private int linkType = 0;

    public CompositeFilterElement(int linkType) {
        this.linkType = linkType;
    }

    public void add(FilterElement element) {
        this.elementMap.put(element.getId(), element);
    }

    public int size() {
        return this.elementMap.size();
    }

    public FilterElement get(String id) {
        return (FilterElement)this.elementMap.get(id);
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterElement element = null;
        FilterInfo result = null;
        FilterInfo filterInfo = null;
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            element = this.get((String)keys[i]);
            filterInfo = element.getFilterInfo();
            if (filterInfo == null || filterInfo.getFilterItems().size() <= 0) continue;
            if (result == null) {
                result = filterInfo;
                continue;
            }
            try {
                result.mergeFilter(filterInfo, this.linkType == 0 ? "AND" : "OR");
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            this.get((String)keys[i]).clear();
        }
    }

    @Override
    public void setParam(Map map) {
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            this.get((String)keys[i]).setParam(map);
        }
    }

    public FilterElement getLeafElement(String id) {
        FilterElement element = (FilterElement)this.elementMap.get(id);
        if (element == null) {
            Object[] keys = this.elementMap.keySet().toArray();
            for (int i = 0; i < this.size(); ++i) {
                element = (FilterElement)this.elementMap.get(keys[i]);
                if (!(element instanceof CompositeFilterElement)) continue;
                return ((CompositeFilterElement)element).getLeafElement(id);
            }
        }
        return element;
    }

    @Override
    protected void setData(Map paramMap, Map propMap) {
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            this.get((String)keys[i]).setData(paramMap, propMap);
        }
    }

    @Override
    public void addCustomerParam(CustomerParams cp) {
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            this.get((String)keys[i]).addCustomerParam(cp);
        }
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp != null) {
            Object[] keys = this.elementMap.keySet().toArray();
            for (int i = 0; i < this.size(); ++i) {
                this.get((String)keys[i]).setElementValue(cp);
            }
        }
    }

    @Override
    protected void setElementData(CustomerParams cp, String key) {
    }

    @Override
    protected boolean verify(VerifyItem verifyItem) {
        return true;
    }

    @Override
    protected boolean verify() {
        Object[] keys = this.elementMap.keySet().toArray();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get((String)keys[i]).verify()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDefaultValue(Object value) {
    }

    @Override
    public void addRptParams(RptParams cp) {
        for (Map.Entry entry : this.elementMap.entrySet()) {
            this.get(entry).addRptParams(cp);
        }
    }

    private FilterElement get(Map.Entry entry) {
        return (FilterElement)entry.getValue();
    }

    @Override
    public void setElementValue(RptParams cp) {
        if (cp != null) {
            Object[] keys = this.elementMap.keySet().toArray();
            for (int i = 0; i < this.size(); ++i) {
                this.get((String)keys[i]).setElementValue(cp);
            }
        }
    }
}

