/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class FilterElement {
    private String id = null;
    private Object blankValue = null;
    private boolean isExclude = false;
    private Collection verifyItems = null;
    public static final int DATESTART = 0;
    public static final int DATEEND = 1;
    public static final int NOTDATE = -1;

    public abstract FilterInfo getFilterInfo();

    public abstract void clear();

    public abstract void setParam(Map var1);

    protected abstract void setData(Map var1, Map var2);

    public abstract void addCustomerParam(CustomerParams var1);

    public abstract void setElementValue(CustomerParams var1);

    protected abstract void setElementData(CustomerParams var1, String var2);

    public abstract void addRptParams(RptParams var1);

    public abstract void setElementValue(RptParams var1);

    protected abstract boolean verify(VerifyItem var1);

    public abstract void setDefaultValue(Object var1);

    public FilterElement() {
    }

    public FilterElement(String id) {
        this.id = id;
    }

    public FilterElement(String id, Object blankValue) {
        this.id = id;
        this.blankValue = blankValue;
    }

    public Object getBlankValue() {
        return this.blankValue;
    }

    public void setBlankValue(Object blankValue) {
        this.blankValue = blankValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void clear(Object obj) {
        if (obj instanceof KDPromptBox) {
            ((KDPromptBox)obj).setValue(null);
        } else if (obj instanceof KDTextField) {
            ((KDTextField)obj).setText(null);
        } else if (obj instanceof KDComboBox) {
            ((KDComboBox)obj).setSelectedIndex(-1);
        } else if (obj instanceof KDDatePicker) {
            ((KDDatePicker)obj).setValue(null);
        } else if (obj instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)obj).setText(null);
        }
    }

    private String getNumber(Object obj, boolean withBlank) {
        Object data = null;
        String result = null;
        if (obj instanceof KDPromptBox) {
            data = ((KDPromptBox)obj).getData();
            if (obj instanceof KDBizPromptBox && (((KDBizPromptBox)obj).getDisplayFormatter() == null || ((KDBizPromptBox)obj).getDisplayFormatter().toString().equalsIgnoreCase("$name$")) && data != null) {
                if (data instanceof Object[]) {
                    result = this.getNumberList((Object[])data);
                } else if (data instanceof DataBaseInfo) {
                    result = ((DataBaseInfo)data).getNumber().toString();
                } else if (data instanceof CoreBillBaseInfo) {
                    result = ((CoreBillBaseInfo)data).getNumber().toString();
                }
            }
            if (result == null) {
                result = ((KDPromptBox)obj).getText().trim();
            }
            if (result.equals("") || withBlank && data != null && this.isBlank(data)) {
                return null;
            }
            return result;
        }
        if (obj instanceof KDTextField && ((KDTextField)obj).getText() != null && ((KDTextField)obj).getText().length() > 0) {
            data = ((KDTextField)obj).getText();
        } else if (obj instanceof KDSpinner && ((KDSpinner)obj).getValue() != null) {
            data = ((KDSpinner)obj).getIntegerVlaue().toString();
        } else if (obj instanceof KDNumberTextField && ((KDNumberTextField)obj).getText() != null && ((KDNumberTextField)obj).getText().length() > 0) {
            data = ((KDNumberTextField)obj).getText();
        } else {
            if (obj instanceof KDComboBox) {
                if (((KDComboBox)obj).getSelectedItem() instanceof IntEnum) {
                    IntEnum itemEnum = (IntEnum)((KDComboBox)obj).getSelectedItem();
                    if (!withBlank && itemEnum != null || !this.isBlank(itemEnum)) {
                        result = String.valueOf(itemEnum.getValue());
                    }
                } else {
                    StringEnum itemEnum = (StringEnum)((KDComboBox)obj).getSelectedItem();
                    if (!withBlank && itemEnum != null || !this.isBlank(itemEnum)) {
                        result = itemEnum.getValue();
                    }
                }
                return result;
            }
            if (obj instanceof KDDatePicker) {
                data = ((KDDatePicker)obj).getTimestamp();
                if (!withBlank && data != null || !this.isBlank(data)) {
                    result = data.toString();
                }
                return result;
            }
            if (obj instanceof KDCheckBox) {
                result = String.valueOf(((KDCheckBox)obj).isSelected());
                return result;
            }
            if (obj instanceof KDRadioButton) {
                result = String.valueOf(((KDRadioButton)obj).isSelected());
                return result;
            }
            if (obj instanceof KDFormattedTextField && ((KDFormattedTextField)obj).getText() != null && ((KDFormattedTextField)obj).getText().length() > 0 && ((KDFormattedTextField)obj).getDataType() == 1) {
                try {
                    data = BOSLocaleUtil.getNumberFormat().parse(((KDFormattedTextField)obj).getText()).toString();
                }
                catch (ParseException e) {
                    data = ((KDFormattedTextField)obj).getText();
                }
            } else if (obj instanceof BasicFormattedTextField && ((BasicFormattedTextField)obj).getText() != null && ((BasicFormattedTextField)obj).getText().length() > 0) {
                data = ((BasicFormattedTextField)obj).getText();
            }
        }
        return (String)(withBlank && this.isBlank(data) ? null : data);
    }

    protected String getNumber(Object obj) {
        return this.getNumber(obj, true);
    }

    protected boolean isBlank(Object data) {
        return data == null || data.equals(this.blankValue);
    }

    protected FilterItemInfo getFilterItemInfo(Object obj, CompareType type) {
        String data = null;
        LinkedHashSet sets = null;
        if (this.isExclude) {
            return null;
        }
        data = this.getNumber(obj);
        if (data != null) {
            if (data.indexOf(";") > -1) {
                sets = SCMGroupClientUtils.getKeyIdList(data);
                if (sets.size() > 0) {
                    return new FilterItemInfo(this.id, (Object)sets, CompareType.INCLUDE);
                }
            } else {
                return new FilterItemInfo(this.id, (Object)data, type);
            }
        }
        return null;
    }

    protected String getName(Object obj) {
        if (obj instanceof KDPromptBox) {
            return ((KDPromptBox)obj).getName();
        }
        if (obj instanceof KDTextField) {
            return ((KDTextField)obj).getName();
        }
        if (obj instanceof KDComboBox) {
            return ((KDComboBox)obj).getName();
        }
        if (obj instanceof KDDatePicker) {
            return ((KDDatePicker)obj).getName();
        }
        if (obj instanceof KDCheckBox) {
            return ((KDCheckBox)obj).getName();
        }
        if (obj instanceof KDRadioButton) {
            return ((KDRadioButton)obj).getName();
        }
        if (obj instanceof BasicFormattedTextField) {
            return ((BasicFormattedTextField)obj).getName();
        }
        if (obj instanceof KDSpinner) {
            return ((KDSpinner)obj).getName();
        }
        return null;
    }

    protected void setParam(Map map, Object obj) {
        String name = this.getName(obj);
        this.setParam(map, name, obj);
    }

    protected void setParam(Map map, String key, Object obj) {
        Object data = null;
        if (key != null && (data = this.getData(obj)) != null && !data.equals(this.blankValue)) {
            map.put(key, data);
        }
    }

    public final String getNumberList(Object[] datas) {
        Object data = null;
        StringBuffer sb = new StringBuffer();
        if (datas != null && datas.length > 0) {
            for (int i = 0; i < datas.length; ++i) {
                data = datas[i];
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                if (data instanceof DataBaseInfo) {
                    sb.append(((DataBaseInfo)data).getNumber().toString());
                    continue;
                }
                if (!(data instanceof CoreBillBaseInfo)) continue;
                sb.append(((CoreBillBaseInfo)data).getNumber().toString());
            }
        }
        return sb.toString();
    }

    public final String getPKList(Object[] datas) {
        Object data = null;
        StringBuffer sb = new StringBuffer();
        if (datas != null && datas.length > 0) {
            for (int i = 0; i < datas.length; ++i) {
                data = datas[i];
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                if (!(data instanceof ObjectBaseInfo)) continue;
                sb.append(((ObjectBaseInfo)data).getId().toString());
            }
        }
        return sb.toString();
    }

    protected void setData(Component obj, Object value) {
        if (obj instanceof KDPromptBox) {
            ((KDPromptBox)obj).setData(value);
        } else if (obj instanceof KDTextField) {
            ((KDTextField)obj).setText((String)value);
        } else if (obj instanceof KDComboBox) {
            String eumValue = null;
            if (value != null) {
                eumValue = value instanceof IntEnum ? String.valueOf(((IntEnum)value).getValue()) : (value instanceof StringEnum ? ((StringEnum)value).getValue() : value.toString());
                KDComboBox cobox = (KDComboBox)obj;
                cobox.setSelectedIndex(this.getIdxOfComboBox(cobox, eumValue));
            }
        } else if (obj instanceof KDDatePicker) {
            ((KDDatePicker)obj).setValue(value);
        } else if (obj instanceof KDCheckBox && value != null && value instanceof Boolean) {
            ((KDCheckBox)obj).setSelected(((Boolean)value).booleanValue());
        } else if (obj instanceof KDRadioButton && value != null && value instanceof Boolean) {
            ((KDRadioButton)obj).setSelected(((Boolean)value).booleanValue());
        } else if (obj instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)obj).setValue(value);
        } else if (obj instanceof KDSpinner) {
            ((KDSpinner)obj).setValue(value);
        }
    }

    protected void setNumber(Object obj, String value) {
        if (value == null) {
            if (obj instanceof Component) {
                this.setData((Component)obj, value);
            }
            return;
        }
        if (obj instanceof KDPromptBox) {
            ((KDPromptBox)obj).setText(value);
        } else if (obj instanceof KDTextField) {
            ((KDTextField)obj).setText(value.toString());
        } else if (obj instanceof KDComboBox) {
            if (value != null) {
                KDComboBox cobox = (KDComboBox)obj;
                cobox.setSelectedIndex(this.getIdxOfComboBox(cobox, value));
            }
        } else if (obj instanceof KDDatePicker) {
            Timestamp time = Timestamp.valueOf(value);
            ((KDDatePicker)obj).setValue((Object)time);
        } else if (obj instanceof KDCheckBox) {
            boolean isSel = Boolean.valueOf(value);
            ((KDCheckBox)obj).setSelected(isSel);
        } else if (obj instanceof KDRadioButton) {
            boolean isSel = Boolean.valueOf(value);
            ((KDRadioButton)obj).setSelected(isSel);
        } else if (obj instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)obj).setText(value);
        } else if (obj instanceof KDSpinner) {
            ((KDSpinner)obj).setValue((Object)new Integer(value));
        }
    }

    private int getIdxOfComboBox(KDComboBox cobox, String value) {
        int count = cobox.getItemCount();
        if (value == null || count <= 0) {
            return -1;
        }
        boolean isIntEnum = cobox.getItemAt(0) instanceof IntEnum;
        int intValue = -1;
        if (isIntEnum) {
            intValue = Integer.valueOf(value);
        }
        for (int idx = 0; idx < count; ++idx) {
            Object item = cobox.getItemAt(idx);
            if (item == null || !(isIntEnum ? ((IntEnum)item).getValue() == intValue : ((StringEnum)item).getValue().equals(value))) continue;
            return idx;
        }
        return -1;
    }

    protected Object getData(Object obj) {
        Object data = null;
        if (obj instanceof KDPromptBox) {
            data = ((KDPromptBox)obj).getData();
            String result = ((KDPromptBox)obj).getText().trim();
            if (result.equals("") || data != null && this.isBlank(data)) {
                return null;
            }
            data = result;
        } else if (obj instanceof KDTextField) {
            data = ((KDTextField)obj).getText();
        } else if (obj instanceof KDComboBox) {
            IntEnum intEnum = (IntEnum)((KDComboBox)obj).getSelectedItem();
            data = new Integer(intEnum.getValue());
        } else if (obj instanceof KDDatePicker) {
            data = ((KDDatePicker)obj).getTimestamp();
        } else if (obj instanceof KDCheckBox) {
            data = ((KDCheckBox)obj).isSelected();
        } else if (obj instanceof KDRadioButton) {
            data = ((KDRadioButton)obj).isSelected();
        } else if (obj instanceof BasicFormattedTextField) {
            data = ((BasicFormattedTextField)obj).getValue();
        }
        if (data != null && data.equals(this.blankValue)) {
            data = null;
        }
        return data;
    }

    protected Object getDataPK(Object obj) {
        String[] data = null;
        if (obj instanceof KDPromptBox) {
            data = ((KDPromptBox)obj).getData();
            if (data != null) {
                if (data instanceof ObjectBaseInfo) {
                    data = ((ObjectBaseInfo)data).getId().toString();
                } else if (data instanceof ObjectBaseInfo[]) {
                    ObjectBaseInfo[] objects = (ObjectBaseInfo[])data;
                    String[] result = new String[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        result[i] = objects[i].getId().toString();
                    }
                    data = result;
                }
            }
        } else {
            return this.getData(obj);
        }
        if (data != null && data.equals(this.blankValue)) {
            data = null;
        }
        return data;
    }

    public boolean isExclude() {
        return this.isExclude;
    }

    public void setExclude(boolean isExclude) {
        this.isExclude = isExclude;
    }

    public Timestamp getTimestamp(Timestamp value, int dateType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        if (dateType == 0) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 995);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public void addCustomerParam(CustomerParams cp, Object obj) {
        String name = this.getName(obj);
        this.addCustomerParam(cp, name, obj);
    }

    public void addCustomerParam(CustomerParams cp, String key, Object obj) {
        String number = this.getNumber(obj, false);
        if (key != null && number != null) {
            cp.addCustomerParam(key, number);
        }
    }

    public void addRptParams(RptParams cp, String key, Object obj) {
        String number = this.getNumber(obj);
        if (key != null && number != null) {
            cp.setObject(key, (Object)number);
        }
    }

    public void addCustomerParamWithPK(CustomerParams cp, String key, Object obj) {
        String pk = this.getPK(obj);
        if (key != null && pk != null) {
            cp.addCustomerParam(key, pk);
        }
    }

    public final Object getElementData(String id) {
        String result = null;
        result = BOSUuid.read((String)id).getType().toString();
        return result;
    }

    protected String getPK(Object obj) {
        Object data = null;
        String result = null;
        if (this.isBlank(obj)) {
            return null;
        }
        if (obj instanceof KDPromptBox && !this.isBlank(data = ((KDPromptBox)obj).getData())) {
            if (data instanceof DataBaseInfo) {
                result = ((DataBaseInfo)data).getId().toString();
            } else if (data instanceof CoreBillBaseInfo) {
                result = ((CoreBillBaseInfo)data).getId().toString();
            } else if (data instanceof Object[]) {
                result = this.getPKList((Object[])data);
            }
        }
        return result;
    }

    public void addVerifyItem(VerifyItem item) {
        if (this.verifyItems == null) {
            this.verifyItems = new ArrayList();
        }
        this.verifyItems.add(item);
    }

    protected boolean verify() {
        VerifyItem item2 = null;
        if (this.verifyItems != null) {
            for (VerifyItem item2 : this.verifyItems) {
                if (this.verify(item2)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isNull(Component component) {
        Object data = this.getData(component);
        return data == null || data instanceof Object[] && (((Object[])data).length == 0 || ((Object[])data)[0] == null) || this.getNumber(component).trim().equals("");
    }
}

