/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class RangeFilterElement
extends FilterElement {
    private Component fromComp = null;
    private Component toComp = null;
    private CompareType fromType = CompareType.GREATER_EQUALS;
    private CompareType toType = CompareType.LESS_EQUALS;
    private Object fromDefValue = null;
    private Object toDefValue = null;
    private String id2;

    public CompareType getFromType() {
        return this.fromType;
    }

    public void setFromType(CompareType fromType) {
        this.fromType = fromType;
    }

    public CompareType getToType() {
        return this.toType;
    }

    public void setToType(CompareType toType) {
        this.toType = toType;
    }

    public RangeFilterElement(String id, Component from, Component to) {
        super(id);
        this.fromComp = from;
        this.toComp = to;
    }

    public RangeFilterElement(String id, Component from, Component to, Object blankValue) {
        super(id, blankValue);
        this.fromComp = from;
        this.toComp = to;
    }

    public RangeFilterElement(String id, String id2, Component from, Component to) {
        this(id, from, to);
        this.id2 = id2;
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item1 = null;
        FilterItemInfo item2 = null;
        item1 = super.getFilterItemInfo(this.fromComp, this.fromType);
        item2 = super.getFilterItemInfo(this.toComp, this.toType);
        if (item1 != null) {
            if (this.fromComp instanceof KDDatePicker) {
                item1.setCompareValue((Object)this.getTimestamp(Timestamp.valueOf((String)item1.getCompareValue()), 0));
            }
            filterInfo.getFilterItems().add(item1);
        }
        if (item2 != null) {
            if (this.toComp instanceof KDDatePicker) {
                item2.setCompareValue((Object)this.getTimestamp(Timestamp.valueOf((String)item2.getCompareValue()), 1));
            }
            filterInfo.getFilterItems().add(item2);
        }
        if (filterInfo.getFilterItems().size() > 1) {
            filterInfo.setMaskString("(#0 and #1)");
        }
        return filterInfo.getFilterItems().size() > 0 ? filterInfo : null;
    }

    @Override
    public void clear() {
        super.clear(this.fromComp);
        super.clear(this.toComp);
        if (this.fromDefValue != null) {
            this.setData(this.fromComp, this.fromDefValue);
        }
        if (this.toDefValue != null) {
            this.setData(this.toComp, this.toDefValue);
        }
    }

    @Override
    public void setParam(Map map) {
        super.setParam(map, this.fromComp);
        super.setParam(map, this.toComp);
    }

    @Override
    protected void setData(Map paramMap, Map propMap) {
        Object type = propMap.get(this.getId());
        CompareType aType = null;
        if (type instanceof List) {
            for (int i = 0; i < ((List)type).size(); ++i) {
                aType = (CompareType)((List)type).get(i);
                if (aType.equals((Object)this.fromType)) {
                    this.setData(this.fromComp, paramMap.get(this.getName(this.fromComp)));
                    continue;
                }
                if (!aType.equals((Object)this.toType)) continue;
                this.setData(this.toComp, paramMap.get(this.getName(this.toComp)));
            }
        } else if (type != null) {
            if (type.equals(this.fromType)) {
                this.setData(this.fromComp, paramMap.get(this.getName(this.fromComp)));
            } else if (type.equals(this.toType)) {
                this.setData(this.toComp, paramMap.get(this.getName(this.toComp)));
            }
        }
    }

    @Override
    public void addCustomerParam(CustomerParams cp) {
        super.addCustomerParam(cp, this.fromComp);
        super.addCustomerParam(cp, this.toComp);
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp != null) {
            this.setNumber(this.fromComp, cp.getCustomerParam(this.getName(this.fromComp)));
            this.setNumber(this.toComp, cp.getCustomerParam(this.getName(this.toComp)));
        }
    }

    @Override
    protected void setElementData(CustomerParams cp, String key) {
    }

    @Override
    protected boolean verify(VerifyItem verifyItem) {
        if (verifyItem.getVerifyType() == VerifyType.LESS_EQUAL_TYPE) {
            String dataStart = this.getNumber(this.fromComp);
            String dataEnd = this.getNumber(this.toComp);
            if (dataStart != null && dataEnd != null && dataStart.compareTo(dataEnd) > 0) {
                this.fromComp.requestFocus();
                verifyItem.showError();
                return false;
            }
        } else if (verifyItem.getVerifyType() == VerifyType.REQUIRED_TYPE) {
            String dataStart = this.getNumber(this.fromComp);
            String dataEnd = this.getNumber(this.toComp);
            if (dataStart == null || dataEnd == null) {
                verifyItem.showError();
                if (dataStart == null) {
                    this.fromComp.requestFocus();
                } else {
                    this.toComp.requestFocus();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDefaultValue(Object value) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values.length > 0) {
                this.fromDefValue = values[0];
            }
            if (values.length > 1) {
                this.toDefValue = values[1];
            }
        }
    }

    @Override
    public void setElementValue(RptParams cp) {
        if (cp == null) {
            return;
        }
        this.setData(this.fromComp, cp.getObject(this.getId()));
        this.setData(this.toComp, cp.getObject(this.id2));
    }

    @Override
    public void addRptParams(RptParams cp) {
        super.addRptParams(cp, this.getId(), this.fromComp);
        super.addRptParams(cp, this.id2, this.toComp);
    }
}

