/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Map;

public class SingleFilterElement
extends FilterElement {
    private Component component = null;
    private CompareType compareType = CompareType.EQUALS;
    private int dateType = -1;
    private Object defValue = null;

    public Object getDefValue() {
        return this.defValue;
    }

    public void setDefValue(Object defValue) {
        this.defValue = defValue;
    }

    public int getDateType() {
        return this.dateType;
    }

    public SingleFilterElement(String id, Component component) {
        super(id);
        this.component = component;
    }

    public SingleFilterElement(String id, Component component, Object blankValue) {
        super(id, blankValue);
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = null;
        FilterItemInfo itemInfo = super.getFilterItemInfo(this.component, this.compareType);
        if (itemInfo != null) {
            filterInfo = new FilterInfo();
            if (this.dateType != -1) {
                itemInfo.setCompareValue((Object)this.getTimestamp(Timestamp.valueOf((String)itemInfo.getCompareValue()), this.dateType));
            }
            filterInfo.getFilterItems().add(itemInfo);
        }
        return filterInfo;
    }

    @Override
    public void clear() {
        if (this.defValue != null) {
            this.setData(this.component, this.defValue);
        } else {
            super.clear(this.component);
        }
    }

    @Override
    public void setParam(Map map) {
        super.setParam(map, this.component);
    }

    private void setData(Object value, CompareType type) {
        super.setData(this.component, value);
    }

    @Override
    protected void setData(Map paramMap, Map propMap) {
        CompareType type;
        if (paramMap.containsKey(this.getName(this.component)) && (type = (CompareType)propMap.get(this.getId())) != null) {
            this.setData(paramMap.get(this.getName(this.component)), type);
        }
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public void setDateType(int dateType) {
        this.dateType = dateType;
    }

    @Override
    public void addCustomerParam(CustomerParams cp) {
        if (this.component instanceof KDPromptBox && ((KDBizPromptBox)this.component).getDisplayFormatter() != null && ((KDBizPromptBox)this.component).getDisplayFormatter().toString().equalsIgnoreCase("$name$")) {
            this.addCustomerParamForId(cp, this.component);
        } else {
            super.addCustomerParam(cp, this.component);
        }
    }

    private void addCustomerParamForId(CustomerParams cp, Component obj) {
        String name = this.getName(obj);
        Object data = ((KDPromptBox)obj).getData();
        String result = null;
        if (data != null) {
            if (data instanceof DataBaseInfo) {
                result = ((DataBaseInfo)data).getId().toString();
            } else if (data instanceof CoreBillBaseInfo) {
                result = ((CoreBillBaseInfo)data).getId().toString();
            }
            if (result != null) {
                cp.addCustomerParam(name, result);
            }
        }
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam(this.getName(this.component)) != null) {
            if (this.component instanceof KDPromptBox && ((KDBizPromptBox)this.component).getDisplayFormatter() != null && ((KDBizPromptBox)this.component).getDisplayFormatter().toString().equalsIgnoreCase("$name$")) {
                this.setElementValue(this.component, cp.getCustomerParam(this.getName(this.component)));
            } else {
                this.setNumber(this.component, cp.getCustomerParam(this.getName(this.component)));
            }
        }
    }

    private void setElementValue(Component component, String value) {
        KDBizPromptBox prmtBox = (KDBizPromptBox)component;
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)value, (boolean)true);
        if (bosType == null) {
            prmtBox.setText(value);
        } else {
            DataBaseInfo[] dataBaseInfos = SCMGroupClientUtils.getDataBaseInfos(value);
            prmtBox.setValue((Object)dataBaseInfos[0]);
        }
    }

    @Override
    protected void setElementData(CustomerParams cp, String key) {
    }

    @Override
    protected boolean verify(VerifyItem verifyItem) {
        if (verifyItem.getVerifyType() == VerifyType.REQUIRED_TYPE && this.isNull(this.component)) {
            this.component.requestFocus();
            verifyItem.showError();
            return false;
        }
        return true;
    }

    @Override
    public void setDefaultValue(Object value) {
        if (value != null) {
            this.defValue = value;
        }
    }

    @Override
    public void addRptParams(RptParams cp) {
        super.addRptParams(cp, this.getId(), this.component);
    }

    @Override
    public void setElementValue(RptParams cp) {
        if (cp != null && cp.getObject(this.getId()) != null) {
            this.setData(this.component, cp.getObject(this.getId()));
        }
    }

    @Override
    protected String getNumber(Object obj) {
        Timestamp data;
        String nubmer = super.getNumber(obj);
        if (obj instanceof KDDatePicker && !this.isBlank(data = ((KDDatePicker)obj).getTimestamp()) && (this.compareType == CompareType.LESS || this.compareType == CompareType.LESS_EQUALS)) {
            nubmer = this.getTimestamp(data, 1).toString();
        }
        return nubmer;
    }
}

