/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.scm.common.rptformula.InvBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvMRPIParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialReqBatchCalculater
extends InvBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.MaterialReqBatchCalculater");
    protected String[] canNullCapitalProperties4MRBatchCalculater = new String[]{"CompanyNumber", "MainBizOrgNumber", "TransactionTypeNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber", "CostCenterOrgUnitNumber", "AdminOrgUnitNumber", "CostObjectNumber"};
    protected String[] canNullPropertiesSplit4MRBatchCalculater = new String[]{";", ";", ";", ";", ";", ";", ";", ";", ";", ";"};

    public MaterialReqBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties4MRBatchCalculater;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit4MRBatchCalculater;
    }

    @Override
    protected String getDetailTableName() {
        return "T_IM_MaterialReqBillentry";
    }

    @Override
    protected String getHeadTableName() {
        return "T_IM_MaterialReqBill";
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            int lastQueryIndex = queryIndex;
            this.params.clear();
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                Parameter param = paramArray.getParameter(queryIndex);
                InvMRPIParamBean formulaParam = new InvMRPIParamBean(param);
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    SCMReportBatchUtils.reviseInvParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                    for (int j = lastQueryIndex; j < queryIndex; ++j) {
                        FormulaValueBackfill.setException((Parameter)paramArray.getParameter(j), (Throwable)e);
                    }
                }
                ++queryIndex;
            }
            try {
                this.innerExecute();
            }
            catch (Exception e) {
                logger.error((Object)e);
                for (int j = lastQueryIndex; j < queryIndex; ++j) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(j), (Throwable)e);
                }
            }
        }
    }

    @Override
    String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4)");
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getTransactionTypecondSqlByID(group));
        sql.append(" and d.FMaterialID in ( ");
        sql.append(" select material.fid from T_BD_Material material ");
        sql.append(" inner join T_BD_MaterialGroupDetial materialGroupDetail on materialGroupDetail.FMaterialid = material.fid ");
        sql.append(" inner join T_BD_MaterialGroupStandard materialGroupStd on materialGroupStd.fid = materialGroupDetail.FMaterialGroupStandardID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup1 on materialGroup1.fid = materialGroupDetail.FMaterialGroupID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup on charindex(materialGroup.flongnumber,materialGroup1.flongnumber) = 1 ");
        sql.append(" where 1 = 1 ");
        sql.append(this.getMaterialGroupStdCondSqlByID(group));
        sql.append(this.getMaterialGroupCondSqlByID(group));
        sql.append(this.getMaterialCondSql(group));
        sql.append(" )");
        sql.append(this.getWarehouseCondSqlByID(group));
        sql.append(this.getCostCenterCondSqlByID(group));
        sql.append(this.getAdminOrgUnitCondSqlByID(group));
        if (!StringUtil.isEmpty(this.getCostObjectCondSqlByID(group))) {
            sql.append(" and d.FCostObjectID in (");
            sql.append(" select costObject1.FId from T_BD_CostObject costObject");
            sql.append(" inner join T_BD_CostObject costObject1 on costObject.FNumber = costObject1.FNumber ");
            sql.append(" where 1 = 1");
            sql.append(this.getCostObjectCondSqlByID(group));
            sql.append(StringUtil.isEmpty(this.getCompanyCondSqlByID(group)) ? "" : " and costObject1.FCOMPANYID = d.FCompanyOrgUnitID");
            sql.append(" )");
        }
        return sql.toString();
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block12: {
            CostObjectCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block11: {
                                                ctx = this.contextProvider.getServerContext();
                                                ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                                if (index != 0) break block11;
                                                CompanyOrgUnitCollection ouc2 = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                                if (ouc2 == null || ouc2.size() <= 0) break block12;
                                                int n = ouc2.size();
                                                for (int i = 0; i < n; ++i) {
                                                    CompanyOrgUnitInfo info = ouc2.get(i);
                                                    String number = info.getNumber();
                                                    String id = info.getId().toString();
                                                    map.put(number, id);
                                                }
                                                break block12;
                                            }
                                            if (index != 1) break block13;
                                            StorageOrgUnitCollection ouc3 = SCMReportBatchUtils.getStorageOrgUnitCollection(ctx, ev);
                                            if (ouc3 == null || ouc3.size() <= 0) break block12;
                                            int n = ouc3.size();
                                            for (int i = 0; i < n; ++i) {
                                                StorageOrgUnitInfo info = ouc3.get(i);
                                                String number = info.getNumber();
                                                String id = info.getId().toString();
                                                map.put(number, id);
                                            }
                                            break block12;
                                        }
                                        if (index != 2) break block14;
                                        TransactionTypeCollection ouc4 = SCMReportBatchUtils.getTransactionTypeCollection(ctx, ev);
                                        if (ouc4 == null || ouc4.size() <= 0) break block12;
                                        int n = ouc4.size();
                                        for (int i = 0; i < n; ++i) {
                                            TransactionTypeInfo info = ouc4.get(i);
                                            String number = info.getNumber();
                                            String id = info.getId().toString();
                                            map.put(number, id);
                                        }
                                        break block12;
                                    }
                                    if (index != 3) break block15;
                                    MaterialGroupStandardCollection ouc5 = SCMReportBatchUtils.getMaterialGroupStdCollection(ctx, ev);
                                    if (ouc5 == null || ouc5.size() <= 0) break block12;
                                    int n = ouc5.size();
                                    for (int i = 0; i < n; ++i) {
                                        MaterialGroupStandardInfo info = ouc5.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block12;
                                }
                                if (index != 4) break block16;
                                MaterialGroupCollection ouc6 = SCMReportBatchUtils.getMaterialGroupCollection(ctx, ev);
                                if (ouc6 == null || ouc6.size() <= 0) break block12;
                                int n = ouc6.size();
                                for (int i = 0; i < n; ++i) {
                                    MaterialGroupInfo info = ouc6.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block12;
                            }
                            if (index != 5) break block17;
                            MaterialCollection ouc7 = SCMReportBatchUtils.getMaterialCollection(ctx, ev);
                            if (ouc7 == null || ouc7.size() <= 0) break block12;
                            int n = ouc7.size();
                            for (int i = 0; i < n; ++i) {
                                MaterialInfo info = ouc7.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block12;
                        }
                        if (index != 6) break block18;
                        WarehouseCollection ouc8 = SCMReportBatchUtils.getWarehouseCollection(ctx, ev);
                        if (ouc8 == null || ouc8.size() <= 0) break block12;
                        int n = ouc8.size();
                        for (int i = 0; i < n; ++i) {
                            WarehouseInfo info = ouc8.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block12;
                    }
                    if (index != 7) break block19;
                    CostCenterOrgUnitCollection ouc9 = SCMReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev);
                    if (ouc9 == null || ouc9.size() <= 0) break block12;
                    int n = ouc9.size();
                    for (int i = 0; i < n; ++i) {
                        CostCenterOrgUnitInfo info = ouc9.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block12;
                }
                if (index != 8) break block20;
                AdminOrgUnitCollection ouc10 = SCMReportBatchUtils.getAdminOrgUnitCollection(ctx, ev);
                if (ouc10 == null || ouc10.size() <= 0) break block12;
                int n = ouc10.size();
                for (int i = 0; i < n; ++i) {
                    AdminOrgUnitInfo info = ouc10.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block12;
            }
            if (index == 9 && (ouc = SCMReportBatchUtils.getCostObjectCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    CostObjectInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    public void setSumField(InvGetParamBean invParamBean) {
        InvMRPIParamBean formulaParam = (InvMRPIParamBean)invParamBean;
        if ("FETCH_BASEQTY".equals(formulaParam.getGetDataType())) {
            this.setSumField("d.FBaseQty");
        } else if ("FETCH_ACTUALCOST".equals(formulaParam.getGetDataType())) {
            this.setSumField("d.FActualCost");
        } else {
            this.setSumField("d.FAmount");
        }
    }

    @Override
    protected List[] groupByDataType(ArrayList paramList) {
        List[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < paramList.size(); ++i) {
            InvMRPIParamBean formulaParam = (InvMRPIParamBean)paramList.get(i);
            if ("FETCH_BASEQTY".equals(formulaParam.getGetDataType())) {
                lists[0].add(formulaParam);
                continue;
            }
            if ("FETCH_ACTUALCOST".equals(formulaParam.getGetDataType())) {
                lists[1].add(formulaParam);
                continue;
            }
            lists[2].add(formulaParam);
        }
        return lists;
    }
}

