/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvSOPIBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.InvSOPIGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import java.util.HashMap;
import java.util.Set;

public class PurchaseInBatchCalculater
extends InvSOPIBatchCalculater {
    public PurchaseInBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String getDetailTableName() {
        return "T_IM_PurInWarehsEntry";
    }

    @Override
    protected String getHeadTableName() {
        return "T_IM_PurInWarehsBill";
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block4: {
            SupplierCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block3: {
                super.innerLoadNumberID(index, map, numberSet);
                ctx = this.contextProvider.getServerContext();
                ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                if (index != 2) break block3;
                PurchaseOrgUnitCollection ouc2 = SCMReportBatchUtils.getPurchaseOrgUnitCollection(ctx, ev);
                if (ouc2 == null || ouc2.size() <= 0) break block4;
                int n = ouc2.size();
                for (int i = 0; i < n; ++i) {
                    PurchaseOrgUnitInfo info = ouc2.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block4;
            }
            if (index == 6 && (ouc = SCMReportBatchUtils.getSupplierCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    SupplierInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    protected String getSOPIOrgCondSqlByID(int group) {
        if (PurchaseInBatchCalculater.checkBit(group, 2)) {
            return " and (d.FPurchaseOrgUnitID = ?)";
        }
        return "";
    }

    @Override
    protected String getCsspTable() {
        return "T_BD_Supplier";
    }

    @Override
    protected String getJoinField() {
        return "cssp.fid = h.FSupplierID";
    }

    @Override
    protected String getCSSPCondSqlByID(int group) {
        if (PurchaseInBatchCalculater.checkBit(group, 6)) {
            return " and (h.FSupplierID = ?)";
        }
        return "";
    }

    @Override
    protected String getCSSPField() {
        return "h.FSupplierID";
    }

    @Override
    protected String getCSSPDetailTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cssp.fid from " + this.getCsspTable() + " cssp ");
        sql.append(" inner join T_BD_SupplierGroupDetail SGD on SGD.FSUPPLIERID = cssp.FID ");
        sql.append(" inner join T_BD_CSSPGroupStandard csspGroupStd on csspGroupStd.fid = SGD.FSUPPLIERGROUPSTANDARDID");
        sql.append(" inner join T_BD_CSSPGroup csspGroup1 on csspGroup1.fid = SGD.FSUPPLIERGROUPID ");
        sql.append(" inner join T_BD_CSSPGroup csspGroup on charindex(csspGroup.flongnumber,csspGroup1.flongnumber) = 1 ");
        return sql.toString();
    }

    @Override
    public InvGetParamBean getInvGetParamBean(Parameter param) {
        return new InvSOPIGetParamBean(param);
    }
}

