/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.scm.common.rptformula.SCMBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SCMGetAmountParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SCMAmountBatchCalculater
extends SCMBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.SCMAmountBatchCalculater");
    private static final String[] canNullCapitalProperties = new String[]{"MainBizOrgNumber", "CompanyNumber", "CurrencyNumber", "MaterialNumber"};
    private static final String[] canNullPropertiesSplit = new String[]{";", ";", ";", ";"};

    public SCMAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            this.params.clear();
            int lastQueryIndex = queryIndex;
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                Parameter param = paramArray.getParameter(queryIndex);
                SCMGetAmountParamBean formulaParam = new SCMGetAmountParamBean(param);
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    SCMReportBatchUtils.reviseAmountParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                }
                ++queryIndex;
            }
            try {
                this.innerExecute();
            }
            catch (Exception e) {
                logger.error((Object)e);
                for (int i2 = lastQueryIndex; i2 < queryIndex; ++i2) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(i2), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return canNullCapitalProperties;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return canNullPropertiesSplit;
    }

    @Override
    protected String getSql(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" left join T_ORG_Company company on company.fid=h.FCompanyOrgUnitID");
        sql.append(" left join T_BD_Currency currency on currency.fid=h.FCurrencyID");
        sql.append(" left join T_BD_Material material on material.fid=d.FMaterialID");
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4 or h.FBaseStatus=6 or h.FBaseStatus=7)");
        sql.append(this.getMainOrgCondSql(group));
        sql.append(this.getCompanyCondSql(group));
        sql.append(this.getCurrencyCondSql(group));
        sql.append(this.getMaterialCondSql(group));
        return sql.toString();
    }

    protected String getSumField() {
        return "d.FAmount";
    }

    protected abstract String getHeadTableName();

    protected abstract String getDetailTableName();

    protected String getMainOrgTableName() {
        return "T_ORG_Sale";
    }

    protected String getMainOrgField() {
        return "h.FSaleOrgUnitID";
    }

    protected String getMainOrgCondSql(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 0)) {
            return " and (mainOrg.FNumber = ?)";
        }
        return "";
    }

    protected String getCompanyCondSql(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 1)) {
            return " and (company.FNumber = ?)";
        }
        return "";
    }

    protected String getCurrencyCondSql(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 2)) {
            return " and (currency.FNumber = ?)";
        }
        return "";
    }

    protected String getMaterialCondSql(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 3)) {
            return " and (material.FNumber = ?)";
        }
        return "";
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block6: {
            MaterialCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block8: {
                block7: {
                    block5: {
                        ctx = this.contextProvider.getServerContext();
                        ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                        if (index != 0) break block5;
                        SaleOrgUnitCollection ouc2 = SCMReportBatchUtils.getSaleOrgUnitCollection(ctx, ev);
                        if (ouc2 == null || ouc2.size() <= 0) break block6;
                        int n = ouc2.size();
                        for (int i = 0; i < n; ++i) {
                            SaleOrgUnitInfo info = ouc2.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block6;
                    }
                    if (index != 1) break block7;
                    CompanyOrgUnitCollection ouc3 = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                    if (ouc3 == null || ouc3.size() <= 0) break block6;
                    int n = ouc3.size();
                    for (int i = 0; i < n; ++i) {
                        CompanyOrgUnitInfo info = ouc3.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block6;
                }
                if (index != 2) break block8;
                CurrencyCollection ouc4 = SCMReportBatchUtils.getCurrencyCollection(ctx, ev);
                if (ouc4 == null || ouc4.size() <= 0) break block6;
                int n = ouc4.size();
                for (int i = 0; i < n; ++i) {
                    CurrencyInfo info = ouc4.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block6;
            }
            if (index == 3 && (ouc = SCMReportBatchUtils.getMaterialCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    MaterialInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    protected String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4 or h.FBaseStatus=6 or h.FBaseStatus=7)");
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getCurrencyCondSqlByID(group));
        sql.append(this.getMaterialCondSqlByID(group));
        return sql.toString();
    }

    protected String getMainOrgCondSqlByID(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 0)) {
            return " and (h.FSaleOrgUnitID = ?)";
        }
        return "";
    }

    protected String getCompanyCondSqlByID(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 1)) {
            return " and (h.FCompanyOrgUnitID = ?)";
        }
        return "";
    }

    protected String getCurrencyCondSqlByID(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 2)) {
            return " and (h.FCurrencyID = ?)";
        }
        return "";
    }

    protected String getMaterialCondSqlByID(int group) {
        if (SCMAmountBatchCalculater.checkBit(group, 3)) {
            return " and (d.FMaterialID = ?)";
        }
        return "";
    }
}

