/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.scm.common.rptformula.InvBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SCMGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class SCMBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.SCMBatchCalculater");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final int BATCH_MAX_SIZE = 3000;
    protected ICalculateContextProvider contextProvider = null;
    private boolean isNeedCheckPermission = true;
    private HashMap permissionFullOrgs = null;
    protected ArrayList params = new ArrayList();
    protected ArrayList[] groupedParams = null;
    protected HashMap methods = new HashMap();
    protected HashMap numberIDCache = new HashMap();
    protected Connection conn = null;

    public ICalculateContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public SCMBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public abstract void execute(SortedParameterArray var1);

    public void initResource() {
        try {
            this.conn = EJBFactory.getConnection((Context)this.contextProvider.getServerContext());
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        this.initPermission();
    }

    public void clearResource() {
        if (this.conn != null) {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    private void initPermission() {
        VariableEntry ve;
        ReportVariables rvs = this.contextProvider.getReportVariables();
        if (rvs != null && (ve = rvs.get("Check_Permissioin", null)) != null) {
            this.isNeedCheckPermission = Boolean.valueOf(ve.getValue());
        }
    }

    public HashMap getUserPermissionOrgs() throws Exception {
        if (this.permissionFullOrgs != null) {
            return this.permissionFullOrgs;
        }
        Context ctx = this.contextProvider.getServerContext();
        Map hasPermissionOrgs = SCMReportBatchUtils.getRptAuthorizedCompany(ctx);
        this.permissionFullOrgs = new HashMap();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("isBizUnit"));
        ev.getSelector().add(new SelectorItemInfo("accountPeriodType"));
        ev.getSelector().add(new SelectorItemInfo("reportConvertMode"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.precision"));
        ev = SCMReportBatchUtils.getMultiEqualEntityView(ev, "id", hasPermissionOrgs.keySet());
        CompanyOrgUnitCollection ouc = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
        int n = ouc.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo info = ouc.get(i);
            String number = info.getNumber();
            this.permissionFullOrgs.put(number, info);
        }
        return this.permissionFullOrgs;
    }

    protected abstract String[] getCanNullCapitalProperty();

    protected abstract String[] getCanNullPropertySplit();

    public int addParam(SCMGetParamBean paramBean) {
        int number = 0;
        try {
            String companyNumber = paramBean.getCompanyNumber().trim();
            StringTokenizer st = new StringTokenizer(companyNumber, ";");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken().trim();
                if (!this.isNeedCheckPermission || this.getUserPermissionOrgs().containsKey(tmp)) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission")});
            }
            this.processCompanyNumber(paramBean, this.getUserPermissionOrgs());
            number = this.parseParamBean(paramBean, 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
            paramBean.getBackFiller().setException((Throwable)e);
        }
        return number;
    }

    protected String processCompanyNumber(SCMGetParamBean paramBean, Map map) {
        HashSet set = new HashSet();
        String companyNumber = paramBean.getCompanyNumber().trim();
        StringTokenizer st = new StringTokenizer(companyNumber, ";");
        while (st.hasMoreTokens()) {
            String number = st.nextToken().trim();
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)map.get(number);
            set.addAll(this.findCompanyBizChildrenNumber(map, info));
        }
        String newCompanyNumber = SCMReportBatchUtils.convertToString(set, ";");
        paramBean.setCompanyNumber(newCompanyNumber);
        return companyNumber;
    }

    protected HashSet findCompanyBizChildrenNumber(Map map, CompanyOrgUnitInfo info) {
        HashSet<String> set = new HashSet<String>();
        String longNumber = info.getLongNumber();
        if (!info.isIsBizUnit()) {
            for (Map.Entry entry : map.entrySet()) {
                CompanyOrgUnitInfo tmpInfo = (CompanyOrgUnitInfo)entry.getValue();
                if (!tmpInfo.isIsBizUnit() || !tmpInfo.getLongNumber().startsWith(longNumber)) continue;
                set.add(tmpInfo.getNumber());
            }
        } else {
            set.add(info.getNumber());
        }
        return set;
    }

    protected int parseParamBean(SCMGetParamBean paramBean, int level) {
        int number = 0;
        String[] properties = this.getCanNullCapitalProperty();
        String[] splits = this.getCanNullPropertySplit();
        if (properties != null && properties.length > 0 && splits != null && splits.length > 0 && properties.length == splits.length && level < properties.length) {
            String propertyName = properties[level];
            String split = splits[level];
            String propertyLongValue = (String)this.invokeGetterMethod(paramBean, propertyName);
            String[] propertyValues = null;
            propertyValues = propertyLongValue == null || propertyLongValue.length() == 0 || split == null || split.length() == 0 || propertyLongValue.indexOf(split) < 0 ? new String[]{propertyLongValue} : propertyLongValue.split(split);
            if (propertyName.equals("MaterialNumber") && this instanceof InvBatchCalculater) {
                SCMGetParamBean tmpParamBean = (SCMGetParamBean)paramBean.clone();
                this.invokeSetterMethod(tmpParamBean, propertyName, propertyLongValue);
                number += this.parseParamBean(tmpParamBean, level + 1);
            } else {
                int n = propertyValues.length;
                for (int i = 0; i < n; ++i) {
                    SCMGetParamBean tmpParamBean = (SCMGetParamBean)paramBean.clone();
                    String propertyValue = propertyValues[i].trim();
                    this.invokeSetterMethod(tmpParamBean, propertyName, propertyValue);
                    number += this.parseParamBean(tmpParamBean, level + 1);
                }
            }
        } else {
            this.params.add(paramBean);
            number = 1;
        }
        return number;
    }

    private Method getGetterMethod(Class clazz, String methodName) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, new Class[0]);
            this.methods.put(methodName, method);
        }
        return method;
    }

    private Method getSetterMethod(Class clazz, String methodName, Class parameterClazz) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, parameterClazz);
            this.methods.put(methodName, method);
        }
        return method;
    }

    protected Object invokeGetterMethod(Object paramBean, String propertyName) {
        String object = null;
        try {
            Class<?> clazz = paramBean.getClass();
            String methodName = "get" + propertyName;
            Method method = this.getGetterMethod(clazz, methodName);
            object = (String)method.invoke(paramBean, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected Object invokeSetterMethod(Object paramBean, String propertyName, String propertyValue) {
        Object object = null;
        try {
            Class<?> clazz = paramBean.getClass();
            String methodName = "set" + propertyName;
            Method method = this.getSetterMethod(clazz, methodName, String.class);
            object = method.invoke(paramBean, propertyValue);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected void groupByParam() {
        String[] properties = this.getCanNullCapitalProperty();
        if (properties != null && properties.length > 0) {
            this.groupedParams = new ArrayList[1 << properties.length];
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                SCMGetParamBean paramBean = (SCMGetParamBean)this.params.get(i);
                int group = 0;
                int m = properties.length;
                for (int j = 0; j < m; ++j) {
                    String propertyName = properties[j];
                    String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                    if (StringUtils.isEmpty((String)propertyValue)) continue;
                    group |= 1 << j;
                    this.initLoadNumberID(propertyName, propertyValue);
                }
                if (this.groupedParams[group] == null) {
                    this.groupedParams[group] = new ArrayList();
                }
                this.groupedParams[group].add(paramBean);
            }
        } else {
            this.groupedParams = new ArrayList[1];
            this.groupedParams[0] = new ArrayList(this.params);
        }
    }

    protected void initLoadNumberID(String propertyName, String propertyValue) {
        HashMap map = null;
        if (this.numberIDCache.containsKey(propertyName)) {
            map = (HashMap)this.numberIDCache.get(propertyName);
        } else {
            map = new HashMap();
            this.numberIDCache.put(propertyName, map);
        }
        if (!map.containsKey(propertyValue)) {
            map.put(propertyValue, null);
        }
    }

    protected void innerExecute() throws Exception {
        String sql = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        this.groupByParam();
        this.loadNumberIDCacheData();
        int count = this.groupedParams.length;
        for (int i = 0; i < count; ++i) {
            ArrayList paramList = this.groupedParams[i];
            if (paramList == null || paramList.size() <= 0) continue;
            int m = paramList.size();
            for (int j = 0; j < m; ++j) {
                SCMGetParamBean paramBean = (SCMGetParamBean)paramList.get(j);
                try {
                    this.setBizTypeByParam(paramBean);
                    sql = this.getSqlByID(i);
                    pstmt = this.conn.prepareStatement(sql);
                    this.setSqlParamsByID(pstmt, paramBean, i);
                    rs = pstmt.executeQuery();
                    BigDecimal value = ZERO;
                    while (rs.next()) {
                        BigDecimal tmp = rs.getBigDecimal(this.getReturnField());
                        if (tmp == null) continue;
                        value = value.add(tmp);
                    }
                    paramBean.getBackFiller().setValue((Object)value);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    paramBean.getBackFiller().setException((Throwable)e);
                    SQLUtils.cleanup(rs, (Statement)pstmt);
                }
            }
        }
    }

    protected void setBizTypeByParam(SCMGetParamBean paramBean) {
    }

    protected void loadNumberIDCacheData() throws Exception {
        String[] properties = this.getCanNullCapitalProperty();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                HashMap map;
                if ("MaterialNumber".equals(properties[j]) && this instanceof InvBatchCalculater || (map = (HashMap)this.numberIDCache.get(properties[j])) == null || map.size() <= 0) continue;
                Iterator itr = map.entrySet().iterator();
                HashSet numberSet = new HashSet();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object value = entry.getValue();
                    if (value != null) continue;
                    Object key = entry.getKey();
                    numberSet.add(key);
                }
                if (numberSet.size() <= 0) continue;
                this.innerLoadNumberID(j, map, numberSet);
            }
        }
    }

    protected abstract void innerLoadNumberID(int var1, HashMap var2, Set var3) throws Exception;

    protected abstract String getSql(int var1);

    abstract String getSqlByID(int var1);

    protected void setSqlParams(PreparedStatement pstmt, SCMGetParamBean paramBean, int group) throws SQLException {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getCanNullCapitalProperty();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!SCMBatchCalculater.checkBit(group, j)) continue;
                String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                pstmt.setString(paramIndex++, propertyValue);
            }
        }
    }

    protected void setSqlParamsByID(PreparedStatement pstmt, SCMGetParamBean paramBean, int group) throws SQLException {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getCanNullCapitalProperty();
        if (properties != null && properties.length > 0) {
            String propertyValue = "";
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!SCMBatchCalculater.checkBit(group, j)) continue;
                Object value = this.invokeGetterMethod(paramBean, propertyName);
                propertyValue = (String)value;
                HashMap map = (HashMap)this.numberIDCache.get(propertyName);
                String id = (String)map.get(propertyValue);
                if ("MaterialGroupNumber".equals(propertyName) || "CsspGroupNumber".equals(propertyName)) {
                    id = propertyValue;
                }
                if ("MaterialNumber".equals(propertyName) && this instanceof InvBatchCalculater) {
                    String[] materialNumbers = propertyValue.split(";");
                    for (int i = 0; i < materialNumbers.length; ++i) {
                        pstmt.setString(paramIndex++, materialNumbers[i].trim());
                    }
                    continue;
                }
                pstmt.setString(paramIndex++, id);
            }
        }
    }

    protected int setFixedSqlParams(PreparedStatement pstmt, SCMGetParamBean paramBean, int paramIndex) throws SQLException {
        pstmt.setTimestamp(paramIndex++, paramBean.getStartTime());
        pstmt.setTimestamp(paramIndex++, paramBean.getEndTime());
        return paramIndex;
    }

    protected String getReturnField() {
        return "FValue";
    }

    public static final boolean checkBit(int i, int index) {
        if (index < 0) {
            return false;
        }
        return (i >> index & 1) == 1;
    }
}

