/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.rptformula.CalGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMGetAmountParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMGetQtyParamBean;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SCMReportBatchUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils");
    private static final String CURRENCY = "Currency";
    private static final String END_PERIOD = "EndPeriod";
    private static final String START_PERIOD = "StartPeriod";
    private static final String END_YEAR = "EndYear";
    private static final String START_YEAR = "StartYear";

    private SCMReportBatchUtils() {
    }

    public static void reviseQtyParameters(Context ctx, SCMGetQtyParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String companyNumber = paramBean.getCompanyNumber();
        int startYear = paramBean.getStartYear();
        int startPeriod = paramBean.getStartPeriod();
        int endYear = paramBean.getEndYear();
        int endPeriod = paramBean.getEndPeriod();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        String _companyID = (String)adapter.getReportProperty("Company.ID");
        Integer _periodType = (Integer)adapter.getReportProperty("PeriodType");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        int maxPeriodNumber = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)startYear, (String)_companyID);
        boolean isSupportAdjustData = false;
        Integer b = (Integer)adapter.getReportProperty("SupportAdjustPeriodData");
        if (b != null && b == 1) {
            isSupportAdjustData = true;
        }
        if (StringUtils.isEmpty((String)paramBean.getCompanyNumber()) && _companyNumber != null) {
            if (_sourceType == null) {
                companyNumber = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        companyNumber = _companyNumber;
                    }
                }
            }
        }
        if (startYear <= 0) {
            if (reportVariables != null) {
                startYear = reportVariables.getIntValue(START_YEAR, sheetName, 0) + startYear;
            }
            if (startYear <= 0) {
                startYear = (Integer)adapter.getReportProperty("Report.Year") + startYear;
            }
        }
        if (startPeriod <= 0) {
            if (reportVariables != null) {
                startPeriod = reportVariables.getIntValue(START_PERIOD, sheetName, 0) + startPeriod;
            }
            if (startPeriod <= 0) {
                startPeriod = (Integer)adapter.getReportProperty("Report.Period") + startPeriod;
            }
        }
        if (endYear <= 0) {
            if (reportVariables != null) {
                endYear = reportVariables.getIntValue(END_YEAR, sheetName, 0) + endYear;
            }
            if (endYear <= 0) {
                endYear = (Integer)adapter.getReportProperty("Report.Year") + endYear;
            }
        }
        if (endPeriod <= 0) {
            if (reportVariables != null) {
                endPeriod = reportVariables.getIntValue(END_PERIOD, sheetName, 0) + endPeriod;
            }
            if (endPeriod <= 0) {
                endPeriod = (Integer)adapter.getReportProperty("Report.Period") + endPeriod;
            }
        }
        if (isSupportAdjustData && _periodType == 3 && endPeriod == 12) {
            endPeriod = maxPeriodNumber;
        }
        if (_periodType != null) {
            Date periodFirstDate = com.kingdee.eas.base.core.util.PeriodUtils.getPeriodFirstDate((int)startYear, (int)startPeriod, (int)SCMReportBatchUtils.getPeriodConstant(RptPeriodTypeEnum.getEnum((int)_periodType)));
            startTime = new Timestamp(periodFirstDate.getTime());
            Date periodLastDate = com.kingdee.eas.base.core.util.PeriodUtils.getPeriodLastDate((int)endYear, (int)endPeriod, (int)SCMReportBatchUtils.getPeriodConstant(RptPeriodTypeEnum.getEnum((int)_periodType)));
            endTime = new Timestamp(SCMReportBatchUtils.getEndDate(periodLastDate).getTime());
        }
        paramBean.setCompanyNumber(companyNumber);
        paramBean.setStartYear(startYear);
        paramBean.setStartPeriod(startPeriod);
        paramBean.setEndYear(endYear);
        paramBean.setEndPeriod(endPeriod);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static void reviseAmountParameters(Context ctx, SCMGetAmountParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String companyNumber = paramBean.getCompanyNumber();
        String currencyNumber = paramBean.getCurrencyNumber();
        int startYear = paramBean.getStartYear();
        int startPeriod = paramBean.getStartPeriod();
        int endYear = paramBean.getEndYear();
        int endPeriod = paramBean.getEndPeriod();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        String _companyID = (String)adapter.getReportProperty("Company.ID");
        Integer _periodType = (Integer)adapter.getReportProperty("PeriodType");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        int maxPeriodNumber = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)startYear, (String)_companyID);
        boolean isSupportAdjustData = false;
        Integer b = (Integer)adapter.getReportProperty("SupportAdjustPeriodData");
        if (b != null && b == 1) {
            isSupportAdjustData = true;
        }
        if (StringUtils.isEmpty((String)companyNumber) && _companyNumber != null) {
            if (_sourceType == null) {
                companyNumber = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        companyNumber = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currencyNumber)) {
            if (reportVariables != null) {
                currencyNumber = reportVariables.getStringValue(CURRENCY, sheetName);
            }
            if (StringUtils.isEmpty((String)currencyNumber)) {
                currencyNumber = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        if (startYear <= 0) {
            if (reportVariables != null) {
                startYear = reportVariables.getIntValue(START_YEAR, sheetName, 0) + startYear;
            }
            if (startYear <= 0) {
                startYear = (Integer)adapter.getReportProperty("Report.Year") + startYear;
            }
        }
        if (startPeriod <= 0) {
            if (reportVariables != null) {
                startPeriod = reportVariables.getIntValue(START_PERIOD, sheetName, 0) + startPeriod;
            }
            if (startPeriod <= 0) {
                startPeriod = (Integer)adapter.getReportProperty("Report.Period") + startPeriod;
            }
        }
        if (endYear <= 0) {
            if (reportVariables != null) {
                endYear = reportVariables.getIntValue(END_YEAR, sheetName, 0) + endYear;
            }
            if (endYear <= 0) {
                endYear = (Integer)adapter.getReportProperty("Report.Year") + endYear;
            }
        }
        if (endPeriod <= 0) {
            if (reportVariables != null) {
                endPeriod = reportVariables.getIntValue(END_PERIOD, sheetName, 0) + endPeriod;
            }
            if (endPeriod <= 0) {
                endPeriod = (Integer)adapter.getReportProperty("Report.Period") + endPeriod;
            }
        }
        if (isSupportAdjustData && _periodType == 3 && endPeriod == 12) {
            endPeriod = maxPeriodNumber;
        }
        if (_periodType != null) {
            Date periodFirstDate = com.kingdee.eas.base.core.util.PeriodUtils.getPeriodFirstDate((int)startYear, (int)startPeriod, (int)SCMReportBatchUtils.getPeriodConstant(RptPeriodTypeEnum.getEnum((int)_periodType)));
            startTime = new Timestamp(periodFirstDate.getTime());
            Date periodLastDate = com.kingdee.eas.base.core.util.PeriodUtils.getPeriodLastDate((int)endYear, (int)endPeriod, (int)SCMReportBatchUtils.getPeriodConstant(RptPeriodTypeEnum.getEnum((int)_periodType)));
            endTime = new Timestamp(SCMReportBatchUtils.getEndDate(periodLastDate).getTime());
        }
        paramBean.setCompanyNumber(companyNumber);
        paramBean.setCurrencyNumber(currencyNumber);
        paramBean.setStartYear(startYear);
        paramBean.setStartPeriod(startPeriod);
        paramBean.setEndYear(endYear);
        paramBean.setEndPeriod(endPeriod);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static void reviseInvParameters(Context ctx, InvGetParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String companyNumber = paramBean.getCompanyNumber();
        String currencyNumber = paramBean.getCurrencyNumber();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                endTime = SCMClientUtils.getServerDate();
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                if (KsqlUtil.isSQLServer(ctx)) {
                    endTime.setNanos(995);
                } else {
                    endTime.setNanos(999999999);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)companyNumber) && _companyNumber != null) {
            if (_sourceType == null) {
                companyNumber = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        companyNumber = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currencyNumber)) {
            if (reportVariables != null) {
                currencyNumber = reportVariables.getStringValue(CURRENCY, sheetName);
            }
            if (StringUtils.isEmpty((String)currencyNumber)) {
                currencyNumber = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompanyNumber(companyNumber);
        paramBean.setCurrencyNumber(currencyNumber);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static Date getBeginDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String convertToString(Collection collection, String split) {
        StringBuffer sb = new StringBuffer();
        if (split == null) {
            split = ",";
        }
        Iterator itr = collection.iterator();
        boolean hasValidValue = false;
        while (itr.hasNext()) {
            if (hasValidValue) {
                sb.append(split);
            }
            sb.append(itr.next());
            hasValidValue = true;
        }
        return sb.toString();
    }

    public static EntityViewInfo getMultiEqualEntityView(String fieldName, Set valueSet) {
        return SCMReportBatchUtils.getMultiEqualEntityView(null, fieldName, valueSet);
    }

    public static EntityViewInfo getMultiEqualEntityView(EntityViewInfo ev, String fieldName, Set valueSet) {
        if (ev == null) {
            ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
        } else if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        if (!StringUtils.isEmpty((String)fieldName) && valueSet != null && valueSet.size() > 0) {
            fieldName = fieldName.trim();
            StringBuffer maskString = new StringBuffer();
            int index = 0;
            boolean hasValidFieldValue = false;
            Iterator it = valueSet.iterator();
            while (it.hasNext()) {
                String fieldValue = it.next().toString().trim();
                if (StringUtils.isEmpty((String)fieldValue)) continue;
                ev.getFilter().getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
                if (!hasValidFieldValue) {
                    maskString.append("#" + index++);
                } else {
                    maskString.append(" or #" + index++);
                }
                hasValidFieldValue = true;
            }
            if (hasValidFieldValue) {
                ev.getFilter().setMaskString(maskString.toString());
            }
        }
        return ev;
    }

    public static String getMultiEqualCondSql(String fieldName, String fieldLongValue) {
        return SCMReportBatchUtils.getMultiEqualCondSql(fieldName, fieldLongValue, ";");
    }

    public static String getMultiEqualCondSql(String fieldName, String fieldLongValue, String splitString) {
        if (!StringUtils.isEmpty((String)fieldName) && !StringUtils.isEmpty((String)fieldLongValue)) {
            fieldName = fieldName.trim();
            fieldLongValue = fieldLongValue.trim();
            StringBuffer sql = new StringBuffer();
            if (splitString == null || splitString.length() == 0 || fieldLongValue.indexOf(splitString) < 0) {
                sql.append(" and (").append(fieldName).append(" = '").append(fieldLongValue).append("')");
            } else {
                String[] fieldValues = fieldLongValue.split(splitString);
                sql.append(" and (");
                boolean hasValidFieldValue = false;
                int n = fieldValues.length;
                for (int i = 0; i < n; ++i) {
                    String fieldValue = fieldValues[i].trim();
                    if (StringUtils.isEmpty((String)fieldValue)) continue;
                    if (!hasValidFieldValue) {
                        sql.append("(").append(fieldName).append(" = '").append(fieldValue).append("')");
                    } else {
                        sql.append(" or (").append(fieldName).append(" = '").append(fieldValue).append("')");
                    }
                    hasValidFieldValue = true;
                }
                sql.append(")");
            }
            return sql.toString();
        }
        return "";
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICompanyOrgUnit company = null;
        company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return company.getCompanyOrgUnitCollection(ev);
    }

    public static CurrencyCollection getCurrencyCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICurrency currency = null;
        currency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        return currency.getCurrencyCollection(ev);
    }

    public static PurchaseOrgUnitCollection getPurchaseOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IPurchaseOrgUnit purchaseOrgUnit = null;
        purchaseOrgUnit = ctx == null ? PurchaseOrgUnitFactory.getRemoteInstance() : PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
        return purchaseOrgUnit.getPurchaseOrgUnitCollection(ev);
    }

    public static CSSPGroupStandardCollection getCSSPGroupStdCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICSSPGroupStandard csspGroupStd = null;
        csspGroupStd = ctx == null ? CSSPGroupStandardFactory.getRemoteInstance() : CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
        return csspGroupStd.getCSSPGroupStandardCollection(ev);
    }

    public static CSSPGroupCollection getCSSPGroupCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICSSPGroup csspGroup = null;
        csspGroup = ctx == null ? CSSPGroupFactory.getRemoteInstance() : CSSPGroupFactory.getLocalInstance((Context)ctx);
        return csspGroup.getCSSPGroupCollection(ev);
    }

    public static SaleOrgUnitCollection getSaleOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISaleOrgUnit saleOrgUnit = null;
        saleOrgUnit = ctx == null ? SaleOrgUnitFactory.getRemoteInstance() : SaleOrgUnitFactory.getLocalInstance((Context)ctx);
        return saleOrgUnit.getSaleOrgUnitCollection(ev);
    }

    public static StorageOrgUnitCollection getStorageOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IStorageOrgUnit storageOrgUnit = null;
        storageOrgUnit = ctx == null ? StorageOrgUnitFactory.getRemoteInstance() : StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        return storageOrgUnit.getStorageOrgUnitCollection(ev);
    }

    public static MaterialCollection getMaterialCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IMaterial material = null;
        material = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        return material.getMaterialCollection(ev);
    }

    public static CustomerCollection getCustomerCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICustomer customer = null;
        customer = ctx == null ? CustomerFactory.getRemoteInstance() : CustomerFactory.getLocalInstance((Context)ctx);
        return customer.getCustomerCollection(ev);
    }

    public static SupplierCollection getSupplierCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISupplier supplier = null;
        supplier = ctx == null ? SupplierFactory.getRemoteInstance() : SupplierFactory.getLocalInstance((Context)ctx);
        return supplier.getSupplierCollection(ev);
    }

    public static TransactionTypeCollection getTransactionTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ITransactionType transactionType = null;
        transactionType = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)ctx);
        return transactionType.getTransactionTypeCollection(ev);
    }

    public static MaterialGroupStandardCollection getMaterialGroupStdCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IMaterialGroupStandard materialGroupStd = null;
        materialGroupStd = ctx == null ? MaterialGroupStandardFactory.getRemoteInstance() : MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
        return materialGroupStd.getMaterialGroupStandardCollection(ev);
    }

    public static MaterialGroupCollection getMaterialGroupCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IMaterialGroup materialGroup = null;
        materialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
        return materialGroup.getMaterialGroupCollection(ev);
    }

    public static WarehouseCollection getWarehouseCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IWarehouse warehouse = null;
        warehouse = ctx == null ? WarehouseFactory.getRemoteInstance() : WarehouseFactory.getLocalInstance((Context)ctx);
        return warehouse.getWarehouseCollection(ev);
    }

    public static Map getRptAuthorizedCompany(Context ctx) throws BOSException, EASBizException {
        IPermission permission = null;
        IObjectPK userPK = null;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            userPK = ctx.getCaller();
        }
        Map authorizedCompany = permission.getAuthorizedOrgs(userPK, OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        return authorizedCompany;
    }

    public static Timestamp convertToTime(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        try {
            if (dateStr != null && dateStr.length() != 0) {
                String[] prop = dateStr.split("-");
                for (int i = 0; i < 3; ++i) {
                    if (i == 0) {
                        calendar.set(1, Integer.parseInt(prop[i]));
                        continue;
                    }
                    if (i == 1) {
                        calendar.set(2, Integer.parseInt(prop[i]) - 1);
                        continue;
                    }
                    if (i != 2) continue;
                    calendar.set(5, Integer.parseInt(prop[i]));
                }
            }
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"15_SCMReportBatchUtils"), (Throwable)e);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static void main(String[] args) {
        String s = "1998-1-31";
    }

    public static void reviseInvParameters(Context ctx, CalGetParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String companyNumber = paramBean.getCompanyNumber();
        String currencyNumber = paramBean.getCurrencyNumber();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                endTime = SCMClientUtils.getServerDate();
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                if (KsqlUtil.isSQLServer(ctx)) {
                    endTime.setNanos(995);
                } else {
                    endTime.setNanos(999999999);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static int getPeriodConstant(RptPeriodTypeEnum periodType) {
        int result = 0;
        if (periodType.equals((Object)RptPeriodTypeEnum.DAILY)) {
            result = 1;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            result = 3;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            result = 4;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            result = 5;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
            result = 2;
        } else if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            result = 6;
        }
        return result;
    }

    public static CostCenterOrgUnitCollection getCostCenterOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICostCenterOrgUnit costCenterOrgUnit = null;
        costCenterOrgUnit = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance() : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        return costCenterOrgUnit.getCostCenterOrgUnitCollection(ev);
    }

    public static AdminOrgUnitCollection getAdminOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IAdminOrgUnit adminOrgUnit = null;
        adminOrgUnit = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        return adminOrgUnit.getAdminOrgUnitCollection(ev);
    }

    public static CostObjectCollection getCostObjectCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICostObject iCostObject = null;
        iCostObject = ctx == null ? CostObjectFactory.getRemoteInstance() : CostObjectFactory.getLocalInstance((Context)ctx);
        return iCostObject.getCostObjectCollection(ev);
    }
}

