/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.scm.common.RptFormulaInvSOFetchDataTypeEnum;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvSOPIBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.InvSOPIGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvSaleIssueParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleOutBatchCalculater
extends InvSOPIBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.SaleOutBatchCalculater");
    protected String[] canNullCapitalProperties = new String[]{"CompanyNumber", "MainBizOrgNumber", "SaleOrgNumber", "TransactionTypeNumber", "CsspGroupStdNumber", "CsspGroupNumber", "CsspNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber", "CurrencyNumber", "CostCenterOrgUnitNumber"};
    protected String[] canNullPropertiesSplit = new String[]{";", ";", ";", ";", ";", ";", ";", ";", ";", ";", ";", ";", ";"};

    public SaleOutBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String getDetailTableName() {
        return "T_IM_SaleIssueEntry";
    }

    @Override
    protected String getHeadTableName() {
        return "T_IM_SaleIssueBill";
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit;
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block5: {
            CostCenterOrgUnitCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block6: {
                block4: {
                    super.innerLoadNumberID(index, map, numberSet);
                    ctx = this.contextProvider.getServerContext();
                    ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                    if (index != 2) break block4;
                    SaleOrgUnitCollection ouc2 = SCMReportBatchUtils.getSaleOrgUnitCollection(ctx, ev);
                    if (ouc2 == null || ouc2.size() <= 0) break block5;
                    int n = ouc2.size();
                    for (int i = 0; i < n; ++i) {
                        SaleOrgUnitInfo info = ouc2.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block5;
                }
                if (index != 6) break block6;
                CustomerCollection ouc3 = SCMReportBatchUtils.getCustomerCollection(ctx, ev);
                if (ouc3 == null || ouc3.size() <= 0) break block5;
                int n = ouc3.size();
                for (int i = 0; i < n; ++i) {
                    CustomerInfo info = ouc3.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block5;
            }
            if (index == 12 && (ouc = SCMReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    CostCenterOrgUnitInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    protected String getSOPIOrgCondSqlByID(int group) {
        if (SaleOutBatchCalculater.checkBit(group, 2)) {
            return " and (d.FSaleOrgUnitID = ?)";
        }
        return "";
    }

    @Override
    protected String getCsspTable() {
        return "T_BD_Customer";
    }

    @Override
    protected String getJoinField() {
        return "cssp.fid = h.FCustomerID";
    }

    @Override
    protected String getCSSPCondSqlByID(int group) {
        if (SaleOutBatchCalculater.checkBit(group, 6)) {
            return " and (h.FCustomerID = ?)";
        }
        return "";
    }

    @Override
    protected String getCSSPField() {
        return "h.FCustomerID";
    }

    @Override
    protected String getCSSPDetailTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cssp.fid from " + this.getCsspTable() + " cssp ");
        sql.append(" inner join T_BD_CustomerGroupDetail CGD on CGD.FCUSTOMERID = cssp.FID ");
        sql.append(" inner join T_BD_CSSPGroupStandard csspGroupStd on csspGroupStd.fid = CGD.FCUSTOMERGROUPSTANDARDID");
        sql.append(" inner join T_BD_CSSPGroup csspGroup1 on csspGroup1.fid = CGD.FCUSTOMERGROUPID ");
        sql.append(" inner join T_BD_CSSPGroup csspGroup on charindex(csspGroup.flongnumber,csspGroup1.flongnumber) = 1 ");
        return sql.toString();
    }

    private Map<String, String> getDataTypeField() {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_BASEQTY.getName(), "FBaseQty");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_ACTUALCOST.getName(), "FActualCost");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_AMOUT.getName(), "FAmount");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_DISCOUNTAMOUNT.getName(), "FDiscountAmount");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_NONTAXAMOUNT.getName(), "FNonTaxAmount");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_LOCALNONTAXAMOUNT.getName(), "FLocalNonTaxAmount");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_TAX.getName(), "FTax");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_LOCALTAX.getName(), "FLocalTax");
        fieldMap.put(RptFormulaInvSOFetchDataTypeEnum.FETCH_LOCALAMOUNT.getName(), "FLocalAmount");
        return fieldMap;
    }

    @Override
    public void setSumField(InvGetParamBean invParamBean) {
        InvSOPIGetParamBean formulaParam = (InvSOPIGetParamBean)invParamBean;
        Map<String, String> fieldMap = this.getDataTypeField();
        String field = fieldMap.get(formulaParam.getGetDataType());
        if (field == null) {
            field = "FLocalAmount";
        }
        this.setSumField("d." + field);
    }

    @Override
    String getSqlByID(int group) {
        return super.getSqlByID(group) + this.getCostCenterCondSqlByID(group);
    }

    @Override
    protected String getCostCenterCondSqlByID(int group) {
        if (SaleOutBatchCalculater.checkBit(group, 12)) {
            return " and (h.FCostCenterOrgUnitID = ?)";
        }
        return "";
    }

    @Override
    public InvGetParamBean getInvGetParamBean(Parameter param) {
        return new InvSaleIssueParamBean(param);
    }
}

