/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.scm.common.tools.BizLogger;
import com.kingdee.eas.scm.common.tools.LogParam;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SQLLogger {
    private static final int MAX_SQL_LENGTH = 3000;

    private static boolean isLogOpen() {
        return LogParam.getInstance().isOpen();
    }

    public static final void writeLog(Context ctx, String bizName, long timeFrom, long timeTo, String[] sqls, Object[] params, int[] numbers) throws BOSException {
        if (!SQLLogger.isLogOpen()) {
            return;
        }
        if (sqls == null || sqls.length == 0) {
            return;
        }
        Logger logger = BizLogger.getLogger();
        logger.info((Object)("bizName :" + bizName));
        StringBuffer sqlBuf = new StringBuffer();
        for (int i = 0; i < sqls.length; ++i) {
            if (i == sqls.length - 1) {
                sqlBuf.append(sqls[i]);
                continue;
            }
            sqlBuf.append(sqls[i] + "\r\n");
        }
        logger.info((Object)("SQL: " + sqlBuf.toString()));
        logger.info((Object)("SQL Parameters:" + SQLLogger.getParamsString(params)));
        logger.info((Object)("execute start time :" + new Timestamp(timeFrom)));
        logger.info((Object)("execute time :" + String.valueOf(timeTo - timeFrom) + "ms"));
        int number = 0;
        for (int i = 0; numbers != null && i < numbers.length; ++i) {
            number += numbers[i];
        }
        logger.info((Object)("return record count:" + String.valueOf(number)));
    }

    private static String getParamsString(Object[] params) {
        String result = null;
        if (params != null && params.length != 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Object[]) {
                    Object[] temp = (Object[])params[i];
                    for (int j = 0; j < temp.length; ++j) {
                        param.append(temp[j]);
                        param.append(",");
                    }
                    continue;
                }
                param.append(params[i]);
                param.append(",");
            }
            result = param.toString().length() > 3000 ? param.toString().substring(0, 3000) : param.toString();
        }
        return result;
    }

    public static final void writeLog(Context ctx, String bizName, long timeFrom, long timeTo, String sql, Object[] params, int number) throws BOSException {
        SQLLogger.writeLog(ctx, bizName, timeFrom, timeTo, new String[]{sql}, params, new int[]{number});
    }

    public static final int[] arraycopy(int[] resultNum, int[] result) {
        int[] temp = null;
        if (resultNum != null && result != null) {
            temp = new int[result.length + resultNum.length];
            System.arraycopy(resultNum, 0, temp, 0, resultNum.length);
            System.arraycopy(result, 0, temp, resultNum.length, result.length);
        }
        return temp;
    }
}

