/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.CSOptionCollection;
import com.kingdee.eas.basedata.master.cssp.CSOptionFactory;
import com.kingdee.eas.basedata.master.cssp.CSOptionInfo;
import com.kingdee.eas.basedata.master.cssp.IUserParamater;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.UserParamaterCollection;
import com.kingdee.eas.basedata.master.cssp.UserParamaterFactory;
import com.kingdee.eas.basedata.master.cssp.UserParamaterInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.master.material.client.MaterialSelectorFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.framework.portrait.util.PortraitViewHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public final class F7ContextManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.util.F7ContextManager");
    private int contextType = 0;
    private int f7DisplayMode = 0;
    private Map f7Map = null;
    private Component owner;
    private OrgType mainOrgType;
    private Map diffTypeOrgs = null;
    private Map ctxChgF7Map = null;
    private Context mainOrgContext;
    private KDBizPromptBox[] prmtNeedOrgF7s;
    private static Map<String, CSOptionInfo> csOptioninfoMap = new HashMap<String, CSOptionInfo>();
    private static Map<String, Integer> f7DisplayModeMap = new HashMap<String, Integer>();
    private PortraitViewHelper portraitViewHelper;
    private KDTActiveCellListener measureUnitListener;
    private KDTActiveCellListener assistPropertyListener;

    public void setPortraitViewHelper(PortraitViewHelper portraitViewHelper) {
        this.portraitViewHelper = portraitViewHelper;
    }

    public F7ContextManager(Component owner, OrgType mainOrgType) throws EASBizException, BOSException {
        this.owner = owner;
        this.mainOrgType = mainOrgType;
        this.init();
    }

    public F7ContextManager(Component owner, int f7DisplayMode, OrgType mainOrgType) throws EASBizException, BOSException {
        this.owner = owner;
        this.mainOrgType = mainOrgType;
        this.f7DisplayMode = f7DisplayMode;
        this.f7Map = new HashMap();
        this.diffTypeOrgs = new HashMap();
        this.ctxChgF7Map = new HashMap();
    }

    public void registerBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg) {
        this.registerBizSupplierF7(bizSupplierBox, col, queryInfo, mainOrg, this.mainOrgType);
    }

    public void registerBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isRelegable) {
        boolean isViewFilter = this.owner instanceof SCMBillFilterUI || this.owner instanceof CommRptBaseConditionUI;
        this.registerBizSupplierF7(bizSupplierBox, col, queryInfo, mainOrg, mainOrgType, isRelegable, isViewFilter);
    }

    public void registerBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, boolean isReportFilter) {
        this.registerBizSupplierF7(bizSupplierBox, col, queryInfo, mainOrg, this.mainOrgType, false, isReportFilter);
    }

    public void registerBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType) {
        boolean isViewFilter = this.owner instanceof SCMBillFilterUI || this.owner instanceof CommRptBaseConditionUI;
        this.registerBizSupplierF7(bizSupplierBox, col, queryInfo, mainOrg, mainOrgType, false, isViewFilter);
    }

    public void registerBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isRelegable, boolean isReportFilter) {
        if (queryInfo != null) {
            bizSupplierBox.setQueryInfo(queryInfo);
        }
        if (this.contextType == 0) {
            bizSupplierBox.setEditable(true);
            bizSupplierBox.setEditFormat("$number$");
            bizSupplierBox.setDisplayFormat("$number$");
            bizSupplierBox.setCommitFormat("$number$;$name$;$mnemonicCode$");
            bizSupplierBox.setCommitParser((IParser)new MainDataParser(bizSupplierBox));
        } else {
            bizSupplierBox.setDisplayFormat("$name$");
        }
        if (this.f7DisplayMode == 0) {
            this.f7Map.put(bizSupplierBox, SCMGroupClientUtils.setBizSupplierF7(bizSupplierBox, this.owner, mainOrgType, queryInfo, isReportFilter));
        } else {
            if (queryInfo == null) {
                bizSupplierBox.setQueryInfo(QueryInfoConstants.getStdSupplierQueryInfo(mainOrgType, isReportFilter));
            }
            this.f7Map.put(bizSupplierBox, QueryInfoConstants.getSupplierQueryOrgId(mainOrgType));
            bizSupplierBox.setEditable(true);
        }
        if (this.contextType == 0) {
            SCMGroupClientUtils.setApproved4SupplierF7(bizSupplierBox, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizSupplierBox));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            col.setRenderer((IBasicRender)avr);
        }
        if (mainOrg != null) {
            bizSupplierBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (isRelegable) {
            this.diffTypeOrgs.put(bizSupplierBox, mainOrgType);
        }
        if (this.portraitViewHelper != null) {
            this.portraitViewHelper.addF7ListenerForPortrait((KDPromptBox)bizSupplierBox, col, 1);
        }
    }

    public F7ContextManager(Component owner, OrgType mainOrgType, int contextType) throws EASBizException, BOSException {
        this.owner = owner;
        this.contextType = contextType;
        this.mainOrgType = mainOrgType;
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        String CUId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        if (f7DisplayModeMap.containsKey(CUId)) {
            this.f7DisplayMode = f7DisplayModeMap.get(CUId);
        } else {
            this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode(CUId);
            f7DisplayModeMap.put(CUId, this.f7DisplayMode);
        }
        this.f7Map = new HashMap();
        this.diffTypeOrgs = new HashMap();
        this.ctxChgF7Map = new HashMap();
    }

    public void registerBizCustomerF7(KDBizPromptBox bizCustomerBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg) {
        this.registerBizCustomerF7(bizCustomerBox, col, queryInfo, mainOrg, this.mainOrgType);
    }

    public void registerBizCustomerF7(KDBizPromptBox bizCustomerBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isRelegable) {
        boolean isViewFilter = this.owner instanceof SCMBillFilterUI || this.owner instanceof CommRptBaseConditionUI;
        this.registerBizCustomerF7(bizCustomerBox, col, false, queryInfo, mainOrg, mainOrgType, isRelegable, isViewFilter);
    }

    public void registerBizCustomerF7(KDBizPromptBox bizCustomerBox, IColumn col, boolean isMultiSelect, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isRelegable, boolean isReportFilter) {
        if (queryInfo != null) {
            bizCustomerBox.setQueryInfo(queryInfo);
        }
        bizCustomerBox.setCommitFormat(this.getCSCommitFormat(1));
        if (this.contextType == 0) {
            bizCustomerBox.setEditFormat("$number$");
            bizCustomerBox.setDisplayFormat("$number$");
            bizCustomerBox.setCommitParser((IParser)new MainDataParser(bizCustomerBox));
        } else {
            bizCustomerBox.setDisplayFormat("$name$");
        }
        if (this.f7DisplayMode == 0) {
            this.f7Map.put(bizCustomerBox, SCMGroupClientUtils.setBizCustomerF7(bizCustomerBox, this.owner, mainOrgType, isMultiSelect, queryInfo, isReportFilter));
        } else {
            if (queryInfo == null) {
                bizCustomerBox.setQueryInfo(QueryInfoConstants.getStdCustomerQueryInfo(mainOrgType, isReportFilter));
            }
            this.f7Map.put(bizCustomerBox, QueryInfoConstants.getCustomerQueryOrgId(mainOrgType));
            bizCustomerBox.setEditable(true);
        }
        if (this.contextType == 0) {
            SCMGroupClientUtils.setApproved4CustomerF7(bizCustomerBox, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCustomerBox));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            col.setRenderer((IBasicRender)avr);
        }
        if (mainOrg != null) {
            bizCustomerBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (isRelegable) {
            this.diffTypeOrgs.put(bizCustomerBox, mainOrgType);
        }
        if (this.portraitViewHelper != null) {
            this.portraitViewHelper.addF7ListenerForPortrait((KDPromptBox)bizCustomerBox, col, 2);
        }
    }

    public String getCSCommitFormat(int csType) {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            CSOptionInfo csOptioninfo = null;
            if (csOptioninfoMap.containsKey(userId + csType)) {
                csOptioninfo = csOptioninfoMap.get(userId + csType);
            } else {
                CSOptionCollection csOptionColl = CSOptionFactory.getRemoteInstance().getCSOptionCollection("select csName,csNumber,csAssistNumber where userID = '" + userId + "' AND csType = " + csType);
                csOptioninfo = csOptionColl.get(0);
                csOptioninfoMap.put(userId + csType, csOptioninfo);
            }
            if (csOptioninfo != null) {
                if (csOptioninfo.isCsName()) {
                    return "$name$";
                }
                if (csOptioninfo.isCsAssistNumber()) {
                    return "$mnemonicCode$";
                }
                if (csOptioninfo.isCsNumber()) {
                    return "$number$";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "$number$;$name$";
    }

    public void registerBizCustomerF7(KDBizPromptBox bizCustomerBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType) {
        this.registerBizCustomerF7(bizCustomerBox, col, false, queryInfo, mainOrg, mainOrgType);
    }

    public void registerBizCustomerF7(KDBizPromptBox bizCustomerBox, IColumn col, boolean isMultiSelect, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType) {
        boolean isViewFilter = this.owner instanceof SCMBillFilterUI || this.owner instanceof CommRptBaseConditionUI;
        this.registerBizCustomerF7(bizCustomerBox, col, isMultiSelect, queryInfo, mainOrg, mainOrgType, false, isViewFilter);
    }

    public void registerBizMaterialF7(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, boolean isMulSelect) {
        this.registerBizMaterialF7(bizMaterialBox, col, queryInfo, mainOrg, this.mainOrgType, isMulSelect);
    }

    public void registerBizMaterialF7(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isMulSelect, boolean isRelegable) {
        this.registerBizMaterialF7(bizMaterialBox, col, queryInfo, mainOrg, mainOrgType, isMulSelect);
        if (isRelegable) {
            this.diffTypeOrgs.put(bizMaterialBox, mainOrgType);
        }
    }

    public void registerBizMaterialF7(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isMulSelect) {
        if (this.contextType == 0) {
            bizMaterialBox.setEditFormat("$number$");
            bizMaterialBox.setDisplayFormat("$number$");
            bizMaterialBox.setCommitParser((IParser)new MainDataParser(bizMaterialBox));
        }
        if (this.f7DisplayMode == 0) {
            this.f7Map.put(bizMaterialBox, SCMGroupClientUtils.setBizMaterialF7(bizMaterialBox, this.owner, mainOrgType, isMulSelect, queryInfo));
        } else {
            if (queryInfo == null) {
                bizMaterialBox.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo(mainOrgType));
            } else if (queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery") || queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery")) {
                bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanNoGroupQuery");
            } else {
                bizMaterialBox.setQueryInfo(queryInfo);
            }
            this.f7Map.put(bizMaterialBox, QueryInfoConstants.getMaterialQueryOrgId(mainOrgType));
            bizMaterialBox.setEditable(true);
            bizMaterialBox.setCommitFormat("$number$;$name$;$model$;$helpCode$");
        }
        bizMaterialBox.setEnabledMultiSelection(isMulSelect);
        SelectorItemCollection selectors = bizMaterialBox.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("baseUnit.id"));
        selectors.add(new SelectorItemInfo("baseUnit.number"));
        selectors.add(new SelectorItemInfo("baseUnit.name"));
        selectors.add(new SelectorItemInfo("assistUnit.id"));
        selectors.add(new SelectorItemInfo("assistUnit.number"));
        selectors.add(new SelectorItemInfo("assistUnit.name"));
        selectors.addObjectCollection((IObjectCollection)MaterialSelectorFactory.getSelectors());
        bizMaterialBox.setSelectorCollection(selectors);
        if (this.contextType == 0) {
            SCMGroupClientUtils.setApproved4MaterialF7(bizMaterialBox, mainOrgType);
        }
        if (this.contextType == 0 && col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
            col.setRenderer((IBasicRender)avr);
        }
        if (mainOrg != null) {
            bizMaterialBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (this.portraitViewHelper != null) {
            this.portraitViewHelper.addF7ListenerForPortrait((KDPromptBox)bizMaterialBox, col, 0);
        }
    }

    protected UserParamaterCollection getUserParams(String numbers) {
        UserParamaterCollection userParams = new UserParamaterCollection();
        try {
            IUserParamater iUserParam = UserParamaterFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("userid", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filter);
            userParams = iUserParam.getUserParamaterCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return userParams;
    }

    protected UserParamaterInfo getUserParamaterInfo(UserParamaterCollection userParams, String number) {
        for (int i = 0; i < userParams.size(); ++i) {
            UserParamaterInfo param = userParams.get(i);
            if (!number.equals(param.getNumber())) continue;
            return param;
        }
        return null;
    }

    public void changeF7Context(boolean needSetMainOrgContext) {
        if (this.f7DisplayMode == 0) {
            Iterator iter = this.f7Map.keySet().iterator();
            KDBizPromptBox f7 = null;
            while (iter.hasNext()) {
                GeneralKDPromptSelectorAdaptor adaptor;
                f7 = (KDBizPromptBox)iter.next();
                if (this.f7Map.get(f7) instanceof GeneralKDPromptSelectorAdaptor) {
                    adaptor = (GeneralKDPromptSelectorAdaptor)this.f7Map.get(f7);
                    if (needSetMainOrgContext) {
                        adaptor.setMainOrgContext(this.mainOrgContext);
                    }
                    adaptor.isCurrentMainOrgChanged();
                    continue;
                }
                adaptor = (F7MaterialMultiUISelectorAdaptor)this.f7Map.get(f7);
                if (needSetMainOrgContext) {
                    adaptor.setMainOrgContext(this.mainOrgContext);
                }
                adaptor.isCurrentMainOrgChanged();
            }
        } else {
            for (KDBizPromptBox f7 : this.f7Map.keySet()) {
                SCMGroupClientUtils.isCurrentMainOrgChanged(f7, (String)this.f7Map.get(f7), null);
            }
        }
    }

    public void changeF7Context(String ids) {
        this.changeF7Context(false);
        this.changeContext4F7(ids);
    }

    public void changeF7Context(String ids, OrgUnitCollection collection) {
        if (ids == null) {
            return;
        }
        this.initUIMainOrgContext(ids.indexOf(44) > -1 ? ids.substring(0, ids.indexOf(44)) : ids);
        if (this.prmtNeedOrgF7s != null && collection != null && this.mainOrgType != null) {
            for (int i = 0; i < this.prmtNeedOrgF7s.length; ++i) {
                this.prmtNeedOrgF7s[i].setMainBizOrgs(collection, this.mainOrgType, this.mainOrgContext);
                if (this.f7Map.containsKey(this.prmtNeedOrgF7s[i])) {
                    this.prmtNeedOrgF7s[i].setFilterInfoProducer(FilterInfoProducerFactory.getMultiOUs4DataFilterInfoProducer((String)this.prmtNeedOrgF7s[i].getQueryInfo().replace(File.separatorChar + "", "."), (OrgUnitCollection)collection));
                }
                this.prmtNeedOrgF7s[i].getQueryAgent().resetRuntimeEntityView();
            }
        }
        try {
            ISCMGroupFacade iScmGroup = SCMGroupFacadeFactory.getRemoteInstance();
            HashMap<OrgType, OrgUnitCollection> orgsMap = new HashMap<OrgType, OrgUnitCollection>();
            Iterator iter = this.diffTypeOrgs.entrySet().iterator();
            OrgUnitCollection delegatedOrgs = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                KDBizPromptBox f7 = (KDBizPromptBox)entry.getKey();
                OrgType orgType = (OrgType)entry.getValue();
                if (orgsMap.containsKey(orgType)) {
                    delegatedOrgs = (OrgUnitCollection)orgsMap.get(orgType);
                } else if (collection != null) {
                    delegatedOrgs = iScmGroup.obtainDelegatedOrgs(collection, this.mainOrgType, orgType);
                    orgsMap.put(orgType, delegatedOrgs);
                }
                f7.setMainBizOrgs(delegatedOrgs, orgType);
                f7.getQueryAgent().resetRuntimeEntityView();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        this.changeF7Context(ids);
    }

    public void changeF7Context(Map uiContext) {
        OrgUnitInfo orgInfo;
        if (uiContext == null) {
            this.changeF7Context(true);
            return;
        }
        for (Map.Entry entry : this.diffTypeOrgs.entrySet()) {
            KDBizPromptBox f7 = (KDBizPromptBox)entry.getKey();
            OrgType orgType = (OrgType)entry.getValue();
            f7.setCurrentMainBizOrgUnit((OrgUnitInfo)uiContext.get(orgType), orgType, this.mainOrgContext);
        }
        for (KDBizPromptBox f7 : this.f7Map.keySet()) {
            if (this.f7DisplayMode == 0) {
                GeneralKDPromptSelectorAdaptor adaptor;
                if (this.f7Map.get(f7) instanceof GeneralKDPromptSelectorAdaptor) {
                    adaptor = (GeneralKDPromptSelectorAdaptor)this.f7Map.get(f7);
                    adaptor.setMainOrgContext(this.mainOrgContext);
                    adaptor.isCurrentMainOrgChanged();
                    continue;
                }
                adaptor = (F7MaterialMultiUISelectorAdaptor)this.f7Map.get(f7);
                adaptor.setMainOrgContext(this.mainOrgContext);
                adaptor.isCurrentMainOrgChanged();
                continue;
            }
            SCMGroupClientUtils.isCurrentMainOrgChanged(f7, (String)this.f7Map.get(f7), this.mainOrgContext);
        }
        if (this.mainOrgContext != null && (orgInfo = (OrgUnitInfo)this.mainOrgContext.get((Object)this.mainOrgType)) != null) {
            this.changeContext4F7(orgInfo.getId().toString());
        }
    }

    public void changeF7Context(KDBizPromptBox kdBizPromptBox) {
        if (this.f7DisplayMode == 0) {
            if (this.f7Map.get(kdBizPromptBox) instanceof GeneralKDPromptSelectorAdaptor) {
                GeneralKDPromptSelectorAdaptor adaptor = (GeneralKDPromptSelectorAdaptor)this.f7Map.get(kdBizPromptBox);
                if (adaptor != null) {
                    adaptor.isCurrentMainOrgChanged();
                }
            } else {
                F7MaterialMultiUISelectorAdaptor adaptor = (F7MaterialMultiUISelectorAdaptor)this.f7Map.get(kdBizPromptBox);
                if (adaptor != null) {
                    adaptor.isCurrentMainOrgChanged();
                }
            }
        } else {
            String id = (String)this.f7Map.get(kdBizPromptBox);
            if (id != null) {
                SCMGroupClientUtils.isCurrentMainOrgChanged(kdBizPromptBox, id, null);
            }
        }
    }

    public void changeF7Context(KDBizPromptBox kdBizPromptBox, OrgUnitCollection collection) {
        if (this.f7DisplayMode == 0) {
            if (this.f7Map.get(kdBizPromptBox) instanceof GeneralKDPromptSelectorAdaptor) {
                GeneralKDPromptSelectorAdaptor adaptor = (GeneralKDPromptSelectorAdaptor)this.f7Map.get(kdBizPromptBox);
                if (adaptor != null) {
                    adaptor.isCurrentMainOrgChanged();
                }
            } else {
                F7MaterialMultiUISelectorAdaptor adaptor = (F7MaterialMultiUISelectorAdaptor)this.f7Map.get(kdBizPromptBox);
                if (adaptor != null) {
                    adaptor.isCurrentMainOrgChanged();
                }
            }
        } else {
            String id = (String)this.f7Map.get(kdBizPromptBox);
            if (id != null) {
                SCMGroupClientUtils.isCurrentMainOrgChanged(kdBizPromptBox, id, null);
            }
        }
    }

    public KDTActiveCellListener getMeasureUnitListener() {
        return this.measureUnitListener;
    }

    public void registerMeasureUnitF7(final KDTable table, final String colNameMaterial, final String colNameUnit) {
        KDBizPromptBox bizUnitBox;
        if (table.getColumn(colNameUnit).getEditor() == null) {
            bizUnitBox = new KDBizPromptBox();
            bizUnitBox.setEditFormat("$number$");
            bizUnitBox.setDisplayFormat("$number$");
            bizUnitBox.setCommitFormat("$number$");
            bizUnitBox.setEditable(true);
            table.getColumn(colNameUnit).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        }
        bizUnitBox = (KDBizPromptBox)table.getColumn(colNameUnit).getEditor().getComponent();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)e.getSource());
                }
                catch (Exception exc) {
                    logger.error((Object)exc);
                }
            }
        });
        this.measureUnitListener = new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameUnit).getColumnIndex() == colIndex) {
                        MaterialInfo materialInfo = (MaterialInfo)table.getCell(rowIndex, colNameMaterial).getValue();
                        ICellEditor cellEditor = table.getColumn(colNameUnit).getEditor();
                        KDBizPromptBox bizUnitBox = null;
                        if (cellEditor != null) {
                            bizUnitBox = (KDBizPromptBox)cellEditor.getComponent();
                        }
                        if (bizUnitBox == null) {
                            return;
                        }
                        if (materialInfo != null) {
                            bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
                            SCMClientUtils.setF7MeasureUnit(bizUnitBox, materialInfo.getId().toString());
                        } else {
                            bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
                        }
                    }
                }
            }
        };
        table.addKDTActiveCellListener(this.measureUnitListener);
    }

    public KDTActiveCellListener getAssistPropertyListener() {
        return this.assistPropertyListener;
    }

    public void registerAssistPropertyF7(final KDTable table, final String colNameMaterial, final String colNameAssitProperty, final SCMBillEditUI editUI) {
        KDBizPromptBox bizAssistPropertyBox;
        if (table.getColumn(colNameAssitProperty).getEditor() == null) {
            bizAssistPropertyBox = new KDBizPromptBox();
            bizAssistPropertyBox.setEditFormat("$number$");
            bizAssistPropertyBox.setDisplayFormat("$name$");
            bizAssistPropertyBox.setCommitFormat("$number$");
            bizAssistPropertyBox.setEditable(true);
            table.getColumn(colNameAssitProperty).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
        }
        bizAssistPropertyBox = (KDBizPromptBox)table.getColumn(colNameAssitProperty).getEditor().getComponent();
        bizAssistPropertyBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialAsstAttrValueQuery");
        this.assistPropertyListener = new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    MaterialInfo materialInfo;
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameAssitProperty).getColumnIndex() == colIndex && (materialInfo = (MaterialInfo)table.getCell(rowIndex, colNameMaterial).getValue()) != null) {
                        String assistAttrTypeID;
                        String string = assistAttrTypeID = materialInfo.getAssistAttr() == null ? null : materialInfo.getAssistAttr().getId().toString();
                        if (assistAttrTypeID != null) {
                            SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)table.getColumn(colNameAssitProperty).getEditor().getComponent(), materialInfo, (IUIObject)editUI);
                        }
                    }
                }
            }
        };
        table.addKDTActiveCellListener(this.assistPropertyListener);
    }

    public void registerWarehouseF7(final KDTable table, final String colNameStorageOrgUnit, final String colNameWarehouse) {
        KDBizPromptBox kDBizPromptBoxWarehouse;
        if (table.getColumn(colNameWarehouse).getEditor() == null) {
            kDBizPromptBoxWarehouse = new KDBizPromptBox();
            kDBizPromptBoxWarehouse.setEditable(true);
            kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
            kDBizPromptBoxWarehouse.setEditFormat("$number$");
            kDBizPromptBoxWarehouse.setCommitFormat("$number$");
            table.getColumn(colNameWarehouse).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
        }
        kDBizPromptBoxWarehouse = (KDBizPromptBox)table.getColumn(colNameWarehouse).getEditor().getComponent();
        kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    StorageOrgUnitInfo storageOrgUnitInfo;
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameWarehouse).getColumnIndex() == colIndex && (storageOrgUnitInfo = (StorageOrgUnitInfo)table.getRow(rowIndex).getCell(colNameStorageOrgUnit).getValue()) != null) {
                        try {
                            ((KDBizPromptBox)table.getColumn(colNameWarehouse).getEditor().getComponent()).setEntityViewInfo(SCMClientUtils.getWarehouseFilter(storageOrgUnitInfo, -1));
                        }
                        catch (EASBizException e1) {
                            logger.error((Object)e1);
                        }
                        catch (BOSException e1) {
                            logger.error((Object)e1);
                        }
                    }
                }
            }
        });
    }

    public void registerWarehouseF7(KDBizPromptBox prmtStorageOrgUnit, KDBizPromptBox prmtWarehouse) {
        prmtWarehouse.setEditable(true);
        prmtWarehouse.setDisplayFormat("$name$");
        prmtWarehouse.setEditFormat("$number$");
        prmtWarehouse.setCommitFormat("$number$");
        prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        if (prmtStorageOrgUnit.getValue() != null) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)prmtStorageOrgUnit.getValue();
        }
        if (storageOrgUnitInfo != null) {
            try {
                prmtWarehouse.setEntityViewInfo(SCMClientUtils.getWarehouseFilter(storageOrgUnitInfo, 1));
            }
            catch (EASBizException e1) {
                logger.error((Object)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
            }
        }
    }

    public void registerBizChannelF7(KDBizPromptBox bizChannelBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg) {
        this.registerBizChannelF7(bizChannelBox, col, queryInfo, mainOrg, this.mainOrgType);
    }

    public void registerBizChannelF7(KDBizPromptBox bizChannelBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType, boolean isRelegable) {
        this.registerBizChannelF7(bizChannelBox, col, queryInfo, mainOrg, mainOrgType);
        if (isRelegable) {
            this.diffTypeOrgs.put(bizChannelBox, mainOrgType);
        }
    }

    public void registerBizChannelF7(KDBizPromptBox bizChannelBox, IColumn col, String queryInfo, OrgUnitInfo mainOrg, OrgType mainOrgType) {
        if (queryInfo != null) {
            bizChannelBox.setQueryInfo(queryInfo);
        }
        if (this.contextType == 0) {
            bizChannelBox.setEditable(true);
            bizChannelBox.setEditFormat("$number$");
            bizChannelBox.setDisplayFormat("$number$");
            bizChannelBox.setCommitFormat("$number$;$name$;$mnemonicCode$");
        }
        if (this.f7DisplayMode == 0) {
            this.f7Map.put(bizChannelBox, SCMGroupClientUtils.setBizSupplierF7(bizChannelBox, this.owner, mainOrgType, queryInfo));
        } else {
            if (queryInfo == null) {
                bizChannelBox.setQueryInfo(QueryInfoConstants.getStdSupplierQueryInfo(mainOrgType));
            }
            this.f7Map.put(bizChannelBox, QueryInfoConstants.getSupplierQueryOrgId(mainOrgType));
            bizChannelBox.setEditable(true);
        }
        if (this.contextType == 0) {
            SCMGroupClientUtils.setApproved4SupplierF7(bizChannelBox, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizChannelBox));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
            col.setRenderer((IBasicRender)avr);
        }
        if (mainOrg != null) {
            bizChannelBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
    }

    public void registerContextChangeF7(KDBizPromptBox f7, String mainOrgProperty) {
        this.ctxChgF7Map.put(f7, mainOrgProperty);
    }

    private void changeContext4F7(String ids) {
        if (this.ctxChgF7Map != null && this.ctxChgF7Map.size() > 0) {
            HashMap viewMap = new HashMap();
            EntityViewInfo viewInfo = null;
            for (Map.Entry entry : this.ctxChgF7Map.entrySet()) {
                KDBizPromptBox f7 = (KDBizPromptBox)entry.getKey();
                String orgProperty = (String)entry.getValue();
                if (orgProperty == null) continue;
                if (viewMap.containsKey(orgProperty)) {
                    viewInfo = (EntityViewInfo)viewMap.get(orgProperty);
                } else {
                    viewInfo = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
                    viewInfo.clearExtendedProperties();
                    viewInfo.setFilter(this.getFilterInfo(orgProperty, ids));
                }
                f7.setEntityViewInfo(viewInfo);
            }
        }
    }

    private FilterInfo getFilterInfo(String orgProperty, String ids) {
        FilterInfo filterInfo = new FilterInfo();
        if (ids != null) {
            if (ids.indexOf(44) == -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids, CompareType.INCLUDE));
            }
        } else if (ids == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("1", (Object)"0"));
        }
        return filterInfo;
    }

    public void setMainOrgContext(Context mainOrgContext) {
        this.mainOrgContext = mainOrgContext;
    }

    public void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgType mainOrgType, OrgType orgType, boolean isRelegable) {
        this.registerBizOrgF7(bizOrgUnitBox, col, null, mainOrgType, orgType);
        if (isRelegable) {
            this.diffTypeOrgs.put(bizOrgUnitBox, mainOrgType);
        }
    }

    public void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgUnitInfo mainOrg, OrgType mainOrgType, OrgType orgType) {
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        SCMGroupClientUtils.setBizOrgF7ByType(bizOrgUnitBox, orgType, mainOrgType, true);
        if (mainOrg != null) {
            bizOrgUnitBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizOrgUnitBox));
        }
        bizOrgUnitBox.setEditable(true);
    }

    private void initUIMainOrgContext(String orgID) {
        if (this.mainOrgContext == null) {
            this.mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)orgID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setPrmtNeedOrgF7s(KDBizPromptBox[] prmtNeedOrgF7s) {
        this.prmtNeedOrgF7s = prmtNeedOrgF7s;
    }

    public int getF7DisplayMode() {
        return this.f7DisplayMode;
    }

    private boolean isOnlySupportQueryViaMaterialNumber() {
        IParamControl ipc = null;
        boolean isOnlySupportQueryViaMaterialNumber = false;
        try {
            ipc = ParamControlFactory.getRemoteInstance();
            String paramvalue = ipc.getParamValue(null, "OnlySupportQueryViaMaterialNumber");
            isOnlySupportQueryViaMaterialNumber = Boolean.valueOf(paramvalue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isOnlySupportQueryViaMaterialNumber;
    }

    public void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgUnitInfo mainOrg, OrgType mainOrgType, OrgType orgType, boolean isSingleMainOrg) {
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        SCMGroupClientUtils.setBizOrgF7ByType(bizOrgUnitBox, orgType, mainOrgType, isSingleMainOrg);
        if (mainOrg != null) {
            bizOrgUnitBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizOrgUnitBox));
        }
        bizOrgUnitBox.setEditable(true);
    }

    public void unRegisterBizF7(KDBizPromptBox bizF7Box) {
        this.f7Map.remove(bizF7Box);
        this.diffTypeOrgs.remove(bizF7Box);
    }
}

