/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class KsqlUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.util.KsqlUtil");

    public static StringBuffer TO_DECIMAL(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(",21,8)");
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDBType(Context ctx) {
        int dbType = 0;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return dbType;
    }

    public static boolean isOracle(Context ctx) {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 2 || dbType == 7 || dbType == 8;
    }

    public static boolean isDB2(Context ctx) {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 1;
    }

    public static boolean isSQLServer(Context ctx) {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 3;
    }

    public static boolean isDM(Context ctx) {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 11;
    }

    public static IRowSet executeQuery(Context ctx, String selectSql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        ResultSet rs = null;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(selectSql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return jdbcRowSet;
    }

    public static int executeUpdate(Context ctx, String updateSql, Object[] params) throws BOSException {
        return KsqlUtil.updateWithRowCount(ctx, updateSql, params);
    }

    private static int updateWithRowCount(Context ctx, String updateSql, Object[] params) throws BOSException {
        int i;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(updateSql);
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            i = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return i;
    }

    public static String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isConjunctionUpdating(String sql) {
        boolean result = false;
        String updSql = sql.toUpperCase();
        int idx = updSql.indexOf("SET");
        if (idx > 0) {
            return updSql.substring(idx + 3).trim().startsWith("(");
        }
        return result;
    }

    public static Collection getRSValue(IRowSet rs, String columnName, boolean distinct) throws BOSException {
        try {
            rs.first();
            AbstractCollection collection = null;
            collection = distinct ? new HashSet() : new ArrayList();
            if (rs.isFirst()) {
                do {
                    collection.add(rs.getObject(columnName));
                } while (rs.next());
            }
            return collection;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Collection getRSValue(IRowSet rs, int columnIdx, boolean distinct) throws BOSException {
        try {
            rs.first();
            AbstractCollection collection = null;
            collection = distinct ? new HashSet() : new ArrayList();
            if (rs.isFirst()) {
                do {
                    collection.add(rs.getObject(columnIdx));
                } while (rs.next());
            }
            return collection;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getBindMarks(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        return sb.toString();
    }

    public static void executeBatch(Context ctx, String updateSql, Object[][] params) throws BOSException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(updateSql);
            if (params != null) {
                boolean isDoubleParam = KsqlUtil.isDoubleParam(ctx, updateSql);
                for (int i = 0; i < params.length; ++i) {
                    int j;
                    for (j = 0; j < params[i].length; ++j) {
                        ps.setObject(j + 1, params[i][j]);
                    }
                    if (isDoubleParam) {
                        for (j = 0; j < params[i].length; ++j) {
                            ps.setObject(params[i].length + j + 1, params[i][j]);
                        }
                    }
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static void executeBatch(Context ctx, String[] updateSql) throws BOSException {
        if (updateSql == null || updateSql.length == 0) {
            return;
        }
        Connection con = null;
        Statement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.createStatement();
            for (int i = 0; i < updateSql.length; ++i) {
                ps.addBatch(updateSql[i]);
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static boolean isUniqueViolated(Context ctx, SQLException e) {
        boolean result = false;
        result = KsqlUtil.isDB2(ctx) && "23505".equals(e.getSQLState()) || KsqlUtil.isOracle(ctx) && "23000".equals(e.getSQLState()) && e.getErrorCode() == 1 || KsqlUtil.isSQLServer(ctx) && "14".equals(e.getSQLState()) && e.getErrorCode() == 1505;
        return result;
    }

    private static boolean isDoubleParam(Context ctx, String updateSql) {
        return !KsqlUtil.isSQLServer(ctx) && KsqlUtil.isConjunctionUpdating(updateSql);
    }
}

