/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PrecisionUtil {
    public static final int DEFAULT_PRICISION = 2;
    public static final String FORMAT_STRING_WITHOUT_E = "%r-[=]{#,##0.############}f";

    public static String getCurrencyFormatString(CurrencyInfo currencyInfo) {
        return com.kingdee.eas.scm.util.numeric.PrecisionUtil.getCurrencyFormatString((CurrencyInfo)currencyInfo);
    }

    public static String getQtyFormatString(IObjectPK materialPK, IObjectPK unitPK) {
        int precision = 0;
        if (materialPK == null || unitPK == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            precision = multiUnit.getQtyPrecision(materialPK.toString(), unitPK.toString());
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMultiMeasureUnitError"));
            SysUtil.abort();
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getQtyFormatString(MaterialInfo materialInfo) {
        MaterialInfo info = null;
        int precision = 2;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), info.getBaseUnit().getId().toString());
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getQtyFormatString(MaterialInfo materialInfo, MaterialPurchasingInfo materialPurchaseInfo) {
        MaterialInfo info = null;
        int precision = 2;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), materialPurchaseInfo.getUnit().getId().toString());
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getQtyFormatString(MaterialInfo materialInfo, MaterialSalesInfo materialSalesInfo) {
        MaterialInfo info = null;
        int precision = 2;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), materialSalesInfo.getUnit().getId().toString());
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getPriceFormatString(MaterialInfo materialInfo) {
        MaterialInfo info = null;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        StringBuffer buffer = new StringBuffer();
        int precision = info.getPricePrecision();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getFormatStringForMultiL(int precision) {
        return CtrlFormatUtilities.getDecimalFormatString();
    }

    public static String getFormatStringWithoutMinus(int precision) {
        if (precision == 0) {
            return "%R_{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r_[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static BigDecimal formatCurrencyPrecision(BigDecimal money, CurrencyInfo currencyInfo) {
        BigDecimal retvalue = null;
        int precision = currencyInfo.getPrecision();
        retvalue = money.setScale(precision, 4);
        return retvalue;
    }

    public static BigDecimal formatQtyPrecision(BigDecimal qty, IObjectPK materialPK, IObjectPK unitPK) {
        int precision = 0;
        BigDecimal retvalue = null;
        if (materialPK == null || unitPK == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            precision = multiUnit.getQtyPrecision(materialPK.toString(), unitPK.toString());
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMultiMeasureUnitError"));
            SysUtil.abort();
        }
        retvalue = qty.setScale(precision, 4);
        return retvalue;
    }

    public static BigDecimal formatQtyPrecision(BigDecimal qty, MaterialInfo materialInfo) {
        BigDecimal retvalue = null;
        MaterialInfo info = null;
        int precision = 2;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), info.getBaseUnit().getId().toString());
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtils.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        retvalue = qty.setScale(precision, 4);
        return retvalue;
    }

    public static BigDecimal formatPricePrecision(BigDecimal price, MaterialInfo materialInfo) {
        BigDecimal retvalue = null;
        int precision = materialInfo.getPricePrecision();
        retvalue = price.setScale(precision, 4);
        return retvalue;
    }

    public static int getCurrencyPrecisionByCompany(CompanyOrgUnitInfo company) {
        int scale = 2;
        if (company != null && company.getBaseCurrency() != null) {
            scale = SCMUtils.effectualPrecision(company.getBaseCurrency().getPrecision());
        }
        return scale;
    }

    public static void formatQtyPrecision(AbstractObjectCollection entries, Method mtdGetQty, Method mtdSetBaseQty, Method mtdSetAssitQty, Method mtdSetAssistUnit) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, EASBizException, BOSException {
        block15: {
            SCMBillEntryBaseInfo entryInfo;
            int i;
            Map unitIdMap;
            block14: {
                if (entries == null || entries.size() == 0 || mtdGetQty == null || mtdSetBaseQty == null) {
                    return;
                }
                ObjectListMap materialsMap = new ObjectListMap(5);
                String[] materialInfos = new String[entries.size() * 2];
                String[] measureUnitInfos = new String[entries.size() * 2];
                unitIdMap = new HashMap();
                int idx = 0;
                BigDecimal zero = new BigDecimal(0.0);
                for (i = 0; i < entries.size(); ++i) {
                    entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
                    BigDecimal qty = (BigDecimal)mtdGetQty.invoke((Object)entryInfo, null);
                    MaterialInfo materialInfo = entryInfo.getMaterial();
                    MeasureUnitInfo unitInfo = entryInfo.getUnit();
                    MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
                    MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
                    if (materialInfo == null) continue;
                    if (mtdSetAssistUnit != null && assistUnitInfo != null) {
                        unitIdMap.put(assistUnitInfo.getId().toString(), null);
                    }
                    if (qty != null && qty.compareTo(zero) == 0) continue;
                    if (qty != null && unitInfo != null && assistUnitInfo != null) {
                        materialsMap.put2(new Integer(i * 2), new Object[]{materialInfo.getId().toString(), unitInfo.getId().toString(), assistUnitInfo.getId().toString(), null, qty});
                        materialInfos[idx] = materialInfo.getId().toString();
                        measureUnitInfos[idx++] = assistUnitInfo.getId().toString();
                    }
                    if (qty == null || unitInfo == null || baseunitInfo == null) continue;
                    materialsMap.put2(new Integer(i * 2 + 1), new Object[]{materialInfo.getId().toString(), unitInfo.getId().toString(), null, null, qty});
                    materialInfos[idx] = materialInfo.getId().toString();
                    measureUnitInfos[idx++] = baseunitInfo.getId().toString();
                }
                if (mtdSetAssistUnit != null && unitIdMap.size() > 0) {
                    unitIdMap = BatchFetchDataUtils.getMeasureUnitInfos(unitIdMap);
                }
                if (materialsMap.size() <= 0) break block14;
                BatchFetchDataUtils.fetchUOMRates(materialsMap);
                String[] amaterialInfos = new String[materialsMap.size()];
                String[] ameasureUnitInfos = new String[materialsMap.size()];
                if (idx < entries.size() * 2) {
                    System.arraycopy(materialInfos, 0, amaterialInfos, 0, idx);
                    System.arraycopy(measureUnitInfos, 0, ameasureUnitInfos, 0, idx);
                } else {
                    amaterialInfos = materialInfos;
                    ameasureUnitInfos = measureUnitInfos;
                }
                HashMap mulUnitMap = SCMClientUtils.getMultiMeasureUnits(amaterialInfos, ameasureUnitInfos);
                MultiMeasureUnitInfo multiUnitInfo = null;
                for (int i2 = 0; i2 < entries.size(); ++i2) {
                    SCMBillEntryBaseInfo entryInfo2 = (SCMBillEntryBaseInfo)entries.getObject(i2);
                    Integer key = new Integer(i2 * 2);
                    if (materialsMap.containsKey(key) && mtdSetAssitQty != null && (!(entryInfo2.get("assistQty") instanceof BigDecimal) || ((BigDecimal)entryInfo2.get("assistQty")).compareTo(zero) == 0)) {
                        BigDecimal rate = (BigDecimal)materialsMap.get(key, 3);
                        int precision = 2;
                        multiUnitInfo = (MultiMeasureUnitInfo)mulUnitMap.get((String)materialsMap.get(key, 0) + (String)materialsMap.get(key, 2));
                        if (multiUnitInfo != null) {
                            precision = multiUnitInfo.getQtyPrecision();
                        }
                        BigDecimal assistUnitQty = rate == null ? (BigDecimal)materialsMap.get(key, 4) : ((BigDecimal)materialsMap.get(key, 4)).multiply(rate);
                        assistUnitQty = assistUnitQty.setScale(precision, 4);
                        mtdSetAssitQty.invoke((Object)entryInfo2, assistUnitQty);
                    }
                    if (materialsMap.containsKey(key = new Integer(i2 * 2 + 1))) {
                        MeasureUnitInfo baseunitInfo = entryInfo2.getBaseUnit();
                        BigDecimal rate = (BigDecimal)materialsMap.get(key, 3);
                        int precision = 2;
                        multiUnitInfo = (MultiMeasureUnitInfo)mulUnitMap.get((String)materialsMap.get(key, 0) + baseunitInfo.getId().toString());
                        if (multiUnitInfo != null) {
                            precision = multiUnitInfo.getQtyPrecision();
                        }
                        BigDecimal baseUnitQty = rate == null ? (BigDecimal)materialsMap.get(key, 4) : ((BigDecimal)materialsMap.get(key, 4)).multiply(rate);
                        baseUnitQty = baseUnitQty.setScale(precision, 4);
                        mtdSetBaseQty.invoke((Object)entryInfo2, baseUnitQty);
                    } else {
                        BigDecimal qty = (BigDecimal)mtdGetQty.invoke((Object)entryInfo2, null);
                        mtdSetBaseQty.invoke((Object)entryInfo2, qty);
                    }
                    if (mtdSetAssistUnit == null || entryInfo2.getMaterial().getAssistUnit() == null) continue;
                    mtdSetAssistUnit.invoke((Object)entryInfo2, unitIdMap.get(entryInfo2.getMaterial().getAssistUnit().getId().toString()));
                }
                break block15;
            }
            if (mtdSetAssistUnit == null) break block15;
            for (i = 0; i < entries.size(); ++i) {
                entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
                if (entryInfo.getMaterial().getAssistUnit() == null) continue;
                mtdSetAssistUnit.invoke((Object)entryInfo, unitIdMap.get(entryInfo.getMaterial().getAssistUnit().getId().toString()));
            }
        }
    }

    public static void formatQtyPrecision(AbstractObjectCollection entries, Method mtdGetQty, Method mtdSetBaseQty, Method mtdSetAssitQty, Method mtdSetAssistUnit, SCMEntryDataVO vo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, EASBizException, BOSException {
        if (vo == null || entries == null || entries.size() == 0 || mtdGetQty == null || mtdSetBaseQty == null || mtdSetAssitQty == null) {
            return;
        }
        BigDecimal zero = new BigDecimal(0.0);
        for (int i = 0; i < entries.size(); ++i) {
            String key;
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            BigDecimal qty = (BigDecimal)mtdGetQty.invoke((Object)entryInfo, null);
            if (qty != null && qty.compareTo(zero) == 0) continue;
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            BigDecimal baserate = null;
            if (qty != null && unitInfo != null && baseunitInfo != null && vo.getMmuConvsRate() != null) {
                key = materialInfo.getId().toString() + unitInfo.getId().toString();
                baserate = (BigDecimal)vo.getMmuConvsRate().get(key);
                key = materialInfo.getId().toString() + baseunitInfo.getId().toString();
                int precision = 2;
                if (vo.getMmuPrecisions() != null) {
                    precision = (Integer)vo.getMmuPrecisions().get(key);
                }
                BigDecimal baseUnitQty = baserate == null ? qty : qty.multiply(baserate);
                baseUnitQty = baseUnitQty.setScale(precision, 4);
                mtdSetBaseQty.invoke((Object)entryInfo, baseUnitQty);
            } else {
                mtdSetBaseQty.invoke((Object)entryInfo, qty);
            }
            if (qty != null && baserate != null && assistUnitInfo != null && vo.getMmuConvsRate() != null) {
                key = materialInfo.getId().toString() + assistUnitInfo.getId().toString();
                BigDecimal rate = (BigDecimal)vo.getMmuConvsRate().get(key);
                BigDecimal assistrate = rate != null ? baserate.divide(rate, 10, 4) : baserate;
                int precision = 2;
                if (vo.getMmuPrecisions() != null) {
                    precision = (Integer)vo.getMmuPrecisions().get(key);
                }
                BigDecimal assistUnitQty = assistrate == null ? qty : qty.multiply(assistrate);
                assistUnitQty = assistUnitQty.setScale(precision, 4);
                mtdSetAssitQty.invoke((Object)entryInfo, assistUnitQty);
            }
            if (assistUnitInfo == null || vo.getAssistMeasureUnitInfos() == null) continue;
            mtdSetAssistUnit.invoke((Object)entryInfo, vo.getAssistMeasureUnitInfos()[i]);
        }
    }
}

