/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.PrecisionConfig4IMRptUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ReportQueryConditionHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.util.ReportQueryConditionHelper");
    private static final String SPLITER = ";";
    private static final String STORAGE_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\StorageOrgUnitQuery";
    private static final String ASSIST_ATTRIBUTE_QUERY = "com\\kingdee\\eas\\basedata\\master\\material\\app\\F7AsstAttrValueQuery";
    private static final String STORE_TYPE_QUERY = "com\\kingdee\\eas\\basedata\\scm\\im\\inv\\app\\F7StoreTypeQuery";
    private static final String MATERIAL_TYPE_QUERY = "com\\kingdee\\eas\\basedata\\master\\material\\app\\F7MaterialGroupQuery";
    private static final String ADMIN_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\AdminOrgUnitQuery";
    private static final String TRANSACTION_TYPE = "com\\kingdee\\eas\\basedata\\scm\\common\\app\\F7TransactionTypeInvQuery";
    private static final String COMPANY_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\CompanyOrgUnitQuery";
    private static final String ACCOUNT_VIEW_QUERY = "com\\kingdee\\eas\\basedata\\master\\account\\app\\F7AccountViewQuery";
    private static QuerySolutionInfo defaultSolution;

    private ReportQueryConditionHelper() {
    }

    public static void fillCustomerParams(CustomerParams params, Container container) {
        Component[] components = container.getComponents();
        if (components != null && components.length != 0) {
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof KDLabel) continue;
                if (components[i] instanceof KDDatePicker) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDDatePicker)components[i]);
                    continue;
                }
                if (components[i] instanceof KDTextField) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDTextField)components[i]);
                    continue;
                }
                if (components[i] instanceof KDFormattedTextField) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDFormattedTextField)components[i]);
                    continue;
                }
                if (components[i] instanceof KDCheckBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDCheckBox)components[i]);
                    continue;
                }
                if (components[i] instanceof KDRadioButton) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDRadioButton)components[i]);
                    continue;
                }
                if (components[i] instanceof KDComboBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDComboBox)components[i]);
                    continue;
                }
                if (components[i] instanceof KDSpinner) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDSpinner)components[i]);
                    continue;
                }
                if (components[i] instanceof KDBizPromptBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDBizPromptBox)components[i]);
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                ReportQueryConditionHelper.fillCustomerParams(params, (Container)components[i]);
            }
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDDatePicker datePicker) {
        if (datePicker.getTimestamp() != null) {
            params.addCustomerParam(datePicker.getName(), datePicker.getTimestamp().toString());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDTextField textField) {
        if (!StringUtil.isEmpty(textField.getText())) {
            params.addCustomerParam(textField.getName(), textField.getText());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDFormattedTextField formattedTextField) {
        if (formattedTextField.getNumberValue() != null) {
            params.addCustomerParam(formattedTextField.getName(), String.valueOf(formattedTextField.getNumberValue().intValue()));
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDCheckBox checkBox) {
        params.putBoolean(checkBox.getName(), checkBox.isSelected());
    }

    private static void fillCustomerParams(CustomerParams params, KDRadioButton radioButton) {
        if (radioButton.isSelected()) {
            params.putBoolean(radioButton.getName(), true);
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDComboBox comboBox) {
        Object cobomItem = comboBox.getSelectedItem();
        if (cobomItem instanceof IntEnum) {
            params.addCustomerParam(comboBox.getName(), String.valueOf(((IntEnum)cobomItem).getValue()));
        } else if (cobomItem instanceof String) {
            params.addCustomerParam(comboBox.getName(), (String)cobomItem);
        } else if (cobomItem instanceof MaterialGroupStandardInfo) {
            params.addCustomerParam(comboBox.getName(), ((MaterialGroupStandardInfo)cobomItem).getName());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDSpinner spinner) {
        Integer precision = spinner.getIntegerVlaue();
        if (precision != null) {
            params.putInt(spinner.getName(), precision.intValue());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDBizPromptBox promptBox) {
        if (!StringUtil.isEmpty(promptBox.getText())) {
            Object promptValue = promptBox.getData();
            if (promptValue != null) {
                if (promptBox.isEnabledMultiSelection() && promptValue.getClass().isArray()) {
                    params.addCustomerParam(promptBox.getName(), ReportQueryConditionHelper.multiCoreBaseInfoToString((Object[])promptBox.getValue()));
                } else if (promptValue instanceof CoreBaseInfo) {
                    params.addCustomerParam(promptBox.getName(), ((CoreBaseInfo)promptValue).getId().toString());
                } else {
                    params.addCustomerParam(promptBox.getName(), promptBox.getText());
                }
            } else {
                params.addCustomerParam(promptBox.getName(), promptBox.getText());
            }
        }
    }

    private static String multiCoreBaseInfoToString(Object[] objects) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof CoreBaseInfo)) continue;
            buffer.append(((CoreBaseInfo)objects[i]).getId().toString());
            buffer.append(SPLITER);
        }
        return buffer.toString();
    }

    public static void fillComponent(Container container, CustomerParams params) {
        ReportQueryConditionHelper.fillComponent(container, params, null);
    }

    public static void fillComponent(Container container, CustomerParams params, SCMFetchData fetchData) {
        Component[] components = container.getComponents();
        if (components != null && components.length != 0) {
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof KDLabel) continue;
                if (components[i] instanceof KDDatePicker) {
                    ReportQueryConditionHelper.fillComponent((KDDatePicker)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDTextField) {
                    ReportQueryConditionHelper.fillComponent((KDTextField)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDFormattedTextField) {
                    ReportQueryConditionHelper.fillComponent((KDFormattedTextField)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDCheckBox) {
                    ReportQueryConditionHelper.fillComponent((KDCheckBox)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDRadioButton) {
                    ReportQueryConditionHelper.fillComponent((KDRadioButton)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDComboBox) {
                    ReportQueryConditionHelper.fillComponent((KDComboBox)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDSpinner) {
                    ReportQueryConditionHelper.fillComponent((KDSpinner)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDBizPromptBox) {
                    ReportQueryConditionHelper.fillComponent((KDBizPromptBox)components[i], params, fetchData);
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                ReportQueryConditionHelper.fillComponent((Container)components[i], params, fetchData);
            }
        }
    }

    private static void fillComponent(KDDatePicker datePicker, CustomerParams params) {
        try {
            Timestamp mfgFrom;
            String strTime = params.getCustomerParam(datePicker.getName());
            if (!StringUtil.isEmpty(strTime) && (mfgFrom = Timestamp.valueOf(strTime)) != null) {
                datePicker.setValue((Object)mfgFrom);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void fillComponent(KDTextField textField, CustomerParams params) {
        textField.setText(null);
        if (!StringUtil.isEmpty(params.getCustomerParam(textField.getName()))) {
            textField.setText(params.getCustomerParam(textField.getName()));
        }
    }

    private static void fillComponent(KDFormattedTextField formattedTextField, CustomerParams params) {
        formattedTextField.setText(null);
        try {
            if (!StringUtil.isEmpty(params.getCustomerParam(formattedTextField.getName()))) {
                formattedTextField.setValue((Object)Integer.valueOf(params.getCustomerParam(formattedTextField.getName())));
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
    }

    private static void fillComponent(KDCheckBox checkBox, CustomerParams params) {
        checkBox.setSelected(params.getBoolean(checkBox.getName()));
    }

    private static void fillComponent(KDRadioButton radioButton, CustomerParams params) {
        radioButton.setSelected(params.getBoolean(radioButton.getName()));
    }

    private static void fillComponent(KDComboBox comboBox, CustomerParams params) {
        if (!StringUtil.isEmpty(params.getCustomerParam(comboBox.getName()))) {
            String strEnum = params.getCustomerParam(comboBox.getName());
            comboBox.setSelectedIndex(ReportQueryConditionHelper.getIdxOfComboBox(comboBox, strEnum));
        }
    }

    private static void fillComponent(KDSpinner spinner, CustomerParams params) {
        spinner.setValue((Object)new Integer(params.getInt(spinner.getName())));
    }

    private static void fillComponent(KDBizPromptBox promptBox, CustomerParams params, SCMFetchData fetchData) {
        try {
            if (!StringUtil.isEmpty(params.getCustomerParam(promptBox.getName()))) {
                ReportQueryConditionHelper.setValueToPromptBox(promptBox, params.getCustomerParam(promptBox.getName()), fetchData);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void setValueToPromptBox(KDBizPromptBox promptBox, String keyParam, SCMFetchData fetchData) {
        if (fetchData != null) {
            if (fetchData.getFetchRptConditionData().get(keyParam) != null) {
                IObjectCollection col = (IObjectCollection)fetchData.getFetchRptConditionData().get(keyParam);
                Object[] results = col.toArray();
                promptBox.setValue(promptBox.isEnabledMultiSelection() ? results : results[0]);
            } else {
                promptBox.setValue(null);
            }
            return;
        }
        try {
            if (STORAGE_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    promptBox.setValue((Object)SCMGroupClientUtils.getOrgUnitInfos(keyParam));
                } else {
                    IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iStorageOrgUnit, keyParam);
                }
            } else if (COMPANY_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    promptBox.setValue((Object)SCMGroupClientUtils.getOrgUnitInfos(keyParam));
                } else {
                    ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iCompanyOrgUnit, keyParam);
                }
            } else if (ADMIN_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtils.getKeyIdList(keyParam), CompareType.INCLUDE));
                    view.setFilter(filter);
                    AdminOrgUnitCollection collection = iAdminOrgUnit.getAdminOrgUnitCollection(view);
                    AdminOrgUnitInfo[] results = new AdminOrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    promptBox.setValue((Object)results);
                } else {
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iAdminOrgUnit, keyParam);
                }
            } else if (STORE_TYPE_QUERY.equals(promptBox.getQueryInfo())) {
                IStoreType iStoreType = StoreTypeFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iStoreType, keyParam);
            } else if (MATERIAL_TYPE_QUERY.equals(promptBox.getQueryInfo())) {
                IMaterialGroup iMaterialType = MaterialGroupFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iMaterialType, keyParam);
            } else if (ASSIST_ATTRIBUTE_QUERY.equals(promptBox.getQueryInfo())) {
                IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getRemoteInstance();
                if (iAsstAttrValue != null) {
                    promptBox.setValue((Object)iAsstAttrValue.getValue((IObjectPK)new ObjectUuidPK(keyParam)));
                }
            } else if (TRANSACTION_TYPE.equals(promptBox.getQueryInfo())) {
                ITransactionType itrTransactionType = TransactionTypeFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)itrTransactionType, keyParam);
            } else if (ACCOUNT_VIEW_QUERY.equals(promptBox.getQueryInfo())) {
                if (!promptBox.isEnabledMultiSelection() && keyParam.indexOf(SPLITER) <= 0) {
                    IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iAccountView, keyParam);
                }
            } else if (ReportQueryConditionHelper.isCoreBaseObjectIDs(keyParam)) {
                promptBox.setData(ReportQueryConditionHelper.getCoreBaseObjectByIDs(promptBox, keyParam));
            } else {
                promptBox.setText(keyParam);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
    }

    private static boolean isCoreBaseObjectIDs(String ids) {
        boolean isCoreBaseObjectIDs = false;
        if (ids != null) {
            isCoreBaseObjectIDs = ids.indexOf(SPLITER) >= 0 ? ReportQueryConditionHelper.isCoreBaseObjectIDs(ids.split(SPLITER)[0]) : BOSUuid.isValid((String)ids, (boolean)true);
        }
        return isCoreBaseObjectIDs;
    }

    private static Object getCoreBaseObjectByIDs(KDBizPromptBox bizBox, String ids) throws BOSException {
        BOSObjectType bosObjectType = null;
        bosObjectType = ids.indexOf(SPLITER) >= 0 ? BOSUuid.read((String)ids.split(SPLITER)[0]).getType() : BOSUuid.read((String)ids).getType();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtils.getKeyIdList(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection collection = coreBase.getCollection(view);
        Object[] results = new Object[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            results[i] = collection.getObject(i);
        }
        if (bizBox.isEnabledMultiSelection()) {
            return results;
        }
        return results[0];
    }

    private static int getIdxOfComboBox(KDComboBox cobox, String value) {
        for (int idx = 0; idx < cobox.getItemCount(); ++idx) {
            Object item = cobox.getItemAt(idx);
            if (item != null && item instanceof IntEnum) {
                int intEnum = Integer.valueOf(value);
                if (((IntEnum)item).getValue() != intEnum) continue;
                return idx;
            }
            if (!(item != null && item instanceof String ? value.equals(item) : item != null && item instanceof MaterialGroupStandardInfo && value.equals(item.toString()))) continue;
            return idx;
        }
        return -1;
    }

    private static void setFilterInfoObject(KDBizPromptBox prmtCompnent, IDataBase dataBase, String id) throws BOSException, EASBizException {
        if (dataBase != null) {
            prmtCompnent.setValue((Object)dataBase.getValue((IObjectPK)new ObjectUuidPK(id)));
        }
    }

    public static CustomerParams getDefaultCustomerParams(boolean useDefaultSolution, CustomerQueryPanel userPanel, CoreUI reportUI, IMetaDataPK queryMetaDataPK) throws Exception {
        CustomerParams cp = null;
        userPanel.getUIContext().clear();
        userPanel.getUIContext().putAll(reportUI.getUIContext());
        if (useDefaultSolution) {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(queryMetaDataPK).getFullName();
            if (iQuery.hasDefaultSolution(reportUI.getMetaDataPK().getFullName(), queryName)) {
                QuerySolutionInfo solution;
                defaultSolution = solution = iQuery.getDefaultSolution(reportUI.getClass().getName(), queryName);
                if (solution.getQueryPanelInfo().size() > 1) {
                    String className = "com.kingdee.eas.scm.common.client.PrecisionConfig4IMRptUI";
                    String panelClassName = null;
                    for (int i = 0; i < solution.getQueryPanelInfo().size(); ++i) {
                        QueryPanelInfo qpi;
                        panelClassName = solution.getQueryPanelInfo().get(i).getPanelClassName();
                        if (panelClassName == null || panelClassName.equals(className) || (qpi = solution.getQueryPanelInfo().get(i)) == null) continue;
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    }
                } else {
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    }
                }
            }
        }
        return cp;
    }

    public static CustomerParams[] getCustomerParams(boolean useDefaultSolution, CustomerQueryPanel userPanel, CoreUI reportUI, IMetaDataPK queryMetaDataPK) throws Exception {
        CustomerParams[] cps = null;
        userPanel.getUIContext().clear();
        userPanel.getUIContext().putAll(reportUI.getUIContext());
        if (useDefaultSolution) {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(queryMetaDataPK).getFullName();
            if (iQuery.hasDefaultSolution(reportUI.getMetaDataPK().getFullName(), queryName)) {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(reportUI.getClass().getName(), queryName);
                for (int i = 0; i < solution.getQueryPanelInfo().size(); ++i) {
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(i);
                    if (qpi == null || StringUtil.isEmpty(qpi.getPanelClassName())) continue;
                    if (cps == null) {
                        cps = new CustomerParams[2];
                    }
                    if (!"com.kingdee.eas.scm.common.client.PrecisionConfig4IMRptUI".equals(qpi.getPanelClassName())) {
                        cps[0] = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        continue;
                    }
                    cps[1] = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                }
            }
        }
        return cps;
    }

    public static void initQueryDialog(CustomerQueryPanel userPanel, CommonQueryDialog queryDialog, Map uiContext, IMetaDataPK queryMetaDataPK, String parentClassName, RptParams rptParams, RptParams contextInitRptParams) throws Exception {
        userPanel.loadFields();
        PrecisionConfig4IMRptUI pc = new PrecisionConfig4IMRptUI();
        pc.setPanelName(pc.getUITitle());
        Dimension dd = userPanel.getSize();
        queryDialog.setMaxReturnCountVisible(false);
        queryDialog.setWidth(dd.width);
        queryDialog.setHeight(dd.height);
        queryDialog.addUserPanel((KDPanel)userPanel);
        queryDialog.addUserPanel((KDPanel)pc);
        queryDialog.setOwner((Component)uiContext.get("Owner"));
        queryDialog.setTitle(userPanel.getUITitle());
        queryDialog.setQueryObjectPK(queryMetaDataPK);
        queryDialog.setShowFilter(false);
        queryDialog.setShowSorter(false);
        queryDialog.setParentUIClassName(parentClassName);
        Method m = userPanel.getClass().getMethod("onInit", RptParams.class);
        m.invoke((Object)userPanel, contextInitRptParams);
        userPanel.initLayout();
        if (rptParams != null) {
            userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)rptParams));
        }
    }

    public static void initQueryDialog(CustomerQueryPanel userPanel, CommonQueryDialog queryDialog, Map uiContext, IMetaDataPK queryMetaDataPK, String parentClassName, RptParams rptParams, RptParams contextInitRptParams, ArrayList notVisibleName) throws Exception {
        userPanel.loadFields();
        PrecisionConfig4IMRptUI pc = new PrecisionConfig4IMRptUI();
        if (notVisibleName != null) {
            for (int i = 0; i < notVisibleName.size(); ++i) {
                String name = notVisibleName.get(i).toString();
                if (name.equals("qty")) {
                    pc.getQtyLableContainer().setVisible(false);
                }
                if (name.equals("assqty")) {
                    pc.getAssQtyLableContainer().setVisible(false);
                }
                if (name.equals("price")) {
                    pc.getPriceLableContainer().setVisible(false);
                }
                if (!name.equals("amount")) continue;
                pc.getAmountLableContainer().setVisible(false);
            }
        }
        pc.setPanelName(pc.getUITitle());
        Dimension dd = userPanel.getSize();
        queryDialog.setMaxReturnCountVisible(false);
        queryDialog.setWidth(dd.width);
        queryDialog.setHeight(dd.height);
        queryDialog.addUserPanel((KDPanel)userPanel);
        queryDialog.addUserPanel((KDPanel)pc);
        queryDialog.setOwner((Component)uiContext.get("Owner"));
        queryDialog.setTitle(userPanel.getUITitle());
        queryDialog.setQueryObjectPK(queryMetaDataPK);
        queryDialog.setShowFilter(false);
        queryDialog.setShowSorter(false);
        queryDialog.setParentUIClassName(parentClassName);
        Method m = userPanel.getClass().getMethod("onInit", RptParams.class);
        m.invoke((Object)userPanel, contextInitRptParams);
        userPanel.initLayout();
        if (rptParams != null) {
            userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)rptParams));
        }
    }

    public static void initQueryDialog(CustomerQueryPanel userPanel, CommonQueryDialog queryDialog, Map uiContext, IMetaDataPK queryMetaDataPK, String parentClassName, RptParams rptParams, RptParams contextInitRptParams, ArrayList visibleName, boolean dynamicLayout) throws Exception {
        userPanel.loadFields();
        PrecisionConfig4IMRptUI pc = new PrecisionConfig4IMRptUI(dynamicLayout);
        int height = 10;
        if (visibleName != null) {
            for (int i = 0; i < visibleName.size(); ++i) {
                String name = visibleName.get(i).toString();
                if (name.equals("qty")) {
                    pc.getQtyLableContainer().setBounds(new Rectangle(10, height, 232, 19));
                    height += 25;
                    continue;
                }
                if (name.equals("assqty")) {
                    pc.getAssQtyLableContainer().setBounds(new Rectangle(10, height, 232, 19));
                    height += 25;
                    continue;
                }
                if (name.equals("price")) {
                    pc.getPriceLableContainer().setBounds(new Rectangle(10, height, 232, 19));
                    height += 25;
                    continue;
                }
                if (!name.equals("amount")) continue;
                pc.getAmountLableContainer().setBounds(new Rectangle(10, height, 232, 19));
                height += 25;
            }
        }
        if (!visibleName.contains("qty")) {
            pc.getQtyLableContainer().setVisible(false);
        }
        if (!visibleName.contains("assqty")) {
            pc.getAssQtyLableContainer().setVisible(false);
        }
        if (!visibleName.contains("price")) {
            pc.getPriceLableContainer().setVisible(false);
        }
        if (!visibleName.contains("amount")) {
            pc.getAmountLableContainer().setVisible(false);
        }
        pc.setPanelName(pc.getUITitle());
        Dimension dd = userPanel.getSize();
        queryDialog.setMaxReturnCountVisible(false);
        queryDialog.setWidth(dd.width);
        queryDialog.setHeight(dd.height);
        queryDialog.addUserPanel((KDPanel)userPanel);
        queryDialog.addUserPanel((KDPanel)pc);
        queryDialog.setOwner((Component)uiContext.get("Owner"));
        queryDialog.setTitle(userPanel.getUITitle());
        queryDialog.setQueryObjectPK(queryMetaDataPK);
        queryDialog.setShowFilter(false);
        queryDialog.setShowSorter(false);
        queryDialog.setParentUIClassName(parentClassName);
        Method m = userPanel.getClass().getMethod("onInit", RptParams.class);
        m.invoke((Object)userPanel, contextInitRptParams);
        userPanel.initLayout();
        if (rptParams != null) {
            userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)rptParams));
        }
    }

    public static QuerySolutionInfo getDefaultSolution() {
        return defaultSolution;
    }
}

