/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.CurrencyExchangeRateUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SCMUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.util.SCMUtils");
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    public static final BigDecimal BIGDECIMAL_ONE;
    public static final BigDecimal EXCHANGERATE_DEFAULT;
    public static final int PRECISION_DEFAUL = 2;
    public static final int PRECISION_DEFAUL_DB = 10;

    public static IObjectPK[] convertStringToObjectPK(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        int num = pkStrs.length;
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(pkStrs[i]);
        }
        return objectPk;
    }

    public static String getBillTypeNOFormBillTypeID(BillTypeInfo billType) {
        if (billType == null || billType.getId() == null) {
            return null;
        }
        return SCMUtils.getBillTypeNOFormBillTypeID(billType.getId());
    }

    public static String getBillTypeNOFormBillTypeID(BOSUuid id) {
        if (id == null) {
            return null;
        }
        return SCMUtils.getBillTypeNOFormBillTypeID(id.toString());
    }

    public static String getBillTypeNOFormBillTypeID(String billTypeID) {
        if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            return "110";
        }
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return "101";
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return "102";
        }
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return "103";
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return "104";
        }
        if ("XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeID)) {
            return "160";
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return "105";
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return "106";
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return "107";
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return "108";
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return "109";
        }
        if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            return "100";
        }
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID)) {
            return "410";
        }
        if ("3a3b5446-0106-1000-e000-01c3c0a812e6463ED552".equals(billTypeID)) {
            return "420";
        }
        if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billTypeID)) {
            return "230";
        }
        if ("510b6503-0105-1000-e000-0117c0a812fd463ED552".equals(billTypeID)) {
            return "330";
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billTypeID)) {
            return "210";
        }
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billTypeID)) {
            return "220";
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(billTypeID)) {
            return "310";
        }
        if ("510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(billTypeID)) {
            return "320";
        }
        if ("50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID)) {
            return "120";
        }
        if ("50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billTypeID)) {
            return "130";
        }
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            return "140";
        }
        if ("50957179-0105-1000-e004-4152c0a812fd463ED552".equals(billTypeID)) {
            return "150";
        }
        if ("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(billTypeID)) {
            return "901";
        }
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(billTypeID)) {
            return "250";
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(billTypeID)) {
            return "350";
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(billTypeID)) {
            return "141";
        }
        if ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) {
            return "121";
        }
        return null;
    }

    public static MultiMeasureUnitInfo getSaleMultiUnit(String meterialID, String saleOrgID) {
        MultiMeasureUnitInfo measureUnitInfo = null;
        try {
            IMaterialSales iMaterialSales = MaterialSalesFactory.getRemoteInstance();
            MaterialSalesInfo materialSaleOrgInfo = iMaterialSales.getSalesInfo(meterialID, saleOrgID);
            MeasureUnitInfo saleUnitInfo = materialSaleOrgInfo.getUnit();
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return measureUnitInfo;
    }

    public static MultiMeasureUnitInfo getPurMultiUnit(String meterialID, String purOrgID) {
        MultiMeasureUnitInfo measureUnitInfo = null;
        try {
            IMaterialPurchasing iMaterialPurchasing = MaterialPurchasingFactory.getRemoteInstance();
            MaterialPurchasingInfo materialPurInfo = iMaterialPurchasing.getPurchasingInfo(meterialID, purOrgID);
            MeasureUnitInfo saleUnitInfo = materialPurInfo.getUnit();
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return measureUnitInfo;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangePrecisionQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = SCMUtils.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = SCMUtils.effectualNumeric(baseQty).divide(SCMUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(Map mmuPrecisionsMap, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitInfo.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        MultiMeasureUnitInfo multiUnifInfo = null;
        MultiMeasureUnitCollection coll = multiUnit.getMultiMeasureUnitCollection(view);
        if (coll != null && coll.size() != 0) {
            multiUnifInfo = coll.get(0);
        }
        MultiMeasureUnitInfo othermultiUnifInfo = null;
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)otherUnitInfo.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        coll = multiUnit.getMultiMeasureUnitCollection(view);
        if (coll != null && coll.size() != 0) {
            othermultiUnifInfo = coll.get(0);
        }
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            mmuPrecisionsMap.put(materialID + multiUnifInfo.getMeasureUnit().getId().toString(), multiUnifInfo.getQtyPrecision());
            mmuPrecisionsMap.put(materialID + othermultiUnifInfo.getMeasureUnit().getId().toString(), othermultiUnifInfo.getQtyPrecision());
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = SCMUtils.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = SCMUtils.effectualNumeric(baseQty).divide(SCMUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public static final Map getMultiMeasureUnitMap(Set materialIdSet, Set unitIdSet) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hm = new HashMap<String, MultiMeasureUnitInfo>();
        if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
            EntityViewInfo entityViewInfo = SCMUtils.getMultiMeasureUnitEntityViewInfo(materialIdSet, unitIdSet);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    MultiMeasureUnitInfo mmuInfo = collection.get(i);
                    String key = mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString();
                    hm.put(key, mmuInfo);
                }
            }
        }
        return hm;
    }

    public static final EntityViewInfo getMultiMeasureUnitEntityViewInfo(Set materialIdSet, Set unitIdSet) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitIdSet, CompareType.INCLUDE));
        filterInfo.setMaskString("#0 and #1");
        SelectorItemCollection sic = entityViewInfo.getSelector();
        sic.add("*");
        sic.add("material.id");
        sic.add("measureUnit.id");
        return entityViewInfo;
    }

    public static BigDecimal getExchangePriceForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal price) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetPrice = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = SCMUtils.effectualExchangeRate(multiUnifInfo.getBaseConvsRate());
            BigDecimal baseExchangeRate2 = SCMUtils.effectualExchangeRate(othermultiUnifInfo.getBaseConvsRate());
            int scale = 28;
            BigDecimal basePrice = SCMUtils.effectualNumeric(price).divide(baseExchangeRate1, scale, 4);
            if (basePrice != null && price != null) {
                scale = basePrice.scale() + price.scale();
            }
            targetPrice = SCMUtils.effectualNumeric(basePrice).multiply(SCMUtils.effectualExchangeRate(baseExchangeRate2)).setScale(scale, 4);
        }
        return targetPrice;
    }

    public static BigDecimal getExchangePricesionQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal baseQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        if (multiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            baseQty = qty.multiply(baseExchangeRate1);
        }
        return baseQty;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, String unitInfoID, BigDecimal qty, String otherUnitInfoID) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfoID.toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfoID.toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1).setScale(16, 4);
            int scale = SCMUtils.effectualPrecision(othermultiUnifInfo.getQtyPrecision());
            targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(MultiMeasureUnitInfo multiUnifInfo, MultiMeasureUnitInfo othermultiUnifInfo, BigDecimal qty) {
        BigDecimal targetQty = qty;
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1).setScale(16, 4);
            targetQty = baseQty.divide(baseExchangeRate2, baseQty.scale() + qty.scale(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeRateQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mulUnit;
        BigDecimal baseExchangeRate = new BigDecimal("1.00");
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (material != null && unit != null && (mulUnit = immu.getMultiUnit(material.getId().toString(), unit.getId().toString())) != null && ((baseExchangeRate = mulUnit.getBaseConvsRate()) == null || new BigDecimal("0").compareTo(baseExchangeRate) == 0)) {
            baseExchangeRate = new BigDecimal("1.00");
        }
        return baseExchangeRate;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static Timestamp getSCMQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static Timestamp[] getDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(5, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static Timestamp getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        if (scmBillBaseInfo == null) {
            return false;
        }
        BillTypeInfo billType = scmBillBaseInfo.getSourceBillType();
        return billType != null;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String billTypeID) {
        if (SCMUtils.isBotpBill(scmBillBaseInfo)) {
            return scmBillBaseInfo.getSourceBillType().getId().toString().equalsIgnoreCase(billTypeID);
        }
        return false;
    }

    public static BigDecimal calculateLocalAmount(BigDecimal amount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal localAmount = new BigDecimal("0.00");
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                localAmount = amount.multiply(exchangeRateinfo.getConvertRate());
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                int scale = amount.scale() + exchangeRateinfo.getConvertRate().scale();
                localAmount = amount.divide(exchangeRateinfo.getConvertRate(), scale, 4);
            }
        } else {
            localAmount = amount;
        }
        return localAmount;
    }

    public static BigDecimal calculateOriginAmount(BigDecimal baseamount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal amount = new BigDecimal("0.00");
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                int scale = baseamount.scale() + exchangeRateinfo.getConvertRate().scale();
                amount = baseamount.divide(exchangeRateinfo.getConvertRate(), scale, 4);
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                amount = baseamount.multiply(exchangeRateinfo.getConvertRate());
            }
        } else {
            amount = baseamount;
        }
        return amount;
    }

    public static BigDecimal getExchangeRateAmount(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        BigDecimal exchangeRate = new BigDecimal("1.00");
        if (currencyInfo != null) {
            ObjectUuidPK sourceCurrPK = new ObjectUuidPK(SCMUtils.getCompanyBaseCurrency(ctx, ficompanyOrgInfo).getId().toString());
            ObjectUuidPK destCurrPK = new ObjectUuidPK(currencyInfo.getId());
            ObjectUuidPK excTablepk = null;
            ExchangeTableInfo exchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
                IExchangeRate iexchangRate = null;
                iexchangRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
                ExchangeRateInfo exchangeRateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                if (exchangeRateinfo != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("exchangeAux.*"));
                    exchangeRateinfo = iexchangRate.getExchangeRateInfo((IObjectPK)new ObjectUuidPK(exchangeRateinfo.getId()), sic);
                }
                if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRate.divide(exchangeRateinfo.getConvertRate(), 4);
                    } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRateinfo.getConvertRate();
                    }
                } else {
                    exchangeRate = new BigDecimal("1.00");
                }
            }
        }
        return exchangeRate;
    }

    public static CurrencyInfo getCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency();
            return currency;
        }
        ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static void releaseMutex(Uuid id) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static boolean requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        return mutexService.requestMutex(param);
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutextName, MutexLockType lockType) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(mutextName);
        param.setMutexLockType(lockType);
        return param;
    }

    public static String getResource(String resClassName, String key, Context ctx) {
        return SCMUtils.getString(resClassName, key, ctx.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static String getResource(String resClassName, String key, String[] params, Context ctx) {
        return SCMUtils.getString(resClassName, key, params, ctx.getLocale());
    }

    public static String getString(String resClassName, String resName, String[] params, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale, (Object[])params);
    }

    public static String toParamString(Iterator itor, List params) {
        int count = 0;
        Object o = null;
        if (params == null) {
            params = new ArrayList<String>();
        }
        StringBuffer paramString = new StringBuffer("(");
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(" ? ");
            params.add(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            paramString.append(")");
        }
        return paramString.toString();
    }

    public static BigDecimal calculateNumericForMulExchangeRate(BigDecimal numeric, ExchangeRateInfo rate, ExchangeRateInfo oldRate, int scale) {
        BigDecimal localNumeric = SCMUtils.convertAmountByExchangeRate(numeric, oldRate, 10);
        BigDecimal result = SCMUtils.effectualNumeric(numeric);
        if (rate != null) {
            ConvertModeEnum mode = rate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = SCMUtils.effectualNumeric(localNumeric).divide(SCMUtils.effectualExchangeRate(rate.getConvertRate()), SCMUtils.effectualPrecision(scale), 4);
                } else if (mode.getValue() == 1) {
                    result = SCMUtils.effectualNumeric(localNumeric).multiply(SCMUtils.effectualExchangeRate(rate.getConvertRate())).setScale(SCMUtils.effectualPrecision(scale), 4);
                }
            } else {
                result = SCMUtils.effectualNumeric(localNumeric).divide(SCMUtils.effectualExchangeRate(rate.getConvertRate()), SCMUtils.effectualPrecision(scale), 4);
            }
        }
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency, BigDecimal exchangeRate) throws BOSException, EASBizException {
        if (SCMUtils.equalsZero(amount) || currency == null || currency.getId() == null || company == null || company.getBaseCurrency() == null || company.getBaseCurrency().getId() == null || currency.getId().toString().equals(company.getBaseCurrency().getId().toString())) {
            return amount;
        }
        ExchangeRateInfo rateInfo = CurrencyExchangeRateUtils.getExchangeRate(ctx, company, currency, null);
        if (rateInfo == null) {
            throw new SCMBillException(SCMBillException.NULL_EXCHANGERATE);
        }
        if (!SCMUtils.equalsZero(exchangeRate)) {
            rateInfo.setConvertRate(SCMUtils.effectualExchangeRate(exchangeRate));
        }
        BigDecimal result = amount;
        result = SCMUtils.convertAmountByExchangeRate(result, rateInfo, PrecisionUtil.getCurrencyPrecisionByCompany(company));
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency) throws BOSException, EASBizException {
        return SCMUtils.convertAmountByCompany(ctx, amount, company, currency, null);
    }

    public static BigDecimal convertAmountByExchangeRate(BigDecimal amount, ExchangeRateInfo exchangeRate, int scale) {
        BigDecimal result = SCMUtils.effectualNumeric(amount);
        if (exchangeRate != null) {
            ConvertModeEnum mode = exchangeRate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = SCMUtils.effectualNumeric(amount).multiply(SCMUtils.effectualExchangeRate(exchangeRate.getConvertRate())).setScale(SCMUtils.effectualPrecision(scale), 4);
                } else if (mode.getValue() == 1) {
                    result = SCMUtils.effectualNumeric(amount).divide(SCMUtils.effectualExchangeRate(exchangeRate.getConvertRate()), SCMUtils.effectualPrecision(scale), 4);
                }
            } else {
                result = SCMUtils.effectualNumeric(amount).multiply(SCMUtils.effectualExchangeRate(exchangeRate.getConvertRate())).setScale(SCMUtils.effectualPrecision(scale), 4);
            }
        }
        return result;
    }

    public static int effectualPrecision(int scale) {
        return scale >= 0 ? scale : 2;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return SCMUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return SCMUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static boolean equalsID(ObjectBaseInfo val1, ObjectBaseInfo val2) {
        return val1 == null ? val2 == null : (val2 == null ? false : val1.getId().equals((Object)val2.getId()));
    }

    public static String getSqlFromHashSet(Set set) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (set != null && set.size() > 0) {
            String[] keys = set.toArray(new String[set.size()]);
            for (int i = 0; i < keys.length; ++i) {
                sqlBuffer.append("'" + keys[i] + "'");
                if (i >= keys.length - 1) continue;
                sqlBuffer.append(",");
            }
        }
        return sqlBuffer.toString();
    }

    public static boolean containsAllIsNull(Object[] objs) {
        if (objs == null) {
            return true;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEffectExistingQty(Context ctx, TransactionTypeInfo ttInfo) {
        if (null == ttInfo) {
            return false;
        }
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        try {
            invUpdateTypeInfo = ctx == null ? TransactionTypeFactory.getRemoteInstance().getDefaultInvUpdateType(ttInfo.getId().toString()) : TransactionTypeFactory.getLocalInstance((Context)ctx).getDefaultInvUpdateType(ttInfo.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return invUpdateTypeInfo == null ? false : invUpdateTypeInfo.isIsNotUpdateInv();
    }

    public static boolean isPresentStoreType(InvUpdateTypeInfo invUpdateTypeInfo, int billType) {
        StoreTypeInfo inWarehsType;
        boolean isPresentStore = false;
        StoreTypeInfo issueType = invUpdateTypeInfo == null ? null : invUpdateTypeInfo.getStoreTypePre();
        StoreTypeInfo storeTypeInfo = inWarehsType = invUpdateTypeInfo == null ? null : invUpdateTypeInfo.getStoreType();
        if (billType == 1 && issueType != null) {
            isPresentStore = "N5YMUAEgEADgAABPwKg/GpfUYaY=".equals(issueType.getId().toString());
        } else if (billType == 2 && inWarehsType != null) {
            isPresentStore = "N5YMUAEgEADgAABPwKg/GpfUYaY=".equals(inWarehsType.getId().toString());
        }
        return isPresentStore;
    }

    public static CostCenterOrgUnitInfo getCostCenterByOrgInfo(Context ctx, String companyOrgUnitInfoID, String adminOrgUnitInfoID) throws BOSException, EASBizException {
        String id;
        if (adminOrgUnitInfoID == null || companyOrgUnitInfoID == null) {
            return null;
        }
        CostCenterOrgUnitInfo costCenter = SCMUtils.getCostCenterByAdminOrgInfo(ctx, adminOrgUnitInfoID);
        Set ids = SCMUtils.getCostCenterByCompanyOrgInfo(ctx, companyOrgUnitInfoID);
        if (costCenter != null && ids.contains(id = costCenter.getId().toString())) {
            return costCenter;
        }
        return null;
    }

    public static CostCenterOrgUnitInfo getCostCenterByAdminOrgInfo(Context ctx, String adminOrgUnitInfoID) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo ret = null;
        IOrgUnitRelation iUnitRel = null;
        if (adminOrgUnitInfoID == null) {
            return null;
        }
        iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrgUnitInfoID, 0, 5);
        ret = (CostCenterOrgUnitInfo)orgCol.get(0);
        return ret;
    }

    public static Set getCostCenterByCompanyOrgInfo(Context ctx, String companyOrgUnitInfoID) throws BOSException, EASBizException {
        OrgUnitCollection orgCol;
        HashSet<String> ids = new HashSet<String>();
        IOrgUnitRelation iUnitRel = null;
        if (companyOrgUnitInfoID != null && (orgCol = (iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getFromUnit(companyOrgUnitInfoID, 1, 5)) != null && orgCol.size() > 0) {
            int n = orgCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo orgInfo = orgCol.get(i);
                ids.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", ids, CompareType.INCLUDE);
        FilterItemInfo filterItemIsBiz = new FilterItemInfo("isBizUnit", (Object)"1", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.getFilterItems().add(filterItemIsBiz);
        viewInfo.setFilter(filterInfo);
        ICostCenterOrgUnit iCostCenterOrgUnit = null;
        iCostCenterOrgUnit = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance() : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        CostCenterOrgUnitCollection col = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
        ids.clear();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            CostCenterOrgUnitInfo info = col.get(i);
            ids.add(info.getId().toString());
        }
        return ids;
    }

    public static Set getCostCenterByCou(Context ctx, String companyOrgUnitInfoID) throws BOSException, EASBizException {
        OrgUnitCollection orgCol;
        HashSet<String> ids = new HashSet<String>();
        IOrgUnitRelation iUnitRel = null;
        if (companyOrgUnitInfoID != null && (orgCol = (iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getFromUnit(companyOrgUnitInfoID, 1, 5)) != null && orgCol.size() > 0) {
            int n = orgCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo orgInfo = orgCol.get(i);
                ids.add(orgInfo.getId().toString());
            }
        }
        return ids;
    }

    public static Set getCostCenterByCompanyOrgInfo(Context ctx, Set companyOrgUnitInfoIDs) throws BOSException, EASBizException {
        HashSet ids = new HashSet();
        if (companyOrgUnitInfoIDs != null && companyOrgUnitInfoIDs.size() > 0) {
            String companyOrgUnitInfoID = null;
            Iterator iterator = companyOrgUnitInfoIDs.iterator();
            while (iterator.hasNext()) {
                companyOrgUnitInfoID = iterator.next().toString();
                Set tempSet = SCMUtils.getCostCenterByCompanyOrgInfo(ctx, companyOrgUnitInfoID);
                ids.addAll(tempSet);
            }
        }
        return ids;
    }

    public static String[] mergeStringArr(String[] arr1, String[] arr2) {
        if (arr1 == null || arr2 == null) {
            return null;
        }
        String[] mergedArr = new String[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, mergedArr, 0, arr1.length);
        System.arraycopy(arr2, 0, mergedArr, arr1.length, arr2.length);
        return mergedArr;
    }

    public static ExchangeRateInfo getExchangeRateInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourcecurrencyInfo, CurrencyInfo baseCurrency, Date bizDate) throws EASBizException, BOSException {
        if (companyOrgUnitInfo == null || sourcecurrencyInfo == null || baseCurrency == null) {
            return null;
        }
        ExchangeRateInfo defaultExchangeRateInfo = null;
        defaultExchangeRateInfo = new ExchangeRateInfo();
        ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
        auxInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        auxInfo.setPrecision(2);
        defaultExchangeRateInfo.setConvertRate(BigDecimal.ONE);
        defaultExchangeRateInfo.setExchangeAux(auxInfo);
        CurrencyInfo baseCurrInfo = baseCurrency;
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        sourceCurrPK = new ObjectUuidPK(sourcecurrencyInfo.getId());
        destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
        ExchangeRateInfo tempexrateinfo = null;
        if (baseCurrInfo.getId().equals((Object)sourcecurrencyInfo.getId())) {
            tempexrateinfo = defaultExchangeRateInfo;
        } else {
            ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
            ObjectUuidPK excTablepk = null;
            if (exchangeTableInfo == null) {
                return null;
            }
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
            tempexrateinfo = ctx == null ? SCMBillCommonFacadeFactory.getRemoteInstance().getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, bizDate) : SCMBillCommonFacadeFactory.getLocalInstance(ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, bizDate);
        }
        return tempexrateinfo;
    }

    static {
        EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE = new BigDecimal("1.0");
    }
}

