/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class WriteBack2RoadCostBillSQLHelper {
    public static String createRCWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_RoadCostBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_RoadCostBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillentry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_AR_OtherBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append(" AND ABS(srcEntry.FAssociateQty) < ABS(destEntry.FBaseQty) ");
            } else {
                sql.append(" AND srcEntry.FAssociateQty < 0 ");
            }
        }
        return sql.toString();
    }

    public static void verifyRCWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        boolean isError = false;
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2RCResource.RoadCostBill_WBERROR")).append("\n");
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.QTYFLOWOFF")).append("\n");
        while (rs.next()) {
            isError = true;
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2RCResource.RoadCostBillNO")).append(":");
            sql.append(rs.getString("srcNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("srcSeq"));
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.AR"));
                }
            }
            sql.append(rs.getString("destNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("destSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getAR2RCTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FMeasureUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8),");
        sql.append("FRecievePayAmount DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getAR2RCInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FMeasureUnitID,");
        sql.append(" SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQty, SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AR_OtherBillentry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FMeasureUnitID ");
        return sql.toString();
    }

    public static String createAR2RCWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_RoadCostBillEntry AS T1 SET ");
        sql.append("(FAssociateQty, FTotalArQty, FTotalArAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT srcEntry.FAssociateQty - tmp.FBaseQty,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FMeasureUnitID THEN srcEntry.FTotalArQty + tmp.FQty ");
            sql.append(" ELSE ROUND((srcEntry.FTotalArQty + tmp.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append(" srcEntry.FTotalArAmount + tmp.FRecievePayAmount ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT srcEntry.FAssociateQty + tmp.FBaseQty,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FMeasureUnitID THEN srcEntry.FTotalArQty - tmp.FQty ");
            sql.append(" ELSE ROUND((srcEntry.FTotalArQty - tmp.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append(" srcEntry.FTotalArAmount - tmp.FRecievePayAmount ");
        }
        sql.append("FROM T_DT_RoadCostBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }
}

