/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class WriteBackFromCarryBillSQLHelper {
    public static String createCBWriteBackVerifySQL(Context ctx, String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_SD_PostRequisitionEntry srcEntry ");
            sql.append("INNER JOIN T_SD_PostRequisition src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FCoreBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND srcEntry.FAssociateQty < 0 ");
            }
        }
        if (isWriteCore[1]) {
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_SD_SaleOrderEntry srcEntry ");
            sql.append("INNER JOIN T_SD_SaleOrder src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FCoreBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND srcEntry.FQuantityUnCtrl = 0 ");
                sql.append("AND (((srcEntry.FQty - srcEntry.FPlanDeliveryQty+srcEntry.FTotalSupplyStockQty) * -1 > isNull(srcEntry.FSendOverRate,0) / 100 * srcEntry.FQty)) ");
            }
        }
        if (isWriteCore[2]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 3 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_StockTransferBillEntry srcEntry ");
            sql.append("INNER JOIN T_IM_StockTransferBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FCoreBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append(" AND (srcEntry.FQuarityUnCtrl = 0 or srcEntry.FQuarityUnCtrl is null) ");
                sql.append(" AND (srcEntry.FTotalPlanDQty - srcEntry.FQty) * 100 > isNull(srcEntry.FQuarityOverRate,0) * srcEntry.FQty ");
            }
        }
        if (isWriteCore[3]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 4 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_SM_PurOrderEntry srcEntry ");
            sql.append("INNER JOIN T_SM_PurOrder src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FCoreBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND srcEntry.FIsQuantityUnCtrl = 0 ");
                sql.append("AND (srcEntry.FPlanReceiveQty - srcEntry.FQty) * 100 > isNull(srcEntry.FReceiveOverRate,0) * srcEntry.FQty ");
            }
        }
        if (isWriteCore.length > 4 && isWriteCore[4]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 5 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_TransferOrderBillEntry srcEntry ");
            sql.append("INNER JOIN T_IM_TransferOrderBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FCoreBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ((srcEntry.FNotControlQty = 0 OR srcEntry.FNotControlQty IS NULL) ");
                sql.append("AND 0 > srcEntry.FUnIssueBaseQty * (1 + (CASE WHEN srcEntry.FQtyOverRate IS NULL THEN 0 ELSE srcEntry.FQtyOverRate END) / 100) ");
                sql.append("AND (srcEntry.FPlanDeliveryQty) > srcEntry.FQty  * (1 + (CASE WHEN srcEntry.FQtyOverRate IS NULL THEN 0 ELSE srcEntry.FQtyOverRate END) / 100))");
            }
        }
        if (isWriteCore.length > 5 && isWriteCore[5]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            boolean isWeight = false;
            String tempSql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='CFisWeight' AND KSQL_COL_TABNAME='T_SD_SaleReturnsEntry'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tempSql);
                if (rs != null && rs.next()) {
                    isWeight = true;
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            sql.append("SELECT 6 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_SD_SaleReturnsEntry srcEntry ");
            sql.append("INNER JOIN T_SD_SaleReturns src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_CarryBillEntry destEntry ON destEntry.FSourceBillEntryID=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_CarryBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            sql.append("AND srcEntry.FQuantityUnCtrl = 0 ");
            if (isWeight) {
                sql.append("AND ((CFisWeight = 1 AND (srcEntry.FPlanDeliveryQty - srcEntry.CFSupplyQty)>0)");
                sql.append(" OR (CFisWeight = 0 AND (srcEntry.FPlanDeliveryQty - srcEntry.FQty)>0))");
            } else {
                sql.append("AND (srcEntry.FPlanDeliveryQty - srcEntry.FQty)>0");
            }
        }
        return sql.toString();
    }

    public static void verifyCBWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        boolean isError = false;
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.QTYFLOWOFF")).append("\n");
        while (rs.next()) {
            isError = true;
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.CARRYBILLNO")).append(":");
            sql.append(rs.getString("destNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("destSeq"));
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.POSTREQUISITION")).append(":");
                    break;
                }
                case 2: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.SALEORDER")).append(":");
                    break;
                }
                case 3: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.STOCKTRANSFER")).append(":");
                    break;
                }
                case 4: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.PURORDER")).append(":");
                    break;
                }
                case 5: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.TRANSFERORDER")).append(":");
                    break;
                }
                case 6: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.SALERETURNS")).append(":");
                }
            }
            sql.append(rs.getString("srcNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("srcSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getCB2SOTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2SOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2SOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty, FTotalUnIssueQty, FTotalUnIssueBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalUnIssueQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalUnIssueQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FTotalUnIssueBaseQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalUnIssueQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalUnIssueQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FTotalUnIssueBaseQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_SD_SaleOrderEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String createCB2SOWriteSQL4FromPRQ(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty )=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        }
        sql.append("FROM T_SD_SaleOrderEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getCB2STTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2STInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2STWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry AS T1 SET ");
        sql.append("(FTotalPlanDQty, FUnIssueBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalPlanDQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalPlanDQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FUnIssueBaseQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalPlanDQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalPlanDQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FUnIssueBaseQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_IM_StockTransferBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getCB2TOTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2TOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2TOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty, FUnIssueBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FUnIssueBaseQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FUnIssueBaseQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_IM_TransferOrderBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getCB2PRQTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2PRQInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2PRQWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_PostRequisitionEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FAssociateQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FAssociateQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_SD_PostRequisitionEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String createCB2SOForPRQWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FID, FPlanDeliveryQty )=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT srcEntry.FID,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT srcEntry.FID,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        }
        sql.append("FROM T_SD_SaleOrderEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String createCB2STForPRQWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry AS T1 SET ");
        sql.append("(FTotalPlanDQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalPlanDQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalPlanDQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalPlanDQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalPlanDQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
        }
        sql.append("FROM T_IM_StockTransferBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getCB2POTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2POInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2POWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SM_PurOrderEntry AS T1 SET ");
        sql.append("(FPlanReceiveQty, FTotalUnReceiveQty, FTotalUnReceiveBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" srcEntry.FPlanReceiveQty + (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END),");
            sql.append(" srcEntry.FTotalUnReceiveQty - (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END),");
            sql.append(" srcEntry.FTotalUnReceiveBaseQty - tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" srcEntry.FPlanReceiveQty - (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END),");
            sql.append(" srcEntry.FTotalUnReceiveQty + (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END),");
            sql.append(" srcEntry.FTotalUnReceiveBaseQty + tmp.FBaseQty ");
        }
        sql.append("FROM T_SM_PurOrderEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getCB2SRTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2SRInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleReturnsEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty, FPlanDeliveryBaseQty, FRemainingQty, FRemainingBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FPlanDeliveryBaseQty+tmp.FBaseQty, ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FRemainingQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FRemainingQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FRemainingBaseQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FPlanDeliveryBaseQty-tmp.FBaseQty, ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FRemainingQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FRemainingQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FRemainingBaseQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_SD_SaleReturnsEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append(" INNER JOIN T_BD_Material mat ON mat.FID=srcEntry.FMaterialID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID AND mat.FIsWeighted=0)");
        return sql.toString();
    }

    public static String createCB2SOForSRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FReturnPlanDeliveryQty, FReturnPlanDeliveryBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReturnPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReturnPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FReturnPlanDeliveryBaseQty+tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReturnPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReturnPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FReturnPlanDeliveryBaseQty-tmp.FBaseQty ");
        }
        sql.append("FROM T_SD_SaleOrderEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append(" INNER JOIN T_BD_Material mat ON mat.FID=srcEntry.FMaterialID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID AND mat.FIsWeighted=0)");
        return sql.toString();
    }
}

