/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.validate.CurrencyDeal;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractCurrencyDeal
implements CurrencyDeal {
    private Context ctx;
    private List<String> sourceBillIds;

    public AbstractCurrencyDeal(Context ctx, List<String> sourceBillIds) {
        this.ctx = ctx;
        this.sourceBillIds = sourceBillIds;
    }

    @Override
    public final String getCurrency() throws BOSException, EASBizException {
        if (null == this.sourceBillIds || this.sourceBillIds.isEmpty()) {
            return null;
        }
        return this.getCurrencyId();
    }

    protected abstract String getCurrencyFieldName();

    protected abstract String getTableName();

    private String getCurrencyId() throws BOSException, EASBizException {
        String currencyFieldName = this.getCurrencyFieldName();
        String query = "select DISTINCT " + currencyFieldName + " from " + this.getTableName() + " where FID IN " + AbstractCurrencyDeal.transList2String(this.sourceBillIds);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)query);
        if (rs.size() > 1) {
            throw new SCMBillException(SCMBillException.SOURCE_BILL_CURRENCY_NOT_CONSISTENT);
        }
        try {
            if (rs.next()) {
                return rs.getString(currencyFieldName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String transList2String(List<String> list) {
        String ids = "";
        for (String idStr : list) {
            if (idStr == null || !BOSUuid.isValid((String)idStr.toString(), (boolean)true)) continue;
            ids = ids + "'" + idStr + "',";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return "(" + ids + ")";
    }
}

