/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.validate.AbstractCurrencyDeal;
import com.kingdee.eas.scm.common.validate.CurrencyDeal;
import com.kingdee.eas.scm.common.validate.CurrencyDealConfig;
import com.kingdee.eas.scm.common.validate.DefaultCurrencyDeal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralCurrencyDealBuilder
implements CurrencyDeal {
    private List<String> sourceBillIds = Collections.emptyList();
    private String bosType;
    private String descBosType;
    private final Context ctx;
    private static final CurrencyDeal defaultChecker = new DefaultCurrencyDeal();
    private static final List<String> specialBosType = Arrays.asList("8B07BBDB", "15F2BD83", "500AB75E");
    private static final Map<String, CurrencyDealConfig> configMap = new HashMap<String, CurrencyDealConfig>();
    private static final Map<String, List<String>> checkMap = new HashMap<String, List<String>>();

    public GeneralCurrencyDealBuilder(Context ctx, List<String> sourceBillIds, String descBosType) {
        if (null != sourceBillIds) {
            this.sourceBillIds = sourceBillIds;
            this.bosType = BOSUuid.read((String)sourceBillIds.get(0)).getType().toString();
        }
        this.descBosType = descBosType;
        this.ctx = ctx;
    }

    public GeneralCurrencyDealBuilder(Context ctx, List<String> sourceBillIds, List<String> coreBillIds, String descBosType) throws SCMBillException {
        this(ctx, sourceBillIds, descBosType);
        if (null == descBosType || null == checkMap.get(descBosType) || !checkMap.get(descBosType).contains(this.bosType)) {
            this.sourceBillIds = Collections.emptyList();
            return;
        }
        if (specialBosType.contains(this.bosType)) {
            if (null == coreBillIds || coreBillIds.isEmpty()) {
                this.sourceBillIds = Collections.emptyList();
                return;
            }
            this.sourceBillIds = coreBillIds;
            this.bosType = BOSUuid.read((String)coreBillIds.get(0)).getType().toString();
        }
    }

    private CurrencyDeal build() {
        return this.getCheckerConfig();
    }

    private CurrencyDeal getCheckerConfig() {
        try {
            String table = FMIsqlFacadeFactory.getLocalInstance((Context)this.ctx).getTableNameByBosType(BOSObjectType.create((String)this.bosType));
            String currencyFieldName = "FCurrencyID";
            return this.constructChecker(currencyFieldName, table);
        }
        catch (Exception e) {
            return defaultChecker;
        }
    }

    private CurrencyDeal constructChecker(final String currencyFieldName, final String tableName) {
        AbstractCurrencyDeal checker = new AbstractCurrencyDeal(this.ctx, this.sourceBillIds){

            @Override
            protected String getCurrencyFieldName() {
                return currencyFieldName;
            }

            @Override
            protected String getTableName() {
                return tableName;
            }
        };
        return checker;
    }

    @Override
    public String getCurrency() throws BOSException, EASBizException {
        return this.build().getCurrency();
    }

    static {
        List<String> purInWarehsBillList = Arrays.asList("3171BFAD", "15F2BD83", "CC3E933B", "8B07BBDB", "5C2A1F0C", "783061E3", "256D05E2", "500AB75E", "F99EE589");
        checkMap.put("783061E3", purInWarehsBillList);
        List<String> saleIssueBillList = Arrays.asList("C48A423A", "9CA9D08F", "783061E3", "8B07BBDB", "5C2A1F0C", "CC3E933B", "546F192F");
        checkMap.put("CC3E933B", saleIssueBillList);
    }
}

