/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.verify;

import com.kingdee.bos.ctrl.data.modal.DataConvertHelper;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.BOSUuid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public final class ValidationUtils {
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String ? ((String)value).length() == 0 : (value instanceof BigDecimal ? ((BigDecimal)value).compareTo(ZERO) == 0 : (value instanceof Boolean ? (Boolean)value == false : (value instanceof Integer ? (Integer)value == 0 : (value instanceof IObjectCollection ? ((IObjectCollection)value).size() == 0 : (value instanceof Collection ? ((Collection)value).size() == 0 : value instanceof Map && ((Map)value).size() == 0)))));
    }

    private static Object insteadOfNull(Object value, DataType dataType) {
        if (value != null) {
            return value;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            return "";
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return Boolean.FALSE;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return ZERO;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return Integer.valueOf("0");
        }
        if (dataType.equals((Object)DataType.SHORT)) {
            return Short.valueOf("0");
        }
        if (dataType.equals((Object)DataType.LONG)) {
            return Long.valueOf("0");
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            return Float.valueOf("0.00");
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            return Double.valueOf("0.00");
        }
        return null;
    }

    public static boolean doRealValidate(Object value, String validation) {
        if (validation.equalsIgnoreCase("REQUIRED")) {
            return ValidationUtils.isEmpty(value);
        }
        return ValidationUtils.doRealCompare(value, null, validation, null, null);
    }

    public static boolean isEquals(Object object, Object val, DataType dataType, String className) {
        if (object == null && val == null) {
            return true;
        }
        if (val == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (dataType.equals((Object)DataType.BOOLEAN) && object instanceof Integer) {
            Boolean o = Boolean.TRUE;
            if ((Integer)object == 0) {
                o = Boolean.FALSE;
            }
            return o.equals(val);
        }
        if (!(object instanceof Comparable) || !(val instanceof Comparable)) {
            return object.equals(val);
        }
        return ValidationUtils.compare(object, val, "=");
    }

    private static Object convert(Object obj, String val, DataType dataType, String className) {
        try {
            Object covertedValue = null;
            if (dataType.equals((Object)DataType.ENUM)) {
                if (obj instanceof Integer) {
                    covertedValue = ValidationUtils.stringConvert(val, DataType.INTEGER, className);
                }
            } else {
                if (dataType.equals((Object)DataType.BOSUUID)) {
                    return BOSUuid.read((String)val);
                }
                covertedValue = ValidationUtils.stringConvert(val, dataType, className);
            }
            return covertedValue;
        }
        catch (DataConvertHelper.DataConvertException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static boolean compare(Object obj, Object val, String operator) {
        if (obj == null || val == null) {
            return false;
        }
        if (!(obj instanceof Comparable)) {
            throw new UnsupportedOperationException("The Object " + obj + " is not supported comparing.");
        }
        int result = ((Comparable)obj).compareTo(val);
        if (operator.equals("=")) {
            return result == 0;
        }
        if (operator.equals("<>")) {
            return result != 0;
        }
        if (operator.equals(">")) {
            return result > 0;
        }
        if (operator.equals("<")) {
            return result < 0;
        }
        if (operator.equals(">=")) {
            return result >= 0;
        }
        if (operator.equals("<=")) {
            return result <= 0;
        }
        throw new UnsupportedOperationException(operator + " is not supported.");
    }

    public static boolean doRealCompare(Object obj, Object val, String operator, DataType dataType, String className) {
        if (operator.equals("isNull")) {
            return obj == null;
        }
        if (operator.equals("isNotNull")) {
            return obj != null;
        }
        Object object = ValidationUtils.insteadOfNull(obj, dataType);
        Object covertedValue = val;
        if (!(object instanceof String) && val instanceof String) {
            covertedValue = ValidationUtils.convert(object, (String)val, dataType, className);
        }
        if (operator.equals("=")) {
            return ValidationUtils.isEquals(object, covertedValue, dataType, className);
        }
        if (operator.equals("<>")) {
            return !ValidationUtils.isEquals(object, covertedValue, dataType, className);
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Comparable) || !(covertedValue instanceof Comparable)) {
            return object.equals(covertedValue);
        }
        return ValidationUtils.compare(object, covertedValue, operator);
    }

    public static Object stringConvert(String val, DataType dataType, String className) throws DataConvertHelper.DataConvertException {
        String str = val;
        if (dataType.equals((Object)DataType.STRING)) {
            return str;
        }
        if (dataType.equals((Object)DataType.ENUM)) {
            try {
                Class<?> clzEnum = Class.forName(className);
                return clzEnum.getField(val).get(val);
            }
            catch (ClassNotFoundException e) {
                throw new DataConvertHelper.DataConvertException("The datatype's className is not a valid Enum class.");
            }
            catch (IllegalArgumentException e) {
                throw new DataConvertHelper.DataConvertException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new DataConvertHelper.DataConvertException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DataConvertHelper.DataConvertException((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new DataConvertHelper.DataConvertException((Throwable)e);
            }
        }
        if (dataType.equals((Object)DataType.OBJECTPK)) {
            return new ObjectStringPK(val);
        }
        return DataConvertHelper.convertData((Object)val, (com.kingdee.bos.ctrl.common.DataType)ValidationUtils.dataTypeAdapting(dataType));
    }

    private static com.kingdee.bos.ctrl.common.DataType dataTypeAdapting(DataType dataType) throws DataConvertHelper.DataConvertException {
        if (dataType.equals((Object)DataType.STRING)) {
            return com.kingdee.bos.ctrl.common.DataType.STRING;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return com.kingdee.bos.ctrl.common.DataType.BOOLEAN;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return com.kingdee.bos.ctrl.common.DataType.DECIMAL;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) {
            return com.kingdee.bos.ctrl.common.DataType.DATETIME;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return com.kingdee.bos.ctrl.common.DataType.INTEGER;
        }
        if (dataType.equals((Object)DataType.SHORT)) {
            return com.kingdee.bos.ctrl.common.DataType.SHORT;
        }
        if (dataType.equals((Object)DataType.LONG)) {
            return com.kingdee.bos.ctrl.common.DataType.LONG;
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            return com.kingdee.bos.ctrl.common.DataType.FLOAT;
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            return com.kingdee.bos.ctrl.common.DataType.DOUBLE;
        }
        if (dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.CHAR)) {
            return com.kingdee.bos.ctrl.common.DataType.BYTE;
        }
        throw new DataConvertHelper.DataConvertException("does not support the dataType " + dataType);
    }
}

