/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BizChainLogger;
import com.kingdee.eas.scm.framework.dataloader.DefaultDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.BatchValidationException;
import com.kingdee.eas.scm.framework.validator.DefaultValidationResult;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.util.LowTimer;
import java.util.List;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validate(IObjectValue bean, List<IVRule> vRuleList, IDataCache dataCache, BizChainLogger logger) throws BOSException, EASBizException {
        assert (bean != null);
        if (vRuleList == null) {
            return;
        }
        LowTimer timer = new LowTimer();
        dataCache = dataCache == null ? new DefaultDataCache() : dataCache;
        int size = vRuleList.size();
        for (int i = 0; i < size; ++i) {
            IVRule vRule = vRuleList.get(i);
            timer.reset();
            if (null != vRule && vRule.supports(bean.getClass())) {
                vRule.setInjectData(dataCache);
                vRule.validate(bean);
            }
            if (logger == null) continue;
            logger.debug(vRule.getClass().getSimpleName() + " exec time: " + timer.msValue());
        }
    }

    public static void validate(IObjectCollection beanCol, List<IVRule> vRuleList, IDataCache dataCache, BizChainLogger logger) throws BOSException, BatchValidationException, EASBizException {
        assert (beanCol != null);
        if (beanCol.size() == 0) {
            return;
        }
        if (beanCol.size() == 1) {
            ValidationUtils.validate(beanCol.getObject(0), vRuleList, dataCache, logger);
            return;
        }
        DefaultValidationResult validationResult = new DefaultValidationResult();
        dataCache = dataCache != null ? dataCache : new DefaultDataCache();
        int size = beanCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue bean = beanCol.getObject(i);
            try {
                if (null == vRuleList) continue;
                ValidationUtils.validate(bean, vRuleList, dataCache, logger);
                continue;
            }
            catch (EASBizException ex) {
                String id = bean.get("id").toString();
                validationResult.addFailure((IObjectPK)new ObjectStringPK(id), ex);
            }
        }
        validationResult.throwExceptionIfHasFialed();
    }
}

