/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation.impl;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.MaxValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.AbstractPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.ObjectTypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MaxValidator
extends AbstractPropertyValidator
implements IPropertyValidator {
    @Override
    protected PropertyValidationError doValidation(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        Object fieldValue = this.getPropertyValue(bean, propertyDesc);
        if (null == fieldValue) {
            PropertyValidationError error = this.getErrorInfo(bean, propertyDesc);
            error.setErrorType(PropertyValidationError.ERRORTYPE.ISNULL);
            return error;
        }
        MaxValidatorDesc desc = (MaxValidatorDesc)propertyDesc;
        boolean isValid = true;
        if (ObjectTypeUtils.isBigDecimal(fieldValue)) {
            BigDecimal bigDecimal = (BigDecimal)fieldValue;
            BigDecimal max = new BigDecimal(desc.getMax());
            isValid = bigDecimal.compareTo(max) != 1;
        } else if (ObjectTypeUtils.isBigInteger(fieldValue)) {
            BigDecimal bigDecimal = new BigDecimal((BigInteger)fieldValue);
            BigDecimal max = new BigDecimal(desc.getMax());
            isValid = bigDecimal.compareTo(max) != 1;
        } else if (ObjectTypeUtils.isString(fieldValue)) {
            BigDecimal bigDecimal = new BigDecimal((String)fieldValue);
            BigDecimal max = new BigDecimal(desc.getMax());
            isValid = bigDecimal.compareTo(max) != 1;
        } else if (ObjectTypeUtils.isByte(fieldValue)) {
            long d = ((Byte)fieldValue).longValue();
            isValid = d < desc.getMax();
        } else if (ObjectTypeUtils.isShort(fieldValue)) {
            long d = ((Short)fieldValue).longValue();
            isValid = d < desc.getMax();
        } else if (ObjectTypeUtils.isInteger(fieldValue)) {
            long d = ((Integer)fieldValue).longValue();
            isValid = d < desc.getMax();
        } else if (ObjectTypeUtils.isLong(fieldValue)) {
            long d = (Long)fieldValue;
            boolean bl = isValid = d < desc.getMax();
        }
        if (!isValid) {
            return this.getErrorInfo(bean, desc);
        }
        return null;
    }

    @Override
    protected PropertyValidationError.ERRORTYPE errorType() {
        return PropertyValidationError.ERRORTYPE.OUTOFMAX;
    }
}

