/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CheckBillNumberVRule
implements IVRule {
    private Context ctx;
    Map<String, Object> numberMap = new HashMap<String, Object>();

    public CheckBillNumberVRule(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public void setInjectData(IDataCache dataCache) {
    }

    @Override
    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillBaseInfo info = (SCMBillBaseInfo)bean;
        if (info.getNumber() == null) {
            throw new SCMBillException(SCMBillException.CHECKBILLNUMBLANK, new Object[]{info.getString("number")});
        }
        if (this.isSameNumber(this.ctx, (IObjectValue)info) || this.isSameNumber(this.ctx, info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getString("number"), ""});
        }
    }

    protected boolean isSameNumber(Context ctx, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        if (this.numberMap.containsKey(number)) {
            return true;
        }
        this.numberMap.put(number, null);
        return false;
    }

    protected boolean isSameNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        filter = this.getCheckNumberFilterInfo(ctx, model);
        if (filter == null) {
            return false;
        }
        return this.exists(ctx, filter, aSCMBillBaseInfo.getBOSType());
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(SCMBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean exists(Context ctx, FilterInfo filter, BOSObjectType bostype) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn, bostype).exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private IORMappingDAO getDAO(Context ctx2, Connection cn, BOSObjectType bosType) {
        return ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)this.ctx, (Connection)cn);
    }

    public FilterInfo getCheckNumberFilterInfo(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return filter;
    }
}

