/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.validator.expression.ExpressionUtils;
import com.kingdee.eas.scm.framework.validator.expression.IExprValue;
import com.kingdee.eas.scm.framework.validator.expression.ObjectValue;
import com.kingdee.eas.scm.framework.validator.expression.ValueType;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class EvaluationExpressions {
    private String expression;
    private List<Node> postfixList;
    private static final String ERROR_RESOURCE = "com.kingdee.eas.scm.common.validator.beanvalidation.ValidationResource";

    public EvaluationExpressions(String expression) throws BOSException {
        this.expression = expression;
        this.parse();
    }

    public IExprValue getValue(IObjectValue info) throws BOSException {
        return this.execute(info);
    }

    private IExprValue execute(IObjectValue info) throws BOSException {
        if (null == this.postfixList || this.postfixList.size() == 0) {
            return new ObjectValue(ValueType.NULL, null);
        }
        Stack<IExprValue> operandStack = new Stack<IExprValue>();
        for (Node node : this.postfixList) {
            IExprValue objValue;
            if (NodeType.OPERATOR.equals((Object)node.getType())) {
                IExprValue result;
                IExprValue objVal2 = (IExprValue)operandStack.pop();
                IExprValue objVal1 = (IExprValue)operandStack.pop();
                if (null == objVal1 || null == objVal2) {
                    return new ObjectValue(ValueType.NULL, null);
                }
                Character ch = (Character)node.getValue();
                switch (ch.charValue()) {
                    case '+': {
                        result = this.add(objVal1, objVal2);
                        break;
                    }
                    case '-': {
                        result = this.sub(objVal1, objVal2);
                        break;
                    }
                    case '*': {
                        result = this.mul(objVal1, objVal2);
                        break;
                    }
                    case '/': {
                        result = this.div(objVal1, objVal2);
                        break;
                    }
                    case '%': {
                        result = this.mod(objVal1, objVal2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ExtendLogicNotRealize", null));
                    }
                }
                operandStack.push(result);
                continue;
            }
            if (NodeType.CONSTANT.equals((Object)node.getType())) {
                objValue = (IExprValue)node.getValue();
                operandStack.push(objValue);
                continue;
            }
            if (!NodeType.VARIABLE.equals((Object)node.getType())) continue;
            String fieldName = (String)node.getValue();
            objValue = this.getVariableValue(fieldName, info);
            operandStack.push(objValue);
        }
        if (operandStack.size() > 0) {
            return (IExprValue)operandStack.pop();
        }
        return new ObjectValue(ValueType.NULL, null);
    }

    private IExprValue add(IExprValue objVal1, IExprValue objVal2) throws BOSException {
        if (ValueType.STRING.equals((Object)objVal1.getType()) || ValueType.STRING.equals((Object)objVal2.getType())) {
            String s = objVal1.getValue().toString() + objVal2.getValue().toString();
            return new ObjectValue(ValueType.STRING, s);
        }
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return new ObjectValue(ValueType.NUMBER, b1.add(b2));
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ComputeEr_Add", null));
    }

    private IExprValue sub(IExprValue objVal1, IExprValue objVal2) throws BOSException {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return new ObjectValue(ValueType.NUMBER, b1.subtract(b2));
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ComputeEr_Sub", null));
    }

    private IExprValue mul(IExprValue objVal1, IExprValue objVal2) throws BOSException {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return new ObjectValue(ValueType.NUMBER, b1.multiply(b2));
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ComputeEr_Multi", null));
    }

    private IExprValue div(IExprValue objVal1, IExprValue objVal2) throws BOSException {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return new ObjectValue(ValueType.NUMBER, b1.divide(b2, 16, RoundingMode.HALF_UP));
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ComputeEr_Divide", null));
    }

    private IExprValue mod(IExprValue objVal1, IExprValue objVal2) throws BOSException {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            BigInteger bi1 = b1.toBigInteger();
            BigInteger bi2 = b2.toBigInteger();
            return new ObjectValue(ValueType.NUMBER, new BigDecimal(bi1.mod(bi2)));
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ComputeEr_Mod", null));
    }

    private IExprValue getVariableValue(String variable, IObjectValue info) throws BOSException {
        Object obj;
        if (variable == null) {
            return null;
        }
        String fulField = variable;
        Object subObj = info;
        while (fulField.indexOf(".") != -1 && subObj != null) {
            String field = fulField.substring(0, fulField.indexOf("."));
            subObj = this.getObjectFieldValue(subObj, field);
            fulField = fulField.substring(fulField.indexOf(".") + 1);
        }
        Object object = obj = subObj != null ? this.getObjectFieldValue(subObj, fulField) : null;
        if (obj == null) {
            return new ObjectValue(ValueType.NULL, null);
        }
        if (obj instanceof Boolean) {
            return new ObjectValue(ValueType.BOOLEAN, (Boolean)obj);
        }
        if (obj instanceof BigDecimal) {
            return new ObjectValue(ValueType.NUMBER, (BigDecimal)obj);
        }
        if (obj instanceof Integer) {
            return new ObjectValue(ValueType.NUMBER, new BigDecimal((Integer)obj));
        }
        if (obj instanceof Long) {
            return new ObjectValue(ValueType.NUMBER, new BigDecimal((Long)obj));
        }
        if (obj instanceof Double) {
            return new ObjectValue(ValueType.NUMBER, new BigDecimal((Double)obj));
        }
        if (obj instanceof String || obj instanceof IObjectPK || obj instanceof BOSUuid) {
            return new ObjectValue(ValueType.STRING, obj.toString());
        }
        if (obj instanceof CoreBaseInfo) {
            return new ObjectValue(ValueType.COREBASEINFO, obj);
        }
        if (obj instanceof Object) {
            return new ObjectValue(ValueType.COREBASEINFO, obj);
        }
        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"NotSupport_DataType", (String[])new String[]{obj.getClass().toString(), variable}));
    }

    private Object getObjectFieldValue(Object obj, String field) throws BOSException {
        String firstChar = field.substring(0, 1);
        field = field.replaceFirst(firstChar, firstChar.toUpperCase());
        Method method = null;
        try {
            method = obj.getClass().getMethod("get" + field, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = obj.getClass().getMethod("is" + field, new Class[0]);
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void parse() throws BOSException {
        if (StringUtils.isEmpty((String)this.expression)) {
            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_ExpressionNull", null));
        }
        Stack<Node> nifixStack = this.parse2NifixExpression();
        this.debugStackInfo();
        List<Node> postfixList = this.parse2PostfixExpression(nifixStack);
        this.setPostfixList(postfixList);
    }

    private void debugStackInfo() {
    }

    private Stack<Node> parse2NifixExpression() throws BOSException {
        Node var;
        Stack<Node> stack = new Stack<Node>();
        boolean isInCharArray = false;
        StringBuilder sb = new StringBuilder();
        char preChar = '\u0000';
        char[] charArray = this.expression.trim().toCharArray();
        int len = charArray.length;
        block7: for (int i = 0; i < len; ++i) {
            char c = charArray[i];
            switch (c) {
                case '\'': {
                    if (preChar != '\\') {
                        boolean bl = isInCharArray = !isInCharArray;
                        if (isInCharArray) {
                            if (sb.length() == 0) break;
                            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_Apostrophe", (String[])new String[]{String.valueOf(i), this.expression}));
                        }
                        ObjectValue objVal = new ObjectValue(ValueType.STRING, sb.toString());
                        var = new Node(objVal, NodeType.CONSTANT);
                        stack.push(var);
                        sb.setLength(0);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '(': {
                    if (isInCharArray) {
                        sb.append(c);
                        break;
                    }
                    if (preChar != '\u0000' && preChar != '(' && preChar != '+' && preChar != '-' && preChar != '*' && preChar != '/') {
                        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_MissSign", (String[])new String[]{String.valueOf(i), this.expression}));
                    }
                    var = new Node(Character.valueOf(c), NodeType.OPERATOR);
                    stack.push(var);
                    break;
                }
                case '%': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    if (isInCharArray) {
                        sb.append(c);
                        break;
                    }
                    if (sb.length() > 0) {
                        ObjectValue objVal;
                        String s = sb.toString();
                        if (ExpressionUtils.isNumber(s)) {
                            BigDecimal b = new BigDecimal(s);
                            ObjectValue objVal2 = new ObjectValue(ValueType.NUMBER, b);
                            var = new Node(objVal2, NodeType.CONSTANT);
                        } else if (ExpressionUtils.isNull(s)) {
                            objVal = new ObjectValue(ValueType.NULL, null);
                            var = new Node(objVal, NodeType.CONSTANT);
                        } else if (ExpressionUtils.isBoolean(s)) {
                            objVal = new ObjectValue(ValueType.BOOLEAN, Boolean.valueOf(s));
                            var = new Node(objVal, NodeType.CONSTANT);
                        } else if (ExpressionUtils.isVariable(s)) {
                            var = new Node(s, NodeType.VARIABLE);
                        } else {
                            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_UnvalidateString", (String[])new String[]{s, this.expression}));
                        }
                        stack.push(var);
                        sb.setLength(0);
                    } else {
                        if (c == '-' && (preChar == '\u0000' || preChar == '(')) {
                            sb.append(c);
                            break;
                        }
                        if (preChar != '\'' && preChar != ')') {
                            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_Solidus", (String[])new String[]{String.valueOf(i), this.expression}));
                        }
                    }
                    var = new Node(Character.valueOf(c), NodeType.OPERATOR);
                    stack.push(var);
                    break;
                }
                case ' ': {
                    if (isInCharArray) break;
                    continue block7;
                }
                case '\\': {
                    if (isInCharArray) {
                        if (preChar != 92) break;
                        sb.append(c);
                        preChar = '\u0000';
                        continue block7;
                    }
                    throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_Sign", (String[])new String[]{String.valueOf(i), this.expression}));
                }
                default: {
                    sb.append(c);
                }
            }
            preChar = c;
        }
        if (sb.length() > 0) {
            String s = sb.toString();
            if (ExpressionUtils.isNumber(s)) {
                BigDecimal b = new BigDecimal(s);
                var = new Node(new ObjectValue(ValueType.NUMBER, b), NodeType.CONSTANT);
            } else if (ExpressionUtils.isNull(s)) {
                ObjectValue objVal = new ObjectValue(ValueType.NULL, null);
                var = new Node(objVal, NodeType.CONSTANT);
            } else if (ExpressionUtils.isBoolean(s)) {
                ObjectValue objVal = new ObjectValue(ValueType.BOOLEAN, Boolean.valueOf(s));
                var = new Node(objVal, NodeType.CONSTANT);
            } else if (ExpressionUtils.isVariable(s)) {
                var = new Node(s, NodeType.VARIABLE);
            } else {
                throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_UnvalidateString", (String[])new String[]{s, this.expression}));
            }
            stack.push(var);
        } else if (preChar != '\'' && preChar != ')') {
            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_MissOpNum", (String[])new String[]{this.expression}));
        }
        return stack;
    }

    private List<Node> parse2PostfixExpression(Stack<Node> nifixStack) throws BOSException {
        ArrayList<Node> postfixList = new ArrayList<Node>();
        if (null == nifixStack || nifixStack.size() == 0) {
            return postfixList;
        }
        Stack<Character> operator = new Stack<Character>();
        block6: for (Node v : nifixStack) {
            if (NodeType.OPERATOR.equals((Object)v.getType())) {
                Character ch = (Character)v.getValue();
                Character c = Character.valueOf(ch.charValue());
                switch (c.charValue()) {
                    case '(': {
                        operator.push(c);
                        break;
                    }
                    case ')': {
                        Character character = null;
                        while (!operator.isEmpty() && (character = (Character)operator.pop()).charValue() != '(') {
                            postfixList.add(new Node(character, NodeType.OPERATOR));
                        }
                        if (character != null && character.charValue() == '(') continue block6;
                        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_MissLfParenthesis", (String[])new String[]{"(", this.expression}));
                    }
                    case '+': 
                    case '-': {
                        Character character;
                        if (operator.isEmpty()) {
                            operator.add(c);
                            break;
                        }
                        while (!operator.isEmpty() && (character = (Character)operator.peek()).charValue() != '(') {
                            postfixList.add(new Node(character, NodeType.OPERATOR));
                            operator.pop();
                        }
                        operator.add(c);
                        break;
                    }
                    case '%': 
                    case '*': 
                    case '/': {
                        if (operator.isEmpty()) {
                            operator.add(c);
                            break;
                        }
                        Character character = (Character)operator.peek();
                        if (character.charValue() == '*' || character.charValue() == '/' || character.charValue() == '%') {
                            postfixList.add(new Node(character, NodeType.OPERATOR));
                            operator.pop();
                        }
                        operator.add(c);
                        break;
                    }
                    default: {
                        throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"ParseEr_UnvalidateSign", (String[])new String[]{String.valueOf(c), this.expression}));
                    }
                }
                continue;
            }
            postfixList.add(v);
        }
        while (!operator.isEmpty()) {
            postfixList.add(new Node(operator.pop(), NodeType.OPERATOR));
        }
        return postfixList;
    }

    private void setPostfixList(List<Node> postfixList) {
        this.postfixList = postfixList;
    }

    private static enum NodeType {
        CONSTANT,
        VARIABLE,
        OPERATOR;

    }

    private class Node {
        private Object value;
        private NodeType type;

        Node(Object value, NodeType type) {
            this.value = value;
            this.type = type;
        }

        NodeType getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }

        public String toString() {
            return (null == this.value ? null : this.value.toString()) + ";" + (null == this.type ? null : this.type.toString());
        }
    }
}

