/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditExceptionRptFacadeFactory;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.CreditReserveEnum;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.credit.ICreditParamFacade;
import com.kingdee.eas.scm.credit.client.CreditCheckEx;
import com.kingdee.eas.scm.credit.client.PassWordDialog;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillCollection;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryCollection;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillFactory;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.client.ConsignSaleBillListUI;
import com.kingdee.eas.scm.sd.sale.client.PostRequisitionEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleReturnsEditUI;
import com.kingdee.eas.scm.sd.sale.report.client.ConsignIssueBalanceUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CreditCheck {
    public static CreditCtrlResult checkSOAtSubmit(SaleOrderEditUI soEditUI) throws Exception {
        SaleOrderInfo so = (SaleOrderInfo)soEditUI.getEditData();
        SaleOrderInfo simpleSo = new SaleOrderInfo();
        simpleSo.setId(so.getId());
        simpleSo.setCompanyOrgUnit(so.getCompanyOrgUnit());
        simpleSo.setOrderCustomer(so.getOrderCustomer());
        simpleSo.setLocalTotalTaxAmount(so.getLocalTotalTaxAmount());
        simpleSo.setBaseStatus(so.getBaseStatus());
        simpleSo.setPaymentType(so.getPaymentType());
        simpleSo.setNumber(so.getNumber());
        simpleSo.setBizDate(so.getBizDate());
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(simpleSo);
        String lockKey = so.getCompanyOrgUnit().getId().toString() + so.getOrderCustomer().getId().toString();
        String companyId = so.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)soEditUI, companyId, 1);
        return result;
    }

    public static CreditCtrlResult checkSOAtAudit(SaleOrderEditUI soEditUI) throws Exception {
        SaleOrderInfo so = (SaleOrderInfo)soEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(so.getId().toString(), CreditFormulaSceneEnum.ORDER);
        String lockKey = so.getCompanyOrgUnit().getId().toString() + so.getOrderCustomer().getId().toString();
        String companyId = so.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)soEditUI, companyId, 1);
        return result;
    }

    public static CreditCtrlResult checkSOAtUnAudit(SaleOrderEditUI soEditUI) throws Exception {
        SaleOrderInfo so = (SaleOrderInfo)soEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(so.getId().toString(), CreditFormulaSceneEnum.ORDER);
        String lockKey = so.getCompanyOrgUnit().getId().toString() + so.getOrderCustomer().getId().toString();
        String companyId = so.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)soEditUI, companyId, 1);
        return result;
    }

    public static CreditCtrlResult checkSRAtSubmit(SaleReturnsEditUI srEditUI) throws Exception {
        SaleReturnsInfo sr = (SaleReturnsInfo)srEditUI.getEditData();
        SaleReturnsInfo simpleSr = new SaleReturnsInfo();
        simpleSr.setId(sr.getId());
        simpleSr.setCompanyOrgUnit(sr.getCompanyOrgUnit());
        simpleSr.setOrderCustomer(sr.getReturnsCustomer());
        simpleSr.setReturnsCustomer(sr.getReturnsCustomer());
        simpleSr.setLocalTotalTaxAmount(sr.getLocalTotalTaxAmount());
        simpleSr.setBaseStatus(sr.getBaseStatus());
        simpleSr.setPaymentType(sr.getPaymentType());
        simpleSr.setNumber(sr.getNumber());
        simpleSr.setBizDate(sr.getBizDate());
        simpleSr.getEntries().addCollection(sr.getEntries());
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(simpleSr);
        String lockKey = sr.getCompanyOrgUnit().getId().toString() + sr.getReturnsCustomer().getId().toString();
        String companyId = sr.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)srEditUI, companyId, 6);
        return result;
    }

    public static CreditCtrlResult checkSRAtAudit(SaleReturnsEditUI srEditUI) throws Exception {
        SaleReturnsInfo sr = (SaleReturnsInfo)srEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        String lockKey = sr.getCompanyOrgUnit().getId().toString() + sr.getReturnsCustomer().getId().toString();
        String companyId = sr.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)srEditUI, companyId, 6);
        return result;
    }

    public static CreditCtrlResult checkSRAtDelete(SaleReturnsEditUI srEditUI) throws Exception {
        SaleReturnsInfo sr = (SaleReturnsInfo)srEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtDelete(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        String lockKey = sr.getCompanyOrgUnit().getId().toString() + sr.getReturnsCustomer().getId().toString();
        String companyId = sr.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)srEditUI, companyId, 6);
        return result;
    }

    public static CreditCtrlResult checkSRAtUnAudit(SaleReturnsEditUI srEditUI) throws Exception {
        SaleReturnsInfo sr = (SaleReturnsInfo)srEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        String lockKey = sr.getCompanyOrgUnit().getId().toString() + sr.getReturnsCustomer().getId().toString();
        String companyId = sr.getCompanyOrgUnit().getId().toString();
        CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)srEditUI, companyId, 6);
        return result;
    }

    public static CreditCtrlResult checkPostbillAtSubmit(PostRequisitionEditUI postBillEditUI) throws Exception {
        postBillEditUI.storeFields();
        PostRequisitionInfo bill = (PostRequisitionInfo)postBillEditUI.getEditData();
        if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552")) {
            return new CreditCtrlResult();
        }
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        try {
            result = creditCtrl.verifyCreditAtSubmit(bill);
        }
        catch (CreditControlException exp) {
            MsgBox.showInfo((Component)postBillEditUI, (String)exp.getMessage());
            SysUtil.abort();
        }
        String companyId = null;
        if (bill.getCompanyOrgUnit() == null) {
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)bill.getSaleOrgUnit());
            companyId = theCompany.getId().toString();
        } else {
            companyId = bill.getCompanyOrgUnit().getId().toString();
        }
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getEntries().get(0).getOrderCustomer() != null) {
            String lockKey = companyId + bill.getEntries().get(0).getOrderCustomer().getId().toString();
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)postBillEditUI, companyId, 4);
        }
        return result;
    }

    public static CreditCtrlResult checkPostbillAtAudit(PostRequisitionEditUI postBillEditUI) throws Exception {
        postBillEditUI.storeFields();
        PostRequisitionInfo bill = (PostRequisitionInfo)postBillEditUI.getEditData();
        if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552")) {
            return new CreditCtrlResult();
        }
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        try {
            result = creditCtrl.verifyCreditAtAudit(bill.getId().toString(), CreditFormulaSceneEnum.POSTBILL);
        }
        catch (CreditControlException exp) {
            MsgBox.showInfo((Component)postBillEditUI, (String)exp.getMessage());
            SysUtil.abort();
        }
        String companyId = null;
        if (bill.getCompanyOrgUnit() == null) {
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)bill.getSaleOrgUnit());
            companyId = theCompany.getId().toString();
        } else {
            companyId = bill.getCompanyOrgUnit().getId().toString();
        }
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getEntries().get(0).getOrderCustomer() != null) {
            String lockKey = companyId + bill.getEntries().get(0).getOrderCustomer().getId().toString();
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)postBillEditUI, companyId, 4);
        }
        return result;
    }

    public static void checkIssuedBillAtSubmit(SaleIssueBillEditUI issuedBillEditUI) throws Exception {
        SaleIssueBillInfo issueBill = (SaleIssueBillInfo)issuedBillEditUI.getEditData();
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
            CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(issueBill);
            String custId = issueBill.getCustomer().getId().toString();
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)issueBill.getStorageOrgUnit());
            String companyId = theCompany.getId().toString();
            String lockKey = companyId + custId;
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)issuedBillEditUI, companyId, 3);
        }
    }

    public static void checkIssuedBillAtAudit(SaleIssueBillEditUI issuedBillEditUI) throws Exception {
        SaleIssueBillInfo issueBill = (SaleIssueBillInfo)issuedBillEditUI.getEditData();
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
            CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            String custId = issueBill.getCustomer().getId().toString();
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)issueBill.getStorageOrgUnit());
            String companyId = theCompany.getId().toString();
            String lockKey = companyId + custId;
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)issuedBillEditUI, companyId, 3);
        }
    }

    public static void checkIssuedBillAtDelete(SaleIssueBillEditUI issuedBillEditUI) throws Exception {
        SaleIssueBillInfo issueBill = (SaleIssueBillInfo)issuedBillEditUI.getEditData();
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
            CreditCtrlResult result = creditCtrl.verifyCreditAtDelete(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            String custId = issueBill.getCustomer().getId().toString();
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)issueBill.getStorageOrgUnit());
            String companyId = theCompany.getId().toString();
            String lockKey = companyId + custId;
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)issuedBillEditUI, companyId, 3);
        }
    }

    public static void checkIssuedBillAtUnAudit(SaleIssueBillEditUI issuedBillEditUI) throws Exception {
        SaleIssueBillInfo issueBill = (SaleIssueBillInfo)issuedBillEditUI.getEditData();
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
            CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            String custId = issueBill.getCustomer().getId().toString();
            CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)issueBill.getStorageOrgUnit());
            String companyId = theCompany.getId().toString();
            String lockKey = companyId + custId;
            CreditCheck.creidtControl(result, lockKey, (CoreBillEditUI)issuedBillEditUI, companyId, 3);
        }
    }

    public static void checkIssuedBillAtUnSettle(ConsignSaleBillListUI consignSaleBillListUI, List<List> billListID) throws Exception {
        List checkBillList = billListID.get(1);
        HashSet billIdSet = new HashSet(checkBillList);
        PaymentTypeInfo paymentType = new PaymentTypeInfo();
        paymentType.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("storageOrgUnit"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("bizdate"));
        selector.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setSelector(selector);
        view.setFilter(filter);
        ConsignSaleBillCollection consignSaleBillColl = ConsignSaleBillFactory.getRemoteInstance().getConsignSaleBillCollection(view);
        if (consignSaleBillColl.size() <= 0) {
            return;
        }
        ConsignSaleBillInfo consignSaleBillInfo = null;
        ConsignSaleBillEntryInfo consignSaleBillentryInfo = null;
        ConsignSaleBillEntryCollection entryColl = null;
        HashSet<String> saleIssueEntryIdSet = new HashSet<String>();
        HashSet<String> saleIssueBillIdSet = new HashSet<String>();
        for (int i = 0; i < consignSaleBillColl.size(); ++i) {
            consignSaleBillInfo = consignSaleBillColl.get(i);
            entryColl = consignSaleBillInfo.getEntrys();
            for (int j = 0; j < entryColl.size(); ++j) {
                consignSaleBillentryInfo = entryColl.get(j);
                saleIssueEntryIdSet.add(consignSaleBillentryInfo.getSourceBillEntryMID());
                saleIssueBillIdSet.add(consignSaleBillentryInfo.getSourceBillMID());
            }
        }
        HashMap<String, SaleIssueBillInfo> saleIssueInfoMap = new HashMap<String, SaleIssueBillInfo>();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", saleIssueBillIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("customer"));
        sic.add(new SelectorItemInfo("storageOrgUnit"));
        sic.add(new SelectorItemInfo("paymentType"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.taxPrice"));
        sic.add(new SelectorItemInfo("entry.price"));
        sic.add(new SelectorItemInfo("entry.salePrice"));
        sic.add(new SelectorItemInfo("entry.discountType"));
        sic.add(new SelectorItemInfo("entry.taxRate"));
        view.setFilter(filter);
        view.setSelector(sic);
        SaleIssueBillCollection saleIssueColl = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(view);
        SaleIssueBillInfo saleIssueInfo = null;
        for (int i = 0; i < saleIssueColl.size(); ++i) {
            saleIssueInfo = saleIssueColl.get(i);
            saleIssueInfoMap.put(saleIssueInfo.getId().toString(), saleIssueInfo);
        }
        CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)consignSaleBillInfo.getStorageOrgUnit(), (boolean)true);
        int localAmountPrecision = theCompany.getBaseCurrency().getPrecision();
        SaleIssueEntryInfo saleIssueEntry = null;
        for (int i = 0; i < consignSaleBillColl.size(); ++i) {
            CreditCondition creditCondition = new CreditCondition();
            BigDecimal amount = new BigDecimal("0");
            BigDecimal salesAmount = new BigDecimal("0");
            BigDecimal settleAmount = new BigDecimal("0");
            consignSaleBillInfo = consignSaleBillColl.get(i);
            for (int j = 0; j < consignSaleBillInfo.getEntries().size(); ++j) {
                consignSaleBillentryInfo = (ConsignSaleBillEntryInfo)consignSaleBillInfo.getEntries().getObject(j);
                saleIssueInfo = (SaleIssueBillInfo)saleIssueInfoMap.get(consignSaleBillentryInfo.getSourceBillMID());
                saleIssueEntry = saleIssueInfo.getEntry().get(consignSaleBillentryInfo.getBillSeq() - 1);
                BigDecimal price = BigDecimal.ZERO;
                price = saleIssueInfo.isIsInTax() ? saleIssueEntry.getTaxPrice() : saleIssueEntry.getSalePrice();
                BigDecimal nowAmount = CreditCheck.getLocalTaxAmount(saleIssueInfo.isIsInTax(), saleIssueEntry.getDiscountType(), saleIssueEntry.getTaxRate(), saleIssueEntry.getDiscount(), consignSaleBillentryInfo.getWriteOffQty(), price, localAmountPrecision, saleIssueInfo.getCurrency().getPrecision(), saleIssueInfo.getExchangeRate(), saleIssueInfo.getConvertMode());
                if ("DawAAAAPoBKwCNyn".equals(consignSaleBillentryInfo.getTransactionType().getId().toString())) {
                    settleAmount = nowAmount.add(settleAmount);
                    continue;
                }
                salesAmount = nowAmount.add(salesAmount);
            }
            amount = settleAmount.subtract(salesAmount).setScale(localAmountPrecision, 4);
            String custId = consignSaleBillInfo.getEntrys().get(0).getCustomer().getId().toString();
            String companyId = theCompany.getId().toString();
            String lockKey = companyId + custId;
            creditCondition.setCustomer(consignSaleBillInfo.getEntrys().get(0).getCustomer());
            creditCondition.setBillNumber(consignSaleBillInfo.getNumber());
            creditCondition.setBillDate(consignSaleBillInfo.getBizDate());
            creditCondition.setCompany(theCompany);
            creditCondition.setPaymentType(paymentType);
            creditCondition.setCreditControlScene(3);
            creditCondition.setDirection(CreditDirectionEnum.LESS);
            HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
            billNumeric.put("BILL_NUMERIC_AMOUNT", amount);
            creditCondition.setBillAmount(amount);
            creditCondition.setBillNumeric(billNumeric);
            CreditCtrlResult creditCtrlResult = CreditControlFacadeFactory.getRemoteInstance().verifyCredit(creditCondition);
            CreditCheck.creditControlforsettle(creditCtrlResult, lockKey, (CoreUI)consignSaleBillListUI, companyId, 3);
            ObjectUuidPK companypk = new ObjectUuidPK(theCompany.getId());
            ObjectUuidPK customerpk = new ObjectUuidPK(consignSaleBillentryInfo.getCustomer().getId());
            CreditBalanceUpdateFacadeFactory.getRemoteInstance().UpdateBalance((IObjectPK)companypk, (IObjectPK)customerpk, CreditReserveEnum.FUNARBILLISSUEDAMT, amount.negate());
            if (amount.compareTo(SysConstant.BIGZERO) == 0) continue;
            CreditUtils.insertCreditLogForSettle((String)companyId, (String)custId, (String)consignSaleBillInfo.getId().toString(), (ConsignSaleBillInfo)consignSaleBillInfo, (BigDecimal)amount.negate(), (CreditOperationEnum)CreditOperationEnum.UNSETTLE);
        }
    }

    public static BigDecimal checkIssuedBillAtSettle(ConsignIssueBalanceUI consignIssueBalanceUI, ConsignSaleBillInfo consignSaleBillInfo) throws Exception {
        CreditCondition creditCondition = new CreditCondition();
        IObjectCollection collection = consignSaleBillInfo.getEntries();
        ConsignSaleBillEntryInfo entry = null;
        BigDecimal amount = new BigDecimal("0");
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> entryIdSet = new HashSet<String>();
        HashMap<String, ConsignSaleBillEntryInfo> consignMap = new HashMap<String, ConsignSaleBillEntryInfo>();
        CustomerInfo customer = null;
        for (int i = 0; i < collection.size(); ++i) {
            String sourceIssuebillId = (String)collection.getObject(i).get("sourcebillmid");
            String consignEntryID = ((ConsignSaleBillEntryInfo)collection.getObject(i)).getSourceBillEntryMID().toString();
            ConsignSaleBillEntryInfo info = (ConsignSaleBillEntryInfo)collection.getObject(i);
            idSet.add(sourceIssuebillId);
            entryIdSet.add(consignEntryID);
            consignMap.put(consignEntryID, info);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("customer"));
        sic.add(new SelectorItemInfo("storageOrgUnit"));
        sic.add(new SelectorItemInfo("paymentType"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.taxPrice"));
        sic.add(new SelectorItemInfo("entry.salePrice"));
        sic.add(new SelectorItemInfo("entry.price"));
        sic.add(new SelectorItemInfo("entry.discountType"));
        sic.add(new SelectorItemInfo("entry.taxRate"));
        entityViewInfo.setFilter(filter);
        entityViewInfo.setSelector(sic);
        SaleIssueBillCollection saleIssueCol = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(entityViewInfo);
        customer = saleIssueCol.get(0).getCustomer();
        String number = null;
        for (int n = 0; n < saleIssueCol.size(); ++n) {
            SaleIssueBillInfo saleIssueBillInfo = saleIssueCol.get(n);
            boolean isTax = saleIssueBillInfo.isIsInTax();
            int amountPrecision = saleIssueBillInfo.getCurrency().getPrecision();
            BigDecimal exchangeRate = saleIssueBillInfo.getExchangeRate();
            ConvertModeEnum convertMode = saleIssueBillInfo.getConvertMode();
            IObjectCollection saleissueColl = saleIssueCol.get(n).getEntries();
            for (int i = 0; i < saleissueColl.size(); ++i) {
                SaleIssueEntryInfo saleissueentry = (SaleIssueEntryInfo)saleissueColl.getObject(i);
                if (!entryIdSet.contains(saleissueentry.getId().toString())) continue;
                entry = (ConsignSaleBillEntryInfo)consignMap.get(saleissueentry.getId().toString());
                number = entry.getBillNumber();
                int localAmountPrecision = (Integer)entry.get("amountPrecision");
                BigDecimal toprice = BigDecimal.ZERO;
                BigDecimal formprice = BigDecimal.ZERO;
                if (isTax) {
                    toprice = entry.getVerifyTaxPrice();
                    formprice = saleissueentry.getTaxPrice();
                } else {
                    toprice = entry.getVerifyPrice();
                    formprice = saleissueentry.getSalePrice();
                }
                BigDecimal toAmount = CreditCheck.getLocalTaxAmount(isTax, saleissueentry.getDiscountType(), saleissueentry.getTaxRate(), entry.getVerifyDiscount(), entry.getWriteOffQty(), toprice, localAmountPrecision, amountPrecision, exchangeRate, convertMode);
                BigDecimal fromAmount = CreditCheck.getLocalTaxAmount(isTax, saleissueentry.getDiscountType(), saleissueentry.getTaxRate(), entry.getVerifyDiscount(), entry.getWriteOffQty(), formprice, localAmountPrecision, amountPrecision, exchangeRate, convertMode);
                amount = amount.add(toAmount.subtract(fromAmount)).setScale(localAmountPrecision, 4);
            }
        }
        String custId = saleIssueCol.get(0).getCustomer().getId().toString();
        CompanyOrgUnitInfo theCompany = CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)saleIssueCol.get(0).getStorageOrgUnit());
        String companyId = theCompany.getId().toString();
        String lockKey = companyId + custId;
        creditCondition.setCustomer(customer);
        creditCondition.setBillNumber(number);
        creditCondition.setBillDate(consignSaleBillInfo.getBizDate());
        creditCondition.setCompany(theCompany);
        creditCondition.setPaymentType(saleIssueCol.get(0).getPaymentType());
        creditCondition.setCreditControlScene(3);
        creditCondition.setDirection(CreditDirectionEnum.ADD);
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", amount);
        creditCondition.setBillAmount(amount);
        creditCondition.setBillNumeric(billNumeric);
        CreditCtrlResult creditCtrlResult = CreditControlFacadeFactory.getRemoteInstance().verifyCredit(creditCondition);
        CreditCheck.creditControlforsettle(creditCtrlResult, lockKey, (CoreUI)consignIssueBalanceUI, companyId, 3);
        return amount;
    }

    private static BigDecimal getLocalAmount(boolean isTax, SaleIssueEntryInfo saleissueentry, ConsignSaleBillEntryInfo entry) {
        BigDecimal localTaxAmount = BigDecimal.ZERO;
        BigDecimal discountRate = entry.getVerifyDiscount();
        if (isTax) {
            if (discountRate.compareTo(new BigDecimal(100)) == 0) {
                localTaxAmount = BigDecimal.ZERO;
                return localTaxAmount;
            }
            BigDecimal taxPrice = entry.getVerifyTaxPrice();
            BigDecimal qty = entry.getWriteOffQty();
            BigDecimal discountAmount = taxPrice.multiply(discountRate.multiply(new BigDecimal(0.01)).multiply(qty));
            localTaxAmount = taxPrice.multiply(qty).subtract(discountAmount).setScale(taxPrice.scale(), 4);
        } else {
            BigDecimal price = entry.getVerifyPrice();
            BigDecimal taxRate = saleissueentry.getTaxRate();
            BigDecimal qty = entry.getWriteOffQty();
            BigDecimal amount = price.multiply(qty);
            amount = amount.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.multiply(new BigDecimal(0.01))));
            BigDecimal taxAmount = amount.multiply(taxRate.multiply(new BigDecimal(0.01)));
            localTaxAmount = amount.add(taxAmount).setScale(price.scale(), 4);
        }
        return localTaxAmount;
    }

    private static BigDecimal getLocalTaxAmount(boolean isTax, DiscountModeEnum discountType, BigDecimal taxRate, BigDecimal discountRate, BigDecimal qty, BigDecimal price, int localAmountPrecision, int amountPrecision, BigDecimal exchangeRate, ConvertModeEnum convertMode) {
        BigDecimal localTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (isTax) {
            if (discountRate.compareTo(new BigDecimal("100.00")) == 0) {
                taxAmount = BigDecimal.ZERO;
                return taxAmount;
            }
            BigDecimal taxPrice = price;
            BigDecimal discountAmount = BigDecimal.ZERO;
            if (DiscountModeEnum.NULL.equals((Object)discountType)) {
                discountAmount = BigDecimal.ZERO;
            } else if (DiscountModeEnum.PERCENT.equals((Object)discountType)) {
                discountAmount = taxPrice.multiply(discountRate.multiply(new BigDecimal("0.01")).multiply(qty)).setScale(amountPrecision, 4);
            } else if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
                discountAmount = taxPrice.multiply(discountRate.multiply(qty)).setScale(amountPrecision, 4);
            }
            taxAmount = taxPrice.multiply(qty).subtract(discountAmount).setScale(amountPrecision, 4);
        } else {
            BigDecimal amount = BigDecimal.ZERO;
            if (DiscountModeEnum.NULL.equals((Object)discountType) || DiscountModeEnum.PERCENT.equals((Object)discountType)) {
                amount = qty.multiply(price).multiply(BigDecimal.ONE.subtract(discountRate.multiply(new BigDecimal("0.01")))).setScale(amountPrecision, 4);
            } else if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
                if (BigDecimal.ZERO.compareTo(price) == 0) {
                    discountRate = BigDecimal.ZERO;
                }
                amount = qty.multiply(price.subtract(discountRate)).setScale(amountPrecision, 4);
            }
            BigDecimal tax = amount.multiply(taxRate.multiply(new BigDecimal("0.01"))).setScale(amountPrecision, 4);
            taxAmount = amount.add(tax).setScale(amountPrecision, 4);
        }
        localTaxAmount = SysConstant.BIGZERO.compareTo(exchangeRate) != 0 ? (convertMode == ConvertModeEnum.DIRECTEXCHANGERATE ? taxAmount.multiply(exchangeRate).setScale(localAmountPrecision, 4) : taxAmount.divide(exchangeRate, localAmountPrecision, 4)) : taxAmount.setScale(localAmountPrecision, 4);
        return localTaxAmount;
    }

    public static CreditCtrlResult checkARAtSubmit(CoreBillEditUI arEditUI) throws Exception {
        BillBaseInfo ar = (BillBaseInfo)arEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(ar);
        String companyId = ar.getCompany().getId().toString();
        String lockKey = companyId + ar.getString("asstActID");
        CreditCheck.creidtControl(result, lockKey, arEditUI, companyId, 2);
        return result;
    }

    public static CreditCtrlResult checkARAtAudit(CoreBillEditUI arEditUI) throws Exception {
        BillBaseInfo ar = (BillBaseInfo)arEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(ar.getId().toString(), CreditFormulaSceneEnum.ARBILL);
        String companyId = ar.getCompany().getId().toString();
        String lockKey = companyId + ar.getString("asstActID");
        CreditCheck.creidtControl(result, lockKey, arEditUI, companyId, 2);
        return result;
    }

    public static CreditCtrlResult checkARAtUnAudit(CoreBillEditUI arEditUI) throws Exception {
        BillBaseInfo ar = (BillBaseInfo)arEditUI.getEditData();
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(ar.getId().toString(), CreditFormulaSceneEnum.ARBILL);
        String companyId = ar.getCompany().getId().toString();
        String lockKey = companyId + ar.getString("asstActID");
        CreditCheck.creidtControl(result, lockKey, arEditUI, companyId, 2);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(CoreUI ui, String billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billID == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyArSysBillAtOperation(new String[]{billID}, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.ARSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(CoreUI ui, String[] billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billID == null || billID.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyArSysBillAtOperation(billID, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.ARSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(CoreUI ui, IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billInfo == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyArSysBillAtOperation(new IObjectValue[]{billInfo}, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.ARSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(CoreUI ui, IObjectValue[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyArSysBillAtOperation(billInfo, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.ARSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(CoreUI ui, String billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billID == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyApSysBillAtOperation(new String[]{billID}, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.APSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(CoreUI ui, String[] billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billID == null || billID.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyApSysBillAtOperation(billID, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.APSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(CoreUI ui, IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billInfo == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyApSysBillAtOperation(new IObjectValue[]{billInfo}, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.APSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(CoreUI ui, IObjectValue[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyApSysBillAtOperation(billInfo, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui, operation, CreditFormulaSceneEnum.APSYSBILL);
        return result;
    }

    public static CreditCtrlResult checkCreditFileAtAlter(CoreUI ui, CreditFileInfo[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyCreditFileAtAlter((IObjectValue[])billInfo, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui);
        return result;
    }

    public static CreditCtrlResult checkCreditFileAtOperate(CoreUI ui, String[] billIDs, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws Exception {
        if (billIDs == null || billIDs.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getRemoteInstance().verifyCreditFileAtOperation(billIDs, operation, direction, billType);
        CreditCheck.creidtControl(result.getCreditResult(), billType, ui);
        return result;
    }

    public static void addExceptionRecord(CoreBillBaseInfo billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        CreditExceptionRptFacadeFactory.getRemoteInstance().addExceptionRecord(billInfo, billType, result, operation);
    }

    public static void addExceptionRecord(CoreBillBaseInfo[] billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        if (billInfo == null || billInfo.length == 0) {
            return;
        }
        HashMap<String, String> billMap = new HashMap<String, String>();
        int length = billInfo.length;
        for (int i = 0; i < length; ++i) {
            if (billInfo[i].getId() != null) {
                if (billInfo[i].getNumber() != null) {
                    billMap.put(billInfo[i].getId().toString(), billInfo[i].getNumber());
                    continue;
                }
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("number"));
                BillBaseInfo info = (BillBaseInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(billInfo[i].getId()), (SelectorItemCollection)selectors);
                billMap.put(billInfo[i].getId().toString(), info.getNumber());
                continue;
            }
            if (billInfo[i].getNumber() == null) continue;
            billMap.put(billInfo[i].getNumber(), billInfo[i].getNumber());
        }
        if (billMap.size() == 0) {
            return;
        }
        CreditExceptionRptFacadeFactory.getRemoteInstance().addExceptionRecord(billMap, billType, result, operation);
    }

    public static void addExceptionRecord(DataBaseInfo[] billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        if (billInfo == null || billInfo.length == 0) {
            return;
        }
        HashMap<String, String> billMap = new HashMap<String, String>();
        int length = billInfo.length;
        for (int i = 0; i < length; ++i) {
            if (billInfo[i].getId() == null) continue;
            billMap.put(billInfo[i].getId().toString(), billInfo[i].getNumber() == null ? "" : billInfo[i].getNumber());
        }
        if (billMap.size() == 0) {
            return;
        }
        CreditExceptionRptFacadeFactory.getRemoteInstance().addExceptionRecord(billMap, billType, result, operation);
    }

    private static void creidtControl(CreditCtrlResult result, String lockKey, CoreBillEditUI editUI, String companyId, int scene) throws Exception {
        if (result.isRequiredCheck()) {
            String oldStatus = editUI.getOprtState();
            CreditCheck.lockBalance((CoreUI)editUI, lockKey);
            if (result.isOverspend() || result.isTimeout()) {
                int ctrlMode = result.getCreditCtrlMode().getValue();
                switch (ctrlMode) {
                    case 0: {
                        int ret = MsgBox.showConfirm3a((Component)editUI, (String)CreditCheck.getResource("CREDITWARNING_CONTINUE"), (String)result.getMsgBody());
                        if (ret == 0) break;
                        CreditCheck.endOperation((CoreUI)editUI, lockKey, oldStatus);
                        break;
                    }
                    case 1: {
                        MsgBox.showDetailAndOK((Component)editUI, (String)CreditCheck.getResource("CREDITCANCEL_CONTINUE"), (String)result.getMsgBody(), (int)2);
                        CreditCheck.endOperation((CoreUI)editUI, lockKey, oldStatus);
                        break;
                    }
                    case 3: {
                        String uiClass = PassWordDialog.class.getName();
                        IUIWindow popUI = null;
                        try {
                            UIContext uiContext = new UIContext((Object)editUI);
                            popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
                        }
                        catch (UIException e) {
                            CreditCheck.unlockBalance((CoreUI)editUI, lockKey, oldStatus);
                            editUI.handUIExceptionAndAbort((Exception)((Object)e));
                        }
                        PassWordDialog passwordDialog = (PassWordDialog)popUI.getUIObject();
                        passwordDialog.setMessage(result.getMsgBody());
                        popUI.show();
                        String thePass = passwordDialog.getPassWord();
                        if (thePass != null && thePass.trim().length() > 0) {
                            ICreditParamFacade icf = CreditParamFacadeFactory.getRemoteInstance();
                            CreditParamInfo cpInfo = icf.getParameter(companyId);
                            BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy((CreditFormulaSceneEnum)CreditFormulaSceneEnum.getEnum(scene), (CreditParamInfo)cpInfo);
                            String theSavedPwd = billCtrlStrategy.getPassword();
                            if (!thePass.equals(theSavedPwd)) {
                                String msgError = CreditCheck.getResource("PASSWORD_ERROR");
                                MsgBox.showInfo((Component)editUI, (String)msgError);
                                CreditCheck.endOperation((CoreUI)editUI, lockKey, oldStatus);
                            }
                        } else {
                            CreditCheck.endOperation((CoreUI)editUI, lockKey, oldStatus);
                        }
                        CreditCheck.log(editUI, scene);
                        break;
                    }
                    default: {
                        CreditCheckEx.creditControl();
                    }
                }
            }
            CreditCheck.unlockBalance((CoreUI)editUI, lockKey, oldStatus);
        }
    }

    private static void creidtControl(CreditCtrlResult result, CreditFormulaSceneEnum billType, CoreUI ui, CreditOperationEnum operation, CreditFormulaSceneEnum scene) throws Exception {
        if (result.isOverspend() || result.isTimeout()) {
            String lockKey = result.getCompanyId() + result.getCustomerId();
            String oldStatus = ui.getOprtState();
            CreditCheck.lockBalance(ui, lockKey);
            int ctrlMode = result.getCreditCtrlMode().getValue();
            switch (ctrlMode) {
                case 0: {
                    int ret = MsgBox.showConfirm3a((Component)ui, (String)CreditCheck.getResource("CREDITWARNING_CONTINUE"), (String)result.getMsgBody());
                    if (ret == 0) break;
                    CreditCheck.endOperation(ui, lockKey, oldStatus);
                    break;
                }
                case 1: {
                    MsgBox.showDetailAndOK((Component)ui, (String)CreditCheck.getResource("CREDITCANCEL_CONTINUE"), (String)result.getMsgBody(), (int)2);
                    CreditCheck.endOperation(ui, lockKey, oldStatus);
                    break;
                }
                case 3: {
                    String uiClass = PassWordDialog.class.getName();
                    IUIWindow popUI = null;
                    try {
                        UIContext uiContext = new UIContext((Object)ui);
                        popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
                    }
                    catch (UIException e) {
                        CreditCheck.unlockBalance(ui, lockKey, oldStatus);
                        ui.handUIExceptionAndAbort((Exception)((Object)e));
                    }
                    PassWordDialog passwordDialog = (PassWordDialog)popUI.getUIObject();
                    passwordDialog.setMessage(result.getMsgBody());
                    popUI.show();
                    String thePass = passwordDialog.getPassWord();
                    if (thePass != null && thePass.trim().length() > 0) {
                        CreditParamInfo cpInfo = result.getCreditParam();
                        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy((CreditFormulaSceneEnum)scene, (CreditParamInfo)cpInfo);
                        String theSavedPwd = billCtrlStrategy.getPassword();
                        if (thePass.equals(theSavedPwd)) break;
                        String msgError = CreditCheck.getResource("PASSWORD_ERROR");
                        MsgBox.showInfo((Component)ui, (String)msgError);
                        CreditCheck.endOperation(ui, lockKey, oldStatus);
                        break;
                    }
                    CreditCheck.endOperation(ui, lockKey, oldStatus);
                }
            }
            CreditCheck.log(result.getBillInfo(), billType);
            CreditCheck.unlockBalance(ui, lockKey, oldStatus);
        }
    }

    private static void creidtControl(Object[] results, CreditFormulaSceneEnum billType, CoreUI ui, CreditOperationEnum operation, CreditFormulaSceneEnum scene) throws Exception {
        if (results == null || results.length == 0) {
            return;
        }
        CreditCtrlResult result = null;
        StringBuffer warnMsg = new StringBuffer("");
        StringBuffer cancelMsg = new StringBuffer("");
        StringBuffer pwdMsg = new StringBuffer("");
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            result = (CreditCtrlResult)results[i];
            if (!result.isOverspend() && !result.isTimeout()) continue;
            String lockKey = result.getCompanyId() + result.getCustomerId();
            String oldStatus = ui.getOprtState();
            CreditCheck.lockBalance(ui, lockKey);
            int ctrlMode = result.getCreditCtrlMode().getValue();
            switch (ctrlMode) {
                case 0: {
                    warnMsg.append(result.getMsgBody());
                    break;
                }
                case 1: {
                    cancelMsg.append(result.getMsgBody());
                    break;
                }
                case 3: {
                    pwdMsg.append(result.getMsgBody());
                }
            }
            CreditCheck.log(result.getBillInfo(), billType);
            CreditCheck.unlockBalance(ui, lockKey, oldStatus);
        }
        if (warnMsg.length() > 0) {
            int ret = MsgBox.showConfirm3a((Component)ui, (String)CreditCheck.getResource("CREDITWARNING_CONTINUE"), (String)warnMsg.toString());
            if (ret != 0) {
                SysUtil.abort();
            }
        } else if (cancelMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)ui, (String)CreditCheck.getResource("CREDITCANCEL_CONTINUE"), (String)cancelMsg.toString(), (int)2);
            SysUtil.abort();
        } else if (pwdMsg.length() > 0) {
            String uiClass = PassWordDialog.class.getName();
            IUIWindow popUI = null;
            try {
                UIContext uiContext = new UIContext((Object)ui);
                popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e) {
                ui.handUIExceptionAndAbort((Exception)((Object)e));
            }
            PassWordDialog passwordDialog = (PassWordDialog)popUI.getUIObject();
            passwordDialog.setMessage(pwdMsg.toString());
            popUI.show();
            String thePass = passwordDialog.getPassWord();
            if (thePass != null && thePass.trim().length() > 0) {
                CreditParamInfo cpInfo = result.getCreditParam();
                BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy((CreditFormulaSceneEnum)scene, (CreditParamInfo)cpInfo);
                String theSavedPwd = billCtrlStrategy.getPassword();
                if (!thePass.equals(theSavedPwd)) {
                    String msgError = CreditCheck.getResource("PASSWORD_ERROR");
                    MsgBox.showInfo((Component)ui, (String)msgError);
                    SysUtil.abort();
                }
            } else {
                SysUtil.abort();
            }
        }
    }

    private static void creidtControl(Object[] results, CreditFormulaSceneEnum billType, CoreUI ui) throws Exception {
        int ret;
        if (results == null || results.length == 0) {
            return;
        }
        CreditCtrlResult result = null;
        StringBuffer msg = new StringBuffer("");
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            result = (CreditCtrlResult)results[i];
            if (!result.isOverspend() && !result.isTimeout()) continue;
            String lockKey = result.getCompanyId() + result.getCustomerId();
            String oldStatus = ui.getOprtState();
            CreditCheck.lockBalance(ui, lockKey);
            result.setCreditCtrlMode(ControlMethodEnum.WARNING);
            msg.append(result.getMsgBody());
            CreditCheck.unlockBalance(ui, lockKey, oldStatus);
            CreditCheck.unlockBalance(ui, lockKey, oldStatus);
        }
        if (msg.length() > 0 && (ret = MsgBox.showConfirm3a((Component)ui, (String)CreditCheck.getResource("CREDITWARNING_CONTINUE"), (String)msg.toString())) != 0) {
            SysUtil.abort();
        }
    }

    private static void creditControlforsettle(CreditCtrlResult result, String lockKey, CoreUI editUI, String companyId, int scene) throws Exception {
        String oldStatus = editUI.getOprtState();
        CreditCheck.lockBalance(editUI, lockKey);
        if (result.isOverspend() || result.isTimeout()) {
            int ctrlMode = result.getCreditCtrlMode().getValue();
            switch (ctrlMode) {
                case 0: {
                    int ret = MsgBox.showConfirm3a((Component)editUI, (String)CreditCheck.getResource("CREDITWARNING_CONTINUE"), (String)result.getMsgBody());
                    if (ret == 0) break;
                    CreditCheck.endOperation(editUI, lockKey, oldStatus);
                    break;
                }
                case 1: {
                    MsgBox.showDetailAndOK((Component)editUI, (String)CreditCheck.getResource("CREDITCANCEL_CONTINUE"), (String)result.getMsgBody(), (int)2);
                    CreditCheck.endOperation(editUI, lockKey, oldStatus);
                    break;
                }
                case 3: {
                    String uiClass = PassWordDialog.class.getName();
                    IUIWindow popUI = null;
                    try {
                        UIContext uiContext = new UIContext((Object)editUI);
                        popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
                    }
                    catch (UIException e) {
                        CreditCheck.unlockBalance(editUI, lockKey, oldStatus);
                        editUI.handUIExceptionAndAbort((Exception)((Object)e));
                    }
                    PassWordDialog passwordDialog = (PassWordDialog)popUI.getUIObject();
                    passwordDialog.setMessage(result.getMsgBody());
                    popUI.show();
                    String thePass = passwordDialog.getPassWord();
                    if (thePass != null && thePass.trim().length() > 0) {
                        ICreditParamFacade icf = CreditParamFacadeFactory.getRemoteInstance();
                        CreditParamInfo cpInfo = icf.getParameter(companyId);
                        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy((CreditFormulaSceneEnum)CreditFormulaSceneEnum.getEnum(scene), (CreditParamInfo)cpInfo);
                        String theSavedPwd = billCtrlStrategy.getPassword();
                        if (thePass.equals(theSavedPwd)) break;
                        String msgError = CreditCheck.getResource("PASSWORD_ERROR");
                        MsgBox.showInfo((Component)editUI, (String)msgError);
                        CreditCheck.endOperation(editUI, lockKey, oldStatus);
                        break;
                    }
                    CreditCheck.endOperation(editUI, lockKey, oldStatus);
                }
            }
        }
        CreditCheck.unlockBalance(editUI, lockKey, oldStatus);
    }

    private static void log(CoreBillEditUI editUI, int scene) {
        String number = editUI.getEditData().getNumber();
        ObjectUuidPK pk = new ObjectUuidPK(editUI.getEditData().getId());
        BOSObjectType bosType = null;
        String billName = null;
        if (scene == 1) {
            billName = CreditFormulaSceneEnum.ORDER.getAlias();
            bosType = new SaleOrderInfo().getBOSType();
        }
        if (scene == 3) {
            billName = CreditFormulaSceneEnum.ISSUEDBILL.getAlias();
            bosType = new SaleIssueBillInfo().getBOSType();
        }
        if (scene == 4) {
            billName = CreditFormulaSceneEnum.POSTBILL.getAlias();
            bosType = new PostRequisitionInfo().getBOSType();
        }
        if (scene == 2) {
            billName = CreditFormulaSceneEnum.ARBILL.getAlias();
            bosType = new BOSObjectType("FC910EF3");
        }
        IObjectPK logPk = LogUtil.beginLog(null, (String)billName, (BOSObjectType)bosType, (IObjectPK)pk, (String)(CreditCheck.getResource("BILLNUMBER") + " " + number + "," + CreditCheck.getResource("CREDITBALANCEOUT")));
        LogUtil.afterLog(null, (IObjectPK)logPk);
    }

    private static void log(CoreBillBaseInfo billInfo, CreditFormulaSceneEnum billType) {
        String number = "";
        if (billInfo != null) {
            number = billInfo.get("number") != null ? (String)billInfo.get("number") : "";
        }
        ObjectUuidPK pk = null;
        if (billInfo.get("id") != null) {
            pk = new ObjectUuidPK(billInfo.get("id").toString());
        }
        String type = "";
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)billType)) {
            type = "FC910EF3";
        } else if (CreditFormulaSceneEnum.APBILL.equals((Object)billType)) {
            type = "48DA3A71";
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)billType)) {
            type = "FA44FD5B";
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)billType)) {
            type = "40284E81";
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)billType)) {
            type = "9B112F80";
        }
        if (pk != null) {
            type = BOSUuid.getBOSObjectType((String)pk.toString(), (boolean)true).toString();
        }
        if (type.length() == 0) {
            return;
        }
        BOSObjectType boseType = BOSObjectType.create((String)type);
        String billName = null;
        billName = billType.getAlias();
        IObjectPK logPk = LogUtil.beginLog(null, (String)billName, (BOSObjectType)boseType, (IObjectPK)pk, (String)(CreditCheck.getResource("BILLNUMBER") + " " + number + "," + CreditCheck.getResource("CREDITBALANCEOUT").substring(0, 4)));
        LogUtil.afterLog(null, (IObjectPK)logPk);
    }

    private static void lockBalance(CoreUI ui, String lockKey) throws Exception {
        try {
            ui.setOprtState("CHECKCREDIT");
            ui.pubFireVOChangeListener(lockKey);
        }
        catch (Throwable e) {
            ui.handUIExceptionAndAbort((Exception)((Object)new CreditControlException(CreditControlException.CHECKCREDIT_ERROR)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlockBalance(CoreUI ui, String lockKey, String oldStatus) throws Exception {
        try {
            ui.setOprtState("RELEASEALL");
            ui.pubFireVOChangeListener(lockKey);
        }
        catch (Throwable e) {
            ui.handUIException(e);
        }
        finally {
            ui.setOprtState(oldStatus);
        }
    }

    private static void endOperation(CoreUI ui, String lockKey, String oldStatus) throws Exception {
        CreditCheck.unlockBalance(ui, lockKey, oldStatus);
        SysUtil.abort();
    }

    public static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key);
    }
}

