/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.tools.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.customize.tools.IIndexCheck;
import com.kingdee.eas.scm.customize.tools.IndexCheckFactory;
import com.kingdee.eas.scm.customize.tools.IndexCheckMsgInfo;
import com.kingdee.eas.scm.customize.tools.client.AbstractIndexCheckMsgUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class IndexCheckMsgUI
extends AbstractIndexCheckMsgUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexCheckMsgUI.class);

    public IndexCheckMsgUI() throws Exception {
        this.actionSelectAll.setEnabled(true);
        this.actionReSelectAll.setEnabled(true);
        logger.info((Object)"IndexCheckMsgUI start");
    }

    public void onShow() throws Exception {
        super.onShow();
        List returnList = (List)this.getUIContext().get("RESULTMSG");
        if (returnList != null && returnList.size() > 0) {
            KDCheckBox chkBox = new KDCheckBox();
            KDTDefaultCellEditor bizchkBoxEditor = new KDTDefaultCellEditor((JCheckBox)chkBox);
            this.kDTable.getColumn("select").setWidth(60);
            this.kDTable.getColumn("select").getStyleAttributes().setLocked(false);
            StringBuffer repairStrategyStr = new StringBuffer();
            for (int i = 0; i < returnList.size(); ++i) {
                IRow newRow = this.kDTable.addRow();
                IndexCheckMsgInfo msgIndexCheckMsgInfo = (IndexCheckMsgInfo)returnList.get(i);
                newRow.getCell("tableName").setValue((Object)msgIndexCheckMsgInfo.getTableName());
                newRow.getCell("indexName").setValue((Object)msgIndexCheckMsgInfo.getIndexName());
                newRow.getCell("differentMsg").setValue((Object)msgIndexCheckMsgInfo.getDiffMsg());
                repairStrategyStr.append(msgIndexCheckMsgInfo.getRepairStrategy() + " \n");
                if (msgIndexCheckMsgInfo.getExeDropSQL().trim().length() > 0) {
                    repairStrategyStr.append(msgIndexCheckMsgInfo.getExeDropSQL() + " \n");
                }
                if (msgIndexCheckMsgInfo.getExeCreateSQL().trim().length() > 0) {
                    repairStrategyStr.append(msgIndexCheckMsgInfo.getExeCreateSQL() + " \n");
                }
                if (msgIndexCheckMsgInfo.getExeDropSQL().trim().length() <= 0 && msgIndexCheckMsgInfo.getExeCreateSQL().trim().length() <= 0) {
                    newRow.getCell("select").getStyleAttributes().setLocked(true);
                    newRow.getCell("select").setEditor(null);
                } else {
                    newRow.getCell("select").setEditor((ICellEditor)bizchkBoxEditor);
                    newRow.getCell("select").setValue((Object)false);
                }
                newRow.getCell("repairStrategy").setValue((Object)repairStrategyStr.toString());
                repairStrategyStr.setLength(0);
                newRow.setUserObject((Object)msgIndexCheckMsgInfo);
            }
        }
        this.kDTable.getColumn("checkResult").getStyleAttributes().setHided(true);
        this.tbResult.setEditable(false);
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuit_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionRepair_actionPerformed(ActionEvent e) throws Exception {
        super.actionRepair_actionPerformed(e);
        this.kDTable.setEditable(false);
        this.btnRepair.setEnabled(false);
        ArrayList<Object> repairList = new ArrayList<Object>();
        repairList.add(this.getUIContext().get("ID").toString());
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            if (this.kDTable.getRow(i).getCell("select").getStyleAttributes().isLocked() || !((Boolean)this.kDTable.getRow(i).getCell("select").getValue()).booleanValue()) continue;
            repairList.add(this.kDTable.getRow(i).getUserObject());
        }
        IIndexCheck iIndexCheck = IndexCheckFactory.getRemoteInstance();
        List returnList = iIndexCheck.reCreateIndex(repairList);
        if (returnList != null && returnList.size() > 0) {
            for (int i = 0; i < returnList.size(); ++i) {
                IRow newRow = this.tbResult.addRow();
                IndexCheckMsgInfo msgIndexCheckMsgInfo = (IndexCheckMsgInfo)returnList.get(i);
                newRow.getCell("SQL").setValue((Object)msgIndexCheckMsgInfo.getRepairStrategy());
                newRow.getCell("result").setValue((Object)msgIndexCheckMsgInfo.getResult());
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            if (this.kDTable.getRow(i).getCell("select").getStyleAttributes().isLocked()) continue;
            this.kDTable.getRow(i).getCell("select").setValue((Object)true);
        }
    }

    @Override
    public void actionReSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            if (this.kDTable.getRow(i).getCell("select").getStyleAttributes().isLocked()) continue;
            this.kDTable.getRow(i).getCell("select").setValue((Object)((Boolean)this.kDTable.getRow(i).getCell("select").getValue() == false ? 1 : 0));
        }
    }
}

