/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceDataModelListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;

public class BalanceDataModelListUI
extends AbstractBalanceDataModelListUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_STATE = "state";
    private static final String COL_SCHEDULED = "isScheduled";
    private static final String COL_INITIALIZE = "isInitialize";
    private static final String COL_UPDATETYPE = "updateType";
    private BalanceModelInfo balanceModelInfo;

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ParentNode", (Object)this.balanceModelInfo);
    }

    public void onLoad() throws Exception {
        this.balanceModelInfo = (BalanceModelInfo)this.getUIContext().get("ParentNode");
        super.onLoad();
        if (this.balanceModelInfo != null && BalanceTypeEnum.RealTime.equals((Object)this.balanceModelInfo.getBalanceType())) {
            this.tblMain.getColumn(COL_UPDATETYPE).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(COL_INITIALIZE).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(COL_UPDATETYPE).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COL_INITIALIZE).getStyleAttributes().setHided(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BalanceDataModelFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.framework.balance.client.BalanceDataModelEditUI";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"75_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        Boolean isScheduled;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"76_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
        if ((isScheduled = (Boolean)row.getCell(COL_SCHEDULED).getValue()).booleanValue()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"77_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (this.balanceModelInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("balanceModel.id", (Object)this.balanceModelInfo.getId(), CompareType.EQUALS));
        }
        return filter;
    }
}

