/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceFieldModelEditUI;
import com.kingdee.eas.scm.framework.balance.client.BalanceFieldSelector;
import com.kingdee.eas.scm.framework.balance.client.BalanceFormulaSelector;
import com.kingdee.eas.scm.framework.client.EntitySelector;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public class BalanceFieldModelEditUI
extends AbstractBalanceFieldModelEditUI {
    private static final long serialVersionUID = 1L;
    private BalanceModelInfo parent;
    private BalanceFieldModelInfo editData;
    private boolean isConfirm = false;
    private SelectorListener fieldFormulaSelectorListener;
    private SelectorListener baseDataSelectorListener;
    private PreChangeListener baseDataPreChangeListener;
    private DataChangeListener baseDataDataChangeListener;

    public BalanceFieldModelEditUI() throws Exception {
        this.txtLength.setEnabled(false);
        this.comboDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BalanceFieldModelEditUI.this.dataTypeChanged(e);
            }
        });
        this.comboBizDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BalanceFieldModelEditUI.this.bizDataTypeChanged(e);
            }
        });
        this.fieldFormulaSelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BalanceFieldModelEditUI.this.initFieldFormula(e);
            }
        };
        this.baseDataSelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BalanceFieldModelEditUI.this.initBaseDataSelector(e);
            }
        };
        this.baseDataPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                BalanceFieldModelEditUI.this.transBaseDataResult(e);
            }
        };
        this.baseDataDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BalanceFieldModelEditUI.this.baseDataDataChanged(eventObj);
            }
        };
    }

    public void onLoad() throws Exception {
        this.parent = (BalanceModelInfo)this.getUIContext().get("BalanceModel");
        this.editData = (BalanceFieldModelInfo)this.getUIContext().get("BalanceField");
        super.onLoad();
        this.chkIsSPvisible.setEnabled(false);
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        this.setBizDataTypeItem();
        super.loadFields();
        this.setComponentState();
        this.addListener();
    }

    private void addListener() {
        this.prmtCalExpression.addSelectorListener(this.fieldFormulaSelectorListener);
        this.prmtBaseData.addSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.addPreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.addDataChangeListener(this.baseDataDataChangeListener);
    }

    private void removeListener() {
        this.prmtCalExpression.removeSelectorListener(this.fieldFormulaSelectorListener);
        this.prmtBaseData.removeSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.removePreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.removeDataChangeListener(this.baseDataDataChangeListener);
    }

    private void setBizDataTypeItem() {
        this.comboBizDataType.removeAllItems();
        this.comboBizDataType.addItem((Object)BizDataTypeEnum.Dim);
        this.comboBizDataType.addItem((Object)BizDataTypeEnum.Organization);
        if (BalanceTypeEnum.RealTime.equals((Object)this.parent.getBalanceType())) {
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.HappenData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.AssistInfo);
        } else {
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.BeginData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.InData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.OutData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.EndData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.YearTotalData);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.Year);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.Month);
            this.comboBizDataType.addItem((Object)BizDataTypeEnum.Period);
        }
        if (BizDataTypeEnum.BeginData.equals((Object)this.editData.getBizDataType())) {
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"78_BalanceFieldModelEditUI"));
        } else if (BizDataTypeEnum.YearTotalData.equals((Object)this.editData.getBizDataType())) {
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"79_BalanceFieldModelEditUI"));
        } else {
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"80_BalanceFieldModelEditUI"));
        }
        this.prmtCalExpression.setSelector(null);
    }

    private void dataTypeChanged(ItemEvent e) {
        if (DataTypeEnum.String.equals(e.getItem())) {
            this.txtLength.setEnabled(true);
            this.txtLength.setRequired(true);
        } else {
            this.txtLength.setEnabled(false);
            this.txtLength.setValue((Object)0);
        }
        if (DataTypeEnum.BOSUuid.equals(e.getItem())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"81_BalanceFieldModelEditUI"));
        } else if (DataTypeEnum.Enum.equals(e.getItem())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"82_BalanceFieldModelEditUI"));
        } else {
            this.prmtBaseData.setEnabled(false);
        }
        this.prmtBaseData.setValue(null);
        this.prmtBaseData.setSelector(null);
        if (DataTypeEnum.Qty.equals(e.getItem()) || DataTypeEnum.Amount.equals(e.getItem()) || DataTypeEnum.Price.equals(e.getItem()) || DataTypeEnum.Boolean.equals(e.getItem()) || DataTypeEnum.Integer.equals(e.getItem())) {
            this.txtDefaultValue.setText("0");
        } else {
            this.txtDefaultValue.setText("");
        }
    }

    private void bizDataTypeChanged(ItemEvent e) {
        BizDataTypeEnum data = (BizDataTypeEnum)((Object)e.getItem());
        if (BizDataTypeEnum.BeginData.equals((Object)data)) {
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"78_BalanceFieldModelEditUI"));
        } else if (BizDataTypeEnum.YearTotalData.equals((Object)data)) {
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"83_BalanceFieldModelEditUI"));
        } else if ("AssistInfo".equals(data.getName())) {
            this.chkIsSPvisible.setEnabled(true);
        } else {
            this.chkIsSPvisible.setEnabled(false);
            this.contCalExpression.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"80_BalanceFieldModelEditUI"));
        }
        this.prmtCalExpression.setValue(null);
    }

    private void setComponentState() {
        if (!this.parent.getState().equals((Object)UseStatusEnum.SAVED) && this.getOprtState().equals(OprtState.EDIT)) {
            this.txtName.setEnabled(false);
            this.comboDataType.setEnabled(false);
        } else {
            this.txtName.setEnabled(true);
            this.comboDataType.setEnabled(true);
        }
        if (this.parent.getState().equals((Object)UseStatusEnum.SAVED)) {
            this.chkIsScheduled.setEnabled(true);
        } else {
            this.chkIsScheduled.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnNew.setVisible(true);
        } else {
            this.btnNew.setVisible(false);
        }
    }

    @Override
    public void storeFields() {
        this.beforeStoreFields();
        super.storeFields();
        if (this.prmtCalExpression.getValue() == null) {
            this.editData.setCalExpression(null);
            this.editData.setCalExpressionAlias(null);
        }
        this.editData = (BalanceFieldModelInfo)this.getDataObject();
    }

    protected void beforeStoreFields() {
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"84_BalanceFieldModelEditUI"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        this.checkFieldNameDup();
        if (this.comboDataType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"85_BalanceFieldModelEditUI"));
            this.comboDataType.requestFocus();
            SysUtil.abort();
        }
        if (this.comboBizDataType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"86_BalanceFieldModelEditUI"));
            this.comboBizDataType.requestFocus();
            SysUtil.abort();
        }
        if (this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.String) && this.txtLength.getIntegerValue() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"87_BalanceFieldModelEditUI"));
            this.txtLength.requestFocus();
            SysUtil.abort();
        }
        if ((this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.BeginData) || this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.InData) || this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.OutData) || this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.EndData)) && !this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.Amount) && !this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.Qty) && !this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.Price)) {
            MsgBox.showInfo((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"88_BalanceFieldModelEditUI", (String[])new String[]{((BizDataTypeEnum)((Object)this.comboBizDataType.getSelectedItem())).getAlias()}));
            this.comboDataType.requestFocus();
            SysUtil.abort();
        }
        if ((this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.Year) || this.comboBizDataType.getSelectedItem().equals((Object)BizDataTypeEnum.Month)) && !this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.Integer)) {
            MsgBox.showInfo((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"89_BalanceFieldModelEditUI", (String[])new String[]{((BizDataTypeEnum)((Object)this.comboBizDataType.getSelectedItem())).getAlias()}));
            this.comboDataType.requestFocus();
            SysUtil.abort();
        }
        if (!this.chkIsNullable.isSelected() && StringUtil.isEmpty((String)this.txtDefaultValue.getText()) && !UseStatusEnum.SAVED.equals((Object)this.parent.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"90_BalanceFieldModelEditUI"));
            this.txtDefaultValue.requestFocus();
            SysUtil.abort();
        }
    }

    private void checkFieldNameDup() {
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.parent.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getId() == null || fieldInfo.getId().equals((Object)this.editData.getId()) || !fieldInfo.getName().equals(this.txtName.getText())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"91_BalanceFieldModelEditUI"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
    }

    private void initFieldFormula(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        this.storeFields();
        ArrayList<BizDataTypeEnum> bizTypefilter = new ArrayList<BizDataTypeEnum>();
        if (BizDataTypeEnum.BeginData.equals((Object)this.editData.getBizDataType())) {
            bizTypefilter.add(BizDataTypeEnum.EndData);
            BalanceFieldSelector selector = new BalanceFieldSelector(this.getUIWindow(), this.parent, bizTypefilter);
            f7Box.setSelector((KDPromptSelector)selector);
        } else if (BizDataTypeEnum.YearTotalData.equals((Object)this.editData.getBizDataType())) {
            bizTypefilter.add(BizDataTypeEnum.InData);
            bizTypefilter.add(BizDataTypeEnum.OutData);
            BalanceFieldSelector selector = new BalanceFieldSelector(this.getUIWindow(), this.parent, bizTypefilter);
            f7Box.setSelector((KDPromptSelector)selector);
        } else if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof BalanceFormulaSelector)) {
            BalanceFormulaSelector selector = new BalanceFormulaSelector(this.getUIWindow(), this.parent, this.editData);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    private void initBaseDataSelector(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
            EntitySelector selector = null;
            if (DataTypeEnum.BOSUuid.equals((Object)dataItem)) {
                selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"92_BalanceFieldModelEditUI"), EntitySelectorType.BaseData);
            } else if (DataTypeEnum.Enum.equals((Object)dataItem)) {
                selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"93_BalanceFieldModelEditUI"), EntitySelectorType.BizEnum);
            }
            f7Box.setSelector(selector);
        }
    }

    private void transBaseDataResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            if (e.getData() instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)e.getData();
                e.setData((Object)entity.getDisplayName());
                f7Box.setUserObject((Object)entity);
            } else if (e.getData() instanceof BizEnumInfo) {
                BizEnumInfo bizInfo = (BizEnumInfo)e.getData();
                e.setData((Object)bizInfo.getAlias());
                f7Box.setUserObject((Object)bizInfo);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void baseDataDataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.editData.setBaseDataBOSType(null);
            this.editData.setBaseDataAlias(null);
            return;
        }
        if (eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
        if (DataTypeEnum.BOSUuid.equals((Object)dataItem)) {
            EntityObjectInfo bdEntity = (EntityObjectInfo)this.prmtBaseData.getUserObject();
            this.editData.setBaseDataBOSType(bdEntity.getType().toString());
            this.editData.setBaseDataAlias(bdEntity.getDisplayName());
        } else if (DataTypeEnum.Enum.equals((Object)dataItem)) {
            BizEnumInfo bizInfo = (BizEnumInfo)this.prmtBaseData.getUserObject();
            this.editData.setBaseDataBOSType(bizInfo.getFullName());
            this.editData.setBaseDataAlias(bizInfo.getAlias());
        }
    }

    protected IObjectValue createNewData() {
        BalanceFieldModelInfo info = new BalanceFieldModelInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setSeq(this.parent.getEntry().size() + 1);
        info.setName("Field" + info.getSeq());
        info.setIsNullable(true);
        if (this.parent.getState().equals((Object)UseStatusEnum.SAVED)) {
            info.setIsScheduled(true);
        } else {
            info.setIsScheduled(false);
        }
        info.setParent(this.parent);
        return info;
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.parent.getEntry().add(this.editData);
        this.isConfirm = true;
        this.editData = (BalanceFieldModelInfo)this.createNewData();
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.parent.getEntry().add(this.editData);
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

