/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.framework.balance.RelationTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractDataTableEditUI;
import com.kingdee.eas.scm.framework.balance.model.PropertyMeta;
import com.kingdee.eas.scm.framework.balance.model.PropertyMetaUtil;
import com.kingdee.eas.scm.framework.client.EntitySelector;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.framework.model.JoinCondition;
import com.kingdee.eas.scm.framework.model.JoinConditionCollection;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComboBox;

public class DataTableEditUI
extends AbstractDataTableEditUI {
    private static final long serialVersionUID = 1L;
    private static final int COL_CHILD_IDX = 0;
    private static final int COL_COMPARESIGN_IDX = 1;
    private static final int COL_PARENT_IDX = 2;
    private static final int COL_LOGIC_IDX = 3;
    private static final String COMPARE_SIGN = "=";
    private DataQueryInfo dataQuery;
    private DataTableInfo parentTable;
    private DataTableInfo editData;
    private EntityObjectInfo childObject;
    private boolean isConfirm = false;
    private int defaultRows = 10;
    private KDComboBox cmbChildProperty;
    private KDComboBox cmbParentProperty;
    private SelectorListener childSelectorListener = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            DataTableEditUI.this.initChildObjectF7(e);
        }
    };
    private PreChangeListener childPreChangeListener = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            DataTableEditUI.this.transBillTypeResult(e);
        }
    };
    private DataChangeListener childChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            try {
                DataTableEditUI.this.childObjectChanged(e);
            }
            catch (Exception err) {
                ExceptionHandler.handle((Throwable)err);
            }
        }
    };

    public DataTableEditUI() throws Exception {
        this.prmtChildObject.setRequired(true);
        this.prmtChildObject.setEditable(false);
    }

    public void onLoad() throws Exception {
        this.dataQuery = (DataQueryInfo)this.getUIContext().get("DataQuery");
        this.editData = (DataTableInfo)this.getUIContext().get("DataTable");
        this.parentTable = this.editData.getParentTable();
        super.onLoad();
        this.removeListener();
        this.loadFields();
        this.addListener();
    }

    @Override
    public void loadFields() {
        if (this.parentTable != null) {
            this.txtParentObject.setText(this.parentTable.getDisplayName());
        }
        if (this.editData.getJoinType() != null) {
            this.cmbRelationType.setSelectedItem((Object)this.editData.getJoinType());
        } else {
            this.cmbRelationType.setSelectedItem((Object)RelationTypeEnum.Inner_Join);
        }
        this.txtChildName.setSelectedLanguage(new LanguageInfo(LocaleUtils.getDefaultLocale()));
        if (this.editData.getBosType() != null) {
            this.childObject = SCMMDUtil.getEntityByBosType(this.editData.getBosType());
            this.prmtChildObject.setValue((Object)this.childObject.getFullName());
            this.txtChildName.setSelectedItemData((Object)this.editData.getName());
            this.txtChildAlias.setText(this.editData.getTableAlias());
        }
        try {
            this.initTable();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.editData.isIsMainTable()) {
            this.cmbRelationType.setEnabled(false);
            this.tblJoinCondition.setEnabled(false);
        } else {
            this.cmbRelationType.setEnabled(true);
            this.tblJoinCondition.setEnabled(true);
        }
    }

    private void initTable() throws Exception {
        this.tblJoinCondition.checkParsed();
        this.cmbChildProperty = new KDComboBox();
        this.fillComBoxTableFields(this.editData, this.cmbChildProperty);
        this.tblJoinCondition.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbChildProperty));
        this.cmbParentProperty = new KDComboBox();
        this.fillComBoxTableFields(this.parentTable, this.cmbParentProperty);
        this.tblJoinCondition.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbParentProperty));
        this.tblJoinCondition.getColumn(1).getStyleAttributes().setLocked(true);
        List valueList = EnumUtils.getEnumList((String)LogicSignEnum.class.getName());
        KDComboBox cmbLogicSign = this.getFieldComboBoxField(valueList.toArray());
        this.tblJoinCondition.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLogicSign));
        this.fillJoinCondition();
        this.fillLeftRows();
        this.tblJoinCondition.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                DataTableEditUI.this.editedCellAfter(e);
            }
        });
    }

    private void editedCellAfter(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.tblJoinCondition.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null || StringUtil.isEmpty((String)object.toString())) {
            if (colIndex == 0) {
                this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(2).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(3).setValue(null);
            }
            return;
        }
        if (colIndex == 0) {
            this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue((Object)COMPARE_SIGN);
        }
    }

    private void removeListener() {
        this.prmtChildObject.removeSelectorListener(this.childSelectorListener);
        this.prmtChildObject.removePreChangeListener(this.childPreChangeListener);
        this.prmtChildObject.removeDataChangeListener(this.childChangeListener);
    }

    private void addListener() {
        this.prmtChildObject.addSelectorListener(this.childSelectorListener);
        this.prmtChildObject.addPreChangeListener(this.childPreChangeListener);
        this.prmtChildObject.addDataChangeListener(this.childChangeListener);
    }

    private void fillJoinCondition() throws Exception {
        JoinCondition condition = null;
        JoinConditionCollection coll = this.editData.getJoinConditionCollection();
        List<PropertyMeta> childList = PropertyMetaUtil.getEntityProperty(this.editData);
        List<PropertyMeta> parentList = PropertyMetaUtil.getEntityProperty(this.parentTable);
        for (int i = 0; i < coll.getConditionCount(); ++i) {
            condition = coll.getJoinConditionAt(i);
            IRow row = this.addRow();
            this.setFieldComboBoxField(this.tblJoinCondition, row.getRowIndex(), 0, childList.toArray(), condition.getChildField().getFieldName());
            row.getCell(1).setValue((Object)COMPARE_SIGN);
            this.setFieldComboBoxField(this.tblJoinCondition, row.getRowIndex(), 2, parentList.toArray(), condition.getParentField().getFieldName());
            this.setLogicComboBoxField(this.tblJoinCondition, row.getRowIndex(), 3, condition.getLogicSign());
            row.setUserObject((Object)condition);
        }
    }

    private void setFieldComboBoxField(KDTable table, int rowIndex, int colIndex, Object[] valueArray, String fieldValue) {
        KDComboBox comboBox = this.getFieldComboBoxField(valueArray);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        PropertyMeta obj = null;
        for (int i = 1; i < count; ++i) {
            obj = (PropertyMeta)comboBox.getItemAt(i);
            if (!obj.getMappingField().getName().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)obj);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void setLogicComboBoxField(KDTable table, int rowIndex, int colIndex, String fieldValue) {
        List valueList = EnumUtils.getEnumList((String)LogicSignEnum.class.getName());
        KDComboBox comboBox = this.getFieldComboBoxField(valueList.toArray());
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        LogicSignEnum obj = null;
        for (int i = 1; i < count; ++i) {
            obj = (LogicSignEnum)comboBox.getItemAt(i);
            if (obj == null || !obj.getValue().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)obj);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private KDComboBox getFieldComboBoxField(Object[] valueArray) {
        KDComboBox kdComboBox = new KDComboBox(valueArray);
        kdComboBox.insertItemAt((Object)"", 0);
        return kdComboBox;
    }

    private void fillLeftRows() {
        int rowCount = this.tblJoinCondition.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.addRow();
            }
        }
    }

    private IRow addRow() {
        int currentRowSize = this.tblJoinCondition.getRowCount();
        return this.tblJoinCondition.addRow(currentRowSize);
    }

    private void fillComBoxTableFields(DataTableInfo dataTable, KDComboBox cmbEntityProperty) {
        cmbEntityProperty.removeAllItems();
        if (dataTable == null || dataTable.getEntity() == null) {
            return;
        }
        List<PropertyMeta> propertyList = PropertyMetaUtil.getEntityProperty(dataTable);
        cmbEntityProperty.addItem((Object)"");
        cmbEntityProperty.addItems(propertyList.toArray());
    }

    @Override
    public void storeFields() {
        this.beforeStoreFields();
        this.editData.setBosType(this.childObject.getType().toString());
        this.editData.setName(this.txtChildName.getSelectedItemData().toString());
        this.editData.setTableName(this.childObject.getTable().getName());
        this.editData.setTableAlias(this.txtChildAlias.getText());
        this.editData.setJoinType((RelationTypeEnum)((Object)this.cmbRelationType.getSelectedItem()));
        this.storeJoinCondition();
    }

    private void storeJoinCondition() {
        IRow row = null;
        boolean isFirst = true;
        LogicSignEnum logicSign = null;
        StringBuffer joinString = new StringBuffer();
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(0).getValue() == null || StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) continue;
            if (!isFirst) {
                joinString.append(" ").append(logicSign == null ? "AND" : logicSign.getValue()).append(" ");
            }
            PropertyMeta property = (PropertyMeta)row.getCell(0).getValue();
            joinString.append(property.getFullSQLFieldName());
            joinString.append(row.getCell(1).getValue());
            property = (PropertyMeta)row.getCell(2).getValue();
            joinString.append(property.getFullSQLFieldName());
            if (row.getCell(3).getValue() instanceof LogicSignEnum) {
                logicSign = (LogicSignEnum)row.getCell(3).getValue();
            }
            isFirst = false;
        }
        this.editData.setJoinCondition(joinString.toString());
    }

    protected void beforeStoreFields() {
        if (this.childObject == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"124_DataTableEditUI"));
            this.prmtChildObject.requestFocus();
            SysUtil.abort();
        }
        if (this.cmbRelationType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"125_DataTableEditUI"));
            this.cmbRelationType.requestFocus();
            SysUtil.abort();
        }
        if (this.txtChildName.getSelectedItemData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"126_DataTableEditUI"));
            this.txtChildName.requestFocus();
            SysUtil.abort();
        } else if (this.dataQuery.isTableNameDumplicate(this.editData.getId(), this.txtChildName.getSelectedItemData().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"127_DataTableEditUI"));
            this.txtChildName.requestFocus();
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)this.txtChildAlias.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"128_DataTableEditUI"));
            this.txtChildAlias.requestFocus();
            SysUtil.abort();
        } else if (this.dataQuery.isTableAliasDumplicate(this.editData.getId(), this.txtChildAlias.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"129_DataTableEditUI"));
            this.txtChildAlias.requestFocus();
            SysUtil.abort();
        }
        if (this.isRelationTableEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"130_DataTableEditUI"));
            SysUtil.abort();
        }
    }

    private boolean isRelationTableEmpty() {
        IRow row = null;
        boolean result = true;
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(0).getValue() == null || StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) continue;
            if (row.getCell(2).getValue() == null || StringUtil.isEmpty((String)row.getCell(2).getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"131_DataTableEditUI"));
                SysUtil.abort();
            }
            result = false;
        }
        return result;
    }

    private void initChildObjectF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            EntitySelector selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"132_DataTableEditUI"), EntitySelectorType.FullEntity);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = (EntityObjectInfo)e.getData();
            if (entity != null) {
                e.setData((Object)entity.getFullName());
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void childObjectChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.childObject = null;
            this.cmbChildProperty.removeAllItems();
            this.txtChildName.setSelectedItemData(null);
            this.txtChildAlias.setText(null);
            this.clearJoinTable();
            return;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.childObject = (EntityObjectInfo)this.prmtChildObject.getUserObject();
        this.txtChildName.setSelectedItemData((Object)this.childObject.getAlias());
        this.txtChildAlias.setText(this.childObject.getName());
        this.editData.setTableName(this.childObject.getTable().getName());
        this.editData.setName(this.childObject.getAlias());
        this.editData.setBosType(this.childObject.getType().toString());
        this.editData.setTableAlias(this.childObject.getName());
        this.clearJoinTable();
        this.fillComBoxTableFields(this.editData, this.cmbChildProperty);
    }

    private void clearJoinTable() {
        IRow row = null;
        int count = this.tblJoinCondition.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblJoinCondition.getRow(i);
            row.getCell(0).setValue(null);
            row.getCell(1).setValue(null);
            row.getCell(2).setValue(null);
            row.getCell(3).setValue(null);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

