/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.util;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTableCollection;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.framework.balance.model.PropertyMeta;
import com.kingdee.eas.scm.framework.balance.model.PropertyMetaUtil;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class DataQueryTreeUtil {
    public static DefaultKingdeeTreeNode getDataQueryRoot(DataQueryInfo dataQuery) {
        if (dataQuery == null || dataQuery.getMainTable() == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = DataQueryTreeUtil.createRoot(dataQuery);
        DataTableCollection coll = dataQuery.getEntry();
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            DataQueryTreeUtil.addTableNode(root, coll.get(i), null);
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getDataQueryRoot(DataQueryInfo dataQuery, BalanceFieldModelInfo fieldModel) {
        if (dataQuery == null || dataQuery.getMainTable() == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = DataQueryTreeUtil.createRoot(dataQuery);
        DataTableCollection coll = dataQuery.getEntry();
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            DataQueryTreeUtil.addTableNode(root, coll.get(i), fieldModel);
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createRoot(DataQueryInfo dataQuery) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(dataQuery.getName());
        return root;
    }

    protected static void fillChildrenNode(DataQueryInfo dataQuery, DefaultKingdeeTreeNode root, DataTableInfo table, BalanceFieldModelInfo fieldModel) {
        if (table == null) {
            return;
        }
        DataTableCollection coll = table.getChildren(dataQuery.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            DefaultKingdeeTreeNode node = DataQueryTreeUtil.addTableNode(root, coll.get(i), fieldModel);
            DataQueryTreeUtil.fillChildrenNode(dataQuery, node, coll.get(i), fieldModel);
        }
    }

    private static DefaultKingdeeTreeNode addTableNode(DefaultKingdeeTreeNode parent, DataTableInfo table, BalanceFieldModelInfo fieldModel) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getName());
        if (parent != null) {
            parent.add((MutableTreeNode)treeNode);
        }
        DataQueryTreeUtil.addTableFieldNode(treeNode, table, fieldModel);
        return treeNode;
    }

    private static void addTableFieldNode(DefaultKingdeeTreeNode parent, DataTableInfo table, BalanceFieldModelInfo fieldModel) {
        if (table == null) {
            return;
        }
        try {
            PropertyMeta property = null;
            List<PropertyMeta> fieldList = PropertyMetaUtil.getEntityProperty(table);
            for (int i = 0; i < fieldList.size(); ++i) {
                property = fieldList.get(i);
                if (!DataQueryTreeUtil.isSameDataType(fieldModel, property)) continue;
                DataQueryTreeUtil.addOneFieldNode(parent, property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addOneFieldNode(DefaultKingdeeTreeNode parent, PropertyMeta property) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)property);
        treeNode.setText(property.getAlias());
        parent.add((MutableTreeNode)treeNode);
    }

    private static boolean isSameDataType(BalanceFieldModelInfo fieldModel, PropertyMeta property) {
        String fieldDataType;
        if (fieldModel == null) {
            return true;
        }
        String propertyDataType = property.getDataType();
        if (propertyDataType.equalsIgnoreCase(fieldDataType = fieldModel.getDataType().getName())) {
            if (fieldDataType.equals("Enum") && fieldModel.getBaseDataBOSType() != null) {
                return property.getEnumClassName().equals(fieldModel.getBaseDataBOSType());
            }
            return true;
        }
        if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
            return true;
        }
        if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
            if (fieldModel.getBaseDataBOSType() != null && property.getRelationBosType().equals(fieldModel.getBaseDataBOSType())) {
                return true;
            }
            if (fieldModel.getBaseDataBOSType() == null) {
                return true;
            }
        }
        return false;
    }
}

