/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.framework.api.bizflow.client.SelectBizFlowUI;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class BizFlowClientHelper {
    private String billID = null;
    private CoreBillBaseInfo editData = null;
    private CoreUI bizUI = null;
    Map<String, Set<String>> bizFlowConfigMap = new LinkedHashMap<String, Set<String>>();
    Map<String, Set<String>> bizFlowConfigNameToCombox = new LinkedHashMap<String, Set<String>>();
    Map<String, Map<String, String>> batchBizFlowMap = null;
    private String billEntryName = null;
    private String alterBillOldEntryIDName = null;

    public BizFlowClientHelper(CoreUI ui, String billID, String billEntryName) throws EASBizException, BOSException {
        this.billEntryName = billEntryName;
        if (ui instanceof ListUI) {
            this.init4ListUI(ui, billID);
        } else if (ui instanceof EditUI) {
            this.init4EditUI(ui);
        }
    }

    public BizFlowClientHelper(CoreUI ui, String billID, String billEntryName, String alterBillOldEntryIDName) throws EASBizException, BOSException {
        this.billEntryName = billEntryName;
        this.alterBillOldEntryIDName = alterBillOldEntryIDName;
        if (ui instanceof ListUI) {
            this.init4ListUI(ui, billID);
        } else if (ui instanceof EditUI) {
            this.init4EditUI(ui);
        }
    }

    public BizFlowClientHelper(CoreUI ui, LinkedHashSet<String> billIDs, String billEntryName) throws EASBizException, BOSException {
        if (!(ui instanceof ListUI) || CollectionUtil.isEmpty(billIDs)) {
            return;
        }
        this.bizUI = ui;
        this.billEntryName = billEntryName;
        if (billIDs.size() == 1) {
            Iterator itor = billIDs.iterator();
            this.init4ListUI(ui, (String)itor.next());
            return;
        }
        this.batchBizFlowAdaption(billIDs);
    }

    private void init4EditUI(CoreUI ui) {
        if (ui != null) {
            this.bizUI = ui;
        }
        this.editData = ((CoreBillEditUI)this.bizUI).getEditData();
        if (this.editData == null) {
            return;
        }
        if (this.editData.getId() != null) {
            this.billID = this.editData.getId().toString();
        }
        if (!this.getBizFlowList((IObjectValue)this.editData)) {
            return;
        }
        this.editData.put("beforeBizFlowSelect", this.bizFlowAdaptation());
        this.bizUI.loadFields();
    }

    private void init4ListUI(CoreUI ui, String billID) throws EASBizException, BOSException {
        if (ui != null) {
            this.bizUI = ui;
        }
        this.billID = billID;
        this.editData = (CoreBillBaseInfo)this.getBillModelByID(billID);
        if (!this.getBizFlowList((IObjectValue)this.editData)) {
            return;
        }
        this.batchBizFlowMap = new HashMap<String, Map<String, String>>();
        this.batchBizFlowMap.put(billID, this.bizFlowAdaptation());
    }

    public Map<String, Map<String, String>> getBatchBizFlowMap() {
        return this.batchBizFlowMap;
    }

    public SelectBizFlowUI getUI() {
        UIContext uiContext = new UIContext(null);
        uiContext.put((Object)"ID", (Object)this.billID);
        uiContext.put((Object)"Owner", (Object)this.bizUI);
        uiContext.put((Object)"InitDataObject", this.bizFlowConfigNameToCombox);
        uiContext.put((Object)"ALTERBILLOLDENTRY", (Object)this.alterBillOldEntryIDName);
        SelectBizFlowUI ui = null;
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectBizFlowUI.class.getName(), (Map)uiContext);
            ui = (SelectBizFlowUI)uiWindow.getUIObject();
            ui.init((IObjectValue)this.editData, this.billEntryName, this.bizFlowConfigMap);
            uiWindow.show();
        }
        catch (UIException e) {
            this.bizUI.handUIException((Throwable)e);
        }
        return ui;
    }

    private boolean getBizFlowList(IObjectValue model) {
        if (model != null) {
            if (!this.initBillInfo(model)) {
                return false;
            }
            try {
                this.bizFlowConfigMap = BizFlowFacadeFactory.getRemoteInstance().bizFlowAdaptationByEntry(model, BatchActionEnum.SUBMIT);
            }
            catch (BOSException e) {
                this.bizUI.handUIException((Throwable)e);
            }
            catch (EASBizException e) {
                this.bizUI.handUIException((Throwable)e);
            }
        }
        return true;
    }

    private boolean initBillInfo(IObjectValue model) {
        IObjectCollection entryColl = (IObjectCollection)model.get(this.billEntryName);
        if (CollectionUtil.isEmpty((IObjectCollection)entryColl) || entryColl.getObject(0) == null || entryColl.getObject(0).getBOSType() == null) {
            return false;
        }
        BOSObjectType bosType = null;
        if (StringUtil.isEmpty((String)model.getString("id"))) {
            ((AbstractObjectValue)model).setSyncOldValue(true);
            bosType = model.getBOSType();
            model.put("id", (Object)BOSUuid.create((BOSObjectType)bosType));
        }
        bosType = entryColl.getObject(0).getBOSType();
        IObjectValue entryInfo = null;
        BOSUuid entryID = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.getObject(i);
            if (!StringUtil.isEmpty((String)entryInfo.getString("id"))) continue;
            ((AbstractObjectValue)model).setSyncOldValue(true);
            entryID = BOSUuid.create((BOSObjectType)bosType);
            entryInfo.put("id", (Object)entryID);
        }
        ((AbstractObjectValue)model).setSyncOldValue(false);
        return true;
    }

    private Map<String, String> bizFlowAdaptation() {
        HashMap<String, String> confirmBizFlowMap = new HashMap();
        if (!CollectionUtil.isEmpty(this.bizFlowConfigMap)) {
            SelectBizFlowUI ui;
            Set<String> allBillEntryIDs = this.bizFlowConfigMap.get("ENTRY_WITH_BIZFLOW");
            this.bizFlowConfigMap.remove("ENTRY_WITH_BIZFLOW");
            if (this.bizFlowConfigMap.isEmpty()) {
                return null;
            }
            this.bizFlowConfigNameToCombox = this.bizFlowConfigMap;
            if (!this.isAllEntryWithBizFlow(allBillEntryIDs)) {
                String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"79_BizFlowIsNull");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (this.isAllEntryWithBizFlow(allBillEntryIDs)) {
                if (this.bizFlowConfigMap.size() == 1) {
                    for (Map.Entry<String, Set<String>> mapEntry : this.bizFlowConfigMap.entrySet()) {
                        String bizFlowID = mapEntry.getKey();
                        bizFlowID = this.getRealBizFlowID(bizFlowID);
                        confirmBizFlowMap.put("ALL_ENTRY", bizFlowID);
                    }
                    return confirmBizFlowMap;
                }
                if (!this.isNeedShowUI()) {
                    Iterator<Map.Entry<String, Set<String>>> itor = this.bizFlowConfigMap.entrySet().iterator();
                    String bizFlowID = null;
                    while (itor.hasNext()) {
                        Map.Entry<String, Set<String>> mapEntry = itor.next();
                        bizFlowID = mapEntry.getKey();
                        bizFlowID = this.getRealBizFlowID(bizFlowID);
                        Set<String> entrySet = mapEntry.getValue();
                        Iterator<String> it = entrySet.iterator();
                        String billEntryID = null;
                        while (it.hasNext()) {
                            billEntryID = it.next();
                            confirmBizFlowMap.put(billEntryID, bizFlowID);
                        }
                    }
                    return confirmBizFlowMap;
                }
            }
            if (!(ui = this.getUI()).isCancel()) {
                confirmBizFlowMap = ui.getReturnObjects();
                confirmBizFlowMap = ui.getReturnObjects();
                int entryCount = ui.getEntryRowCount();
                if (entryCount == confirmBizFlowMap.size()) {
                    return confirmBizFlowMap;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"32_BizFlowSelectUI"));
                SysUtil.abort();
                return confirmBizFlowMap;
            }
        } else {
            return null;
        }
        SysUtil.abort();
        return confirmBizFlowMap;
    }

    private String getRealBizFlowID(String bizFlowID) {
        if (StringUtil.isEmpty((String)bizFlowID)) {
            return null;
        }
        return bizFlowID.split("!@#!@#")[0];
    }

    private boolean isNeedShowUI() {
        IObjectCollection entryColl = (IObjectCollection)this.editData.get(this.billEntryName);
        if (!CollectionUtil.isEmpty((IObjectCollection)entryColl)) {
            Iterator<Map.Entry<String, Set<String>>> itor = this.bizFlowConfigMap.entrySet().iterator();
            Set<String> billEntrys = null;
            int size = 0;
            while (itor.hasNext()) {
                Map.Entry<String, Set<String>> mapEntry = itor.next();
                billEntrys = mapEntry.getValue();
                if (billEntrys.size() == 0) {
                    return true;
                }
                size += billEntrys.size();
            }
            return entryColl.size() != size;
        }
        return true;
    }

    private boolean isAllEntryWithBizFlow(Set<String> allBillEntryIDs) {
        IObjectCollection entryColl = (IObjectCollection)this.editData.get(this.billEntryName);
        if (!CollectionUtil.isEmpty((IObjectCollection)entryColl)) {
            if (entryColl.size() == allBillEntryIDs.size()) {
                return true;
            }
            Iterator<Map.Entry<String, Set<String>>> itor = this.bizFlowConfigMap.entrySet().iterator();
            Set<String> billEntrys = null;
            while (itor.hasNext()) {
                Map.Entry<String, Set<String>> mapEntry = itor.next();
                billEntrys = mapEntry.getValue();
                if (billEntrys.size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private IObjectValue getBillModelByID(String billID) throws BOSException, EASBizException {
        if (billID == null || billID.length() == 0) {
            return null;
        }
        CoreBillBaseInfo model = null;
        ICoreBillBase iCoreBill = null;
        iCoreBill = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)BOSObjectType.create((String)BOSUuid.read((String)billID).getType().toString()), ICoreBillBase.class);
        model = iCoreBill.getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(billID));
        return model;
    }

    private void batchBizFlowAdaption(LinkedHashSet<String> billIDs) {
        this.batchBizFlowMap = new HashMap<String, Map<String, String>>();
        Map billBizFlowMap = null;
        try {
            billBizFlowMap = BizFlowFacadeFactory.getRemoteInstance().batchBizFlowAdaptation(billIDs, BatchActionEnum.SUBMIT, this.billEntryName);
        }
        catch (EASBizException e) {
            this.bizUI.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            this.bizUI.handUIException((Throwable)e);
        }
        if (CollectionUtil.isEmpty((Map)billBizFlowMap)) {
            return;
        }
        Map<Object, Object> billInfoMap = new HashMap();
        try {
            billInfoMap = this.getBillInfoMapByID(billIDs);
        }
        catch (BOSException e) {
            this.bizUI.handUIException((Throwable)e);
        }
        Iterator itor = billBizFlowMap.entrySet().iterator();
        Map.Entry entry = null;
        Map bizFlowMap = null;
        Map<String, String> confirmBizFlowMap = null;
        String billID = null;
        while (itor.hasNext()) {
            entry = itor.next();
            billID = (String)entry.getKey();
            bizFlowMap = (Map)entry.getValue();
            this.editData = (CoreBillBaseInfo)billInfoMap.get(billID);
            confirmBizFlowMap = this.bizFlowAdaption(bizFlowMap);
            if (confirmBizFlowMap != null && confirmBizFlowMap.size() == 0) {
                String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"96_BatchSubmitError");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            this.batchBizFlowMap.put(billID, confirmBizFlowMap);
        }
    }

    private Map<String, String> bizFlowAdaption(Map<String, Set<String>> bizFlowMap) {
        HashMap<String, String> confirmBizFlowMap = new HashMap<String, String>();
        if (CollectionUtil.isEmpty(bizFlowMap)) {
            return null;
        }
        bizFlowMap.remove("ENTRY_WITH_BIZFLOW");
        if (bizFlowMap.isEmpty()) {
            return null;
        }
        if (bizFlowMap.containsKey("isAllEntryWithBizFlow")) {
            return confirmBizFlowMap;
        }
        if (bizFlowMap.size() == 1) {
            for (Map.Entry<String, Set<String>> mapEntry : bizFlowMap.entrySet()) {
                String bizFlowID = mapEntry.getKey();
                bizFlowID = this.getRealBizFlowID(bizFlowID);
                confirmBizFlowMap.put("ALL_ENTRY", bizFlowID);
            }
            return confirmBizFlowMap;
        }
        if (!this.isNeedShowUI()) {
            Iterator<Map.Entry<String, Set<String>>> itor = bizFlowMap.entrySet().iterator();
            String bizFlowID = null;
            while (itor.hasNext()) {
                Map.Entry<String, Set<String>> mapEntry = itor.next();
                bizFlowID = mapEntry.getKey();
                bizFlowID = this.getRealBizFlowID(bizFlowID);
                Set<String> entrySet = mapEntry.getValue();
                Iterator<String> it = entrySet.iterator();
                String billEntryID = null;
                while (it.hasNext()) {
                    billEntryID = it.next();
                    confirmBizFlowMap.put(billEntryID, bizFlowID);
                }
            }
            return confirmBizFlowMap;
        }
        return confirmBizFlowMap;
    }

    private Map<String, IObjectValue> getBillInfoMapByID(Set<String> billIDs) throws BOSException {
        if (CollectionUtil.isEmpty(billIDs)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIDs, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        Iterator<String> itor = billIDs.iterator();
        BOSObjectType bosObjectType = BOSObjectType.create((String)BOSUuid.read((String)itor.next()).getType().toString());
        ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBillBase.class);
        CoreBaseCollection billColl = new CoreBaseCollection();
        try {
            for (String billId : billIDs) {
                billColl.add(icoreBase.getValue((IObjectPK)new ObjectUuidPK(billId)));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, IObjectValue> billInfoMap = new HashMap<String, IObjectValue>();
        IObjectValue billInfo = null;
        String billId = null;
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            billInfo = billColl.getObject(i);
            billId = billInfo.get("id").toString();
            billInfoMap.put(billId, billInfo);
        }
        return billInfoMap;
    }
}

