/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.CustomizedSelect;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.client.util.VirtualTreeNode;
import com.kingdee.eas.base.commonquery.CommonQuery;
import com.kingdee.eas.base.commonquery.CommonQuerySelect;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.client.DefaultPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BizFlowClientUtil {
    private static final String DEFAULT_F7_QUERY = "defaultF7Query";
    private static final String DEFAULT_F7_UI = "defaultF7UI";
    private static final String commonQueryFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String MAXLEVELINFO = "MAXLEVELINFO";

    public static KDPromptBox getF7(EntityObjectInfo entity, String fieldName, String bosType) throws BOSException {
        MetaDataPK pk = BizFlowClientUtil.getDefaultF7Query(entity);
        if (pk == null) {
            return null;
        }
        QuerySelect select = new QuerySelect(pk.getFullName());
        select.setAccessLoader(CommonUtils.getCustomQueryLoader(pk));
        select.propertyUnitSelect().select("*", null).extendPropertySelect().select(new String[]{DEFAULT_F7_QUERY, DEFAULT_F7_UI});
        SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
        SimplePropertyUnitCollection propertyUnitCollection = query.propertyUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            SimplePropertyUnit queryFieldInfo = propertyUnitCollection.get(i);
            if (!fieldName.equalsIgnoreCase(queryFieldInfo.getName())) continue;
            String defaultF7 = BizFlowClientUtil.getDefaultF7Query(queryFieldInfo);
            if (defaultF7 != null && !defaultF7.trim().equalsIgnoreCase("")) {
                return BizFlowClientUtil.createF7(defaultF7, pk, queryFieldInfo.getName(), true, null);
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
            EntityObjectInfo enty = loader.getEntity(BOSObjectType.create((String)bosType));
            defaultF7 = BizFlowClientUtil.getDefaultF7Query(BizFlowClientUtil.getSimpleEntity(enty.getFullName()));
            String defaultF7UI = BizFlowClientUtil.getDefaultF7UI(queryFieldInfo);
            if (defaultF7 == null || defaultF7.trim().equalsIgnoreCase("")) {
                if (defaultF7UI != null && !defaultF7UI.trim().equalsIgnoreCase("")) continue;
                MsgBox.showError((String)(EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning") + pk.getFullName() + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning1") + queryFieldInfo.getName() + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning2") + entity.getFullName() + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning3")));
                continue;
            }
            return BizFlowClientUtil.createF7(defaultF7, pk, queryFieldInfo.getName(), true, null);
        }
        return null;
    }

    public static DataObject getRefMetaData(EntityObjectInfo entity, String fieldName) throws BOSException {
        if (entity == null || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        MetaDataPK pk = BizFlowClientUtil.getDefaultF7Query(entity);
        if (pk == null) {
            return null;
        }
        DataObject[] dos = BizFlowClientUtil.getRefMetaData(pk, new String[]{fieldName});
        if (dos.length == 1) {
            return dos[0];
        }
        for (int i = 0; i < dos.length; ++i) {
            if (!fieldName.equals(dos[i].getOwner())) continue;
            return dos[i];
        }
        return null;
    }

    protected static DataObject[] getRefMetaData(MetaDataPK queryInfo, String[] queryFieldName) throws BOSException {
        CommonQuerySelect select = new CommonQuerySelect(queryInfo.getFullName());
        select.setAccessLoader(CommonUtils.getCustomQueryLoader(queryInfo));
        select.selectFieldRefMetaData(queryFieldName);
        CommonQuery query = (CommonQuery)MetaDataAccessFactory.getRemoteInstance().select((CustomizedSelect)select);
        return BizFlowClientUtil.toClientDataObject(query.getFieldRefMetaData());
    }

    public static DataObject getRefMetaData(MetaDataPK queryInfo, String queryFieldName) throws BOSException {
        if (queryFieldName == null) {
            return null;
        }
        DataObject[] dos = BizFlowClientUtil.getRefMetaData(queryInfo, new String[]{queryFieldName});
        if (dos.length == 1) {
            return dos[0];
        }
        for (int i = 0; i < dos.length; ++i) {
            if (!queryFieldName.equals(dos[i].getOwner())) continue;
            return dos[i];
        }
        return null;
    }

    public static KDBizPromptBox createNoNormalSimpleF7(String queryInfo, EntityViewInfo viewInfo) {
        KDBizPromptBox newPrmt = new KDBizPromptBox();
        newPrmt.setQueryInfo(queryInfo);
        newPrmt.setEditable(true);
        newPrmt.setDisplayFormat("$name$");
        newPrmt.setEditFormat("$number$");
        newPrmt.setCommitFormat("$id$");
        newPrmt.setEntityViewInfo(viewInfo);
        return newPrmt;
    }

    public static boolean isBoolean(MetaDataPK queryInfo, String queryFieldName) throws BOSException {
        DataObject dateType = BizFlowClientUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && DataType.BOOLEAN.getName().equals(dateType.getName());
    }

    public static boolean isEnum(MetaDataPK queryInfo, String queryFieldName) throws BOSException {
        DataObject dateType = BizFlowClientUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && DataType.ENUM.getName().equals(dateType.getName());
    }

    public static boolean isString(String typeName) {
        return typeName.equals(DataType.STRING.getName());
    }

    public static void setDateCtrlField(KDTable kdTable, int rowIndex, int colIndex, Date initDate) {
        KDDatePicker datePicker = new KDDatePicker();
        if (initDate instanceof Timestamp) {
            datePicker.setTimeEnabled(true);
        } else if (initDate instanceof Time) {
            datePicker.setTimeEnabled(true);
        }
        datePicker.setValue((Object)initDate);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    public static boolean[] isString(MetaDataPK pk, String[] queryFieldName, boolean isQuery) throws BOSException {
        CommonQuerySelect select = new CommonQuerySelect(pk.getFullName(), isQuery, false);
        select.setAccessLoader(CommonUtils.getCustomQueryLoader(pk));
        select.selectFieldIsString(queryFieldName);
        CommonQuery query = (CommonQuery)MetaDataAccessFactory.getRemoteInstance().select((CustomizedSelect)select);
        return query.getFieldIsString();
    }

    public static IObjectValue getBizData(IObjectValue data) throws BOSException {
        SimpleEntity entity = BizFlowClientUtil.getSimpleEntity(MDContextFactory.getRemoteInstance().entityMapping.getProperty(data.getBOSType()).getFullName());
        String pk = data.get(entity.getLogicalKeyProperties()[0]).toString();
        return BizFlowClientUtil.getRemoteValue(pk);
    }

    public static IObjectValue getRemoteValue(String pkValue) throws BOSException {
        BOSUuid id = BOSUuid.read((String)pkValue);
        IObjectValue objectValue = null;
        objectValue = DynamicObjectFactory.getRemoteInstance().getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        return objectValue;
    }

    public static SimpleEntity getSimpleEntity(String fullName) throws BOSException {
        EntitySelect select = new EntitySelect(fullName);
        select.extendPropertySelect().select(new String[]{DEFAULT_F7_QUERY, DEFAULT_F7_UI});
        select.selectLogicalKeyProperties();
        return MetaDataAccessFactory.getRemoteInstance().select(select);
    }

    public static DataObject[] toClientDataObject(DataObject[] do1) {
        if (do1 == null) {
            return null;
        }
        DataObject[] dataObject = new DataObject[do1.length];
        for (int i = 0; i < do1.length; ++i) {
            dataObject[i] = BizFlowClientUtil.toClientDataObject(do1[i]);
        }
        return dataObject;
    }

    public static DataObject toClientDataObject(DataObject do1) {
        if (do1 == null) {
            return null;
        }
        DataObject dataObject = new DataObject();
        dataObject.setColLength(do1.getColLength());
        dataObject.setExtendValue(do1.getExtendValue());
        dataObject.setName(do1.getName());
        dataObject.setValue(do1.getValue());
        dataObject.setOwner(do1.getOwner());
        return dataObject;
    }

    public static String getDefaultF7UI(SimplePropertyUnit fieldInfo) {
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getExtendedProperty(DEFAULT_F7_UI);
    }

    public static MetaDataPK getDefaultF7Query(EntityObjectInfo entity) throws BOSException {
        if (entity == null) {
            return null;
        }
        String listUI = entity.getExtendedProperty("listUI");
        if (StringUtils.isEmpty((String)listUI)) {
            return null;
        }
        MetaDataPK pk = null;
        try {
            Class<?> clazz = Class.forName(listUI);
            pk = (MetaDataPK)((ListUI)clazz.newInstance()).getMainQueryPK();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        if (pk == null) {
            pk = MetaDataPK.create((String)entity.getExtendedProperty(DEFAULT_F7_QUERY));
        }
        return pk;
    }

    private static KDPromptBox createF7(String f7QueryName, MetaDataPK pk, String queryFiledName, boolean isQuery, IPromptBoxFactory promptBoxFactory) {
        if (promptBoxFactory != null) {
            KDPromptBox promptBox = promptBoxFactory.create(f7QueryName);
            if (promptBox == null) {
                return promptBoxFactory.create(f7QueryName, pk, queryFiledName, isQuery);
            }
            return promptBox;
        }
        return new DefaultPromptBoxFactory().create(f7QueryName, pk, queryFiledName, isQuery);
    }

    public static String getDefaultF7Query(SimplePropertyUnit queryFieldInfo) {
        if (queryFieldInfo == null) {
            return null;
        }
        return queryFieldInfo.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7Query(SimpleEntity entity) {
        if (entity == null) {
            return null;
        }
        return entity.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static void initEntityTree(KDTree tree, EntityObjectInfo entity) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)entity);
        root.setText(entity.getDisplayName());
        BizFlowClientUtil.getChildren(root);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                BizFlowClientUtil.expandVitualNode(event);
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                KDTree tree = (KDTree)event.getSource();
                TreePath path = event.getPath();
                if (path.getPathCount() > 5) {
                    tree.collapsePath(path);
                    MsgBox.showInfo((Component)tree, (String)EASResource.getString((String)BizFlowClientUtil.RESXFILENAME, (String)BizFlowClientUtil.MAXLEVELINFO));
                }
            }
        });
        ((KingdeeTreeModel)tree.getModel()).setRoot((TreeNode)root);
    }

    private static void getChildren(DefaultKingdeeTreeNode treeNode) {
        PropertyInfo property;
        if (treeNode == null || treeNode.getUserObject() == null) {
            return;
        }
        if (treeNode.getUserObject() instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)treeNode.getUserObject();
            if (entity != null) {
                PropertyCollection childPropertyList = entity.getEntityProperties();
                for (int i = 0; i < childPropertyList.size(); ++i) {
                    PropertyInfo property2 = childPropertyList.get(i);
                    if (entity.containsKey("LongName") && entity.containsKey("LongAlias")) {
                        property2.put("LongName", (Object)(entity.get("LongName") + "." + property2.getName()));
                        property2.put("LongAlias", (Object)(entity.get("LongAlias") + "." + property2.getAlias()));
                    } else {
                        property2.put("LongName", (Object)property2.getName());
                        property2.put("LongAlias", (Object)(entity.getAlias() + "." + property2.getAlias()));
                    }
                    property2.put("XBosType", (Object)entity.getType().toString());
                    DefaultKingdeeTreeNode childTreeNode = new DefaultKingdeeTreeNode((Object)property2);
                    childTreeNode.setText(property2.getAlias());
                    if (property2 instanceof LinkPropertyInfo) {
                        childTreeNode.add((MutableTreeNode)new VirtualTreeNode());
                    }
                    treeNode.add((MutableTreeNode)childTreeNode);
                }
            }
        } else if (treeNode.getUserObject() instanceof PropertyInfo && (property = (PropertyInfo)treeNode.getUserObject()) instanceof LinkPropertyInfo) {
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo bo = null;
            if (RelationshipType.COMPOSITION.equals((Object)relation.getType())) {
                if (!(relation.getClientProperty() instanceof LinkPropertyInfo)) {
                    bo = relation.getClientObject();
                }
                if (!(relation.getSupplierProperty() instanceof LinkPropertyInfo)) {
                    bo = relation.getSupplierObject();
                }
            } else if (RelationshipType.ASSOCIATION.equals((Object)relation.getType())) {
                bo = relation.getSupplierObject();
            }
            if (bo == null) {
                return;
            }
            if (property.containsKey("LongName") && property.containsKey("LongAlias")) {
                bo.put("LongName", property.get("LongName"));
                bo.put("LongAlias", property.get("LongAlias"));
            } else {
                bo.put("LongName", (Object)property.getName());
                bo.put("LongAlias", (Object)property.getAlias());
            }
            treeNode.setUserObject((Object)bo);
            BizFlowClientUtil.getChildren(treeNode);
        }
    }

    private static void expandVitualNode(TreeExpansionEvent event) {
        KDTree tree = (KDTree)event.getSource();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
        if (treeNode.getChildCount() == 1 && treeNode.getChildAt(0) instanceof VirtualTreeNode) {
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            BizFlowClientUtil.getChildren(treeNode);
        }
    }
}

