/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client.util;

import com.kingdee.eas.scm.framework.bizflow.client.RightPanel;
import com.kingdee.eas.scm.framework.bizflow.client.util.GraphActions;
import com.mxgraph.util.mxEventObject;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class KeyboardHandler {
    RightPanel panel;

    RightPanel getPanel() {
        return this.panel;
    }

    public KeyboardHandler(RightPanel panel) {
        this.panel = panel;
        this.installKeyboardActions(panel);
    }

    protected void installKeyboardActions(RightPanel panel) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(panel, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(panel, 0, inputMap);
        SwingUtilities.replaceUIActionMap(panel, this.createActionMap());
    }

    protected InputMap getInputMap(int condition) {
        InputMap map = null;
        if (condition == 1) {
            map = (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
        } else if (condition == 0) {
            map = new InputMap();
            map.put(KeyStroke.getKeyStroke("DELETE"), "delete");
            map.put(KeyStroke.getKeyStroke("ENTER"), "edit");
            map.put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
            map.put(KeyStroke.getKeyStroke("control A"), "selectAll");
            map.put(KeyStroke.getKeyStroke("control X"), "cut");
            map.put(KeyStroke.getKeyStroke("CUT"), "cut");
            map.put(KeyStroke.getKeyStroke("control C"), "copy");
            map.put(KeyStroke.getKeyStroke("COPY"), "copy");
            map.put(KeyStroke.getKeyStroke("control V"), "paste");
            map.put(KeyStroke.getKeyStroke("PASTE"), "paste");
            map.put(KeyStroke.getKeyStroke("UP"), "moveUp");
            map.put(KeyStroke.getKeyStroke("DOWN"), "moveDown");
            map.put(KeyStroke.getKeyStroke("RIGHT"), "moveRight");
            map.put(KeyStroke.getKeyStroke("LEFT"), "moveLeft");
            map.put(KeyStroke.getKeyStroke("SPACE"), "changeSelectMode");
            map.put(KeyStroke.getKeyStroke("control Z"), "undo");
            map.put(KeyStroke.getKeyStroke("control Y"), "redo");
        }
        return map;
    }

    protected ActionMap createActionMap() {
        ActionMap map = (ActionMap)UIManager.get("ScrollPane.actionMap");
        map.put("edit", GraphActions.getEditAction());
        map.put("delete", GraphActions.getDeleteAction());
        map.put("selectAll", GraphActions.getSelectAllAction());
        map.put("cut", TransferHandler.getCutAction());
        map.put("copy", TransferHandler.getCopyAction());
        map.put("paste", TransferHandler.getPasteAction());
        map.put("moveUp", GraphActions.getMoveUpAction());
        map.put("moveDown", GraphActions.getMoveDownAction());
        map.put("moveRight", GraphActions.getMoveRightAction());
        map.put("moveLeft", GraphActions.getMoveLeftAction());
        map.put("changeSelectMode", new ChangeSelectModelAction("changeSelectMode"));
        map.put("undo", GraphActions.getUndoAction());
        map.put("redo", GraphActions.getRedoAction());
        return map;
    }

    public class ChangeSelectModelAction
    extends AbstractAction {
        private static final long serialVersionUID = 3421324753577770476L;

        public ChangeSelectModelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RightPanel rightPanel = KeyboardHandler.this.getPanel();
            if (rightPanel != null) {
                boolean isConnect = KeyboardHandler.this.panel.isConnectable();
                if (isConnect) {
                    rightPanel.setConnectable(false);
                    rightPanel.setDragEnabled(true);
                    rightPanel.getGraph().setCellsSelectable(true);
                } else {
                    rightPanel.setConnectable(true);
                    rightPanel.setDragEnabled(false);
                    rightPanel.eventSource.fireEvent(new mxEventObject("clear", "cell", null));
                    rightPanel.getGraph().setCellsSelectable(false);
                    rightPanel.getGraph().clearSelection();
                }
            }
        }
    }
}

