/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.ConditionTableCollection;
import com.kingdee.eas.scm.framework.condition.ConditionTableFactory;
import com.kingdee.eas.scm.framework.condition.ConditionTableInfo;
import com.kingdee.eas.scm.framework.condition.client.AbstractConditionTableListUI;
import com.kingdee.eas.scm.framework.condition.client.ConditionRecordMaintainUI;
import com.kingdee.eas.scm.framework.condition.client.ConditionTableEditUI;
import com.kingdee.eas.scm.framework.condition.util.ConditionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ConditionTableListUI
extends AbstractConditionTableListUI {
    private static final long serialVersionUID = 2481271257020291008L;
    private static final String COL_STATE = "status";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";

    protected String getEditUIName() {
        return ConditionTableEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ConditionTableFactory.getRemoteInstance();
    }

    @Override
    public void actionMaintainData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() != 1) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("CONDITIONTABLE_NOT_ACTIVE_CANNOT_MDATA"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        String viewUi = ConditionRecordMaintainUI.class.getName();
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(viewUi, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(viewUi, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("CONDITIONTABLE_HAS_ACTIVE_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCancel.setVisible(true);
        this.actionCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableDel();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableDel() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("CONDITIONTABLE_HAS_ACTIVE_CANNOT_DEL"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (0 != MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"CONFIRM_MSG"))) {
            return;
        }
        this.setstate(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setstate(UseStatusEnum.ACTIVE, e);
    }

    private void setstate(UseStatusEnum state, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ConditionTableCollection col = ConditionTableFactory.getRemoteInstance().getConditionTableCollection(view);
        ConditionTableInfo reserSchema = null;
        ArrayList<String> numberList = new ArrayList<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reserSchema = col.get(i);
                String cu = reserSchema.getCU() != null ? reserSchema.getCU().getId().toString() : null;
                numberList.add(reserSchema.getNumber());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
                pks.remove(reserSchema.getId().toString());
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)this.bdScmImRes, (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        List errors = ConditionTableFactory.getRemoteInstance().setState(pks, state);
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setLog(numberList, "invupdatetype_enable", ConditionUtil.getResourceString("METHOD_ACTIVE"));
        } else {
            this.setLog(numberList, "invupdatetype_disable", ConditionUtil.getResourceString("METHOD_INACTIVE"));
        }
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.refresh(e);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void setLog(List<String> numberList, String logItemName, String methodName) throws Exception {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"26D87E6B"), null, (String)numberList.get(i), (String)logItemName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
    }
}

