/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.framework.log.ILogConfig;
import com.kingdee.eas.scm.framework.log.LogConfigFactory;
import com.kingdee.eas.scm.framework.log.LogConfigInfo;
import com.kingdee.eas.scm.framework.log.client.AbstractLogConfigListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogConfigListUI
extends AbstractLogConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(LogConfigListUI.class);
    private static final String EDITUI = "com.kingdee.eas.scm.framework.log.client.LogConfigEditUI";
    private String RESOURCE = "com.kingdee.eas.scm.framework.log.SCMLogResource";
    public static final String HAS_ERROR = "hasError";
    public static final String ERROR_MSG = "errorMsg";

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = LogConfigFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).batchEnable(ids);
        boolean hasError = (Boolean)resultMap.get(HAS_ERROR);
        String string = msg = hasError ? EASResource.getString((String)this.RESOURCE, (String)"anyBillNotActive") : EASResource.getString((String)this.RESOURCE, (String)"activeSucceed");
        if (hasError) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)resultMap.get(ERROR_MSG).toString(), (int)2);
        }
        this.setMessageText(msg);
        this.refresh(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = LogConfigFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).batchDisable(ids);
        boolean hasError = (Boolean)resultMap.get(HAS_ERROR);
        String string = msg = hasError ? EASResource.getString((String)this.RESOURCE, (String)"anyBillNotDisable") : EASResource.getString((String)this.RESOURCE, (String)"disableSucceed");
        if (hasError) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)resultMap.get(ERROR_MSG).toString(), (int)2);
        }
        this.setMessageText(msg);
        this.refresh(e);
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
    }

    protected String getEditUIName() {
        return EDITUI;
    }

    protected ILogConfig getBizInterface() throws Exception {
        return LogConfigFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col == null) continue;
                col.setGroup(true);
                col.setMergeable(true);
            }
        }
    }

    private String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "name", "logType", "status", "CU.name", "entry.billType"};
        return columns;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkCanEdit() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            LogConfigInfo logConfigInfo = this.getBizInterface().getLogConfigInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectorItemCollection());
            if (logConfigInfo == null) {
                throw new ObjectNotFoundException();
            }
            this.checkCanEdit(logConfigInfo);
        }
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("status"));
        return sics;
    }

    protected void checkCanEdit(LogConfigInfo billInfo) throws Exception {
        if (1 == billInfo.getStatus().getValue()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"BillStatusCantBeEdited"));
            SysUtil.abort();
        }
    }
}

