/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.model;

import com.kingdee.eas.scm.framework.model.JoinField;
import com.kingdee.eas.scm.util.string.StringUtil;

public class JoinCondition {
    private static final String EQUAL_SIGN = "=";
    private JoinField childField;
    private JoinField parentField;
    private String logicSign;

    public JoinCondition(JoinField childField, JoinField parentField) {
        this.childField = childField;
        this.parentField = parentField;
    }

    public JoinCondition(String expression) {
        this.parse(expression);
    }

    private void parse(String expression) {
        if (StringUtil.isEmpty((String)expression)) {
            return;
        }
        String field = expression.substring(0, expression.indexOf(EQUAL_SIGN)).trim();
        this.childField = new JoinField(field);
        field = expression.substring(expression.indexOf(EQUAL_SIGN) + 1).trim();
        this.parentField = new JoinField(field);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.childField == null || this.parentField == null) {
            return str.toString();
        }
        str.append(this.childField.toString()).append(EQUAL_SIGN).append(this.parentField.toString());
        return str.toString();
    }

    public JoinField getChildField() {
        return this.childField;
    }

    public void setChildField(JoinField childField) {
        this.childField = childField;
    }

    public JoinField getParentField() {
        return this.parentField;
    }

    public void setParentField(JoinField parentField) {
        this.parentField = parentField;
    }

    public String getLogicSign() {
        return this.logicSign;
    }

    public void setLogicSign(String logicSign) {
        this.logicSign = logicSign;
    }
}

