/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.openapi;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.framework.openapi.APIId;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.framework.openapi.Request;
import com.kingdee.eas.scm.framework.openapi.exception.PurCloudException;
import com.kingdee.eas.scm.framework.openapi.policy.ClientPolicy;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OpenApiClientTest {
    public static final int TIMEOUT = 6000;
    public static final String ENCODE = "UTF-8";
    public static final String host = "http://192.168.204.131:8086/purchase/openapi";
    public static final String nameSpace = "com.kingdee.purchase.openapi";
    private PurCloudClient client;

    public void setUp() {
        ClientPolicy policy = new ClientPolicy("192.168.204.131").setHttpPort(8086).setEnterpriseId("31250065");
        policy.setContentCharset(ENCODE).setTimeout(0);
        this.client = new PurCloudClient(policy);
    }

    private static String getUserId(Context ctx) {
        String number = "\u7f57\u65ed";
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        try {
            return URLEncoder.encode(number, ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void execute(Request request) {
        try {
            request.setOrgUnitId("QYYAAAAAB/rM567U").setUserId(OpenApiClientTest.getUserId(null));
            String result = this.client.send(request);
            System.out.println(result);
        }
        catch (PurCloudException e) {
            System.out.println("ErrorCode: " + e.getErrorCode() + "; ErrorMessage: " + e.getErrorMessage());
        }
    }

    public void te11stPostBuyOff() {
        Request request = new Request(new APIId(nameSpace, "buyoffer.postBuyOffer", 1));
        request.setParam("subject", "3605512032");
        request.setParam("sourceType", "kingdee");
        request.setParam("items", "[{\"subject\":\"\u82f9\u679c\",\"unit\":\"\u4e2a\",\"purchaseAmount\":12,\"productCode\":\"123\",\"prItemId\":\"1\"},{\"subject\":\"\u9999\u8549\",\"unit\":\"\u65a4\",\"purchaseAmount\":4,\"productCode\":\"345\",\"prItemId\":\"1\"}]");
        request.setParam("contact", "sky");
        request.setParam("phone", "13800010002");
        request.setParam("gmtQuotationExpire", "2010-10-12 12:32:55");
        request.setParam("prId", "10001");
        this.execute(request);
    }

    public void testQueryBuyOffByPrId() {
        Request request = new Request(new APIId(nameSpace, "buyoffer.getBuyOfferListByPrId", 1));
        request.setParam("prId", "QYYAAAARE64lQo8u");
        this.execute(request);
    }

    public void testQueryBuyOffById() {
        Request request = new Request(new APIId(nameSpace, "buyoffer.getBuyOfferInfoById", 1));
        request.setParam("buyOfferId", "700025439");
        this.execute(request);
    }

    public void te12stCloseBuyOff() {
        Request request = new Request(new APIId(nameSpace, "buyoffer.closeBuyOffer", 1));
        request.setParam("buyOfferId", "700025439");
        request.setParam("closeReason", "\u62a5\u4ef7\u622a\u6b62\uff0c\u5df2\u4e0b\u5355");
        this.execute(request);
    }

    public void testSaveOrderInfo() {
        Request request = new Request(new APIId(nameSpace, "purorder.postOrderInfo", 1));
        request.setParam("orderId", "hellowordsky");
        request.setParam("totalAmount", "562013");
        request.setParam("freightAmount", "0");
        request.setParam("orderAmount", "562013");
        request.setParam("sourceType", "BUYOFFER");
        request.setParam("orderStatus", "ordered");
        request.setParam("supplierCompanyName", "\u5f15\u516504");
        request.setParam("supplierCode", "yr04");
        request.setParam("supplierMemberId", "foxtest002");
        request.setParam("orderItemList", "[{\"price\":1000,\"productName\":\"\u6a44\u6984\u6cb9\",\"orderItemId\":\"I4cD8Xk6QNatyZEoPdV4HCYEHMU=\",\"count\":50},{\"price\":2560,\"productName\":\"\u8d8a\u91ce\u8f66\",\"orderItemId\":\"eYNGbxeaTyaEBbQgtJqwzyYEHMU=\",\"count\":200}]");
        request.setParam("payType", "offline");
        this.execute(request);
    }

    public void testUpdateOrderStatus() {
        Request request = new Request(new APIId(nameSpace, "purorder.updateOrderInfo", 1));
        request.setParam("orderId", "cmbYOT7sQiyL38yu9IUZkjFxv60=");
        request.setParam("orderStatus", "invalid");
        this.execute(request);
    }

    public void te12stGetSupplier() {
        Request request = new Request(new APIId(nameSpace, "supplier.getSupplier", 1));
        request.setParam("memberId", "foxtest001");
        this.execute(request);
    }

    public void te12stGetQuotationListByBuyOfferId() {
        Request request = new Request(new APIId(nameSpace, "quotation.getQuotationListByBuyOffId", 1));
        request.setParam("buyofferId", "700026205");
        this.execute(request);
    }
}

