/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.plugin.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.plugin.PlugInCollection;
import com.kingdee.eas.scm.framework.plugin.PlugInFactory;
import com.kingdee.eas.scm.framework.plugin.PlugInInfo;
import com.kingdee.eas.scm.framework.plugin.PlugInModel;
import com.kingdee.eas.scm.framework.plugin.PlugInType;
import com.kingdee.eas.scm.framework.plugin.client.AbstractPlugInManageUI;
import com.kingdee.eas.scm.framework.plugin.client.PlugInEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlugInManageUI
extends AbstractPlugInManageUI {
    private static final Logger logger = CoreUIObject.getLogger(PlugInManageUI.class);
    private static final String COL_ID = "id";
    private static final String COL_SEQ = "seq";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_PLUGINCLASS = "plugInClass";
    private static final String COL_DESCRIPTION = "description";
    private static final String COL_PLUGINTYPE = "pluginType";
    private static final String COL_PLUGINMODEL = "pluginModel";
    private boolean isModified = false;
    private int bizflowPlugInModel;
    private PlugInCollection plugInColl;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddNew.setEnabled(false);
        this.btnModify.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("PlugInModel") != null && this.getUIContext().get("PlugInModel").toString().length() > 0) {
            this.bizflowPlugInModel = Integer.parseInt(this.getUIContext().get("PlugInModel").toString());
            filter.getFilterItems().add(new FilterItemInfo("pluginMode", (Object)this.bizflowPlugInModel));
        }
        if (this.getUIContext().get("BizModel") != null && this.getUIContext().get("BizModel").toString().length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bizModel", (Object)this.getUIContext().get("BizModel").toString()));
        }
        view.setFilter(filter);
        SorterItemCollection sortor = new SorterItemCollection();
        sortor.add(new SorterItemInfo(COL_SEQ));
        view.setSorter(sortor);
        this.plugInColl = PlugInFactory.getRemoteInstance().getPlugInCollection(view);
        this.loadPlugInTable();
    }

    private void loadPlugInTable() {
        this.tblPlugIn.checkParsed();
        this.tblPlugIn.setEditable(false);
        this.tblPlugIn.removeRows();
        this.tblPlugIn.getSelectManager().setSelectMode(2);
        int size = this.plugInColl.size();
        PlugInInfo plugIn = null;
        for (int i = 0; i < size; ++i) {
            plugIn = this.plugInColl.get(i);
            this.addRow(plugIn);
        }
    }

    private void addRow(PlugInInfo plugIn) {
        IRow row = this.tblPlugIn.addRow();
        this.updateRow(row, plugIn);
    }

    private void updateRow(IRow row, PlugInInfo plugIn) {
        row.getCell(COL_ID).setValue((Object)plugIn.getId().toString());
        row.getCell(COL_SEQ).setValue((Object)plugIn.getSeq());
        row.getCell(COL_NUMBER).setValue((Object)plugIn.getNumber());
        row.getCell(COL_NAME).setValue((Object)plugIn.getName());
        row.getCell(COL_PLUGINCLASS).setValue((Object)plugIn.getPlugInClass());
        row.getCell(COL_DESCRIPTION).setValue((Object)plugIn.getDescription());
        row.setUserObject((Object)plugIn);
    }

    protected PlugInInfo createNewData() {
        PlugInInfo plugIn = new PlugInInfo();
        plugIn.setId(BOSUuid.create((BOSObjectType)plugIn.getBOSType()));
        plugIn.setSeq(this.tblPlugIn.getRowCount() + 1);
        plugIn.setPlugInType(PlugInType.CUSTOM);
        plugIn.setPlugInMode(PlugInModel.BILLSTATUS);
        return plugIn;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        PlugInInfo plugIn = this.createNewData();
        uiContext.put("InitDataObject", plugIn);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.plugin.client.PlugInEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        PlugInEditUI plugInEditUI = (PlugInEditUI)uiWindow.getUIObject();
        if (!plugInEditUI.isCancel()) {
            this.addRow(plugIn);
            this.plugInColl.add(plugIn);
            this.isModified = true;
        }
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        PlugInInfo oldPlugIn = (PlugInInfo)row.getUserObject();
        PlugInInfo newPlugIn = (PlugInInfo)oldPlugIn.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("InitDataObject", newPlugIn);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.balance.client.BalancePlugInEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        PlugInEditUI plugInEditUI = (PlugInEditUI)uiWindow.getUIObject();
        if (!plugInEditUI.isCancel()) {
            this.updateRow(row, newPlugIn);
            this.plugInColl.remove(oldPlugIn);
            this.plugInColl.add(newPlugIn);
            this.isModified = true;
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        PlugInInfo plugIn = (PlugInInfo)row.getUserObject();
        if (this.confirmRemove()) {
            this.plugInColl.remove(plugIn);
            PlugInFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(plugIn.getId()));
            this.tblPlugIn.removeRow(row.getRowIndex());
            if (row.getRowIndex() < this.tblPlugIn.getRowCount()) {
                this.adjustPlugInSeq();
                this.isModified = true;
            }
        }
    }

    private void adjustPlugInSeq() {
        int size = this.tblPlugIn.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblPlugIn.getRow(i);
            row.getCell(COL_SEQ).setValue((Object)(i + 1));
            ((PlugInInfo)row.getUserObject()).setSeq(i + 1);
        }
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        int index = row.getRowIndex();
        if (index == 0) {
            return;
        }
        this.tblPlugIn.moveRow(index, index - 1);
        this.adjustPlugInSeq();
        this.tblPlugIn.getSelectManager().select(index - 1, 0);
        this.isModified = true;
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        int index = row.getRowIndex();
        if (index == this.tblPlugIn.getRowCount() - 1) {
            return;
        }
        this.tblPlugIn.moveRow(index, index + 1);
        this.adjustPlugInSeq();
        this.tblPlugIn.getSelectManager().select(index + 1, 0);
        this.isModified = true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isModified) {
            return;
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < this.plugInColl.size(); ++i) {
            colls.add((CoreBaseInfo)this.plugInColl.get(i));
        }
        PlugInFactory.getRemoteInstance().saveBatchData(colls);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.FRAMEWORKAutoGenerateResource", (String)"169_PlugInManageUI"));
        this.isModified = false;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModified && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.framework.FRAMEWORKAutoGenerateResource", (String)"170_PlugInManageUI")))) {
            this.actionSave_actionPerformed(e);
        }
        this.disposeUIWindow();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void checkSelected() {
        if (this.tblPlugIn.getRowCount() == 0 || this.tblPlugIn.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

