/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.robot.AbstractSCMRobotFacadeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMRobotFacadeControllerBean
extends AbstractSCMRobotFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.robot.SCMRobotFacadeControllerBean");

    @Override
    protected Map _fetchInitData(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orgTypeList", this.getOrgTypeList(ctx));
        result.put("systemOrgMap", this.getSystemOrgMap(ctx));
        result.put("businessTypeMap", this.getBusinessTypeMap(ctx));
        result.put("operatorTypeMap", this.getOperatorTypeMap(ctx));
        return result;
    }

    private Map getSystemOrgMap(Context ctx) throws BOSException {
        HashMap systemOrgMap = new HashMap();
        ArrayList subSystemList = null;
        HashMap<String, Object> systemMap = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct FOrgtype,FsubSystem from T_scm_robotRelation ");
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        try {
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            while (rs.next()) {
                int orgType = rs.getInt("forgtype");
                int subSytem = rs.getInt("FsubSystem");
                if (SystemEnum.getEnum((int)subSytem) != null) {
                    systemMap = new HashMap<String, Object>();
                    systemMap.put("alias", SystemEnum.getEnum((int)subSytem).getAlias());
                    systemMap.put("value", subSytem);
                }
                if (systemOrgMap.get(orgType) == null) {
                    subSystemList = new ArrayList();
                    systemOrgMap.put(orgType, subSystemList);
                }
                ((List)systemOrgMap.get(orgType)).add(systemMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return systemOrgMap;
    }

    private List getOrgTypeList(Context ctx) throws BOSException {
        ArrayList<OrgType> orgTypeList = new ArrayList<OrgType>();
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct forgtype from T_scm_robotRelation ");
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        try {
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            while (rs.next()) {
                int orgType = rs.getInt("forgtype");
                if (OrgType.getEnum((int)orgType) == null) continue;
                OrgType subSystemEnum = OrgType.getEnum((int)orgType);
                orgTypeList.add(subSystemEnum);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return orgTypeList;
    }

    protected Map getBusinessTypeMap(Context ctx) throws BOSException, EASBizException {
        HashMap businessTypeMap = new HashMap();
        ArrayList businessTypeList = null;
        HashMap<String, Object> businessMap = null;
        StringBuffer sql = new StringBuffer();
        String locStr = ctx.getLocale().toString();
        sql.append(" select  distinct a.forgtype ForgType,a.fsubsystem Fsubsystem,a.fbusinessnumber Fnumber,b.fname_").append(locStr).append(" fname ");
        sql.append(" from T_scm_robotRelation A ");
        sql.append(" inner join t_vc_businesstype b  on a.fsubsystem = b.FSUBSYSTEM and a.fbusinessnumber = b.FNUMBER ");
        sql.append(" union ");
        sql.append(" select  distinct a.forgtype ForgType,a.fsubsystem Fsubsystem,a.fbusinessnumber Fnumber,b.fname_").append(locStr).append(" fname ");
        sql.append(" from T_scm_robotRelation A ");
        sql.append(" inner join t_vc_billtype b  on a.fsubsystem = b.FSUBSYSTEM and a.fbusinessnumber = b.fbosobjecttype ");
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        try {
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            while (rs.next()) {
                int orgType = rs.getInt("ForgType");
                int subSytem = rs.getInt("Fsubsystem");
                String number = rs.getString("Fnumber");
                String name = rs.getString("Fname");
                String key = orgType + "_" + subSytem;
                businessMap = new HashMap<String, Object>();
                businessMap.put("number", number);
                businessMap.put("name", name);
                businessMap.put("isDefault", false);
                if (businessTypeMap.get(key) == null) {
                    businessTypeList = new ArrayList();
                    businessTypeMap.put(key, businessTypeList);
                }
                ((List)businessTypeMap.get(key)).add(businessMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return businessTypeMap;
    }

    protected Map getOperatorTypeMap(Context ctx) throws BOSException, EASBizException {
        HashMap operatorTypeMap = new HashMap();
        ArrayList operatorList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        Locale loc = ctx.getLocale();
        String locStr = loc.toString();
        String geneVoucher = EASResource.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"geneVoucher", (Locale)loc);
        sql.append(" select * from ( ");
        sql.append(" select fsubsystem,to_char(fnumber) fnumber,to_char(foperatorNumber) foperatorNumber,to_char(foperatorName_" + locStr + ") fname,to_char(fdatafilterui) fdataFilterUI,fseq  from t_vc_businesstype ");
        sql.append(" union all ");
        sql.append(" select fsubsystem,to_char(fbosobjecttype) fnumber ,to_char('scpz') foperatorNumber,to_char('" + geneVoucher + "') fname,to_char('') fdataFilterUI,fseq from t_vc_billtype ) T   order by fsubsystem ,fnumber,fseq ");
        try {
            ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            String preNumber = null;
            String number = null;
            int preSubSystem = 0;
            int subSystem = 0;
            String name = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"Gen_profit_center_voucher");
            while (rs.next()) {
                String fdataFilterUI;
                String fname;
                String foperator;
                HashMap<String, String> opeMap = new HashMap<String, String>();
                number = rs.getString("fnumber");
                subSystem = rs.getInt("fsubsystem");
                if (subSystem != 32) {
                    if (preNumber == null && preSubSystem == 0) {
                        preNumber = number;
                        preSubSystem = subSystem;
                    } else if (null != preNumber && !preNumber.equals(number) || preSubSystem != subSystem) {
                        if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                            ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                        } else {
                            operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                        }
                        operatorList = new ArrayList();
                        preNumber = number;
                        preSubSystem = subSystem;
                    }
                    foperator = rs.getString("foperatorNumber");
                    fname = rs.getString("fname");
                    fdataFilterUI = rs.getString("fdataFilterUI");
                    opeMap.put("number", foperator);
                    opeMap.put("name", fname);
                    opeMap.put("dataFilterUI", fdataFilterUI);
                    operatorList.add(opeMap);
                    continue;
                }
                if (preNumber == null && preSubSystem == 0) {
                    preNumber = number;
                    preSubSystem = subSystem;
                } else if (null != preNumber && !preNumber.equals(number) || preSubSystem != subSystem) {
                    if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                        ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                    } else {
                        operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                    }
                    operatorList = new ArrayList();
                    preNumber = number;
                    preSubSystem = subSystem;
                }
                foperator = rs.getString("foperatorNumber");
                fname = rs.getString("fname");
                fdataFilterUI = rs.getString("fdataFilterUI");
                if (name.equals(fname)) continue;
                opeMap.put("number", foperator);
                opeMap.put("name", fname);
                opeMap.put("dataFilterUI", fdataFilterUI);
                operatorList.add(opeMap);
            }
            if (null != preNumber && preNumber.equals(number) && number != null && preSubSystem == subSystem && subSystem != 0) {
                if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                    ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                } else {
                    operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                }
                operatorList = new ArrayList();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return operatorTypeMap;
    }

    @Override
    protected Map _getPeriodData(Context ctx, Map params) throws BOSException, EASBizException {
        PeriodInfo currentPeriod;
        String orgID = (String)params.get("orgID");
        String orgType = (String)params.get("orgType");
        int subSystem = Integer.parseInt(params.get("subSystem").toString());
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)orgID));
        if (!"Company".equals(orgType)) {
            OrgUnitCollection orgsByRelation = OrgRelationUtils.getOrgsByRelation((OrgType)OrgType.getEnum((String)orgType), (OrgType)OrgType.Company, (BOSUuid)BOSUuid.read((String)orgID));
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgsByRelation.get(0);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        SystemEnum system = SystemEnum.INVENTORYMANAGEMENT;
        if (12 == subSystem) {
            system = SystemEnum.ACCOUNTSRECEIVABLE;
        }
        if (13 == subSystem) {
            system = SystemEnum.ACCOUNTSPAYABLE;
        }
        if ((currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)system, (CompanyOrgUnitInfo)companyOrgUnitInfo)) != null) {
            String alias = this.getPeriodString(ctx, currentPeriod);
            HashMap<String, Object> curPeriodMap = new HashMap<String, Object>();
            curPeriodMap.put("alias", alias);
            curPeriodMap.put("value", currentPeriod.getNumber());
            result.put("current", curPeriodMap);
            List periodList = this.getPeriodList(ctx, companyOrgUnitInfo.getId().toString());
            result.put("periods", periodList);
        }
        return result;
    }

    public List getPeriodList(Context ctx, String companyId) throws EASBizException, BOSException {
        String periodTypeID = "";
        String sql = "select FACCOUNTPERIODID from T_ORG_COMPANY where FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{companyId});
        try {
            if (rs.next()) {
                periodTypeID = rs.getString("FACCOUNTPERIODID");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("periodYear"));
        selector.add(new SelectorItemInfo("periodNumber"));
        selector.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeID, CompareType.EQUALS));
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.ASCEND);
        sortCol.add(sorterItem);
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sortCol);
        PeriodCollection periodCollection = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
        ArrayList result = new ArrayList();
        Iterator it = periodCollection.iterator();
        while (it.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            PeriodInfo periodInfo = (PeriodInfo)it.next();
            String alias = this.getPeriodString(ctx, periodInfo);
            map.put("alias", alias);
            map.put("value", periodInfo.getNumber());
            result.add(map);
        }
        return result;
    }

    private String getPeriodString(Context ctx, PeriodInfo periodInfo) throws EASBizException, BOSException {
        String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
        String s = EASCommonResource.getString((String)resFullName, (String)"periodformat", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(new String[]{new Integer(periodInfo.getPeriodYear()).toString(), new Integer(periodInfo.getPeriodNumber()).toString()});
        if (periodInfo.isIsAdjustPeriod()) {
            result = result + "(" + EASCommonResource.getString((String)resFullName, (String)"PeriodAdjuxt", (Locale)ctx.getLocale()) + ")";
        }
        return result;
    }

    @Override
    protected Map _getSchemaInitData(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        List schemaOrgTypeList = this.getSchemaOrgTypeList(ctx);
        result.put("orgList", schemaOrgTypeList);
        List subSystemList = this.getSchemaSubSystemList(ctx);
        result.put("subSystemList", subSystemList);
        return result;
    }

    private List getSchemaOrgTypeList(Context ctx) throws BOSException, EASBizException {
        ArrayList<OrgType> orgTypeList = new ArrayList<OrgType>();
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct FOrgType from T_SCM_SCMRobotOperation ");
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        try {
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            while (rs.next()) {
                int orgType = rs.getInt("FOrgType");
                if (OrgType.getEnum((int)orgType) == null) continue;
                OrgType subSystemEnum = OrgType.getEnum((int)orgType);
                orgTypeList.add(subSystemEnum);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return orgTypeList;
    }

    private List getSchemaSubSystemList(Context ctx) throws BOSException, EASBizException {
        ArrayList<SystemEnum> subSystemList = new ArrayList<SystemEnum>();
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct FSubSystem from T_SCM_SCMRobotOperation ");
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        try {
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            while (rs.next()) {
                int subSystem = rs.getInt("FSubSystem");
                if (SystemEnum.getEnum((int)subSystem) == null) continue;
                SystemEnum subSystemEnum = SystemEnum.getEnum((int)subSystem);
                subSystemList.add(subSystemEnum);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return subSystemList;
    }
}

