/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.writeoff;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.util.TableManagerHelper;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractWriteOffStrategy
implements IWriteOffStrategy {
    public static Logger logger = Logger.getLogger((String)AbstractWriteOffStrategy.class.getName());
    public static final String SQL_FROM = "FROM";
    public static final String SQL_INTO = "INTO";
    public static final String CR = " \r\n ";
    protected TableManager tableManager;
    public static Map<String, String> tabMap = new HashMap<String, String>();

    @Override
    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        return null;
    }

    @Override
    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        return null;
    }

    @Override
    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        return null;
    }

    protected void preFilterVerifyData(Context ctx, String mainTempTable, String secTempTable) throws BOSException, EASBizException {
    }

    protected Object invokeTableManger(Context ctx, String methodName, Class[] paramTypes, Object[] params) throws BOSException, EASBizException {
        Object obj = null;
        try {
            if (null == this.tableManager) {
                this.tableManager = TableManager.getTableManager((Context)ctx);
            }
            Method method = TableManager.class.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            obj = method.invoke((Object)this.tableManager, params);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return obj;
    }

    protected String generateTableName(Context ctx) throws BOSException, EASBizException {
        Object obj = this.invokeTableManger(ctx, "generateTableName", null, null);
        return obj == null ? null : obj.toString();
    }

    protected String createIndexName(Context ctx) throws BOSException, EASBizException {
        Object obj = this.invokeTableManger(ctx, "createIndexName", null, null);
        return obj == null ? null : obj.toString();
    }

    private void executeSQLDirect(Context ctx, String sql) throws BOSException, EASBizException {
        this.invokeTableManger(ctx, "executeSQLDirect", new Class[]{String.class}, new String[]{sql});
    }

    private void executeSQL(Context ctx, String sql) throws BOSException, EASBizException {
        this.invokeTableManger(ctx, "executeSQL", new Class[]{String.class}, new String[]{sql});
    }

    public void executeWithOutTx(Context ctx, String sql) throws BOSException, EASBizException {
        try {
            if (null == this.tableManager) {
                this.tableManager = TableManager.getTableManager((Context)ctx);
            }
            if (!this.tableManager.isOracle()) {
                this.executeSQLDirect(ctx, sql);
            } else {
                this.executeSQL(ctx, sql);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"executeWithOutTx error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static String getTableNameByBosType(Context ctx, String bosType) {
        if (StringUtils.isEmpty((String)bosType)) {
            return null;
        }
        String type = bosType.toString();
        String tableName = tabMap.get(type);
        if (StringUtils.isEmpty((String)tableName)) {
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
            tableName = entity.getTable().getName();
            tabMap.put(type, tableName);
        }
        return tableName;
    }

    public String createIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        if (StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columns)) {
            return null;
        }
        columns = columns.trim();
        String indexName = this.createIndexName(ctx);
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : (isClustered ? "CREATE CLUSTERED INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")");
        this.executeWithOutTx(ctx, sql);
        return indexName;
    }

    public static String getLinkedField(String field) {
        if (!StringUtils.isEmpty((String)field) && field.split("\\.").length > 1) {
            return "\"" + field + "\"";
        }
        return field;
    }

    public String fetchDataIntoTempTable(Context ctx, String bostype, String entryIdField, String sql) throws BOSException, EASBizException {
        TableManagerHelper helper = new TableManagerHelper();
        int txAction = helper.getTxLevel(ctx);
        String tableName = null;
        try {
            Method method = TableManagerHelper.class.getMethod("fetchDataIntoTempTable", Context.class, String.class, String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)helper);
            tableName = (String)txInvoker.invoke(method, new Object[]{ctx, entryIdField, sql}, txAction);
        }
        catch (Throwable e) {
            throw new BOSException("reflect invoke IWriteOffCommonFacade.fetchDataIntoTempTable error:", e);
        }
        return tableName;
    }

    public abstract SelectorItemCollection getPreMatchSelector(String var1, WriteOffCommonParams var2);

    public abstract IRowSet getPreMatchRowSet(Context var1, SelectorItemCollection var2, String var3, String var4) throws BOSException, EASBizException;

    public abstract IObjectValue buildBasicWriteOffEntryInfo(Context var1, IRowSet var2, WriteOffCommonInfo var3, WriteOffCommonParams var4) throws SQLException;

    public boolean isUsePreMatch(Context ctx, WriteOffCommonParams params) {
        return false;
    }
}

